/*
** $Id: drawconn_w.h,v 1.1 1992/12/11 19:07:11 dhb Exp $
** $Log: drawconn_w.h,v $
** Revision 1.1  1992/12/11  19:07:11  dhb
** Initial revision
**
*/

/**********************************************************
**                                                       **
**                      CONN MODES                       **
**                                                       **
**********************************************************/

typedef struct conn_pix_struct {
	VIEW_PIX_CORE_TYPE
	char	*outlinemode;
	char	*outlineicon;
	char	*anterograde;
	/* more private fields */
	Element	**sel_elms; /* All elements selected for connections */
	int		*nsel;
	Connection	**conns;	/* connections being displayed */
	int		*index;			/* indices of the geom-elms in conns */
	int		nconns;
	int		maxnconns;
	short	*isconn;		/* boolean for whether a given elm
							** has any conns on it */
} ConnPix, *ConnPixPtr;

/* 
** Equivalent data structure of connpix ..
*/
#ifdef EQUIV
typedef struct conn_pix_struct {
	PIX_CORE_TYPE
	/*	private fields */
	Pix	**icons;
	int	*value;
	/* public fields */
	char	*viewmode;
	char	*storage_mode;
	char	*pixcolor;
	char	*hlhistmode;
	char	*hldispmode;
	char	*vmin;
	char	*vmax;
	char	*autoscale;
	char	*path;
	char	*field;
	char	*nx;
	char	*ny;
	char	*autospace;

	/* the conn specific fields */

	char	*from_this_plane;
	/* more private fields */
	Element	**sel_elms; /* All elements selected for connections */
	int		*nsel;
	Connection	**conns;	/* connections being displayed */
	int		*index;			/* indices of the geom-elms in conns */
	int		nconns;
	int		maxnconns;		/* max no of conns allocated so far */
} ConnPix, *ConnPixPtr;
#endif EQUIV

#define XtNanterograde "anterograde"
#define XtCAnterograde "Anterograde"
#define XtNoutlinemode "outlinemode"
#define XtCOutlinemode "Outlinemode"
#define XtNoutlineicon "outlineicon"
#define XtCOutlineicon "Outlineicon"
