static char rcsid[] = "$Id: drawconn_w.c,v 1.1 1992/12/11 19:06:47 dhb Exp $";

/*
** $Log: drawconn_w.c,v $
** Revision 1.1  1992/12/11  19:06:47  dhb
** Initial revision
**
*/

/* --------------------------------------------- */
/* The init routine for setting up a conn based on
 * the draw widget.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "xodus_ext.h"
#include "draw_funcs.h"
#include "drawview_w.h"
#include "drawconn_w.h"

#define  MAXNSEL 100
extern	Widget x_ntw_get();
int		ConnUpdateFunc();
char	*fillstr();
static 	char *GetConnValue();
Boolean	ConnSetHook();
static void	ConnGetHook();
int	ConnViewIcons();


/* --------------------------------------------- */

static XtResource ConnResources[] = {
	{XtNpixname, XtCPixname, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, name),
		XtRString, "conn"
	},
	{XtNpixcolor, XtCPixcolor, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, pixcolor),
		XtRString, "Black"
	},
	{XtNviewmode, XtCViewmode, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, viewmode),
		XtRString, "colorview"
	},
	{XtNviewicon, XtCViewicon, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, viewicon),
		XtRString, "fillbox.icon"
	},
	{XtNoutlinemode, XtCOutlinemode, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, outlinemode),
		XtRString, "box"
	},
	{XtNoutlineicon, XtCOutlineicon, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, outlineicon),
		XtRString, "box.icon"
	},
	{XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, hlhistmode),
		XtRString, "lastone"
	},
	{XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, hldispmode),
		XtRString, "star"
	},
	{XtNfield, XtCField, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, field),
		XtRString, "delay"
	},
	{XtNpath, XtCPath, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, path),
		XtRString, "/"
	},
	{XtNvmin, XtCVmin, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, vmin),
		XtRString, "0"
	},
	{XtNvmax, XtCVmax, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, vmax),
		XtRString, "100"
	},
	{XtNautoscale, XtCAutoscale, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, autoscale),
		XtRString, "TRUE"
	},
    {XtNnx, XtCNx, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, nx),
        XtRString, "10        "
    },
    {XtNny, XtCNy, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, ny),
        XtRString, "10            "
    },
    {XtNautospace, XtCAutospace, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, autospace),
		XtRString, "TRUE"
	},
	{XtNox, XtCOx, XtRString, sizeof(char *),
		XtOffset(ViewPixPtr, ox),
		XtRString, "0.00000000000000"
	},
	{XtNoy, XtCOy, XtRString, sizeof(char *),
		XtOffset(ViewPixPtr, oy),
		XtRString, "0.00000000000000"
	},
	{XtNoz, XtCOz, XtRString, sizeof(char *),
		XtOffset(ViewPixPtr, oz),
		XtRString, "0.00000000000000"
	},
	{XtNanterograde, XtCAnterograde, XtRString, sizeof(char *),
		XtOffset(ConnPixPtr, anterograde),
		XtRString, "TRUE"
	},
};



/* --------------------------------------------- */

/* 
	the individual drawconn widget needs to know 
	(1) the list of elements which it is displaying. the 
		strength/source/dest of the conn will be indicated on the
		coords of this list of elms by boxes/color codings. This
		part is functionally identical to the view widget.
	(2) the list of elements it will display connections from/to.
	(3) the list of elements it has to hilight. This should be
		the intersection of (1) and (2) but variations may be
		permissible, such as providing yet another list (groan, do
		this later if at all) of all the elements in the source plane
		for display.
	(3) whether it is displaying connections from or to (1).
	(4) the usual view options.
	(5)	Often the coords in (1) and (2) do not apply to the elms
		actually involved in the connections, but to the parent neuron.
		some way of specifying the set of sub-elements of the parent
		(eg axons, synapses) will be useful: a short path maybe ?
		This option can be put in later.
*/

Pix *
XoCreateConn(parent,args,num_args)
	DrawWidget  parent;
	ArgList args;
	Cardinal	num_args;
{
	ConnPix		 *pix;
	Pix			 *image,*icon;
	DrawPart *pict;
	XGCValues		values;

	pict = &(parent->draw);
	/*
	pict->w = (Widget)parent;
	pict->gc = XtGetGC((Widget)parent,GCForeground, &values) ;
	pict->display = XtDisplay(parent);
	pict->d = XtWindow(parent);
	*/
	pict->pixvalue = (char *) calloc(200,sizeof(char));

	pix = (ConnPix *) calloc(1,sizeof(ConnPix));
	
	image = parent->draw.images;
	icon = parent->draw.icons;
	/* Might have to do XrmGetResources here instead if the
	** routine overwrites existing images.  */
	XtGetSubresources(parent,pix,XtNimages,XtCPix,ConnResources,
		XtNumber(ConnResources),args,num_args);

	parent->draw.pixname = fillstr(pix->name);

	parent->draw.images = (Pix *)pix;
	pix->next = image;
	parent->draw.icons = icon;

	pix->resources = ConnResources;
	pix->num_resources = XtNumber(ConnResources);

	SetConnPix(parent,pix);
	SetElmViewPath(parent,pix);
	pix->isconn = (short *) calloc(pix->npts,sizeof(short));
	if (SetElmViewRescale(parent,pix) == PATHERROR)
		return(NULL);
	if (SetConnUpdate(parent,pix) == PATHERROR)
		return(NULL);

	SetConnIcons(parent,pix);

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);
	pix->hilight->get_value = GetConnValue;
	pix->hilight->hl_clean_disp = CleanConnHl;

	SetPixColor(pix,pix->pixcolor);
	
/*
** Now we can finally step in and set up the values as specified
** by args, since the resources and all have been set up
*/
	XoSetValuesFromStrings(parent,args,num_args);

	RescaleDraw(parent);
	(((ElmViewUpdate *)(pix->update))->func)(parent,pix);

	return((Pix *)pix);
}

SetConnPix(parent,pix)
	Widget parent;
	ConnPix	*pix;
{
    Element     **elms;
    ElmViewUpdate       *update;
    ElmRescale      *rescale;
    ElementList     *elmlist, *WildcardGetElement();
	static Element	*sel_elms[MAXNSEL];
	static int		nsel = 0;

	/*
	** Horrible hack here to make all the connections talk to
	** each other: use the same sel_elms and nsel for all of them.
	*/
	pix->sel_elms = sel_elms;
	pix->nsel = &nsel;

    pix->rescale = (Rescale *) calloc(1,sizeof(ElmRescale));
    pix->update = (Update *) calloc(1,sizeof(ElmViewUpdate));
    pix->refresh_func = ConnViewIcons;
    pix->set_hook = ConnSetHook;
    pix->get_hook = ConnGetHook;
	pix->conns = (Connection **) calloc(CHUNKSIZE,sizeof(Connection *));
	pix->index = (int *) calloc(CHUNKSIZE,sizeof(int));
	pix->maxnconns = CHUNKSIZE;
	pix->nconns = 0;
}


SetConnUpdate(parent,pix)
    Widget  parent;
    ConnPix *pix;
{
    int     type = 0,offset = 0,nptrs = 0;
    ElmViewUpdate       *update;
	int					ret_flag = 1;

    if (GetConnFieldInfo(pix->field,&type,&offset,
        ((ElmRescale *)(pix->rescale))->elms) == PATHERROR) {
		fprintf(stderr,"can't get info for field '%s'\n",pix->field);
		type = 0;
		offset = 0;
	}
    update = (ElmViewUpdate *) pix->update;
    update->func = ConnUpdateFunc;
    update->vmin = Atof(pix->vmin);
    update->vmax = Atof(pix->vmax);
    update->autoscale = (strcmp(pix->autoscale,"TRUE") == 0);
    update->field = pix->field;
    update->field_type = type;
    update->offset = offset;
	return(1);
}


/*
** Basically the same as SetViewIcons except that it splices in
** an empty box for the 0 icon to indicate no connection
*/

SetConnIcons(parent,pix)
	DrawWidget	parent;
	ConnPix		*pix;
{
	Pix	*icon,*reficon;
    Coord   scale,offset;
    CoordRescale    *rescale;
	static char tempname[200];
	char		*iconname;

    if (!(rescale = ((CoordRescale *)(pix->rescale)))) return;

	if (strcmp(pix->outlinemode,"box") == 0) {
		iconname = "box.icon";
	} else if (strcmp(pix->outlinemode,"point") == 0) {
		iconname = NULL;
	} else if (strcmp(pix->outlinemode,"nooutline") == 0) {
		iconname = NULL;
	} else if (strcmp(pix->outlinemode,"icon") == 0) {
		iconname = pix->outlineicon;
	} else {
		printf("outline mode '%s' not recognised. Using box.\n",
			pix->outlinemode);
		iconname = "box.icon";
	}

	if (iconname) {
	    /* Getting and rescaling the reference icon */
	    offset.x = offset.y = offset.z = 0.0;
	    scale.x = 
			(rescale->xmax - rescale->xmin)/(float)(rescale->nx * 2);
	    scale.y  = 
			(rescale->ymax - rescale->ymin)/(float)(rescale->ny * 2);
	    scale.z = 0.0;
	    if (!(reficon = ScaleAndCopyIcon(iconname,scale,offset))) {
	        fprintf(stderr,"Could not find icon '%s'\n",iconname);
	        return;
	    }
	
		sprintf(tempname,"%s_outline.icon",pix->name);
		icon = add_pix2(parent,tempname,sizeof(Pix));
		reficon->next = icon->next ;
		reficon->name = icon->name ;
		*icon = *reficon;
		free(reficon);
	}

	SetViewIcons(parent,pix);
	/*
	if (strcmp(pix->viewmode,"colorview") == 0)
		pix->icons[0]->color = (char *)WhiteColor ; 
	*/
}

/*
	Update geom & conns. The value 0 means that the conn is not
	present, and is displayed as the open-conn icon.
	Update hilights. standard. 
	First we scan through all the conns to generate values for the
	display. Then we install these values in the value array with
	0 being the unconnected icon.
*/

int ConnUpdateFunc(parent,pix)
	DrawWidget	parent;
	ConnPix	*pix;
{
	int	i;
	int	*pixvalue;

	pixvalue = pix->value;

	for (i = 0 ; i < pix->npts; i++) 
		pixvalue[i] = 0;
	SetConnValues(pix,pix->nconns);
}

int RefreshAllConns(parent,pix)
	DrawWidget	parent;
	ConnPix	*pix;
{
	int	i;
	int	*pixvalue;
	Pix	*temp;
	DrawPart	*pict;

	for (temp = parent->draw.images ; temp ; temp = temp->next) {
		if (temp->set_hook == ConnSetHook) {
			pixvalue = ((ConnPix *)temp)->value;
			((ConnPix *)pix)->nconns = 0;
			*(((ConnPix *)pix)->nsel) = 0;
			for (i = 0 ; i < temp->npts; i++) 
				pixvalue[i] = 0;
		}
	}
	ShowConn3(parent);
}


int	SetConnValues(pix,nconns)
	ConnPix	*pix;
	int		nconns;
{
	int i;
	ElmViewUpdate *update;
	float	*value;
	float	*valuesum;
	int		*pixvalue;
	int		*index;
	short	*isconn;
	float	vmin,vmax;
	float	scale;
	int		offset;
	Element	**elms;
	Connection	**conns;
	char	*e;

	if (pix->npts <= 0) return;
	conns = pix->conns;
	value = (float *) malloc(nconns * sizeof(float));
	valuesum = (float *) calloc(pix->npts,sizeof(float));

	update = (ElmViewUpdate *)pix->update;

	elms = ((ElmRescale *)(pix->rescale))->elms;
	offset = update->offset;
	switch (update->field_type) {
		case	FLOATARRAY :
			for (i = 0 ; i < nconns; i++ ) 
				value[i]  = *((float *)((char *)conns[i] + offset));
			break;
		case	DOUBLEARRAY :
			for (i = 0 ; i < nconns; i++ ) 
				value[i]  = (float)(*((double *)((char *)conns[i] +
					offset)));
			break;
		case	SHORTARRAY :
			for (i = 0 ; i < nconns; i++ ) 
				value[i]  = (float)(*((short *)((char *)conns[i] +
					offset)));
			break;
		case	INTARRAY :
			for (i = 0 ; i < nconns; i++ ) 
				value[i]  = (float)(*((int *)((char *)conns[i] + 
					offset)));
			break;
		default :
			break;
	}
	isconn = pix->isconn;
	index = pix->index;
	for (i = 0 ; i < pix->npts; i++)
		isconn[i] = 0;
	for (i = 0 ; i < nconns ; i++) 
		isconn[index[i]] = 1;
	for (i = 0 ; i < nconns; i++) {
		valuesum[index[i]] += value[i];
	}
	if (update->autoscale) {
		vmax = vmin = valuesum[0];
		for (i = 0 ; i < pix->npts; i++ ) {
			if (vmin > valuesum[i])
				vmin = valuesum[i];
			else if (vmax < valuesum[i])
				vmax = valuesum[i];
		}
		update->vmin = vmin;
		update->vmax = vmax;
		sprintf(pix->vmin,"%f",vmin);
		sprintf(pix->vmax,"%f",vmax);
	}

	pixvalue = pix->value;
	if ((scale = update->vmax - update->vmin) < EPSILON) {
		for (i = 0 ; i < nconns; i++) 
			pixvalue[index[i]] = 1;
		free(value);
		free(valuesum);
		return(0);
	}

	vmin = update->vmin;
	scale = (float)(NICONS - 1) / scale;
	for (i = 0 ; i < pix->npts; i++) {
		pixvalue[i] = (valuesum[i] - vmin) * scale + 1;
	}
	free(value);
	free(valuesum);
	return(1);
}

int	ResetConnValues(pix,from,to)
	ConnPix	*pix;
	int		from;
	int		to;
{
	int		i;
	int		*index;
	int		*value;

	index = pix->index;
	value = pix->value;

	for (i = from ; i < to ; i++) 
		value[index[i]] = 0;
}


int GetConnFieldInfo(fieldname,fieldtype,fieldoffset,elms)
	char 	*fieldname;
	int		*fieldtype;
	int		*fieldoffset;
	Element	**elms;
{
	int i;
	int len;
	int is_at_wildcard;
	char	*conntype;
	char	*type;
	Info	info;

	/*
	** For version 0.8 :
	pl->type = pl->elms[0]->object->type;
	*/
	/* Hack to get the damn thing to work */
	/*
	conntype = ((Projection *)(elms[0]))->connect_type;
	if (!conntype) 
	*/
	conntype = "connection_type";
	*fieldoffset = 
		CalculateOffset(conntype,fieldname,&info);
	type = info.type;
	if (!type)  return(0);

	if (strcmp(type,"float") == 0) 
		*fieldtype |= FLOATARRAY;
	else if (strcmp(type,"int") == 0) 
		*fieldtype |= INTARRAY;
	else if (strcmp(type,"short") == 0) 
		*fieldtype |= SHORTARRAY;
	else if (strcmp(type,"double") == 0) 
		*fieldtype |= DOUBLEARRAY;
	else 
		return(PATHERROR);
	return(PATHSET);
}

AddConnIcons(pict,pix,from,to)
	DrawPart *pict;
	ConnPix *pix;
	int		from,to;
{
	int	 *value;
	int	 index;
	int	 i,j,k;
	Pix	 **icons,*icon;
	int	 niconpts = 0;
	XPoint  *pts,*oldpts,*pixpts;
	short   x,y,h;


	pixpts = pix->pts;
	value = pix->value;
	icons = pix->icons;

	if (!(icons = pix->icons)) return(0);
	h = pict->w->core.height;

	for (i = 0 ; i < NICONS ; i++) {
		if (icons[i]->npts > niconpts)
	niconpts = icons[i]->npts;
	}
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	for ( k = from ; k < to; k++) {
		i = pix->index[k];
		x = pixpts[i].x;
		y = pixpts[i].y - h;

		index = value[i];
		if (index < 0)
			index = 0;
		else if (index >= NICONS)
			index = NICONS - 1;
		icon = icons[index];

		oldpts = icon->pts;
		for (j = 0 ; j < icon->npts ; j++) {
			pts[j].x = oldpts[j].x + x;
			pts[j].y = oldpts[j].y + y;
		}
		icon->pts = pts;
		if (output_flag == PSOUT)
			XSetForeground(pict->display,pict->gc,
				(int)icon->color);
		else
			XSetForeground(pict->display,pict->gc,
				colorscale[(int)icon->color]);
		(icon->refresh_func)(pict,icon);
		icon->pts = oldpts;
	}
	free(pts);
	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
}

DropConnIcons(pict,pix,from,to)
	DrawPart *pict;
	ConnPix *pix;
	int		from,to;
{
	int	 *value;
	int	 index;
	int	 i,j,k;
	Pix	 **icons,*icon,*zeroicon;
	int	 niconpts = 0;
	XPoint  *pts,*oldpts,*pixpts;
	short   x,y;
	short	h = pict->w->core.height;


	pixpts = pix->pts;
	value = pix->value;
	icons = pix->icons;

	if (!(icons = pix->icons)) return(0);

	for (i = 0 ; i < NICONS ; i++) {
		if (icons[i]->npts > niconpts)
			niconpts = icons[i]->npts;
	}
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	zeroicon = icons[0];
	for ( k = from ; k < to; k++) {
		i = pix->index[k];
		x = pixpts[i].x;
		y = pixpts[i].y - h;

		index = value[i];
		if (index < 0)
			index = 0;
		else if (index >= NICONS)
			index = NICONS - 1;
		icon = icons[index];

		/* Clear old conn value */
		oldpts = icon->pts;
		for (j = 0 ; j < icon->npts ; j++) {
			pts[j].x = oldpts[j].x + x;
			pts[j].y = oldpts[j].y + y;
		}
		icon->pts = pts;
		XSetForeground(pict->display,pict->gc,
			pict->w->core.background_pixel);
		(icon->refresh_func)(pict,icon);
		icon->pts = oldpts;
	}
	free(pts);
	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
}

Boolean ConnSetHook(parent,pix,argnames,nargs)
    DrawWidget  parent;
    ConnPix *pix;
    char    **argnames;
    int     nargs;
{
	int	 i;
	Boolean do_update = FALSE;
	Boolean do_rescale = FALSE;
	Boolean do_viewpath = FALSE;

	if (nargs == 0)
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpixcolor) == 0) {
			SetPixColor(parent,pix);
		} else if (strcmp(argnames[i],XtNviewmode) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNviewicon) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoutlinemode) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoutlineicon) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNpath) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNfield) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmin) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmax) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNautoscale) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNnx) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNny) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNautospace) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNox) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoy) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoz) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNanterograde) == 0) {
			RefreshAllConns(parent,pix);
		}
	}
	if (do_viewpath) {
		SetElmViewPath(parent,pix);
		if (pix->isconn)
			free(pix->isconn);
		pix->isconn = (short *) calloc(pix->npts,sizeof(short));
	}
	if (do_rescale) {
		SetElmViewRescale(parent,pix);
		SetConnIcons(parent,pix);
		RescaleDraw(parent);
	}
    if (do_update) {
        SetConnUpdate(parent,pix);
        ConnUpdateFunc(parent,pix);
    }

    return(TRUE);
}

static void ConnGetHook(pix,rl,args,nargs)
    ConnPix *pix;
    XrmResourceList rl;
    ArgList args;
    Cardinal    nargs;
{
}


static char *
GetConnValue(pict,pix,index)
	DrawPart	*pict;
	ConnPix	*pix;
	int		index;
{
	static char	path[200];

	strcpy (path,
		Pathname(((ElmRescale *)(pix->rescale))->elms[index]));
	return(fillstr(path));
}

int ConnViewIcons(pict,pix)
	DrawPart	*pict;
	ConnPix		*pix;
{
	int i,j;
	Pix *reficon;
	int niconpts = 0;
	XPoint  *pts,*oldpts;
	short   h;
	short	x,y;
	static char	tempname[100];

	CViewIcons(pict,pix); /* similar to ViewIcons but doesnt draw where
						  ** isconn[i] == 0 */

	if (strcmp(pix->outlinemode,"point") == 0) {
		DrawPoints(pict,pix);
	} else if (strcmp(pix->outlinemode,"nooutline") == 0) {
		/* Do nothing. no outlines needed */
	} else {
		/* In all other cases draw the outline icon */
		sprintf(tempname,"%s_outline.icon",pix->name);
		if (reficon = find_pix2(pict->w,tempname)) {
	
			h = pict->w->core.height;
		
			niconpts = reficon->npts;
			pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
		
			oldpts = reficon->pts;
			reficon->pts = pts;
		   	XSetForeground(pict->display,pict->gc,
				name_to_color(reficon->color));
			for (i = 0 ; i < pix->npts ; i++) {
				x = pix->pts[i].x;
				y = pix->pts[i].y;
				for (j = 0 ; j < reficon->npts ; j++) {
					pts[j].x = oldpts[j].x + x;
					pts[j].y = oldpts[j].y + y - h;
				}
				(reficon->refresh_func)(pict,reficon);
			}
			reficon->pts = oldpts;
		
			free(pts);
		} else {
			fprintf(stderr,"cannot find reficon '%s'\n",
				pix->outlineicon);
		}
	}
}

int CViewIcons(pict,pix)
    DrawPart	*pict;
    ConnPix		*pix;
{
    int     *value;
    int     index;
    int     i,j;
    Pix     **icons,*icon;
    int     niconpts = 0;
    XPoint  *pts,*oldpts,*pixpts;
    short   x,y,w,h;


    pixpts = pix->pts;
    value = pix->value;
    icons = pix->icons;

    if (!(icons = pix->icons)) return(0);
	if (!(pict->w)) {
		fprintf(stderr,"View Window has not been displayed yet\n");
		return(0);
	}
    h = pict->w->core.height;
    w = pict->w->core.width;

    for (i = 0 ; i < NICONS ; i++) {
        if (icons[i]->npts > niconpts)
            niconpts = icons[i]->npts;
    }
    pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
    pixpts = pix->pts;

    for ( i = 0 ; i < pix->npts; i++) {
		if (pix->isconn[i] == 0) continue;
        x = pixpts[i].x;
        y = pixpts[i].y - h;
		if (x < -w || x > (w + w) || y < -h || y > (h + h)) 
			continue;

        index = value[i];
        if (index < 0)
            index = 0;
        else if (index >= NICONS)
            index = NICONS - 1;
        icon = icons[index];

        oldpts = icon->pts;
        for (j = 0 ; j < icon->npts ; j++) {
            pts[j].x = oldpts[j].x + x;
            pts[j].y = oldpts[j].y + y;
        }
        icon->pts = pts;
		if (output_flag == PSOUT)
			XSetForeground(pict->display,pict->gc,
				(int)icon->color);
		else
			XSetForeground(pict->display,pict->gc,
				colorscale[(int)icon->color]);
        (icon->refresh_func)(pict,icon);
        icon->pts = oldpts;
    }
    free(pts);
    XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
    if (pix->hilight) {
        (pix->hilight->hl_refresh)(pict,pix);
    }
}


int CleanConnHl(pict,pix,index)
	DrawPart	*pict;
	ConnPix		*pix;
	int		index;
{
	if (pix->isconn[index])
		CleanViewHl(pict,pix,index);
}
