static char rcsid[] = "$Id: draw_w.c,v 1.2 1993/06/29 23:00:25 dhb Exp $";

/*
** $Log: draw_w.c,v $
** Revision 1.2  1993/06/29  23:00:25  dhb
** X11R5 patches
**
** Revision 1.1  1992/12/11  19:06:46  dhb
** Initial revision
**
*/

#include "draw_ext.h"
#include "xodus_defs.h"
#include "XoClickBuffer.h"
#include "LayoutP.h"
#include "draw_funcs.h"



#define ROTANGLE 0.2
#define MINANGLE 0.0001

static XtResource resources[] = {
	{XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
		XtOffset(DrawWidget, draw.callback),
		XtRCallback, (caddr_t)NULL
	},
	{XtNimages, XtCPix, XtRPointer, sizeof(Pix *),
		XtOffset(DrawWidget, draw.images),
		XtRString, (caddr_t)NULL
	},
	{XtNwhen, XtCWhen, XtRPointer, sizeof(XoWhen *),
		XtOffset(DrawWidget, draw.when),
		XtRString, (caddr_t)NULL
	},
	{XtNicons, XtCPix, XtRPointer, sizeof(Pix *),
		XtOffset(DrawWidget, draw.icons),
		XtRString, (caddr_t)NULL
	},
	{XtNcx, XtCCenter, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.cx),
		XtRString, "0.0"
	},
	{XtNcy, XtCCenter, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.cy),
		XtRString, "0.0"
	},
	{XtNcz, XtCCenter, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.cz),
		XtRString, "0.0"
	},
	{XtNvx, XtCViewpt, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.vx),
		XtRString, "4.0"
	},
	{XtNvy, XtCViewpt, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.vy),
		XtRString, "-20"
	},
	{XtNvz, XtCViewpt, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.vz),
		XtRString, "3"
	},
	{XtNwx, XtCWx, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.wx),
		XtRString, "1000"
	},
	{XtNwy, XtCWy, XtRFloat, sizeof(float), 
		XtOffset(DrawWidget, draw.wy),
		XtRString, "1000"
	},
	{XtNvalue, XtCValue, XtRString, sizeof(char *), 
		XtOffset(DrawWidget, draw.pixvalue),
		XtRString, "/"
	},
	{XtNpixchoose, XtCPixchoose, XtRString, sizeof(char *), 
		XtOffset(DrawWidget, draw.pixname),
		XtRString, "pix"
	},
	{XtNtransform, XtCTransform, XtRFunction, sizeof(caddr_t), 
		XtOffset(DrawWidget, draw.transf_func),
		XtRString, "z2d"
	},
	{XtNrefresh_flag, XtCRefresh_flag, XtRString, sizeof(char *), 
		XtOffset(DrawWidget, draw.refresh_flag),
		XtRString, "TRUE"
	},
};

static void Destroy();
void drawInitialise();
Boolean	DrawSetValues();
Boolean DrawSetValuesHook();
void DrawGetValuesHook();
static void DrawWhenFunc();
static void DrawWhenUp();
void WhenMotion();
struct click_buffer_struct	current_click,last_click;

static void Quitdraw(), drawDisplay();
static void DrawPrint();
static void PanLeft();
static void PanDown();
static void PanUp();
static void PanRight();
static void ZoomIn();
static void ZoomOut();
static void TransfX();
static void TransfY();
static void TransfZ();
static void TransfOrtho();
static void RotLeft();
static void RotRight();
static void RotUp();
static void RotDown();

static void FindLabel();

static char translations[] =	
	"<BtnDown>: DrawWhenFunc() \n\
	<BtnUp>: DrawWhenUp() \n\
	Ctrl<Key>P: DrawPrint() \n\
	Ctrl<Key>H: PanLeft() \n\
	Ctrl<Key>J: PanDown() \n\
	Ctrl<Key>K: PanUp() \n\
	Ctrl<Key>L: PanRight() \n\
	Ctrl<Key>I: ZoomIn() \n\
	Ctrl<Key>O: ZoomOut() \n\
	Ctrl<Key>X: TransfX() \n\
	Ctrl<Key>Y: TransfY() \n\
	Ctrl<Key>Z: TransfZ() \n\
	Ctrl<Key>W: TransfOrtho() \n\
	Ctrl<Key>\\<: RotLeft() \n\
	Ctrl<Key>\\>: RotRight() \n\
	Ctrl<Key>Q: RotUp() \n\
	Ctrl<Key>A: RotDown() \n\
	<BtnMotion>: WhenMotion()" ;
/*
	"! Button1 Button2 Button3 <BtnDown>: DrawWhenFunc() \n\
	! Button1 Button2 Button3 <BtnUp>: DrawWhenUp() \n\
	! Button1 Button2 Button3 <Motion>: WhenMotion()" ;
*/

static XtActionsRec	drawActions[] = {
	{"DrawWhenFunc", DrawWhenFunc},
	{"DrawWhenUp", DrawWhenUp},
	{"WhenMotion", WhenMotion},
	{"DrawPrint", DrawPrint},
	{"PanLeft", PanLeft},
	{"PanDown", PanDown},
	{"PanUp", PanUp},
	{"PanRight", PanRight},
	{"ZoomIn", ZoomIn},
	{"ZoomOut", ZoomOut},
	{"TransfX", TransfX},
	{"TransfY", TransfY},
	{"TransfZ", TransfZ},
	{"TransfOrtho", TransfOrtho},
	{"RotLeft", RotLeft},
	{"RotRight", RotRight},
	{"RotUp", RotUp},
	{"RotDown", RotDown},
};

DrawClassRec drawClassRec = {
	{
		/* superclass			*/	(WidgetClass) &widgetClassRec,
		/* class_name			*/	"draw",
		/* widget_size			*/	sizeof(DrawRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize	*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	drawInitialise,
		/* initialize_hook		*/	NULL,
		/* realize				*/	XtInheritRealize,
		/* actions				*/	drawActions,
		/* num_actions			*/	XtNumber(drawActions),
		/* resources			*/	resources,
		/* num_resources		*/	XtNumber(resources),
		/* xrm_class			*/	NULLQUARK,
		/* input flags			*/	TRUE, TRUE, TRUE, FALSE,
		/* destroy				*/	Destroy,
		/* resize				*/	RescaleDraw,
		/* expose				*/	drawDisplay,
		/* set_values 			*/	DrawSetValues,
		/* set_values_hook		*/	DrawSetValuesHook,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	DrawGetValuesHook,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback offsets		*/	NULL,
		/* tm_table				*/	translations,
	}
};

WidgetClass drawWidgetClass = (WidgetClass)&drawClassRec;

void drawInitialise(request,new)
	Widget request,new;
{
	DrawWidget	gw = (DrawWidget)new;
}

static void Destroy(w)
		 DrawWidget w;
{
	Pix	**pix;

	for (pix = &(w->draw.images) ; drop_pix3(pix););
	for (pix = &(w->draw.icons) ; drop_pix3(pix););
	XtRemoveAllCallbacks(w, XtNcallback);
}

Boolean	DrawSetValues(current,request,new)
	DrawWidget	current;
	DrawWidget	request;
	DrawWidget	new;
{
	char	*name;
	Pix		*pix;

	if (current->draw.cx != request->draw.cx || 
		current->draw.cy != request->draw.cy ||
		current->draw.cz != request->draw.cz || 
		current->draw.vx != request->draw.vx || 
		current->draw.vy != request->draw.vy ||
		current->draw.vz != request->draw.vz || 
		current->draw.wx != request->draw.wx || 
		current->draw.wy != request->draw.wy ||
		current->draw.transf_func != request->draw.transf_func) {
			RescaleDraw(new);
			return(TRUE);
	}
	if (strcmp(current->draw.refresh_flag,request->draw.refresh_flag)
		!= 0 && 
		strcmp(request->draw.refresh_flag,"FALSE") != 0)
		return(TRUE);
	else
		return(FALSE);
}

Boolean	DrawSetValuesHook(w,args,num_args)
	DrawWidget	w;
	ArgList	args;
	Cardinal *num_args;
{
  	int	 		i,j;
	XrmResourceList rl;
	int	 		num_resources;
	XrmQuark	xrm_name;
	char		*name;
	char		*pixname;
	Pix			*pix;
	static	char		*changed_args[50];
	int			nchanged_args = 0;
	Boolean		ret;

	if (!(pix = find_pix2(w,w->draw.pixname))) {
		/*
		fprintf(stderr,"pix '%s' not found in DrawSetValuesHook\n",
			w->draw.pixname);
		*/
		return(FALSE);
	}

	if (!(rl = (XrmResourceList)pix->resources)) {
		fprintf(stderr,"coulndt find resources for pix '%s' in DrawSetValuesHook\n");
		return(FALSE);
	}
    if (pix->num_resources == 0) {
		fprintf(stderr,"coulndt find resources for pix '%s' in DrawSetValuesHook\n");
		return(FALSE);
	}
	if (!num_args) {
		fprintf(stderr,"num args null in DrawSetValuesHook\n");
		return(FALSE);
	}

    /* Resource lists are assumed to be in compiled form already via the
       initial XtGetSubresources calls */

    for (i = 0 ; i < *num_args ; i++) {
    	xrm_name = XrmStringToQuark(args[i].name);
    	for (j = 0 ; j < pix->num_resources ; j++) {
        	if (xrm_name == rl[j].xrm_name) {
				XoCvtStringToThings(rl[j].xrm_type,args[i].value,
					&(args[i]));
        		XoCopyFromArg(args[i].value,
                	(XtArgVal) pix - rl[j].xrm_offset - 1,
                	rl[j].xrm_size);
				changed_args[nchanged_args] = args[i].name;
				nchanged_args++;
        		break;
        	}
    	}
	}
	ret = (pix->set_hook)(w,pix,changed_args,nchanged_args);
	if (strcmp(w->draw.refresh_flag,"FALSE") != 0)
		return(ret);
	else
		return(FALSE);
}

void DrawGetValuesHook(w,args,num_args)
	DrawWidget	w;
	ArgList	args;
	Cardinal *num_args;
{
	XrmResourceList rl;
	Pix			*pix;

	if (!(pix = find_pix2(w,w->draw.pixname))) {
		/*
		fprintf(stderr,"pix '%s' not found in DrawGetValuesHook\n",
			w->draw.pixname);
		*/
		return;
	}

	if (!(rl = (XrmResourceList)pix->resources)) {
		fprintf(stderr,"pix '%s' does not have resources\n",
			w->draw.pixname);
		return;
	}

	XtGetSubvalues(pix,rl,pix->num_resources,
		args, *num_args);
}

static void DrawWhenFunc(w,event,params,num_params)
	Widget	w;
	XEvent	*event;
	String	*params;
	Cardinal	*num_params;
{
    XButtonEvent    *e;
    DrawWidget  dw = (DrawWidget)w;
    int     x,y,r;
    XPoint      *pts;
    Pix     *pix;
    Pix     *bestpix;
    int     bestpt;
    int     bestdist;
    int     i;

    e = (XButtonEvent *)event;
    x = e->x;
    y = e->y;

    pix = dw->draw.images;

    bestdist = w->core.width * w->core.width;
    bestpt = 0;
    bestpix = NULL;

    while (pix != NULL) {
        if ((pix->hilight) && (pix->npts > 0) &&
			(pix->hilight->hl_hist) && (pix->hilight->hl_refresh)) {
            pts = pix->pts;
            for (i = 0 ; i < pix->npts ; i++) {
                r = (x - pts[i].x) * (x - pts[i].x) +
                    (y - pts[i].y) * (y - pts[i].y) ; 
                if (bestdist > r) {
                    bestdist = r;
                    bestpt = i;
                    bestpix = pix;
                }
            }
        }
        pix = pix->next;
	}
    if ((bestpix != NULL) && (bestdist < 5000 )) {
		last_click = current_click;
		current_click.value = 
			(bestpix->hilight->get_value)(&(dw->draw),bestpix,bestpt);
		current_click.pix = (char *)bestpix;
		current_click.index = bestpt;
		if (bestpix->rescale->func == UseCoords) {
			current_click.x =
				((CoordRescale *)(bestpix->rescale))->coords[bestpt].x;
			current_click.y =
				((CoordRescale *)(bestpix->rescale))->coords[bestpt].y;
			current_click.z = 
				((CoordRescale *)(bestpix->rescale))->coords[bestpt].z;
		} else if (bestpix->rescale->func == UseElms) {
			current_click.x =
				((ElmRescale *)(bestpix->rescale))->elms[bestpt]->x;
			current_click.y =
				((ElmRescale *)(bestpix->rescale))->elms[bestpt]->y;
			current_click.z = 
				((ElmRescale *)(bestpix->rescale))->elms[bestpt]->z;
		}
		current_click.w = w;
		/*
		current_click.widgetname = WidgetPathname(w);
		*/
		current_click.screenx = e->x;
		current_click.screeny = e->y;
		current_click.button = e->button;
		current_click.motion = 0;
		current_click.ok = 1;
	} else {
		current_click.ok = 0;
		current_click.screenx = e->x;
		current_click.screeny = e->y;
		current_click.button = e->button;
	}
	if (dw->draw.transf_func == z2d) {
		current_click.x = dw->draw.cx + dw->draw.wx *
			((float)(e->x) / (float)(dw->core.width) - 0.5);
		current_click.y = -(-dw->draw.cy + dw->draw.wy *
			((float)(e->y) / (float)(dw->core.height) - 0.5));
	} else if (dw->draw.transf_func == x2d) {
		current_click.y = dw->draw.cy + dw->draw.wx *
			((float)(e->x) / (float)(dw->core.width) - 0.5);
		current_click.z = -(-dw->draw.cz + dw->draw.wy *
			((float)(e->y) / (float)(dw->core.height) - 0.5));
	} else if (dw->draw.transf_func == y2d) {
		current_click.x = dw->draw.cx + dw->draw.wx *
			((float)(e->x) / (float)(dw->core.width) - 0.5);
		current_click.z = -(-dw->draw.cz + dw->draw.wy *
			((float)(e->y) / (float)(dw->core.height) - 0.5));
	}
}

static void DrawWhenUp(w,event,params,num_params)
	DrawWidget	w;
	XEvent	*event;
	String	*params;
	Cardinal	*num_params;
{
	XoWhen	*when;
	XtCallbackRec	*callback;
	int		i;
	char	*fillstr();
	
	when = w->draw.when;
	if (last_click.motion) {
/* the event was a drag since the mouse moved */
		DrawWhenFunc(w,event,params,num_params);
		if (!current_click.ok) {
           	fprintf(stderr,"could not find an object where released\n");
           	return;
        }
		for ( ; when ; when = when->next)
			if (strcmp(when->action,XoDrag) == 0 && 
				when->button == current_click.button )
				execute_button(w,when->script,NULL);
	} else {
/* the event was a click since the mouse stayed in the same place */
		if (current_click.ok) {
			/* Doing the hilighting */
			(((Pix *)(current_click.pix))->hilight->hl_hist)(
				&(w->draw),current_click.pix,current_click.index);
			/* 
			** Setting the pict->value 
			** The idea is that the item currently hilighted should be
			** the one whose value is returned. If there are no 
			** currently hilighted 
			** items, then the site of the last click is chosen.
			*/
			if (((Pix *)(current_click.pix))->hilight->nhl > 0)
				w->draw.pixvalue = 
					(((Pix *)(current_click.pix))->hilight->get_value)
					(&(w->draw),current_click.pix,current_click.index);
			else 
				w->draw.pixvalue = current_click.value;
	
			w->draw.pixname = fillstr(((Pix *)(current_click.pix))->name);
			/* Passing the value to the element equiv of the draw */
			if (((LayoutConstraints)
				(w->core.constraints))->layout.layout_callback 
				!= NULL) {
				callback = (XtCallbackRec *)
					(((LayoutConstraints)
					(w->core.constraints))->layout.layout_callback);
				i = 0;
				while (callback[i].callback != NULL) {
					(callback[i].callback)(w,
						callback[i].closure, NULL);
					i++;
				}
			}
		}
		/* Calling the scripts */
		for ( ; when ; when = when->next) {
			if (strcmp(when->action,XoClick) == 0 && 
				when->button == current_click.button ) {
				execute_button(w,when->script,NULL);
			}
		}
	}
}

static void drawDisplay(w,event,region)
	Widget	w;
	XEvent	*event;
	Region	region;
{
	DrawWidget dw = (DrawWidget) w;
	/*
	XGCValues	values;	
	*/
	Pix			*pix;
	DrawPart	*pict;

	if (!w->core.visible) return;
	RescaleDraw(w);

	pict = &(dw->draw);
	/*
	pict->w = w;
	pict->gc = XtGetGC((Widget)w,GCForeground, &values) ;
	pict->display = XtDisplay(w);
	pict->d = XtWindow(w);

	XSetFillRule(pict->display,pict->gc,WindingRule);
	*/

	pix = pict->images;
	while (pix != NULL) {
		XSetForeground(pict->display,pict->gc,name_to_color(pix->color));
		if (pix->refresh_func)
			(pix->refresh_func)(pict,pix);
		pix = pix->next;
	}
	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
}

RefreshDraw(drawname)
	char *drawname;
{
	Widget	w,x_ntw_get();

	w = (Widget)x_ntw_get(drawname);

	RescaleDraw(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

DrawPoints(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	if (pix->npts > 0)
		XPSDrawPoints(pict->display,pict->d,pict->gc,pix->pts,pix->npts,
			CoordModeOrigin);
}

DrawLines(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	if (pix->npts > 0)
		XPSDrawLines(pict->display,pict->d,pict->gc,pix->pts,pix->npts,
			CoordModeOrigin);
}

DrawSegs(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	XSegment	*segs;
	XPoint		*pts;
	int			i,j = 0;

	if (pix->npts < 2) return;
	pts = pix->pts;
	segs = (XSegment *) malloc(pix->npts/2 * sizeof(XSegment));

	for (i = 0 ; i < pix->npts/2 ; i++) {
		segs[i].x1 = pts[j].x;
		segs[i].y1 = pts[j].y;
		j++;
		segs[i].x2 = pts[j].x;
		segs[i].y2 = pts[j].y;
		j++;
	}

	XPSDrawSegments(pict->display,pict->d,pict->gc,segs,pix->npts/2);

	free(segs);
}

DrawArrows(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	XSegment	*segs;
	XPoint		*pts;
	int			i,j = 0,k = 0;
	float		dx, dy, len;

	if (pix->npts < 2) return;
	pts = pix->pts;
	segs = (XSegment *) malloc(3 * pix->npts/2 * sizeof(XSegment));

	for (i = 0 ; i < pix->npts/2 ; i++) {
		segs[k].x1 = pts[j].x;
		segs[k].y1 = pts[j].y;
		j++;
		segs[k].x2 = pts[j].x;
		segs[k].y2 = pts[j].y;
		j++; 
		dx = segs[k].x2 - segs[k].x1;
		dy = segs[k].y2 - segs[k].y1;
		k++;

		len = sqrt(fabs(dx * dx + dy * dy)) / 10.0;
		segs[k].x2 = segs[k - 1].x2;
		segs[k].y2 = segs[k - 1].y2;
		segs[k].x1 = segs[k].x2 - (dx + dy)/len;
		segs[k].y1 = segs[k].y2 - (dy - dx)/len;
		k++;
		segs[k].x2 = segs[k - 2].x2;
		segs[k].y2 = segs[k - 2].y2;
		segs[k].x1 = segs[k].x2 - (dx - dy)/len;
		segs[k].y1 = segs[k].y2 - (dx + dy)/len;
		k++;
	}

	XPSDrawSegments(pict->display,pict->d,pict->gc,segs,k);

	free(segs);
}

DrawRects(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	XRectangle	*rects;
	XPoint		*pts;
	int			i,j = 0;
	short		x,y;
	short		w,h;

	if (pix->npts < 2) return;
	pts = pix->pts;
	rects = (XRectangle *) malloc(pix->npts/2 * sizeof(XRectangle));

	for (i = 0 ; i < pix->npts/2 ; i++) {
		x = pts[j].x;
		w = pts[j + 1].x - x;
		if (w < 0) {
			x = pts[j + 1].x;
			w = -w;
		}
		y = pts[j].y;
		h = pts[j + 1].y - y;
		if (h < 0) {
			y = pts[j + 1].y;
			h = -h;
		}
		rects[i].x = x;
		rects[i].y = y;
		rects[i].width = w;
		rects[i].height = h;
	}

	XPSDrawRectangles(pict->display,pict->d,pict->gc,rects,pix->npts/2);

	free(rects);
}

DrawArcs(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
}

DrawBitmap(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
}

FillRects(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	XRectangle	*rects;
	XPoint		*pts;
	int			i,j = 0;
	short		x,y;
	short		w,h;

	if (pix->npts < 2) return;
	pts = pix->pts;
	rects = (XRectangle *) malloc(pix->npts/2 * sizeof(XRectangle));

	for (i = 0 ; i < pix->npts/2 ; i++) {
		x = pts[j].x;
		w = pts[j + 1].x - x;
		if (w < 0) {
			x = pts[j + 1].x;
			w = -w;
		}
		y = pts[j].y;
		h = pts[j + 1].y - y;
		if (h < 0) {
			y = pts[j + 1].y;
			h = -h;
		}
		rects[i].x = x;
		rects[i].y = y;
		rects[i].width = w;
		rects[i].height = h;
	}

	XFillRectangles(pict->display,pict->d,pict->gc,rects,pix->npts/2);

	free(rects);
}

CFillPoly(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	if (pix->npts < 1) return;
	XPSFillPolygon(pict->display,pict->d,pict->gc,pix->pts,pix->npts,
		Complex,CoordModeOrigin);
}

FillPoly(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	if (pix->npts < 1) return;
	XPSFillPolygon(pict->display,pict->d,pict->gc,pix->pts,pix->npts,
		Complex,CoordModeOrigin);
}

FillArcs(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
}

DrawString(pict,pix)
	DrawPart	*pict;
	StringPix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i;
	char	**string;
	XPoint	*pts;

	display = pict->display;
	string = pix->string;
	pts = pix->pts;

	for (i = 0 ; i < pix->npts ; i++) {
		XoDrawCenteredString(display,d,gc,string[i],pts[i].x,pts[i].y);
	}
}

FillString(pict,pix)
	DrawPart	*pict;
	StringPix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i;
	char	**string;
	XPoint	*pts;

	display = pict->display;
	string = pix->string;
	pts = pix->pts;

	for (i = 0 ; i < pix->npts ; i++) {
		XoFillCenteredString(display,d,gc,string[i],pts[i].x,pts[i].y);
	}
}

int DrawIcons(pict,pix)
	DrawPart		*pict;
	IconPix		*pix;
{
	int i,j;
	Pix	**icons,*icon;
	int	niconpts = 0;
	XPoint	*pts,*oldpts,*pixpts;
	short	x,y,h;

	if (!(icons = pix->icons)) return(0);
	h = pict->w->core.height;

	for (i = 0 ; i < pix->npts; i++) {
		if (icons [i] && icons[i]->npts > niconpts)
			niconpts = icons[i]->npts;
	}
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	for ( i = 0 ; i < pix->npts; i++) {
		x = pixpts[i].x;
		y = pixpts[i].y - h;
		if (!(icon = icons[i]))
			continue;
		oldpts = icon->pts;
		for (j = 0 ; j < icon->npts ; j++) {
			pts[j].x = oldpts[j].x + x;
			pts[j].y = oldpts[j].y + y;
		}
		icon->pts = pts;
		XSetForeground(pict->display,pict->gc,name_to_color(icon->color));
		(icon->refresh_func)(pict,icon);
		icon->pts = oldpts;
	}
	free(pts);
}

DrawFatLines(pict,pix)
	DrawPart		*pict;
	UnivalPix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i;
	int		*value;
	XPoint	*pts;

	display = pict->display;
	value = pix->value;
	pts = pix->pts;

	for (i = 0 ; i < (pix->npts - 1) ; i+= 2) {
   		XSetLineAttributes(display,gc,(unsigned int)value[i],
   			LineSolid,CapButt,JoinMiter);

  		XPSDrawLine(display,d,gc,pts[i].x,pts[i].y,
			pts[i+1].x,pts[i+1].y);
	}
}

DrawColoredLines(pict,pix)
	DrawPart		*pict;
	UnivalPix	*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int		i;
	int		*value;
	XPoint	*pts;

	display = pict->display;
	value = pix->value;
	pts = pix->pts;

	for (i = 0 ; i < (pix->npts - 1) ; i+= 2) {
		XSetForeground(display,gc,(unsigned long)value[i]);

  		XPSDrawLine(display,d,gc,pts[i].x,pts[i].y,
			pts[i+1].x,pts[i+1].y);
	}
}

DrawFatColoredLines(pict,pix)
	DrawPart		*pict;
	BivalPix	*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i;
	int		*value1, *value2;
	XPoint	*pts;

	display = pict->display;
	value1 = pix->value;
	value2 = pix->value2;
	pts = pix->pts;

	for (i = 0 ; i < (pix->npts - 1) ; i+= 2) {
		XSetForeground(display,gc,(unsigned long)value1[i]);

   		XSetLineAttributes(display,gc,(unsigned int)value2[i],
   			LineSolid,CapButt,JoinMiter);

  		XPSDrawLine(display,d,gc,pts[i].x,pts[i].y,
			pts[i+1].x,pts[i+1].y);
	}
}

XoDrawCenteredString(display,d,gc,str,x,y)
	Display	*display;
	Drawable	d;
	GC	gc;
	char	*str;
	int	x,y;
{
	int	dir,desc,asc;
	int	wid,ht;
	XCharStruct	ret;
	XFontStruct	*fontstruct,*XQueryFont();

	if (str == NULL) return;

	fontstruct = XQueryFont(display,gc->gid);
	XTextExtents(fontstruct,str,strlen(str),&dir,&desc,&asc,&ret);
	wid = ret.rbearing - ret.lbearing;
	ht = ret.ascent + ret.descent;
	XPSDrawString(display,d,gc,x - wid/2,y + ht/2 - ret.descent,str,
		strlen(str));
}

XoFillCenteredString(display,d,gc,str,x,y)
	Display	*display;
	Drawable	d;
	GC	gc;
	char	*str;
	int	x,y;
{
	int	dir,desc,asc;
	int	wid,ht;
	XCharStruct	ret;
	XFontStruct	*fontstruct,*XQueryFont();

	if (str == NULL) return;

	fontstruct = XQueryFont(display,gc->gid);
	XTextExtents(fontstruct,str,strlen(str),&dir,&desc,&asc,&ret);
	wid = ret.rbearing - ret.lbearing;
	ht = ret.ascent + ret.descent;
	XPSDrawImageString(display,d,gc,x - wid/2,y + ht/2 - ret.descent,str,
		strlen(str));
}

char	*
DRAW(argc,argv)
	int argc;
	char	**argv;
{
	Widget	x_ntw_get();
	DrawWidget	dw;

	if (argc < 2) {
		printf("usage : %s treename\n",argv[0]);
		return("");
	}
	if (!(dw = (DrawWidget)x_ntw_get(argv[1])))
		 return("");
}

/*
** DrawPrint:	Print Current Draw to printer
**
*/
static void DrawPrint(w, event)
	Widget	w;
	XEvent	*event;
{
	PreparePS(XtDisplay(w), XtWindow(w), 1.0);
	fprintf(stderr,"Dont do anything, it is PRINTING!\n");
	drawDisplay(w, NULL, NULL);
	FinishPS();
	fprintf(stderr,"FINISHED PRINTING!\n");
}

static void PanLeft(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r = sqrt(x * x + y * y + z * z);
	ratio = w->draw.wx/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		w->draw.cx -= ratio * y / r;
		w->draw.cy += ratio * x / r;
	} else if (w->draw.transf_func == z2d) {
		w->draw.cx += ratio;
	} else if (w->draw.transf_func == x2d) {
		w->draw.cy += ratio;
	} else if (w->draw.transf_func == y2d) {
		w->draw.cx += ratio;
	}
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void PanDown(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r =x * x + y * y + z * z;
	ratio = w->draw.wy/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		w->draw.cx += ratio * x * z / r;
		w->draw.cy += ratio * y * z / r;
		w->draw.cz -= ratio * (x * x + y * y) / r;
	} else if (w->draw.transf_func == z2d) {
		w->draw.cy += ratio;
	} else if (w->draw.transf_func == x2d) {
		w->draw.cz += ratio;
	} else if (w->draw.transf_func == y2d) {
		w->draw.cz += ratio;
	}
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void PanUp(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r =x * x + y * y + z * z;
	ratio = w->draw.wy/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		w->draw.cx -= ratio * x * z / r;
		w->draw.cy -= ratio * y * z / r;
		w->draw.cz += ratio * (x * x + y * y) / r;
	} else if (w->draw.transf_func == z2d) {
		w->draw.cy -= ratio;
	} else if (w->draw.transf_func == x2d) {
		w->draw.cz -= ratio;
	} else if (w->draw.transf_func == y2d) {
		w->draw.cz -= ratio;
	}
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void PanRight(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r = sqrt(x * x + y * y + z * z);
	ratio = w->draw.wx/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		w->draw.cx += ratio * y / r;
		w->draw.cy -= ratio * x / r;
	} else if (w->draw.transf_func == z2d) {
		w->draw.cx -= ratio;
	} else if (w->draw.transf_func == x2d) {
		w->draw.cy -= ratio;
	} else if (w->draw.transf_func == y2d) {
		w->draw.cx -= ratio;
	}
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void ZoomIn(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.wx /= 1.5;
	w->draw.wy /= 1.5;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void ZoomOut(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.wx *= 1.5;
	w->draw.wy *= 1.5;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void TransfX(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.transf_func = x2d;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void TransfY(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.transf_func = y2d;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void TransfZ(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.transf_func = z2d;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void TransfOrtho(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	w->draw.transf_func = ortho3d;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void RotLeft(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ctheta,stheta,nctheta,nstheta;

	x = w->draw.vx;
	y = w->draw.vy;

	r = sqrt(x * x + y * y);
	ctheta = x / r;
	stheta = y / r;
	nctheta = ctheta * cos(ROTANGLE) - stheta * sin(ROTANGLE);
	nstheta = ctheta * sin(ROTANGLE) + stheta * cos(ROTANGLE);
	w->draw.vx = nctheta * r;
	w->draw.vy = nstheta * r;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void RotRight(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float ctheta,stheta,nctheta,nstheta;

	x = w->draw.vx;
	y = w->draw.vy;

	r = sqrt(x * x + y * y);
	ctheta = x / r;
	stheta = y / r;
	nctheta = ctheta * cos(-ROTANGLE) - stheta * sin(-ROTANGLE);
	nstheta = ctheta * sin(-ROTANGLE) + stheta * cos(-ROTANGLE);
	w->draw.vx = nctheta * r;
	w->draw.vy = nstheta * r;
	RescaleDraw(w);
	xodus_set_draw_elm(w);
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
}

static void RotUp(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float cphi,sphi,ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r = sqrt(x * x + y * y + z * z);
	ratio = w->draw.wx/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		cphi = z/r;
		sphi = sqrt(1.0 - cphi * cphi);
		ratio = sphi * cos(ROTANGLE) + sin(ROTANGLE) * cphi;
		cphi = cphi * cos(ROTANGLE) - sphi * sin(ROTANGLE);
		if (sphi > MINANGLE) {
			ratio /= sphi;
			w->draw.vx *= ratio;
			w->draw.vy *= ratio;
			w->draw.vz = r * cphi;
			RescaleDraw(w);
			xodus_set_draw_elm(w);
			XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
		}
	}
}

static void RotDown(w,event)
	DrawWidget	w;
	XEvent	*event;
{
	float x,y,z,r;
	float cphi,sphi,ratio;

	x = w->draw.vx;
	y = w->draw.vy;
	z = w->draw.vz;
	r = sqrt(x * x + y * y + z * z);
	ratio = w->draw.wx/10.0;
	if (w->draw.transf_func == ortho3d || w->draw.transf_func == perspective) {
		cphi = z/r;
		sphi = sqrt(1.0 - cphi * cphi);
		ratio = sphi * cos(-ROTANGLE) + sin(-ROTANGLE) * cphi;
		cphi = cphi * cos(-ROTANGLE) - sphi * sin(-ROTANGLE);
		if (sphi > MINANGLE) {
			ratio /= sphi;
			w->draw.vx *= ratio;
			w->draw.vy *= ratio;
			w->draw.vz = r * cphi;
			RescaleDraw(w);
			xodus_set_draw_elm(w);
			XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
		}
	}
}
