static char rcsid[] = "$Id: draw_hilight.c,v 1.1 1992/12/11 19:06:44 dhb Exp $";

/*
** $Log: draw_hilight.c,v $
** Revision 1.1  1992/12/11  19:06:44  dhb
** Initial revision
**
*/

/****************************************************************
**                                                             **
**                       DRAW HILIGHTS                         **
**                                                             **
****************************************************************/
#include "draw_ext.h"
#include "drawview_w.h"
#include "elmtree_w.h"
#include "xodus_ext.h"


LastOneHist(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	Pix		*hlicon;
	Hilight	*hl;
	int		i;
	int		*index;

	hl = pix->hilight;
	index = hl->index;
	

	if (hl->nhl == 0 || index[0] != hlindex) { 
		/* This cell has not been selected yet */
		if (hl->nhl == 1) { /* get rid of the last point */
			if (hl->hl_drop_disp)
				hl->hl_drop_disp(pict,pix,index[0]);
		}
		index[0] = hlindex;
		hl->nhl = 1;
		if (hl->hl_add_disp)
			hl->hl_add_disp(pict,pix,hlindex);
	} else { 
		/* Remove it from array of selected pixes */
		hl->nhl = 0;
		if (hl->hl_drop_disp)
			hl->hl_drop_disp(pict,pix,hlindex);
	}
}

LastTwoHist(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	Pix		*hlicon;
	Hilight	*hl;
	int		i;
	int		*index;

	hl = pix->hilight;
	index = hl->index;

	if (hl->nhl == 2) {
		if (index[0] == hlindex) {
			/* get rid of first point and reduce nhl */
			if (hl->hl_drop_disp)
				hl->hl_drop_disp(pict,pix,index[0]);
			index[0] = index[1];
			hl->nhl = 1;
		} else if (index[1] == hlindex) {
			if (hl->hl_drop_disp)
				hl->hl_drop_disp(pict,pix,index[1]);
			hl->nhl = 1;
		} else {
			/* get rid of the first point */
			if (hl->hl_drop_disp)
				hl->hl_drop_disp(pict,pix,index[0]);
			if (hl->hl_add_disp)
				hl->hl_add_disp(pict,pix,hlindex);
			index[0] = index[1];
			index[1] = hlindex;
		}
	} else if (hl->nhl == 1) {
		if (index[0] != hlindex) { /* add to second pt */
			if (hl->hl_add_disp)
				hl->hl_add_disp(pict,pix,hlindex);
			index[1] = hlindex;
			hl->nhl = 2;
		} else { /* get rid of first point */
			if (hl->hl_drop_disp)
				hl->hl_drop_disp(pict,pix,index[0]);
			hl->nhl = 0;
		}
	} else if (hl->nhl == 0) { /* add to first hl */
		if (hl->hl_add_disp)
			hl->hl_add_disp(pict,pix,hlindex);
		index[0] = hlindex;
		hl->nhl = 1;
	}
}

FWBLHist(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
}

FWBFHist(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	Pix		*hlicon;
	Hilight	*hl;
	int		i,j;
	int		*index;

	hl = pix->hilight;
	index = hl->index;
	

	for (i = 0 ; i < hl->nhl ; i++)
		if (hlindex == index[i]) break;
	if (i == hl->nhl) { /* This cell has not been selected yet */
		if (hl->nhl == MAXNHL) 
			i--;
		index[i] = hlindex;
		hl->nhl += 1;
		if (hl->hl_add_disp)
			hl->hl_add_disp(pict,pix,hlindex);
	} else { 
		/* Remove it from array of selected pixes */
		hl->nhl-- ;
		for (j = i; j < hl->nhl ; j++)
			index[j] = index[j + 1];
		if (hl->hl_drop_disp)
			hl->hl_drop_disp(pict,pix,hlindex);
	}
}

/* Should really go and look at the refresh_funcs to decide which
** kinds of pixes they are, and size the inverted region accordingly.
** For simplicity, I will only code the default case now 
** Also, I really need a table to get sensible inverses. For now
** I will only use the lower 3 bits since they map onto wildly 
** different colors. Hack !!!!! */
RefreshInvertHl(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i,j;
	XPoint	*pts;
	int	w,h;

	w = pict->w->core.width / 40;
	h = pict->w->core.height / 30;
	display = pict->display;
	pts = pix->pts;
	XSetState(display,gc,0x7,0,GXandReverse,0xffff);

	for (i = 0 ; i < pix->hilight->nhl ; i++) {
		j = pix->hilight->index[i];
		XFillRectangle(display,d,gc,pts[j].x - w,pts[j].y - h,
			w + w, h + h);
	}
	XSetState(display,gc,1,0,GXcopy,0xffff);
}

AddInvertHl(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	int w = pict->w->core.width / 40;
	int h = pict->w->core.height / 30;

	XSetState(pict->display,pict->gc,0x7,0,GXandReverse,0xffff);
	XFillRectangle(pict->display,pict->d,pict->gc,
		pix->pts[hlindex].x - w,pix->pts[hlindex].y - h,
			w + w, h + h);
	XSetState(pict->display,pict->gc,1,0,GXcopy,0xffff);
}

DropInvertHl(pict,pix,hlindex)
	DrawPart	*pict;
	Pix		*pix;
	int		hlindex;
{
	int w = pict->w->core.width / 40;
	int h = pict->w->core.height / 30;

	XSetState(pict->display,pict->gc,0x7,0,GXandReverse,0xffff);
	XFillRectangle(pict->display,pict->d,pict->gc,
		pix->pts[hlindex].x - w,pix->pts[hlindex].y - h,
			w + w, h + h);
	XSetState(pict->display,pict->gc,1,0,GXcopy,0xffff);
	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XSetBackground(pict->display,pict->gc,pict->w->core.background_pixel);
}

RefreshStarHl(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i,j;
	XPoint	*pts;

	display = pict->display;
	pts = pix->pts;

	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	for (i = 0 ; i < pix->hilight->nhl ; i++) {
		j = pix->hilight->index[i];
		XoDrawCenteredString(display,d,gc,"*",pts[j].x,pts[j].y);
	}
}

AddStarHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XoDrawCenteredString(pict->display,pict->d,pict->gc,"*",
		pix->pts[index].x,pix->pts[index].y);
}

DropStarHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	XSetForeground(pict->display,pict->gc,pict->w->core.background_pixel);
	XoDrawCenteredString(pict->display,pict->d,pict->gc,"*",
		pix->pts[index].x,pix->pts[index].y);
	if (pix->hilight->hl_clean_disp)
		(pix->hilight->hl_clean_disp)(pict,pix,index);
}

RefreshCountHl(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int	i,j;
	XPoint	*pts;
	static char	str[10];

	display = pict->display;
	pts = pix->pts;

	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XSetBackground(pict->display,pict->gc,0);
	for (i = 0 ; i < pix->hilight->nhl ; i++) {
		j = pix->hilight->index[i];
		sprintf(str,"%d",i);
		XoFillCenteredString(display,d,gc,str,pts[j].x,pts[j].y);
	}
}

AddCountHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	static char	str[10];

	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XSetBackground(pict->display,pict->gc,0);
	sprintf(str,"%d",pix->hilight->nhl - 1);
	XoFillCenteredString(pict->display,pict->d,pict->gc,str,
		pix->pts[index].x,pix->pts[index].y);
}

DropCountHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	static char	str[10];

	XSetForeground(pict->display,pict->gc,pict->w->core.background_pixel);
	XSetBackground(pict->display,pict->gc,pict->w->core.background_pixel);
	sprintf(str,"%d",pix->hilight->nhl - 1);
	XoFillCenteredString(pict->display,pict->d,pict->gc,str,
		pix->pts[index].x,pix->pts[index].y);
	if (pix->hilight->hl_clean_disp)
		(pix->hilight->hl_clean_disp)(pict,pix,index);
}

RefreshIndexHl(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
	Display	*display;
	Drawable d = pict->d;
	GC		gc = pict->gc;
	int		i,j;
	XPoint	*pts;
	static	char	str[20];

	display = pict->display;
	pts = pix->pts;

	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XSetBackground(pict->display,pict->gc,0);

	for (i = 0 ; i < pix->hilight->nhl ; i++) {
		j = pix->hilight->index[i];
		sprintf(str,"%d",j);
		XoFillCenteredString(display,d,gc,str,pts[j].x,pts[j].y);
	}
}

AddIndexHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	static	char	str[20];

	XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
	XSetBackground(pict->display,pict->gc,0);

	sprintf(str,"%d",index);
	XoFillCenteredString(pict->display,pict->d,pict->gc,str,
		pix->pts[index].x,pix->pts[index].y);
}

DropIndexHl(pict,pix,index)
	DrawPart	*pict;
	Pix		*pix;
	int		index;
{
	static	char	str[20];
	
	XSetForeground(pict->display,pict->gc,pict->w->core.background_pixel);
	XSetBackground(pict->display,pict->gc,pict->w->core.background_pixel);
	sprintf(str,"%d",index);
	XoFillCenteredString(pict->display,pict->d,pict->gc,str,
		pix->pts[index].x,pix->pts[index].y);
	if (pix->hilight->hl_clean_disp)
		(pix->hilight->hl_clean_disp)(pict,pix,index);
}

BorderHl(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
}

IconHl(pict,pix)
	DrawPart	*pict;
	Pix		*pix;
{
}


CleanViewHl(pict,pix,index)
	DrawPart	*pict;
	ViewPix		*pix;
	int		index;
{
	int	*value;
	int		val;
	int 	i,j;
	Pix		**icons,*icon;
	int		niconpts = 0;
	XPoint	*pts,*oldpts,*pixpts;
	short	x,y;
	short	h = pict->w->core.height;
	int colorflag = 0;

	pixpts = pix->pts;
	value = pix->value;
	icons = pix->icons;

	if (!(icons = pix->icons)) return(0);

	val = value[index];
	if (val >= NICONS) val = NICONS - 1;
	else if (val < 0) val = 0;
	niconpts = icons[val]->npts;
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	x = pixpts[index].x;
	y = pixpts[index].y;

	if (index < 0)
		index = 0;
	else if (val >= NICONS)
		val = NICONS - 1;
	icon = icons[val];

	oldpts = icon->pts;
	for (j = 0 ; j < icon->npts ; j++) {
		pts[j].x = oldpts[j].x + x;
		pts[j].y = oldpts[j].y + y - h;
	}
	icon->pts = pts;
    if (strcmp(pix->viewmode,XtNboxview) == 0 || 
        strcmp(pix->viewmode,XtNfillboxview) == 0 || 
        strcmp(pix->viewmode,XtNxbar) == 0 || 
        strcmp(pix->viewmode,XtNybar) == 0 || 
        strcmp(pix->viewmode,XtNzbar) == 0 || 
        strcmp(pix->viewmode,XtNsizeiconview) == 0)
		XSetForeground(pict->display,pict->gc,name_to_color(icon->color));
	else
		XSetForeground(pict->display,pict->gc,colorscale[(int)(icon->color)]);
	(icon->refresh_func)(pict,icon);
	icon->pts = oldpts;

	free(pts);
}

CleanIconHl(pict,pix,index)
	DrawPart	*pict;
	IconPix		*pix;
	int		index;
{
	int	*value;
	int		val;
	int 	i,j;
	Pix		**icons,*icon;
	int		niconpts = 0;
	XPoint	*pts,*oldpts,*pixpts;
	short	x,y;
	short	h = pict->w->core.height;

	pixpts = pix->pts;
	icons = pix->icons;

	if (!(icons = pix->icons)) return(0);

	niconpts = icons[index]->npts;
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	x = pixpts[index].x;
	y = pixpts[index].y;

	if (index < 0)
		index = 0;

	icon = icons[index];

	oldpts = icon->pts;
	for (j = 0 ; j < icon->npts ; j++) {
		pts[j].x = oldpts[j].x + x;
		pts[j].y = oldpts[j].y + y - h;
	}
	icon->pts = pts;
	XSetForeground(pict->display,pict->gc,name_to_color(icon->color));
	(icon->refresh_func)(pict,icon);
	icon->pts = oldpts;

	free(pts);
}

CleanTreeHl(pict,pix,index)
	DrawPart	*pict;
	TreePix		*pix;
	int		index;
{
	int	*value;
	int		val;
	int 	i,j;
	Pix		**icons,*icon;
	int		niconpts = 0;
	XPoint	*pts,*oldpts,*pixpts;
	short	x,y;
	short	h = pict->w->core.height;

	pixpts = pix->pts;
	icons = pix->icons;

	if (!(icons = pix->icons)) return(0);

	niconpts = icons[index]->npts;
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
	pixpts = pix->pts;

	x = pixpts[index].x;
	y = pixpts[index].y;

	if (index < 0)
		index = 0;

	icon = icons[index];

	oldpts = icon->pts;
	for (j = 0 ; j < icon->npts ; j++) {
		pts[j].x = oldpts[j].x + x;
		pts[j].y = oldpts[j].y + y - h;
	}
	icon->pts = pts;
	XSetForeground(pict->display,pict->gc,name_to_color(icon->color));
	(icon->refresh_func)(pict,icon);
	icon->pts = oldpts;
	XSetForeground(pict->display,pict->gc,name_to_color(pix->color));
	XSetBackground(pict->display,pict->gc,0);
	XoFillCenteredString(pict->display,pict->d,pict->gc,pix->text[index],
		pixpts[index].x,pixpts[index].y);

	free(pts);
}
