static char rcsid[] = "$Id: do_draw_widgets.c,v 1.1 1992/12/11 19:06:42 dhb Exp $";

/*
** $Log: do_draw_widgets.c,v $
** Revision 1.1  1992/12/11  19:06:42  dhb
** Initial revision
**
*/

#include	"draw_ext.h"
#include	"xodus_args.h"
#include	"draw_funcs.h"


/****************************************************************
**                                                             **
**                      DRAW WIDGETS                           **
**                                                             **
****************************************************************/

Widget
do_3d_draw(argc,argv)
	int 	argc;
	char    **argv;
{
	int	xt,yt,wt,ht, usercoord;
	float	xmin, ymin, xmax, ymax;
	char	*name;
	Widget	draw_w;
	Widget	x_3d_draw();

	if (argc < 2) {
		fprintf(stderr, "usage: %s name \n", argv[0]);
		return(NULL);
	}
	xodus_reset_arg();
	/*
	if (debug)
		fprintf(stderr,"genesis_find_form called with %s\n", argv[1]);
	*/
	genesis_find_form(argv[1]);
	name = (char *)GetBaseComponent(argv[1]);
	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;
	xodus_parse_args(argc - 2, argv + 2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"do_3d_draw: no parent form selected from %s\n",
			argv[0]);
		return(NULL);
	}

	draw_w = (Widget)x_3d_draw(
		x_arg(ARG_FORM), x_arg(ARG_NAME), 
		x_arg(ARG_TITLE), atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		g_copy(x_arg(ARG_SCRIPT)),
		xt, yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);

	return(draw_w);

}

/****************************************************************
**                                                             **
**                        Draw Commands                        **
**                                                             **
****************************************************************/


XoPixUpdate(argc,argv)
    int     argc;
    char    **argv;
{
    DrawWidget  dw;
    Widget  XoGetWidgetFromString();
	Pix			*pix;

    if (argc < 3) {
        printf("usage : %s drawname pixname\n",argv[0]);
        return;
    }
    if (!(dw = (DrawWidget)XoGetWidgetFromString(argv[1]))) return;
    if (!(pix = find_pix2(dw,argv[2]))) return;
	update_pix(dw,pix,0);
}

update_pix(dw,pix)
	DrawWidget	dw;
	Pix		*pix;
{
	XGCValues	values;

	/*
    dw->draw.w = (Widget)dw;
    dw->draw.gc = XtGetGC((Widget)dw,GCForeground, &values) ;
    dw->draw.display = XtDisplay(dw);
    dw->draw.d = XtWindow(dw);
	*/

	/*
	horrible hack to decide if the elements should be refreshed first
	to clear them for the views which use size of elements to display
	them.
	*/
    if (pix->update && pix->update->func) {
		if (pix->refresh_func == ViewIcons) 
			UnViewIcons(&(dw->draw),pix);
        (pix->update->func)(dw,pix,0);
	}
    if (pix->refresh_func) 
        (pix->refresh_func)(&(dw->draw),pix);
	if (dw->draw.display)
		/*XFlush(dw->draw.display); */
		XSync(dw->draw.display,0);
}

XoWidgetUpdate(argc,argv)
    int     argc;
    char    **argv;
{
    Widget  w,XoGetWidgetFromString();
	Pix		*pix;

    if (argc < 2) {
        printf("usage : %s drawname\n",argv[0]);
        return;
    }
    if (!(w = XoGetWidgetFromString(argv[1]))) return;
	XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,False);
	if (strcmp(XtClass(w)->core_class.class_name,"draw") == 0) {
		for (pix = ((DrawWidget)w)->draw.images; pix ; pix = pix->next){
    		if (pix->update && pix->update->func) {
        		(pix->update->func)(w,pix,0);
			}
    		if (pix->refresh_func) {
        		(pix->refresh_func)(&(((DrawWidget)(w))->draw),pix);
			}
		}
	}
	/*XFlush(XtDisplay(w));*/
	XSync(XtDisplay(w),0);
}

XoSendEvent(argc,argv)
    int     argc;
    char    **argv;
{
    Widget  w,XoGetWidgetFromString();
	static XButtonEvent xbe = {ButtonPress, 0,FALSE, 
		NULL,NULL,NULL,NULL,0,0,0,0,0,Button1Mask,Button1,TRUE};


    if (argc < 3) {
        printf("usage : %s drawname action\n",argv[0]);
		printf("allowed actions : click1 click2 click3\n");
        return;
    }
    if (!(w = XoGetWidgetFromString(argv[1]))) return;
	if (strcmp(argv[2],"click1") == 0)
		xbe.button = Button1;
	else if (strcmp(argv[2],"click2") == 0)
		xbe.button = Button2;
	else if (strcmp(argv[2],"click3") == 0)
		xbe.button = Button3;
	else {
        printf("usage : %s drawname action\n",argv[0]);
		printf("allowed actions : click1 click2 click3\n");
		return;
	}
	XoExecuteButton(w,&xbe);
}

XoListPix(argc,argv)
    int     argc;
    char    **argv;
{
    DrawWidget  dw;
	Pix			*pix;
	int			i;

    if (argc < 2) {
        printf("usage : %s drawname\n",argv[0]);
        return;
    }
    if (!(dw = (DrawWidget)XoGetWidgetFromString(argv[1]))) return;

	pix = dw->draw.images;
	printf("Pixes for widget '%s' : \n",argv[1]);
	for (i = 1 ; pix ; pix = pix->next , i++)
		printf("%d : pix name = '%s'\n",i,pix->name);

	pix = dw->draw.icons;
	printf("Icons for widget '%s' : \n",argv[1]);
	for (i = 1 ; pix ; pix = pix->next , i++)
		printf("%d : pix name = '%s'\n",i,pix->name);
}

/*
** x_3d_draw:	Create a 3d draw widget
**
*/
Widget
x_3d_draw(form,name,title,x,y,width,height,script, xt, yt, wt, ht,
		xwidget, ywidget, wwidget, hwidget, usercoord)
	char	*form, *name, *title;
	Position		x,y;
	Dimension		width, height;
	char	*script;
	int	xt,yt,wt,ht,usercoord;
	char	*xwidget, *ywidget, *wwidget, *hwidget;
{
	Widget	parent, draw3_widget;
	Widget	init_3d_draw_w();
	char	*temp;

	parent = (Widget)x_ntw_get(form);
	if (parent == NULL) {
		fprintf(stderr,"x_draw:	No parent named '%s' found\n", form);
		return(NULL);
	}

	temp = (char *)g_copy(name);
	draw3_widget = init_3d_draw_w(parent, temp, title, script, x, y,
		 width, height, xt, yt, wt, ht, xwidget, ywidget,
		wwidget, hwidget, usercoord);

	x_ntw_add(name,draw3_widget);
	return(draw3_widget);
}
