/*
** $Id: XoClickBuffer.h,v 1.1 1992/12/11 19:07:03 dhb Exp $
** $Log: XoClickBuffer.h,v $
** Revision 1.1  1992/12/11  19:07:03  dhb
** Initial revision
**
*/

struct click_buffer_struct {
	Widget	w; 			/* widget that was clicked on */
	char	*widgetname;/* widget that was clicked on */
	char	*value;		/* value found on click */
	char	*pix;		/* pix where value was found */
	char	*icon;		/* icon to be displayed by cursor if dragging*/
	int 	index;		/* index of object clicked on */
	int 	screenx,screeny;	/* screen position of click */
	float	x,y,z;		/* 3d coords of click (2d in case of graph) */
	int		button;		/* tells which button was hit.  */
	int		motion;		/* flag to indicate that the mouse will move */
	int		ok;			/* flag to say if value was found ok */
};

extern struct click_buffer_struct current_click;
extern struct click_buffer_struct last_click;

extern void WhenMotion();

#ifdef EXPLANATION

Operations performed for various actions : (in order of execution, if
	the options are specified)

click(n)		Automatically sets values, then runs <script>
doubleclick(n) 	Automatically sets values, then runs <script>
drag(n)			No values are changed, only runs <script>
update			<script> 


In each case, every event fills up the click buffers first. 
There are two click buffers - current_click and last_click.
They are accessible from the script using the following routines:
thiswidget		- returns the current click widget name/path
thisvalue		- returns the current click value 
thispos			- returns the screen position of the click x y 
thiscoord		- returns the equivalent coords of the click x y z

lastwidget		- returns the last click widget name/path
lastvalue		- returns the last click value 
lastpos			- returns the screen position of the click x y 
lastcoord		- returns the equivalent coords of the click x y z

After a click or doubleclick the current_click buffer will contain the 
info about the object just clicked on. The last_click buffer will
have the previous values of current click.
After a drag, the current_click buffer will have the values of the 
destination object and the last_click buffer will have the values of
the source object.
An update does not change the buffers.

#endif

