static char rcsid[] = "$Id: Cell.c,v 1.1 1992/10/29 19:57:31 dhb Exp $";

/*
** $Log: Cell.c,v $
 * Revision 1.1  1992/10/29  19:57:31  dhb
 * Initial revision
 *
*/

/******************************************************************
**                                                               **
**                  Cell.c : Cell display widget                 **
**                                                               **
**          By Upinder S. Bhalla, 1989, 1991 Caltech             **
**                                                               **
******************************************************************/

/* All the necessary include files */
#include "draw_ext.h"
#include "draw_funcs.h"
#include "xodus_ext.h"
#include "Cell.h"

/* This really depends on the segment.g file for symcompartments */
#define CONNECTCROSS_NUM	5

static char	*GetCellValue();
static Boolean CellSetHook();
static void CellGetHook();
static int		MembId;
int	CellRefresh();
int	CleanCellHl();
int	CellUpdateFunc();

static XtResource CellResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, name),
        XtRString, "view"
    },
    {XtNfatfield, XtCFatfield, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fatfield),
        XtRString, "dia"
    },
    {XtNautofat, XtCAutofat, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, autofat),
        XtRString, "TRUE"
    },
    {XtNfatmin, XtCFatmin, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fatmin),
        XtRString, "0"
    },
    {XtNfatmax, XtCFatmax, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fatmax),
        XtRString, "1"
    },
    {XtNfatfix, XtCFatfix, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fatfix),
        XtRString, "FALSE"
    },
    {XtNfatrange, XtCFatrange, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fatrange),
        XtRString, "-40"
    },

    {XtNcolfield, XtCColfield, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, colfield),
        XtRString, "x"
    },
    {XtNautocol, XtCAutocol, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, autocol),
        XtRString, "TRUE"
    },
    {XtNcolmin, XtCColmin, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, colmin),
        XtRString, "0"
    },
    {XtNcolmax, XtCColmax, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, colmax),
        XtRString, "1"
    },
    {XtNcolfix, XtCColfix, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, colfix),
        XtRString, "FALSE"
    },

    {XtNpath, XtCPath, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, path),
        XtRString, "/"
    },
    {XtNrootpath, XtCRootpath, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, rootpath),
        XtRString, "/"
    },
    {XtNfieldpath, XtCFieldpath, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, fieldpath),
        XtRString, "."
    },

    {XtNlabelmode, XtCLabelmode, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, labelmode),
        XtRString, "none"
    },

    {XtNrooticon, XtCIconname, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, rooticon),
        XtRString, "none"
    },
    {XtNox, XtCOx, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, ox),
        XtRString, "0.00000000000000"
    },
    {XtNoy, XtCOy, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, oy),
        XtRString, "0.00000000000000"
    },
    {XtNoz, XtCOz, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, oz),
        XtRString, "0.00000000000000"
    },

    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(CellPixPtr, hldispmode),
        XtRString, "star"
    },
};


Pix *
XoCreateCell(parent,args,num_args)
	DrawWidget	parent;
	ArgList	args;
	Cardinal	num_args;
{
	CellPix			*pix;
	Pix				*image,*icon;
	char			*fillstr();

	parent->draw.pixvalue = (char *) calloc(200,sizeof(char));
	pix = (CellPix *) calloc(1,sizeof(CellPix));
	pix->name = (char *)calloc(20,sizeof(char));
	pix->color = (char *)calloc(20,sizeof(char));
	pix->fatfield = (char *)calloc(20,sizeof(char));
	pix->autofat = (char *)calloc(20,sizeof(char));
	pix->fatmin = (char *)calloc(20,sizeof(char));
	pix->fatmax = (char *)calloc(20,sizeof(char));
	pix->fatfix = (char *)calloc(20,sizeof(char));
	pix->fatrange = (char *)calloc(20,sizeof(char));
	pix->colfield = (char *)calloc(20,sizeof(char));
	pix->autocol = (char *)calloc(20,sizeof(char));
	pix->colmax = (char *)calloc(20,sizeof(char));
	pix->colmin = (char *)calloc(20,sizeof(char));
	pix->colfix = (char *)calloc(20,sizeof(char));
	pix->path = (char *)calloc(20,sizeof(char));
	pix->rootpath = (char *)calloc(40,sizeof(char));
	pix->fieldpath = (char *)calloc(80,sizeof(char));
	pix->labelmode = (char *)calloc(20,sizeof(char));
	pix->rooticon = (char *)calloc(20,sizeof(char));
	
	image = parent->draw.images;
	icon = parent->draw.icons;
	/* Might have to do XrmGetResources here instead if the
	** routine overwrites existing images.  */
	XtGetSubresources(parent,pix,XtNimages,XtCPix,CellResources,
		XtNumber(CellResources),args,num_args);

	parent->draw.pixname = fillstr(pix->name);

	parent->draw.images = (Pix *)pix;
	pix->next = image;
	parent->draw.icons = icon;

	pix->resources = CellResources;
	pix->num_resources = XtNumber(CellResources);
	pix->rescale = (Rescale *) calloc(1,sizeof(ElmRescale));
	pix->update = (Update *) calloc(1,sizeof(ElmViewUpdate));
	pix->update2 = (Update *) calloc(1,sizeof(ElmViewUpdate));
	pix->refresh_func = CellRefresh;
	pix->set_hook = CellSetHook;
	pix->get_hook = CellGetHook;

	MembId = ClassID("membrane");

	SetElmCellPath(parent,pix);
	if (!SetCellRescale(parent,pix)) {
		fprintf(stderr,"Error in creating Cell Rescale\n");
		return(NULL);
	}
	if (!SetCellUpdate(parent,pix)) {
		fprintf(stderr,"Error in creating View update\n");
		return(NULL);
	}

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);
	pix->hilight->get_value = GetCellValue;
	pix->hilight->hl_clean_disp = CleanCellHl;

	RescaleDraw(parent);
	if (pix->update && (((ElmViewUpdate *)(pix->update))->func))
		(((ElmViewUpdate *)(pix->update))->func)(parent,pix);

	/* Hack to shut the pixcolor complaint up */
	pix->color = "Black";
	return((Pix *)pix);
}

SetCellRescale(parent,pix)
	Widget	parent;
	CellPix	*pix;
{
	return(1);
}

int SetElmCellPath(parent,pix)
	Widget	parent;
	CellPix	*pix;
{
	Element 		**elms;
	Element 		*GetElement(),*RelGetElement();
	ElmRescale		*rescale;
	ElementList		*elmlist, *WildcardGetElement();
	int				nptrs;
	int				i;

	if (!(elmlist = WildcardGetElement(pix->path, 0))) {
		fprintf(stderr,"couldnt parse path %s\n",pix->path);
		return(0);
	}
	nptrs = elmlist->nelements;
	elms = elmlist->element;
    if (nptrs == 0 || (!elms)) {
        printf("No elements found for this path (%s)\n", pix->path);
        return(0);
    }

	if (!(pix->root_elm = GetElement(pix->rootpath))) {
        printf("No element found for this path (%s)\n", pix->rootpath);
        return(0);
	}

	if (pix->npts < nptrs) {
		if (pix->pts) free(pix->pts);
		if (pix->val1) free(pix->val1);
		if (pix->val2) free(pix->val2);
		if (pix->parents) free(pix->parents);
		pix->pts = (XPoint *) calloc(nptrs, sizeof(XPoint));
		pix->val1 = (int *) calloc(nptrs, sizeof(int));
		pix->val2 = (int *) calloc(nptrs, sizeof(int));
		pix->parents = (int *) calloc(nptrs, sizeof(int));
	}
	pix->npts = nptrs;

	rescale = (ElmRescale *)(pix->rescale);
	rescale->elms = elms;
	rescale->path = pix->path;
	rescale->rel_path = pix->fieldpath;
	if (strcmp(pix->fieldpath,".") != 0) { /* using fieldpath */
		if (rescale->rel_elms)
			free(rescale->rel_elms);
		rescale->rel_elms = (Element **)calloc(nptrs,sizeof(Element *));
		for(i=0;i<nptrs;i++) {
			rescale->rel_elms[i] = 
				RelGetElement(elms[i],pix->fieldpath);
			/*
			if (!(rescale->rel_elms[i] = 
				RelGetElement(elms[i],pix->fieldpath)))
				*/
		}
	}
	rescale->func = UseElms;
	sscanf(pix->ox,"%f",&(rescale->offset.x));
	sscanf(pix->oy,"%f",&(rescale->offset.y));
	sscanf(pix->oz,"%f",&(rescale->offset.z));
	generate_arbor(pix);
	return(1);
}

/*
** Sets two update structures : one for the color and the other 
** for the thickness of the dends
*/
SetCellUpdate(parent,pix)
	Widget	parent;
	CellPix	*pix;
{
	int		type = 0,offset = 0;
	ElmViewUpdate	   *update;

	update = (ElmViewUpdate *) pix->update;
	update->func = CellUpdateFunc;
	update->vmin = Atof(pix->colmin);
	update->vmax = Atof(pix->colmax);
	update->autoscale = (strcmp(pix->autocol,"TRUE") == 0);
	update->field = pix->colfield;
	if (strcmp(update->field,"calc_dia") == 0) {
		if (GetElmFieldInfo("Ra",&type,&offset,
			((ElmRescale *)(pix->rescale))->elms,pix->npts) != PATHERROR) {
			update->offset = offset;
			if (type == FLOATARRAY) {
				update->field_type = DIARRAY;
			} else {
				update->field_type = WRONG;
				/*
				printf("Ra is of wrong type %d\n",type);
				*/
			}
		} else {
			update->field_type = WRONG;
		}
	} else if (strcmp(pix->fieldpath,".") != 0) {
		/*
		if (((ElmRescale *)(pix->rescale))->rel_elms[0]) 
		if (GetElmFieldInfo(update->field,&type,&offset,
			((ElmRescale *)(pix->rescale))->rel_elms,pix->npts) != PATHERROR) 
		*/
		switch (GetElmFieldInfo(update->field,&type,&offset,
			((ElmRescale *)(pix->rescale))->rel_elms,pix->npts)){
			case PATHSET :
				update->offset = offset;
				update->field_type = type;
			break;
			case PATHNOTSET :
				if (!((ElmRescale *)(pix->rescale))->rel_elms[0]) {
					update->field_type = WRONG;
					break;
				}
				if (getobjenv(((ElmRescale *)
				(pix->rescale))->rel_elms[0]->object,update->field)) {
					update->field_type = ENVARRAY;
				} else {
					update->field_type = WRONG;
					printf("field '%s' not known\n",update->field);
				}
			break;
			default :
				printf("field '%s' on path '%s' not found\n",
					update->field,pix->fieldpath);
			break;
		}
	} else {
		if (GetElmFieldInfo(update->field,&type,&offset,
			((ElmRescale *)(pix->rescale))->elms,pix->npts) != PATHERROR) {
			update->offset = offset;
			update->field_type = type;
		}  else if (!((ElmRescale *)(pix->rescale))->elms[0]) {
				update->field_type = WRONG;
		} else if (getobjenv(((ElmRescale *)(pix->rescale))->elms[0]->object,
			update->field)) {
			update->field_type = ENVARRAY;
		} else {
			update->field_type = WRONG;
			printf("field '%s' not known\n",update->field);
		}
	}

	type = 0, offset = 0;
	update = (ElmViewUpdate *) pix->update2;
	update->func = CellUpdateFunc;
	update->vmin = Atof(pix->fatmin);
	update->vmax = Atof(pix->fatmax);
	update->autoscale = (strcmp(pix->autofat,"TRUE") == 0);
	update->field = pix->fatfield;
	if (strcmp(update->field,"calc_dia") == 0) {
		if (GetElmFieldInfo("Ra",&type,&offset,
			((ElmRescale *)(pix->rescale))->elms,pix->npts) != PATHERROR) {
			update->offset = offset;
			if (type == FLOATARRAY) {
				update->field_type = DIARRAY;
			} else {
				update->field_type = WRONG;
				/*
				printf("Ra is of wrong type %d\n",type);
				*/
			}
		} else {
			update->field_type = WRONG;
		}
	} else if (GetElmFieldInfo(update->field,&type,&offset,
		((ElmRescale *)(pix->rescale))->elms,pix->npts) != PATHERROR) {
		update->offset = offset;
		update->field_type = type;
	}  else if (
		getobjenv(((ElmRescale *)(pix->rescale))->elms[0]->object,
		update->field)) {
		update->field_type = ENVARRAY;
	} else {
		update->field_type = WRONG;
		printf("field '%s' not known\n",update->field);
	}
	return(1);
}

/*
** Same as ElmViewUpdate func but this one has more array options
** and has a subroutine which does most of the work, which is 
** called twice : for the fat and col updates respectively.
*/
int CellUpdateFunc(parent,pix)
	DrawWidget	parent;
	CellPix		*pix;
{
	float maxrange;

	UpdateCalc(pix,pix->update,pix->val1,NICONS);
	sprintf(pix->colmin,"%.9g",((ElmViewUpdate *)(pix->update))->vmin);
	sprintf(pix->colmax,"%.9g",((ElmViewUpdate *)(pix->update))->vmax);

	/* set the max width of the dendrite line segments :
	** If fatrange is negative, the absolute value of fatrange is the
	** max width in pixels.
	** If fatrange is positive, it represents the max width in space
	** units as used by the draw widget, and hence scales with the
	** draw widget parameters.
	*/
	maxrange = Atof(pix->fatrange);
	if (maxrange < 0)
		maxrange = -maxrange;
	else
		maxrange = maxrange *
			(((float)parent->core.width) / parent->draw.wx + 
			((float)parent->core.height) / parent->draw.wy) / 2.0;
	UpdateCalc(pix,pix->update2,pix->val2,(int)maxrange);
	sprintf(pix->fatmin,"%.9g",((ElmViewUpdate *)(pix->update2))->vmin);
	sprintf(pix->fatmax,"%.9g",((ElmViewUpdate *)(pix->update2))->vmax);
}

UpdateCalc(pix,update,pixvalue,maxrange)
	CellPix	*pix;
	ElmViewUpdate *update;
	int		*pixvalue;
	int		maxrange;
{
	int i;
	float	*value;
	float	vmin,vmax;
	float	scale;
	int		offset = 0, offset2 = 0;
	int		type = 0;
	Element	**elms;
	char	*e;
	ElmViewUpdate	*u2;

	if (pix->npts <= 0) return;
	value = (float *) calloc(pix->npts, sizeof(float));
	offset = update->offset;
	u2=(ElmViewUpdate *)(pix->update2);
	switch (update->field_type) {
		case	FLOATARRAY :
			if (strcmp(pix->fieldpath,".")==0 || update==u2){
				elms = ((ElmRescale *)(pix->rescale))->elms;
			} else {
				elms = ((ElmRescale *)(pix->rescale))->rel_elms;
			}
			for (i = 0 ; i < pix->npts; i++ ) 
				if (elms[i])
					value[i]  = *((float *)((char *)elms[i] + offset));
			break;
		case	DOUBLEARRAY :
			if (strcmp(pix->fieldpath,".")==0 || update==u2){
				elms = ((ElmRescale *)(pix->rescale))->elms;
			} else {
				elms = ((ElmRescale *)(pix->rescale))->rel_elms;
			}
			for (i = 0 ; i < pix->npts; i++ ) 
				if (elms[i])
				value[i]  = (float)(*((double *)((char *)elms[i] +
					offset)));
			break;
		case	SHORTARRAY :
			if (strcmp(pix->fieldpath,".")==0 || update==u2){
				elms = ((ElmRescale *)(pix->rescale))->elms;
			} else {
				elms = ((ElmRescale *)(pix->rescale))->rel_elms;
			}
			for (i = 0 ; i < pix->npts; i++ ) 
				if (elms[i])
				value[i]  = (float)(*((short *)((char *)elms[i] +
					offset)));
			break;
		case	INTARRAY :
			if (strcmp(pix->fieldpath,".")==0 || update==u2){
				elms = ((ElmRescale *)(pix->rescale))->elms;
			} else {
				elms = ((ElmRescale *)(pix->rescale))->rel_elms;
			}
			for (i = 0 ; i < pix->npts; i++ ) 
				if (elms[i])
				value[i]  = (float)(*((int *)((char *)elms[i] + 
					offset)));
			break;
		case	DIARRAY :
			elms = ((ElmRescale *)(pix->rescale))->elms;
			if (GetElmFieldInfo("Cm",&type,&offset2,
				((ElmRescale *)(pix->rescale))->elms,pix->npts) == PATHERROR) {
				printf("couldn't get field Cm\n");
				return(0);
			}
			if (type != FLOATARRAY) {
				printf("Field Cm is not a float %d\n",type);
				return(0);
			}
			/* get the Ra's */
			for (i = 0 ; i < pix->npts; i++ ) {
				value[i]  = *((float *)((char *)elms[i] + offset));
				if (value[i] < EPSILON) {
					printf("Ra is Zero for element %s\n",elms[i]->name);
					return;
				}
			}
			for (i = 0 ; i < pix->npts; i++ ) {
				value[i] = (*((float *)((char *)elms[i] + offset2))) /
					value[i];
				value[i] = exp((log(value[i]))/3.0);
			}
			break;
		case ENVARRAY :
			if (strcmp(pix->fieldpath,".") == 0) {
				elms = ((ElmRescale *)(pix->rescale))->elms;
			} else {
				elms = ((ElmRescale *)(pix->rescale))->rel_elms;
			}
			for (i = 0 ; i < pix->npts; i++ ) 
				if (elms[i])
				value[i]  = Atof(getobjenv(elms[i]->object,
					update->field));
			break;
		default :
			break;
	}
	if (update->autoscale) {
		vmax = vmin = value[0];
		for (i = 0 ; i < pix->npts; i++) {
			if (vmin > value[i])
				vmin = value[i];
			else if (vmax < value[i])
				vmax = value[i];
		}
		update->vmin = vmin;
		update->vmax = vmax;
	}

	if ((scale = update->vmax - update->vmin) < EPSILON) {
		free(value);
		for (i = 0 ; i < pix->npts; i++) 
			pixvalue[i] = maxrange/2;
		return;
	}

	vmin = update->vmin;
	scale = (float)maxrange / scale;
	for (i = 0 ; i < pix->npts; i++) {
		pixvalue[i] = (value[i] - vmin) * scale;
	}
	free(value);
	return(1);
}

static char *
GetCellValue(pict,pix,index)
    DrawPart    *pict;
    CellPix *pix;
    int     index;
{
    static char path[200];

    strcpy (path,
        Pathname(((ElmRescale *)(pix->rescale))->elms[index]));
    return(fillstr(path));
}

generate_arbor(pix)
    CellPix  *pix;
{
	int		i,j;
	Element	**elms;
	register Element	*dst_elm;
	MsgOut	*msgout;
	int nelms = pix->npts;
	float	maxdia = 0.0;
	int		maxdiaindex = 0;
	int		type;
	int		dia_offset;
	float	dia;

/* First, find the root element */
	elms = ((ElmRescale *)(pix->rescale))->elms;

	for (i = 0 ; i < nelms ; i++) {
		if (elms[i] == pix->root_elm) {
			maxdiaindex = i;
			break;
		}
	}
	if (GetElmFieldInfo("dia",&type,&dia_offset, elms,pix->npts) == PATHERROR) {
		printf("Error : could not find dia field on compartment %s\n",
			elms[0]->name);
		return;
	}
	if (i >= nelms) {
		for (i = 0 ; i < nelms ; i++){
			dia = *((float *)((char *)elms[i] + dia_offset));
			if (dia > maxdia) {
				maxdia = dia;
				maxdiaindex = i;
			}
		}
	}

/*
** Then traverse the tree defined by the messages to decide which
** compartment is connected to which 
*/
	pix->parents[maxdiaindex] = -1;
	pix->root_elm = elms[maxdiaindex];
	for (msgout = elms[maxdiaindex]->msg_out ; msgout ; msgout = msgout->next) {
		dst_elm = msgout->dst;
		if (CheckClass(dst_elm,MembId)) {
			for (j = 0; j < nelms ; j++) {
				if (dst_elm == elms[j]) {
					cell_traverse(pix,elms,maxdiaindex,j);
					break;
				}
			}
		}
	}
}

cell_traverse(pix,elms,parent,this)
    CellPix  *pix;
	Element	**elms;
	int		parent,this;
{
	int		i,j;
	register Element	*dst_elm;
	MsgOut	*msgout;
	int nelms = pix->npts;
	Element	*pelm = elms[parent];

	pix->parents[this] = parent;

	for (msgout = elms[this]->msg_out ; msgout ;
		msgout = msgout->next) {
		dst_elm = msgout->dst;
		if (dst_elm != pelm && CheckClass(dst_elm,MembId)) {
			if (msgout->msg_in->type == CONNECTCROSS_NUM &&
				strcmp(dst_elm->object->name,"symcompartment") == 0)
				continue;
			if (this < (nelms-1) && dst_elm == elms[this + 1]) {
				cell_traverse(pix,elms,this,this + 1);
			} else if (this > 0 && dst_elm == elms[this - 1]) {
				cell_traverse(pix,elms,this,this - 1);
			} else {
				for (j = 0; j < nelms ; j++) {
					if (dst_elm == elms[j]) {
						cell_traverse(pix,elms,this,j);
						break;
					}
				}
			}
		}
	}
}

static int number_label(pict,pix,compt_index,parent_index)
    DrawPart  *pict;
    CellPix  *pix;
	int compt_index;
	int parent_index;
{
	int x,y;
	static char str[20];

	sprintf(str,"%d",compt_index);
	XSetForeground(pict->display,pict->gc,
		XBlackPixel(pict->display,XDefaultScreen(pict->display)));
	if (parent_index < 0) {
		x = pix->pts[compt_index].x;
		y = pix->pts[compt_index].y;
	} else {
		x = (3 * pix->pts[compt_index].x + pix->pts[parent_index].x)/4;
		y = (3 * pix->pts[compt_index].y + pix->pts[parent_index].y)/4;
	}
	XoDrawCenteredString(pict->display,pict->d,pict->gc,str,x,y);
}

static int name_label(pict,pix,compt_index,parent_index)
    DrawPart  *pict;
    CellPix  *pix;
	int compt_index;
	int parent_index;
{
	int x,y;
	static char str[80];
	Element	*elm;

	elm = ((ElmRescale *)(pix->rescale))->elms[compt_index];
	sprintf(str,"%s[%d]",elm->name,elm->index);
	
	XSetForeground(pict->display,pict->gc,
		XBlackPixel(pict->display,XDefaultScreen(pict->display)));
	if (parent_index < 0) {
		x = pix->pts[compt_index].x;
		y = pix->pts[compt_index].y;
	} else {
		x = (3 * pix->pts[compt_index].x + pix->pts[parent_index].x)/4;
		y = (3 * pix->pts[compt_index].y + pix->pts[parent_index].y)/4;
	}
	XoDrawCenteredString(pict->display,pict->d,pict->gc,str,x,y);
}

static int path_label(pict,pix,compt_index,parent_index)
    DrawPart  *pict;
    CellPix  *pix;
	int compt_index;
	int parent_index;
{
	int x,y;
	static char str[80];
	Element	*elm;

	elm = ((ElmRescale *)(pix->rescale))->elms[compt_index];
	sprintf(str,"%s[%d]",elm->name,elm->index);

	XSetForeground(pict->display,pict->gc,
		XBlackPixel(pict->display,XDefaultScreen(pict->display)));
	if (parent_index < 0) {
		x = pix->pts[compt_index].x;
		y = pix->pts[compt_index].y;
	} else {
		x = (3 * pix->pts[compt_index].x + pix->pts[parent_index].x)/4;
		y = (3 * pix->pts[compt_index].y + pix->pts[parent_index].y)/4;
	}
	XoDrawCenteredString(pict->display,pict->d,pict->gc,str,x,y);
}

static int dummy_label(pict,pix,compt_index,parent_index)
    DrawPart  *pict;
    CellPix  *pix;
	int compt_index;
	int parent_index;
{
}

int CellRefresh(pict,pix)
    DrawPart  *pict;
    CellPix  *pix;
{
	int		i,j;
	int		*parents;
    int     col;
    int     width;
	int		this,next;
	int		(*compt_label_func)();
	int		rootindex=-1;

	parents = pix->parents;

	if (strcmp(pix->labelmode,"number") == 0) {
		compt_label_func = number_label;
	} else if (strcmp(pix->labelmode,"name") == 0) {
		compt_label_func = name_label;
	} else if (strcmp(pix->labelmode,"path") == 0) {
		compt_label_func = path_label;
	} else {
		compt_label_func = dummy_label ;
	}
	if (Atof(pix->fatrange) > 0.0)
		CellUpdateFunc(pict->w,pix);

	for (this = 0 ; this < pix->npts ; this++) {
		next = parents[this];
		if (next == -1) {
			rootindex=this;
			/*
			draw_root_icon(pict,pix,this);
			compt_label_func(pict,pix,this,next);
			*/
			continue;
		}
		col = pix->val1[this];
		if (col >= NICONS) col = NICONS -1;
		else if (col < 0) col = 0;
		if (output_flag == XOUT) 
			col = colorscale[col];
		width = pix->val2[this];
		if (width < 0) width = 0;
	
		XSetLineAttributes(pict->display,pict->gc,
			width,LineSolid,CapProjecting,JoinBevel);
		XSetForeground(pict->display,pict->gc,col);
		XPSDrawLine(pict->display,pict->d,pict->gc,
			pix->pts[this].x,pix->pts[this].y,
			pix->pts[next].x,pix->pts[next].y);
		compt_label_func(pict,pix,this,next);
	}
	if (rootindex >= 0) {
		draw_root_icon(pict,pix,rootindex);
		compt_label_func(pict,pix,this,-1);
	}
}

draw_root_icon(pict,pix,this)
	DrawPart	*pict;
	CellPix		*pix;
	int			this;
{
    int     col;
    int     width;
	float	maxrange;
	Coord	scale;
	Pix		*icon;

	col = pix->val1[this];
	if (col >= NICONS) col = NICONS -1;
	else if (col < 0) col = 0;
	if (output_flag == XOUT) 
		col = colorscale[col];
	width = pix->val2[this];
	if (width < 0) width = 1;

	/* Check if icon exists */
	if (icon = find_pix2(pict->w,pix->rooticon)) {
		icon->color = (char *)col;
		if (strcmp(pix->fatfix,"FALSE") == 0) {
				maxrange = ((float)width) *
					(pict->wx / ((float)(pict->w->core.width)) + 
					pict->wy / ((float)(pict->w->core.height))) /
					2.0;

			scale.x = scale.y = scale.z = maxrange;
			XoScalePix(icon,0,scale);
		}
		DrawOneIcon(pict,icon,pix->pts[this].x,pix->pts[this].y);
	} else {
	/* otherwise draw default box */
		XSetForeground(pict->display,pict->gc,col);
	/* Upi hack Apr 92 : why not draw a circle instead ? */
	/*
		XFillRectangle(pict->display,pict->d,pict->gc,
			pix->pts[this].x - width/2,pix->pts[this].y, width,5);
	*/
		XFillArc(pict->display,pict->d,pict->gc,
			pix->pts[this].x-width/2,pix->pts[this].y-width/2,
				width,width,0,23040);
	}
}

SetCellValues()
{
}

static Boolean CellSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	CellPix	*pix;
	char	**argnames;
	int		nargs;
{
	int		i;
	Boolean do_update = FALSE;
	Boolean do_rescale = FALSE;
	Boolean do_path = FALSE;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpath) == 0) {
			do_path = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNcolfield) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNcolmin) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNcolmax) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNautocol) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNfatfield) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNfatmin) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNfatmax) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNfatrange) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNautofat) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNlabelmode) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNfieldpath) == 0) {
			do_path = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNrooticon) == 0) {
			get_cellicon(parent,pix);
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNox) == 0) {
			do_path = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNoy) == 0) {
			do_path = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNoz) == 0) {
			do_path = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		}
	}
	if (do_path) {
		SetElmCellPath(parent,pix);
	}
	if (do_rescale) {
		RescaleDraw(parent);
	}
	if (do_update) {
		SetCellUpdate(parent,pix);
		CellUpdateFunc(parent,pix);
	}
	return(TRUE);
}

int get_cellicon(parent,pix)
	DrawWidget	parent;
	CellPix	*pix;
{
	Widget fw;
	Coord	scale,offset,*coords;
	float	sc;
	float	maxrange;

	Pix	*icon,*find_pix2();

	/* Check if icon already exists */
	if (find_pix2(parent,pix->rooticon)) {
		drop_pix2(parent,pix->rooticon);
	}
	/* Calculate scale for icon, based on fatrange */
	/* using space dimensions for the default */
	maxrange = Atof(pix->fatrange);
	if (maxrange < 0) /* using pixel dimensions */
		maxrange = -maxrange *
			(parent->draw.wx / ((float)parent->core.width) + 
			parent->draw.wy / ((float)parent->core.height)) / 2.0;
	/* since icons are from -1 to + 1 */
	scale.x = scale.y = scale.z = maxrange/2.0;
	offset.x = offset.y = offset.z = 0.0;
	/* try to copy it over from xproto */ 
	if (icon = ScaleAndCopyIcon(pix->rooticon,scale,offset))
		append_pix(parent,icon,1);

	return(1);
}

static void	CellGetHook(pix,rl,args,nargs)
	CellPix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

int CleanCellHl()
{
}
ConfigurePyramidal()
{
	float	VertRange,HorizRange,BranchAngle;
	Coord	Axis;
}

ConfigureMitral()
{
}

ConfigureGranule()
{
}

ConfigurePurkinje()
{
}

ConfigureBipolar()
{
}

ConfigureCBGranule()
{
}

ConfigureBasket()
{
}

Element *RelGetElement(rel,pathname)
Element	*rel;
char *pathname;
{
Element 	*element;
char 		*tree_ptr;
char 		*name;
int		count;
char 		*GetTreeName();
char 		*AdvancePathname();

	element = rel;
	tree_ptr = pathname;

    while(*tree_ptr != '\0' && element != NULL){
	name = GetTreeName(tree_ptr);
	count = GetTreeCount(tree_ptr);
	if(strcmp(name,"..") == 0){
	    /*
	    ** parent element
	    */
	    element = element->parent;
	} else 
	if(strcmp(name,".") == 0){
	    /*
	    ** current element
	    element = element;
	    */
	} else {
	    element = (Element *)GetChildElement(element,name,count);
	}
	tree_ptr = AdvancePathname(tree_ptr);
    }
    return(element);
}
