static char rcsid[] = "$Id: problem.c,v 1.1 1992/12/11 19:06:35 dhb Exp $";

/*
** $Log: problem.c,v $
** Revision 1.1  1992/12/11  19:06:35  dhb
** Initial revision
**
*/

#include "com_ext.h"
#include <X11/IntrinsicP.h>
#include "sim_ext.h"
#include "widget_struct.h"
#include "Layout.h"

extern	char *g_copy();
extern	char *set_form();
/*
** xfunc_parse_set:	
**
**	Step through the arguments of a set line and set fields as 
**	we go alone.
**
*/
xfunc_parse_set(element, argc, argv, specific_parser)
	struct	widget_type	*element;
	int			argc;
	char			**argv;
	int			(*specific_parser)();
{
	int	inc = 0;
	int	i = 0;
	while (i < argc) {
		inc = xfunc_core_set(element, i, argc, argv);
		if (inc < 0)
			return;	/* error occured abort rest of line */
		if (inc == 0) { /* try widget specific parser */
			if (specific_parser != NULL)
			inc = (specific_parser)(element, i, argc, argv);
		}
		if (inc < 0)
			return;
		if (inc == 0) {
			fprintf(stderr,"Error: skipping invalid field '%s'\n",
				argv[i]);
			inc++;
		}
		i = i + inc;
	}
}

/*
** xfunc_core_set:
**
** Returns:	-1 on "ran out of args" error
**
**		0 on "not a valid generic arg" error
**
**		i, where i is the number of args to skip to next 'field'
**
*/
xfunc_core_set(element, i, argc, argv)
	struct widget_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	int	percent;
	char	*field;
	char	*value;
	Arg	arg[3];
	int	n;

	field = argv[i];
	if (field[0] == '[')  /* these should all have been parsed down */
		return(1);

	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	value = argv[i];

	if (strcmp(field,"absolute_x") == 0 || 
		strcmp(field,"absolute_y") == 0 ||
		strcmp(field,"absolute_width") == 0 ||
		strcmp(field,"absolute_height") == 0) {
		fprintf(stderr,"SET: <warning> element field '%s' is read-only\n",
			field);
		return(2);
	}
	if (strcmp(field,"x") == 0) {
		percent = xfunc_percent_hack(value);
		element->x = (float)Atof(value);
		if (percent)
			element->xtype |= LAYOUT_RELATIVE;
		else
			element->xtype &= 0xfffe;
		do_widget_move(element);
		return(2);
	}
	if (strcmp(field,"y") == 0) {
		percent = xfunc_percent_hack(value);
		element->y = (float)Atof(value);
		if (percent)
			element->ytype |= LAYOUT_RELATIVE;
		else
			element->ytype &= 0xfffe;
		do_widget_move(element);
		return(2);
	}
	if (strcmp(field,"width") == 0) {  /* need to put in % stuff.. */
		percent = xfunc_percent_hack(value);
		element->width = (Dimension)atoi(value);
		if (percent)
			element->widthtype |= LAYOUT_RELATIVE;
		else
			element->widthtype &= 0xfffe;
		do_widget_resize(element);
		return(2);
	}
	if (strcmp(field,"height") == 0) {
		percent = xfunc_percent_hack(value);
		element->height = (Dimension)atoi(value);
		if (percent)
			element->heightype |= LAYOUT_RELATIVE;
		else
			element->heightype &= 0xfffe;
		do_widget_resize(element);
		return(2);
	}
	if (strcmp(field,"xwidget") == 0) {
		if (element->xwidget != NULL) {
			free (element->xwidget);
			element->xwidget = NULL;
		}
		element->xwidget = (char *)g_copy(value);
		return(2);
	}
	if (strcmp(field,"ywdiget") == 0) {
		if (element->ywidget != NULL) {
			free (element->ywidget);
			element->ywidget = NULL;
		}
		element->ywidget = (char *)g_copy(value);
		return(2);
	}
	if (strcmp(field,"wwidget") == 0) {
		if (element->wwidget != NULL) {
			free (element->wwidget);
			element->wwidget = NULL;
		}
		element->wwidget = (char *)g_copy(value);
		return(2);
	}
	if (strcmp(field,"hwidget") == 0) {
		if (element->hwidget != NULL) {
			free (element->hwidget);
			element->hwidget = NULL;
		}
		element->hwidget = (char *)g_copy(value);
		return(2);
	}
	if (strcmp(field,"title") == 0) {
		fprintf(stderr,"TITLE CANNOT BE CHANGED AFTER CREATION\n");
		return(2);
	}
	if (strcmp(field,"xtype") == 0) {
		element->xtype = atoi(value);
		n = 0;
		XtSetArg(arg[n], XtNxtype, element->xtype); n++;
		XtSetValues(element->widget, arg, n);
		return(2);
	}
	if (strcmp(field,"ytype") == 0) {
		element->ytype = atoi(value);
		n = 0;
		XtSetArg(arg[n], XtNytype, element->ytype); n++;
		XtSetValues(element->widget, arg, n);
		return(2);
	}
	if (strcmp(field,"widthtype") == 0) {
		element->widthtype = atoi(value);
		n = 0;
		XtSetArg(arg[n], XtNwidthtype, element->widthtype); n++;
		XtSetValues(element->widget, arg, n);
		return(2);
	}
	if (strcmp(field,"heightype") == 0) {
		element->heightype = atoi(value);
		n = 0;
		XtSetArg(arg[n], XtNheightype, element->heightype); n++;
		XtSetValues(element->widget, arg, n);
		return(2);
	}
	if (strcmp(field,"form") == 0) {
		fprintf(stderr,"Error: form can only be SET on CREATion\n");
		return(2);
	}
	if (strcmp(field,"widget") == 0) {
		fprintf(stderr,"Error: widgets cannot be SET\n");
		return(2);
	}
	return(0);
}
