static char rcsid[] = "$Id: parse.c,v 1.1 1992/12/11 19:06:34 dhb Exp $";

/*
** $Log: parse.c,v $
** Revision 1.1  1992/12/11  19:06:34  dhb
** Initial revision
**
*/

#include	"com_ext.h"
#include	"gen_struct.h"

static struct valid_arg generic_args[] = {
	{"title", 1, 2}, 
	{"x", 0, 2},
	{"y", 0, 2},
	{"width", 0, 2},
	{"height", 0, 2},
	{"absolute_x", 1, 2},
	{"absolute_y", 1, 2},
	{"absolute_width", 1, 2},
	{"absolute_height", 1, 2},
	{"xwidget", 0, 2},
	{"ywidget", 0, 2},
	{"hwidget", 0, 2},
	{"wwidget", 0, 2},
	{"heighttype", 0, 2},
	{"widthtype", 0, 2},
	{"xtype", 0, 2},
	{"ytype", 0, 2},
	{"widgets", 0, 0},
	{"END", -1, -1}
};
x_parse_set(argc, argv, list2)
	int	argc;
	char	**argv;
	struct valid_arg	*list2;
{
	return(set_parser(argc, argv, generic_args, list2));
}

/*
** set_parser:	This is a generic parsing routine used for all
**			X-element "SET" cases.  It scans the lists passed
**			if they are non-null and compares them to the
**			argc, argv lines.
**
*/
set_parser(argc, argv, list1, list2)
	int	argc;
	char	**argv;
	struct valid_arg	*list1;
	struct valid_arg	*list2;
{
	int	skip;
	int	i = 0;
	
	while (i < argc) {
		if (argv[i][0] == '[') /* assume all '[]'s are single args */
			i++;
		skip = set_parser_inlist(argv[i], list1);
		if (skip < 0) 
			skip = set_parser_inlist(argv[i], list2);
		if (skip < 0) {
			fprintf(stderr,
				"SET: unknown or invalid argument '%s'\n",
				argv[i]);
			fprintf(stderr,	
				"     [abandoning current SET line]\n");
			return(0);
		}
		/* special case of skipping one '[ .... ]' */
		if (skip == 0) {
			i++;
			if (i >= argc || argv[i][0] != '[') {
				fprintf(stderr,"SET: expected []'s...\n");
				fprintf(stderr,	
					"     [abandoning current SET line]\n");
				return(0);
			}
			skip = set_parser_skip_brackets(i, argc, argv);
			if (skip == 0 || skip < 0) {
				fprintf(stderr,"SET: expected []'s...\n");
				fprintf(stderr,	
					"     [abandoning current SET line]\n");
				return(0);
			}
			i = i + skip;
			continue;
		}
		i = i + skip;
	}
	return(1);	/* This parse looked OK */
}

/*
** set_parser_inlist:	Check for 'field' in 'list'
**
*/
set_parser_inlist(str, list)
	char	*str;
	struct valid_arg	*list;
{
	int	i = 0;
	while  (list[i].modify_flag != -1) {
		if (strcmp(list[i].str, str) == 0) 
			return(list[i].value);
		i++;
	}
	return(-1);
}
/*
** set_parser_skip_brackets:	The next argument must start with
**				an '['.  Skip ranges of '[...]' until
**				the next argument is NOT an '['.
**
*/
set_parser_skip_brackets(i, argc, argv)
	int	i;
	int	argc;
	char	**argv;
{
	int	j;
	while (i < argc) {
		for (j = 0; j < strlen(argv[i]); j++) {
			if (argv[i][j] == ']')
				return(argc-i+1);
			j++;
		}
		i++;
	}
	return(-1);
}


