static char rcsid[] = "$Id: do_commands.c,v 1.1 1992/12/11 19:06:31 dhb Exp $";

/*
** $Log: do_commands.c,v $
** Revision 1.1  1992/12/11  19:06:31  dhb
** Initial revision
**
*/

#include	"com_ext.h"
#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	"xodus_args.h"
#include	"xodus_ext.h"
#include	"toggle_w.h"


do_destroy_widget(argc,argv)
	int argc;
	char **argv;
{
	char	*name;
	char 	*value;
	Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);
	if (w == NULL) {
		fprintf(stderr,"%s: the widget '%s' does not exist\n",	
			argv[0], name);
		return(0);
	}	

	/*  If the widget is a form we want to remove the appshell
	**  above it as well 
	*/
	parent = XtParent(w);

	if (!x_remove_toplevel(parent)) {	/* if not a form */
		XtUnmapWidget(w);
		XtDestroyWidget(w);
	}					

	x_ntw_add(name,NULL);
}

do_map_all_widgets(argc,argv)
int argc;
char **argv;
{
	if (argc != 1) {
		fprintf(stderr,"usage: %s\n", argv[0]);
		return;
	}
	x_map_toplevel();
}

do_realize_widgets(argc,argv)
int argc;
char **argv;
{
	if (argc != 1) {
		fprintf(stderr,"usage: %s\n", argv[0]);
		return;
	}
	realize_toplevel();
}

do_unmap_widget(argc,argv)
int argc;
char **argv;
{
char	*name;
char 	*value;
Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);

	if (w == NULL) {
		fprintf(stderr,"the widget '%s' does not exist\n",name);
		return(0);
	}
	parent = XtParent(w);
	if (is_toplevel(parent)) 
		XtUnmapWidget(parent);
	else
		XtUnmapWidget(w);
	XFlush(XtDisplay(w));
}

do_map_widget(argc,argv)
int argc;
char **argv;
{
char	*name;
char 	*value;
Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);
	if (w == NULL) {
		fprintf(stderr,"the widget '%s' does not exist\n",name);
		return(0);
	}	
	parent = XtParent(w);
	if (is_toplevel(parent))
		XtMapWidget(parent);
	else	
		XtMapWidget(w);
	XFlush(XtDisplay(w));
}

do_set_color(argc,argv)
	int argc;
	char **argv;
{
	char	*name;
	char 	*value;
	void	SetColorScale();

	if(argc < 2){
		fprintf(stderr, "usage:	%s colorscale\n",argv[0]);
		fprintf(stderr, "	colorscales : hot rainbow grey\n");
		return;
	}

	SetColorScale(argv[1]);
}

do_simple_graph_add_pts(argc,argv)
    int argc;
    char    **argv;
{
}

do_axis_graph_add_pts(argc,argv)
    int argc;
    char    **argv;
{
	int    i;
	Widget w;

	if (argc < 2) {
		fprintf(stderr, "usage: %s graphname plotname colorname x y [x y ....]\n",
			argv[0]);
		return;
	}

	
	w = (Widget)x_ntw_get(argv[1]);
	if (w == NULL) {
		fprintf(stderr,"do_axis_graph_add_pts: no graph '%s'\n",
			argv[1]);
		return;
	}
	for (i = 4; i < argc; i += 2) {
		graph_add_pts(w,argv[2], argv[3],
			Atof(argv[i]),Atof(argv[i + 1]));
	}
}

do_set_axis_graph_range(argc, argv)
	int	argc;
	char	**argv;
{
	char	xmin[20], ymin[20], xmax[20], ymax[20];
	int	junk;

	if (argc < 3 ) {
		fprintf(stderr,"usage:	%s graphname <range>\n", 
			argv[0]);
		fprintf(stderr,"	<range> -> [xmin,ymin,xmax,ymax]\n");
		fprintf(stderr,"	<range> -> xmin=value ...\n");
		return;
	}

	xodus_reset_arg();

	if (!axis_graph_get_range(argv[1], xmin, ymin, xmax, ymax))
		return;

	xodus_arg_set(ARG_XMIN, xmin);
	xodus_arg_set(ARG_YMIN, ymin);
	xodus_arg_set(ARG_XMAX, xmax);
	xodus_arg_set(ARG_YMAX, ymax);
	
	xodus_parse_args(argc-2, argv+2, &junk, &junk, &junk, &junk, &junk);

	x_set_axis_graph_range(argv[1],
		Atof(x_arg(ARG_XMIN)),
		Atof(x_arg(ARG_YMIN)),
		Atof(x_arg(ARG_XMAX)),
		Atof(x_arg(ARG_YMAX)));
}

do_set_simple_graph_range(argc, argv)
	int	argc;
	char	**argv;
{
}
	

do_event(argc,argv)
    int argc;
    char    **argv;
{
	Widget	w, x_ntw_get();
	WidgetClass	wc;

	if (argc < 2) {
		fprintf(stderr, "usage: %s widgetname\n", argv[0]);
		return;
	}

	if (w = x_ntw_get(argv[1])) {
		wc = XtClass(w);
#ifdef X11R3
		if (wc == toggleWidgetClass) {
#else
		if (wc == genesisToggleWidgetClass) {
#endif X11R3
			toggleNotify(w,NULL);
		} else
			XtCallCallbacks(w,XtNcallback,NULL);
	}
}

unmap_widget(name)
	char *name;
{
	Widget	w, parent, x_ntw_get();

	w = x_ntw_get(name);
	if (w == NULL) {
		fprintf(stderr,"unmap_widget: the widget '%s' does not exist\n", name);
		return(0);
	}
	parent = XtParent(w);
	if (is_toplevel(parent)) 
		XtUnmapWidget(parent);
	else
		XtUnmapWidget(w);
}

map_widget(name)
	char	*name;
{
	Widget	w, parent, x_ntw_get();

	w = x_ntw_get(name);
	if (w == NULL) {
		fprintf(stderr,"map_widget%s: the widget '%s' does not exist\n",
			 name);
		return(0);
	}	
	parent = XtParent(w);
	if (is_toplevel(parent))
		XtMapWidget(parent);
	else	
		XtMapWidget(w);
}


do_raise_widget(argc,argv)
int argc;
char **argv;
{
char	*name;
char 	*value;
Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);

	if (w == NULL) {
		fprintf(stderr,"the widget '%s' does not exist\n",name);
		return(0);
	}
	parent = XtParent(w);
	if (is_toplevel(parent)) 
		XRaiseWindow(display,XtWindow(parent));
	else
		XRaiseWindow(display,XtWindow(w));
	XFlush(XtDisplay(w));
}

do_lower_widget(argc,argv)
int argc;
char **argv;
{
char	*name;
char 	*value;
Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);

	if (w == NULL) {
		fprintf(stderr,"the widget '%s' does not exist\n",name);
		return(0);
	}
	parent = XtParent(w);
	if (is_toplevel(parent)) 
		XLowerWindow(display,XtWindow(parent));
	else
		XLowerWindow(display,XtWindow(w));
	XFlush(XtDisplay(w));
}


do_map_on_top(argc,argv)
int argc;
char **argv;
{
char	*name;
char 	*value;
Widget	w,parent,x_ntw_get();

	if(argc < 2){
		fprintf(stderr, "usage: %s widget\n",argv[0]);
		return;
	}
	name = argv[1];
	w = x_ntw_get(name);

	if (w == NULL) {
		fprintf(stderr,"the widget '%s' does not exist\n",name);
		return(0);
	}
	parent = XtParent(w);
	if (is_toplevel(parent)) {
		XRaiseWindow(display,XtWindow(parent));
		XtMapWidget(parent);
	} else {
		XRaiseWindow(display,XtWindow(w));
		XtMapWidget(w);
	}
	XFlush(XtDisplay(w));
}
