static char rcsid[] = "$Id: arg.c,v 1.1 1992/12/11 19:06:29 dhb Exp $";

/*
** $Log: arg.c,v $
** Revision 1.1  1992/12/11  19:06:29  dhb
** Initial revision
**
*/

#include "com_ext.h"
#include	"xodus_args.h"
#include	<X11/IntrinsicP.h>
#include	"Layout.h"

#undef DEBUG

extern int debug;

typedef  struct xodus_args {
	int	usercoord;
	char	*id;
	char	*def;
	char	*override;
} XODUS_ARGS;

static int	xodus_arg_count	= 0;

static	XODUS_ARGS xodus_arg_table[30];

xodus_init_def_args()
{
	xodus_arg_count = 0;
	xodus_build_arg(xodus_arg_count, ARG_STRING, "", 0);
		 xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_STATE, "0", 0);
		 xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_FORM, "", 0);
		 xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_XWIDGET, "NULL", 2);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_YWIDGET, "NULL", 2);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_WWIDGET, "NULL", 2);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_HWIDGET, "NULL", 2);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_X, "20", 1);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_Y, "20", 1);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_W, "200", 1);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_H, "30", 1);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_SCRIPT, NULL, 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_TITLE, "title", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_NAME, "name", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_FILENAME, "/usr/genesis/README", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_LABEL, "1", 0 );
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_XMIN, "0.00", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_YMIN, "0.00", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_XMAX, "100.00", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_YMAX, "100.00", 0);
		xodus_arg_count++;
	xodus_build_arg(xodus_arg_count, ARG_FONT, "", 0);
		 xodus_arg_count++;
}
/*
** xodus_arg_set:	set arg, return -1 on failure, 0 on no-usercoord,
**			1 on usercoord
*/

xodus_arg_set(str, val)
	char	*str, *val;
{
	char	*userval;
	int	i = 0;

	if (str == NULL || *str == NULL)
		return(0);
	for (i =0; i < xodus_arg_count; i++) {
		if (xodus_arg_table[i].id != NULL && 
		strcmp(xodus_arg_table[i].id, str) == 0) {
			if (xodus_arg_table[i].override != NULL)
				free(xodus_arg_table[i].override);
			xodus_arg_table[i].override = 
				(char *)malloc(strlen(val)+1);
			*(xodus_arg_table[i].override) = NULL;
			if (*val != NULL)
				strcpy(xodus_arg_table[i].override, val);
			return(xodus_arg_table[i].usercoord);
		}
	}
	return(0);
}


/*
** build_xodus_arg:	Insert stuff into list at named position.
**
*/
xodus_build_arg(i, id, val, u)
	int		i;
	char	*id;
	char	*val;
	int	u;
{
	xodus_arg_table[i].id = (char *)malloc(strlen(id)+1);
	strcpy(xodus_arg_table[i].id, id);
	if (val) {
		xodus_arg_table[i].def = (char *)malloc(strlen(val)+1);
		strcpy(xodus_arg_table[i].def, val);
	} else {
		xodus_arg_table[i].def = NULL;
	}
	xodus_arg_table[i].override = NULL;
	xodus_arg_table[i].usercoord = u;
}

/*
** x_arg:	Return pointer to string named in list
**
*/
char *
x_arg(id)
	char	*id;
{
	int	i;
	for (i = 0 ; i < xodus_arg_count ;i++)
		if (strcmp(xodus_arg_table[i].id, id) == 0) {
			if (xodus_arg_table[i].override != NULL)
				return(xodus_arg_table[i].override);
			return(xodus_arg_table[i].def);
		}
	fprintf(stderr,"x_arg: FATAL ERROR - id %s not found\n", id);
	return(NULL);
}

xodus_parse_args(argc, argv, xt, yt, wt, ht, usercoord)
	int	argc;
	char	**argv;
	int	*xt, *yt, *wt, *ht, *usercoord;
{
	
	char	*xw, *yw, *ww, *hw;
	char	*xmin, *ymin, *xmax, *ymax;
	char	x[30], y[30], width[30], height[30];
	int	i, j;
	
	*xt = *yt = *wt = *ht = LAYOUT_ABSOLUTE;
	xw = yw = hw = ww = NULL;
	xmin = ymin = xmax = ymax = NULL;


	for (i=0; i < argc; i++) {
		if (argv[i][0] == '[') {
			*usercoord = 1;
			i = i + xodus_parse_coordinates(i, argc, argv, x, y, 
				width, height, xt, yt, wt, ht);
if(debug)
			fprintf(stderr,"xodus_parse_coord rets: %s %s %s %s\n",
				x, y, width, height);
			xodus_arg_set(ARG_X, x);
			xodus_arg_set(ARG_Y, y);
			xodus_arg_set(ARG_W, width);
			xodus_arg_set(ARG_H, height);
			continue;
		} else if (argv[i][0] == '-') {
			if (strcmp(&argv[i][1], "value") == 0) {
				xodus_arg_set(ARG_STRING, argv[i+1]);
				i++;
				continue;
			}
			if (strcmp(&argv[i][1], "font") == 0) {
				xodus_arg_set(ARG_FONT, argv[i+1]);
				i++;
				continue;
			}
			if (strcmp(&argv[i][1], "form") == 0) {
				xodus_arg_set(ARG_FORM, argv[i+1]);
				i++;
				continue;
			}
			if (strcmp(&argv[i][1], "widgets") == 0) {
				i = i + parse_widgets(i, argc, argv, 
					&xw, &yw, &ww, &hw);
				xodus_arg_set(ARG_XWIDGET, xw);
				xodus_arg_set(ARG_YWIDGET, yw);
				xodus_arg_set(ARG_WWIDGET, ww);
				xodus_arg_set(ARG_HWIDGET, hw);
				free(xw);
				free(yw);
				free(ww);
				free(hw);
				continue;
			}
			if (strcmp(&argv[i][1], "nolabel") == 0) {
				xodus_arg_set(ARG_LABEL, "0");
				continue;
			}
			if (strcmp(&argv[i][1], "script") == 0) {
				xodus_arg_set(ARG_SCRIPT, argv[i+1]);
				i++;
				continue;
			}
			if (strcmp(&argv[i][1], "title") == 0) {
				xodus_arg_set(ARG_TITLE, argv[i+1]);
				i++;
				continue;
			}
			if (strcmp(&argv[i][1], "range") == 0) {
				i++;
				if (argv[i][0] == '[') {
					i = i + xodus_parse_range(i, argc, argv,
						 &xmin, &ymin, &xmax, &ymax);
					xodus_arg_set(ARG_XMIN, xmin);
					xodus_arg_set(ARG_YMIN, ymin);
					xodus_arg_set(ARG_XMAX, xmax);
					xodus_arg_set(ARG_YMAX, ymax);
					free(xmin);
					free(ymin);
					free(xmax);
					free(ymax);
					continue;
				} else 
					fprintf(stderr,
					"parse_args: -range [ not found\n");
				continue;
			}
			xodus_parse_set(argv[i], argv[i+1], usercoord, 
				xt,yt,wt,ht);
			i++;
		}
/*			else if (strncmp(argv[i], "range=",6) == 0) { 
**			i = i + xodus_parse_range(i, argc, argv,
**				 &xmin, &ymin, &xmax, &ymax);
**			xodus_arg_set(ARG_XMIN, xmin);
**			xodus_arg_set(ARG_YMIN, ymin);
**			xodus_arg_set(ARG_XMAX, xmax);
**			xodus_arg_set(ARG_YMAX, ymax);
**			free(xmin);
**			free(ymin);
**			free(xmax);
**			free(ymax);
**			continue;
**		} else 
**			xodus_parse_set(argv[i], usercoord,xt,yt,wt,ht);
**		
*/
	}
}

xodus_parse_set(in_str, value, usercoord,xt,yt,wt,ht)
	char	*in_str;
	char	*value;
	int	*usercoord;
	int	*xt, *yt,*wt, *ht;
{
	char	*str, *start;
	char	*userval;
	int	i = 0;

	if (in_str == NULL || *in_str == NULL)
		return;
	str = in_str;
	if (*str == '-') str++;
	for (i =0; i < xodus_arg_count; i++) {
		if (xodus_arg_table[i].id != NULL && 
		strcmp(xodus_arg_table[i].id, str) == 0) {
			if (xodus_arg_table[i].override != NULL)
				free(xodus_arg_table[i].override);
			xodus_arg_table[i].override = NULL;
			xodus_arg_table[i].override  = (char *)
				g_copy(value);
			if ( xodus_arg_table[i].usercoord)
				*usercoord = 1;
			if ( xodus_arg_table[i].usercoord == 1)
				xodus_percent_hack(
					xodus_arg_table[i].id,
					xodus_arg_table[i].override,
					xt,yt,wt,ht);
				
		}
	}
}

/*
** xodus_parse_coordinates:	We have at least one argv with an "(".
**			Affix x, y, w, h values upto the ")", which
**			may or maynot be part of the same argv[i].
**
*/
xodus_parse_coordinates(i, argc, argv, x, y, w, h, xt, yt, wt, ht)
	int	i;
	int	argc;
	char	**argv;
	char	*w, *h, *x, *y;
	int	*xt, *yt, *wt, *ht;
{
	char	str[100];
	int	j = 0;
	int	k;
	int	first = 1;
	int	start;
	int	l;
	int	c;
	int	x1,y1,w1,h1;
	int	done = 0;

	start = i;

	while (i < argc && !done) {
		for (k = 0; k < strlen(argv[i]); k++) {
			if (first) {
				first = 0;
				continue;
			} else {
				if (argv[i][k] == ']') {
					str[j++] = NULL;
					done = 1;
					continue;
				} else 
					str[j++] = argv[i][k];
			}
		}
		i++;
	}
	if (i == argc && j == 0) {
		fprintf(stderr,"coord: no end paran.  Skipping argument\n");
		return(1);
	}
	*xt = *yt = *ht = *wt = LAYOUT_ABSOLUTE;
	l = 0;
	c = 0;
	while (l < strlen(str)) {
		if (str[l] == ',') {
			c++; l++;
			continue;
		}
		if (str[l] == '%') {
			switch (c) {
				case 0:
					*xt = LAYOUT_RELATIVE;
					break;
				case 1:
					*yt = LAYOUT_RELATIVE;
					break;
				case 2:
					*wt = LAYOUT_RELATIVE;
					break;
				case 3:
					*ht = LAYOUT_RELATIVE;
					break;
				default:
					fprintf(stderr,"parse_coord -- too many commas to parse %%\n");
					break;
			}
			/* get rid of '%'*/
			for (j = l; j < strlen(str) - 1; j++) 
				str[j] = str[j+1];
			str[j] = NULL;
			continue;
		}
		l++;
	}
	j =0;
	k = 0;
	while (str[j] != ',')
		x[k++] = str[j++];
	x[k] = NULL;
	k = 0; j++;
	while (str[j] != ',')
		y[k++] = str[j++];
	y[k] = NULL;
	k = 0; j++;
	while (str[j] != ',')
		w[k++] = str[j++];
	w[k] = NULL;
	k = 0; j++;
	while (str[j] != ',' && str[j] != NULL)
		h[k++] = str[j++];
	h[k] = NULL;

if(debug){
	fprintf(stderr,"xodus_parse_coordinates: %s\n", str);
	fprintf(stderr,"xodus_parse_coordinates: %s/%s/%s/%s\n", x,y,w,h);
}
	return(i - start - 1);
}


/*
** xodus_percent_hack:	Used in the cases of setting X,Y,W,H
**
*/
xodus_percent_hack(id, str, xt,yt,wt,ht)
	char	*id, *str;
	int	*xt, *yt, *wt, *ht;
{
	int	i;
	for (i = 0; i < strlen(str); i++) {
		if (str[i] == '%') {
			str[i] = NULL;
			switch (id[0]) {
				case 'x':
					*xt = LAYOUT_RELATIVE;
					break;
				case 'y':
					*yt = LAYOUT_RELATIVE;
					break;
				case 'w':
					*wt = LAYOUT_RELATIVE;
					break;
				case 'h':
					*ht = LAYOUT_RELATIVE;
					break;
			}
			return;
		}
	}
}

xodus_reset_arg()
{
	int	i;
	for (i =0 ; i < xodus_arg_count; i++) {
		if (xodus_arg_table[i].override != NULL)
			free(xodus_arg_table[i].override);
		xodus_arg_table[i].override = NULL;
	}
}

/*
** parse_widgets:	We have at least one argv with an "[".
**			Affix xw, yw, ww, hw strings upto the "]", which
**			may or maynot be part of the same argv[i].
**
*/
parse_widgets(i, argc, argv, xw, yw, ww, hw)
	int	i;
	int	argc;
	char	**argv;
	char	**xw, **yw, **ww, **hw;
{
	char	str[100];
	char	*foo, *bar;
	int	j;
	int	k;
	int	first;
	int	start;
	int	c;
	int	done;

	j = 0;
	first = 1;
	done = 0;
	start = i;

	while (i < argc && !done) {
		for (k = 0; k < strlen(argv[i]); k++) {
			if (first) {
				first = 0;
				continue;
			} else {
				if (argv[i][k] == ']') {
					str[j++] = ']';
					str[j++] = NULL;
					done = 1;
					continue;
				} else 
					str[j++] = argv[i][k];
			}
		}
		i++;
	}
	if (i == argc && j == 0) {
		fprintf(stderr,"parse_widgets: no end paran.  Skipping argument\n");
		return(1);
	}
	/* we now have "xstr,ystr,wstr,hstr" */
	c = 0;
	foo = str;
	while (foo != NULL && *foo != NULL && *foo != '[')
		foo++;
	if (foo == NULL || *foo == NULL)
			return;
	foo++;
	bar = foo;
#ifdef DEBUG
	fprintf(stderr,"initial string is: %s\n", foo);
#endif
	while (foo != NULL && *foo != NULL && c < 4) {
		if (*foo == ',' || *foo == NULL || *foo == ']') {
			*foo = NULL;
#ifdef DEBUG
			fprintf(stderr,"PARSEWIDGET: %d %s\n", c, bar);
#endif
			switch (c) {
				case 0:
					*xw = (char *)g_copy(bar);
					bar = foo + 1;
					break;
				case 1:
					*yw = (char *)g_copy(bar);
					bar = foo + 1;
					break;
				case 2:
					*ww = (char *)g_copy(bar);
					bar = foo + 1;
					break;
				case 3:
					*hw = (char *)g_copy(bar);
					bar = foo + 1;
					break;
				default:
					fprintf(stderr,
					"parse_widgets: remainder error %s\n",
						 foo);
					break;
			}
			c++;
		}
		foo++;
	}
#ifdef DEBUG
	fprintf(stderr,"parse widgets returns [%s] [%s] [%s] [%s]\n",
			*xw, *yw, *ww, *hw);
#endif
	return(i - start - 1);
}

/*
** parse_range:	We have at least one argv with an "[".
**			Affix xmin,xmax,ymim,ymax
**			may or maynot be part of the same argv[i].
**
** can take either: [xmin,ymin,xmax,ymax]
**			range=[xmin,ymin,xmax,ymax]
**
*/
xodus_parse_range(i, argc, argv, xw, yw, ww, hw)
	int	i;
	int	argc;
	char	**argv;
	char	**xw, **yw, **ww, **hw;
{
	char	str[100];
	char	*foo, *bar;
	int	j;
	int	k;
	int	first;
	int	start;
	int	c;
	int	done;

	j = 0;
	first = 1;
	done = 0;
	start = i;

	while (i < argc && !done) {
		for (k = 0; k < strlen(argv[i]); k++) {
			if (first) {	/* skip "range=[" and the like ... */
				if (k == strlen(argv[i])) 
					return(1);
				if (argv[i][k] == '[') 
					first = 0;
				continue;
			} else {
				if (argv[i][k] == ']') {
					str[j++] = ']';
					str[j++] = NULL;
					done = 1;
					continue;
				} else 
					str[j++] = argv[i][k];
			}
		}
		i++;
	}
	if (i == argc && j == 0) {
		fprintf(stderr,"parse_range: no end paran.  Skipping argument\n");
		return(1);
	}
	/* we now have "xmin,xmax,ymin,ymax]" */
	c = 0;
	foo = bar = str;
#ifdef DEBUG
	fprintf(stderr,"xodus_parse_range: string is '%s'\n", str);
	fprintf(stderr,"initial string is: %s\n", foo);
#endif
	while (foo != NULL && *foo != NULL && c < 4) {
		if (*foo == ',' || *foo == NULL || *foo == ']') {
			*foo = NULL;
			/*
			fprintf(stderr,"PARSEWIDGET: %d %s\n", c, bar);
			*/
			switch (c) {
				case 0:
					*xw = (char *)g_copy(bar);
					/*
					fprintf(stderr,"xw=%s\n", *xw);
					*/
					bar = foo + 1;
					break;
				case 1:
					*yw = (char *)g_copy(bar);
					/*
					fprintf(stderr,"yw=%s\n", *yw);
					*/
					bar = foo + 1;
					break;
				case 2:
					*ww = (char *)g_copy(bar);
					/*
					fprintf(stderr,"ww=%s\n", *ww);
					*/
					bar = foo + 1;
					break;
				case 3:
					*hw = (char *)g_copy(bar);
					/*
					fprintf(stderr,"hw=%s\n", *hw);
					*/
					bar = foo + 1;
					break;
				default:
					fprintf(stderr,
					"parse_widgets: remainder error %s\n",
						 foo);
					break;
			}
			c++;
		}
		foo++;
	}
#ifdef DEBUG
	fprintf(stderr,"parse range returns [%s] [%s] [%s] [%s]\n",
			*xw, *yw, *ww, *hw);
#endif
	return(i - start - 1);
}

/*
xodus_set_elms(w)
	Widget w;
{
	int i;
	XtCallbackRec	*callback;

	if (((LayoutConstraints)
		(w->core.constraints))->layout.layout_callback != NULL) {
		callback = (XtCallbackRec *) (((LayoutConstraints)
			(w->core.constraints))->layout.layout_callback);
		i = 0;
		while (callback[i].callback != NULL) {
			(callback[i].callback)(w,
			callback[i].closure, NULL);
			i++;
		}
	} else {
		printf("No layout constraints\n");
	}
}
*/
