static char rcsid[] = "$Id: shapematch.c,v 1.1 1992/12/11 19:06:09 dhb Exp $";

/*
** $Log: shapematch.c,v $
** Revision 1.1  1992/12/11  19:06:09  dhb
** Initial revision
**
*/

/*
** A brutally hacked piece of code to try to get a decent shapematch
** for the bulb model in the short time I have..
*/
#include <stdio.h>
#include <math.h>
#include "sim_ext.h"
#include "olf_struct.h"

int find_spike();
float do_shapematch();
float	est_max();
float	est_min();
float	do_stats();
void	altspline();
float ShapeStats();


#define MAXPTS 5000
#define MAXSPKS 500
#define MIN_SHAPE_SAMPLES 8

#define SN 0
#define SX 1
#define SY 2
#define SL 3
#define SL2 4
#define SH 5
#define SH2 6
#define SP 7
#define SP2 8
#define SS 9
#define ST 10
#define SW 11
#define NPARMS 12

#define SNSIMSPK 14
#define SNREFSPK 15

#define NSUM 16

#define SDT 0.001	/* 1.00 msec */

static float default_wt[]={
	0.1,	/* SN number */
	10.0,	/* SX time scaling charging curves */
	10.0,	/* SY amplitude scaling charging curves */
	1.0,	/* SL low pt on spikes */
	0.0,	/* SL2 low pt on spikes, only if below ref */
	1.0,	/* SH pk of spks */
	0.0,	/* SH2 pk of spks, only if below ref */
	1.0,	/* SP PTP of spks */
	0.0,	/* SP2 PTP of spks only if below ref */
	10.0,	/* SS Spike Shape -- very important parm */
	10.0,	/* ST Timing of individual spikes */
	1.0,	/* SW Width of individual spikes */
};

#ifdef STANDALONE
main(argc,argv)
	int		argc;
	char	**argv;
{
	printf("%f\n",do_shapematch(argc,argv));
}
#endif

typedef struct spikeinfo_type {
	int lo,hi;
	float tlo,thi;
} Spikeinfo;


float do_shapematch(argc,argv)
	int		argc;
	char	**argv;
{
	FILE	*simfile,*reffile,*fopen();
	float match;
	int i,j;
	float *sim,*simt,*ref,*reft;
	int 	nsim,nref;
	int		plot_flag=0,verbose_flag=0;
	float	Atof();
	float	*sum,*sumsq;
	struct table_type *wtelm,*resultelm;
	float	*wt;
	float	startt;


	if (argc<4) {
		printf("usage : %s reffile simfile startt [-W weight_array][-R Result_array]\n", argv[0]);
		printf("[n nspike_wt][-x scalexwt][-y scaleywt][-l lowt][-L toolowt]\n");
		printf("[-h hiwt][-H toohiwt][-p ptpwt][-P too_small_ptp_wt]\n");
		printf("[-s shape_wt][-t time_wt][-w width_wt]\n[-n nspike_wt]\n");
		printf("[-p ptpwt][-P too_small_ptp_wt][-s shape_wt][-t time_wt][-w width_wt]\n[-n nspike_wt]\n");
		printf("[-d[isplay]][-v[erbose]]\n");
		return(0);
	}

	if ((startt=Atof(argv[3]))<0.0) {
		printf("Error : startt = %s is too small\n",argv[3]);
		return(0);
	}

	if (!(reffile = fopen(argv[1],"r"))) {
		printf("Error : could not open file %s\n",argv[1]);
		return(0);
	}
	if (!(simfile = fopen(argv[2],"r"))) {
		printf("Error : could not open file %s\n",argv[2]);
		fclose(reffile);
		return(0);
	}

	sim = (float *)calloc(MAXPTS,sizeof(float));
	simt = (float *)calloc(MAXPTS,sizeof(float));
	ref = (float *)calloc(MAXPTS,sizeof(float));
	reft = (float *)calloc(MAXPTS,sizeof(float));
	sum = (float *)calloc(NSUM,sizeof(float));
	sumsq = (float *)calloc(NSUM,sizeof(float));
	wt = (float *)calloc(NSUM,sizeof(float));
	for(i=0;i<NPARMS;i++) wt[i]=default_wt[i];
	wtelm=NULL;
	resultelm=NULL;

	for(i=0;i < MAXPTS &&
		EOF != fscanf(simfile,"%f %f",&(simt[i]),&sim[i]) ; i++);
	nsim = i;

	for(i=0;i < MAXPTS &&
		EOF != fscanf(reffile,"%f %f",&(reft[i]),&ref[i]) ; i++);
	nref = i;

	for(i=3;i<argc;i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
				case 'W':
					i++;
					wtelm=(struct table_type *)GetElement(argv[i]);
					if (!wtelm ||
						strcmp(wtelm->object->name,"table")!=0) {
						printf("Error : could not find table elm %s\n",
							argv[i]);
						return(100);
					}
					if (wtelm->alloced && wtelm->table->xdivs>=NPARMS)
							for(j=0;j<NPARMS;j++)
								wt[j]=wtelm->table->table[j];
					else
						printf("Warning : table %s too small. Using default wts\n",argv[i]);
					break;
				case 'R':
					i++;
					resultelm=(struct table_type *)GetElement(argv[i]);
					if (!resultelm ||
						strcmp(resultelm->object->name,"table")!=0) {
						printf("Error : could not find table elm %s\n",
							argv[i]);
						return(100);
					}
					break;
				case 'd':
					plot_flag=1;
					break;
				case 'v':
					verbose_flag=1;
					break;
				case 'x':
					i++;wt[SX]=Atof(argv[i]);
					break;
				case 'y':
					i++;wt[SY]=Atof(argv[i]);
					break;
				case 'l':
					i++;wt[SL]=Atof(argv[i]);
					break;
				case 'L':
					i++;wt[SL2]=Atof(argv[i]);
					break;
				case 'h':
					i++;wt[SH]=Atof(argv[i]);
					break;
				case 'H':
					i++;wt[SH2]=Atof(argv[i]);
					break;
				case 'p':
					i++;wt[SP]=Atof(argv[i]);
					break;
				case 'P':
					i++;wt[SP2]=Atof(argv[i]);
					break;
				case 's':
					i++;wt[SS]=Atof(argv[i]);
					break;
				case 't':
					i++;wt[ST]=Atof(argv[i]);
					break;
				case 'w':
					i++;wt[SW]=Atof(argv[i]);
					break;
				case 'n':
					i++;wt[SN]=Atof(argv[i]);
					break;
				default:
					break;
			}
		}
	}
	for(i=0;reft[i]<startt;i++);
	for(j=0;simt[j]<startt;j++);
	ShapeMatch(ref+i,reft+i,nref-i,sim+j,simt+j,nsim-j,
		1,0.0,0.0,0.03,0.03,sum,sumsq,plot_flag,startt);

	match=sumsq[SS];

	free(sim);
	free(simt);
	free(ref);
	free(reft);
	free(sum);
	free(sumsq);
	fclose(reffile);
	fclose(simfile);

	return(match);
}

ShapeMatch(ref,reft,nref,sim,simt,nsim,
	autoest,user_maxest, user_minest, maxwindow,minwindow,
	sum,sumsq,plot_flag,startt)
	float	*ref;
	float	*reft;
	int		nref;
	float	*sim;
	float	*simt;
	int		nsim;
	int		autoest;
	float	user_maxest,user_minest,maxwindow,minwindow;
	float	*sum,*sumsq;
	int		plot_flag;
	float	startt;
{
	int		i,j,k,m;
	int		nrefspk,nsimspk,nminspk;
	Spikeinfo	*refspk,*simspk;
	float	thresh;
	float	maxest,minest;
	float	t,st;
	float	ry,sy;
	float	scalet;
	float	dt=SDT;
	FILE	*rout,*sout,*fopen();

	if (plot_flag) {
		rout=fopen("rout","w");
		sout=fopen("sout","w");
	}

	refspk=(Spikeinfo *)calloc(MAXSPKS,sizeof(Spikeinfo));
	simspk=(Spikeinfo *)calloc(MAXSPKS,sizeof(Spikeinfo));

	for(i=0;i<NSUM;i++) sum[i]=sumsq[i]=0.0;
	
	/* Setting the max and min values for the spike peaks */
	if (autoest) {
		maxest = est_max(ref,nref);
		minest = est_min(ref,nref);
	} else {
		maxest = user_maxest;
		minest = user_minest;
	}
	thresh=(maxest+5*minest)/6.0;

	nrefspk=0;
	refspk[nrefspk].lo=0;
	refspk[nrefspk].tlo=reft[0];
	for(i=1;i<nref-2;i++) {
		if (ref[i-1]<thresh && ref[i]<=thresh && ref[i+1]>thresh && 
			ref[i+2]>thresh) {
			refspk[nrefspk].hi=i;
			refspk[nrefspk].thi=reft[i];
			nrefspk++;
		}
		if (ref[i-1]>thresh && ref[i]>=thresh && ref[i+1]<thresh && 
			ref[i+2]<thresh) {
			refspk[nrefspk].lo=i+1;
			refspk[nrefspk].tlo=reft[i+1];
		}
	}
	refspk[nrefspk].hi=nref-1;
	refspk[nrefspk].thi=reft[nref-1];
	nrefspk++;

	nsimspk=0;
	simspk[nsimspk].lo=0;
	simspk[nsimspk].tlo=simt[0];
	for(i=1;i<nsim-2;i++) {
		if (sim[i-1]<thresh && sim[i]<=thresh && sim[i+1]>thresh && 
			sim[i+2]>thresh) {
			simspk[nsimspk].hi=i;
			simspk[nsimspk].thi=simt[i];
			nsimspk++;
		}
		if (sim[i-1]>thresh && sim[i]>=thresh && sim[i+1]<thresh && 
			sim[i+2]<thresh) {
			simspk[nsimspk].lo=i+1;
			simspk[nsimspk].tlo=simt[i+1];
		}
	}
	simspk[nsimspk].hi=nsim-1;
	simspk[nsimspk].thi=simt[nsim-1];
	nsimspk++;

	nminspk=(nsimspk>nrefspk) ? nrefspk : nsimspk;

	k=1;
	m=1;
	t=0.0;
	for(i=0;i<nminspk;i++) {
		scalet=(simspk[i].thi-simspk[i].tlo)/
			(refspk[i].thi-refspk[i].tlo);
		for (;t<refspk[i].thi;t+=dt) {
			for(;t>reft[k] && k <nref;k++);
			ry=ref[k-1]+(ref[k]-ref[k-1])*
				(t-reft[k-1])/(reft[k]-reft[k-1]);
			st=simspk[i].tlo+(t-refspk[i].tlo)*scalet;
			for(;st>simt[m] && m <nsim;m++);
			sy=sim[m-1]+(sim[m]-sim[m-1])*
				(st-simt[m-1])/(simt[m]-simt[m-1]);
			
			if (plot_flag) {
				fprintf(rout,"%f	%f\n",t,ry);
				fprintf(sout,"%f	%f\n",t,sy);
			}
			sumsq[SS]+=(ry-sy)*(ry-sy);
		}
	}
	free(refspk);
	free(simspk);
	if (plot_flag) {
		fclose(rout);
		fclose(sout);
	}
}

#ifdef STANDALONE
int find_spike(arr,start,npts,maxest,maxwindow)
	float	*arr;
	int		start;
	int		npts;
	float	maxest;
	float	maxwindow;
{
	int i;
	float hi,lo;
	float y;

	hi=maxest+maxwindow;
	lo=maxest-maxwindow;

	if (start > MAXPTS - 3)
		return(0);

	for (i=start+2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>=arr[i+1] && y>=arr[i+2])
				return(i);
		}
	}
	return(0);
}

find_max(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>arr[i+1] && y>arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	*mean = 0.0;
	*err = 0.0;

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

find_min(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y<arr[i-2] && y<arr[i-1] && y<arr[i+1] && y<arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

float est_max(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float max;

	if (npts <= 0)
		return(0.0);

	max = arr[0];

	for(i=1;i<npts;i++)
		if (max < arr[i])
			max = arr[i];
	return(max);
}

float est_min(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float min;

	if (npts <= 0)
		return(0.0);

	min = arr[0];

	for(i=1;i<npts;i++)
		if (min > arr[i])
			min = arr[i];
	return(min);
}

/* linterp does linear interpolatoon */
int linterp(xa,ya,n,x,y)
float *xa,*ya,x,*y;
int n;
{
	int klo,khi,k;
	float h,b,a;

	klo=0;
	/* khi=n-1; */
	khi=n;
	while (khi-klo > 1) {
		k=(khi+klo) >> 1;
		if (xa[k] > x) khi=k;
		else klo=k;
	}
	h=xa[khi]-xa[klo];
	if (h == 0.0) {
		printf("phooo! : Bad XA input to linterp in shapematch\n");
		return(0);
	}
	*y= ya[klo]+ (ya[khi]-ya[klo])*(x-xa[klo])/h;
	return(1);
}

#endif

#undef MAXPTS
#undef MAXSPKS
#undef MIN_SHAPE_SAMPLES

#undef SX
#undef SY
#undef SL
#undef SL2
#undef SH
#undef SH2
#undef SP
#undef SP2
#undef SS
#undef ST
#undef SW
#undef SN
#undef NPARMS

#undef SNSIMSPK
#undef SNREFSPK

#undef NSUM
