static char rcsid[] = "$Id: scale_parms.c,v 1.1 1992/12/11 19:06:07 dhb Exp $";

/*
** $Log: scale_parms.c,v $
** Revision 1.1  1992/12/11  19:06:07  dhb
** Initial revision
**
*/

#include "sim_ext.h"

/*
** scale_parms : a utility function for parameter variations.
** scales the selected fields in a path by the given factors.
** The path and protopath are assumed to be wild card paths of elements,
** usually compartments in a cell model. The relpath is a fixed relative
** path off these compartments to a specific channel, whose field
** is to be scaled. Clearly, there should be complete correspondence
** between the prototype and the scaled path.
**
** By Upinder S. Bhalla, Caltech. March 1992
*/
do_scale_parms(argc,argv)
	int		argc;
	char	**argv;
{
	double scale;
	ElementList *proto,*dest;
	Info info;
	int		err_flag=0;
	int	 	offset;
	char	*address;
	short	datatype;
	char	protopath[200];
	char	destpath[200];
	char	*relpath,*field;
	int		i;

	if (argc < 6) {
		printf("usage: %s path protopath relpath field scale_factor [r f s] [r f s]..\n",
			argv[0]);
		return;
	}
	for(i=3;i+2<argc;i++) {
		relpath=argv[i]; i++;
		field=argv[i]; i++;
		scale=Atod(argv[i]);

		sprintf(destpath,"%s/%s",argv[1],relpath);
		sprintf(protopath,"%s/%s",argv[2],relpath);

		if (!(dest=WildcardGetElement(destpath,0))) {
			printf("Error : Could not get path %s\n",destpath);
			return;
		}
		if (strcmp(argv[2],".")==0) {
			proto=dest;
		} else {
			if (!(proto=WildcardGetElement(protopath,0))) {
				printf("Error : Could not get path %s\n",protopath);
				FreeElementList(dest);
				return;
			}
		}
		if (proto->nelements != dest->nelements ||
			dest->nelements <= 0) {
			printf("Error : Invalid # of elms on  %s=%d;%s=%d have\n",
				destpath,dest->nelements,protopath,proto->nelements);
			err_flag=1;
		}

		if (!err_flag &&
			(address=CalculateAddress(dest->element[0],
			Type(dest->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				argv[0],field,argv[1]);
			err_flag=1;
		}
		if (!err_flag) {
			offset=info.offset;
			datatype=GetDatatype(info.type);
		}
		if (!err_flag &&
			(address=CalculateAddress(proto->element[0],
			Type(proto->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				argv[0],field,argv[2]);
			err_flag=1;
		}
		if (!err_flag &&
			offset!=info.offset || datatype != GetDatatype(info.type)) {
			printf("Error in %s. Field %s differs between %s and %s\n",
				argv[0],field,destpath,protopath);
			err_flag=1;
		}
		if (!err_flag) {
			ScaleParm(proto,dest,offset,scale,datatype);
		}
		FreeElementList(dest);
		if (proto!= dest)
			FreeElementList(proto);
	}
}

ScaleParm(srcs,dests,offset,scale,datatype)
	ElementList *srcs,*dests;
	int		offset;
	double scale;
	short datatype;
{
	int i;
	switch(datatype) {
		case INT :
			for (i=0;i<dests->nelements;i++) {
				*((int *)((char *)(dests->element[i])+offset)) = 
				scale * *((int *)((char *)(srcs->element[i])+offset));
			}
		break;
		case FLOAT:
			for (i=0;i<dests->nelements;i++) {
				*((float *)((char *)(dests->element[i])+offset)) = 
				scale * *((float *)((char *)(srcs->element[i])+offset));
			}
		break;
		case DOUBLE:
			for (i=0;i<dests->nelements;i++) {
				*((double *)((char *)(dests->element[i])+offset)) = 
				scale* *((double *)((char *)(srcs->element[i])+offset));
			}
		break;
	}
}

#ifdef OLD
do_scale_parms(argc,argv)
	int		argc;
	char	**argv;
{
	double scale;
	ElementList *src_elmlist,*dest_elmlist;
	Info info;
	int		err_flag=0;
	int	 offset,address;
	short	datatype;

	if (argc < 5) {
		printf("usage : %s path prototype field scale_factor [f s] [f s] .... \n",
			argv[0])
		return
	}

	scale=atod(argv[3]);

	if (!(dest_elmlist=WildcardGetElement(argv[1],1))) {
		return;
	}
	if (strcmp(argv[2],".")==0) {
		src_elmlist=dest_elmlist;
	} else {
		if (!(src_elmlist=WildcardGetElement(argv[2],1))) {
			FreeElementList(dest_elmlist);
			return;
		}
	}
	if (src_elmlist->nelements != dest_elmlist->nelements ||
		dest->elmlist->nelements == 0) {
		err_flag=1;
	}

	for(i=3;i<argc,i++) {
		field=argv[i];
		i++;
		scale=atod(argv[i]);

		if (!err_flag &&
			(address=CalculateAddress(dest_elmlist->element[0],
			Type(dest_elmlist->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				argv[0],field,argv[1]);
			err_flag=1;
		}
		offset=info.offset;
		datatype=GetDatatype(info.type);
		if (!err_flag &&
			(address=CalculateAddress(src_elmlist->element[0],
			Type(src_elmlist->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				argv[0],field,argv[2]);
			err_flag=1;
		}
		if (!err_flag &&
			offset!=info.offset || datatype != GetDatatype(info.type)) {
			printf("Error in %s. Field %s differs between %s and %s\n",
				argv[0],field,argv[1],argv[2]);
			err_flag=1;
		}
	
		if (err_flag)  {
			FreeElementList(dest_elmlist);
			if (src_elmlist != dest_elmlist)
				FreeElementList(src_elmlist);
			return;
		}
		ScaleParm(src_elmlist,dest_elmlist,offset,scale,datatype)
	}
}
#endif
