static char rcsid[] = "$Id: rand_comp.c,v 1.1 1992/12/11 19:06:05 dhb Exp $";

/*
** $Log: rand_comp.c,v $
** Revision 1.1  1992/12/11  19:06:05  dhb
** Initial revision
**
*/

/* Erik De Schutter, 8/91 */
/* Returns name of a randomly selected compartment from {root} {path} */

#include <stdio.h>
#include "sim_ext.h"
#include "tools.h"
#include "seg_struct.h"

char *do_rand_comp(argc,argv)
/* As there is no easy way to know how many compartments there are, we
**  randomly determine in each one whether it should be selected.  An
**  individual compartment has a chance of 1.0% to be selected, unless the
**  user specifies another probability */  
int argc;
char **argv;

{
Element		*elm,*path,*root;
char		name[100];
int			nargs = 1;
float		prob = 0.010;

	if (argc < 1) {
		printf("usage: %s [-p prob] root [path]",argv[0]);
		printf("returns pseudo-randomly selected compartment from tree root");
		printf("on repeated calls path should be the preceding selection");
	}

    if (strcmp(argv[1],"-p") == 0) {
		prob = Atof(argv[2]);
		nargs += 2;
	}

	root = GetElement(argv[nargs]);
	if (!root) {
		fprintf(stderr,"could not find (sym)compartment '%s'\n",argv[1]);
		return(NULL);
	}
	if (argc > nargs+1) {
		path = GetElement(argv[nargs+1]);
		if (!path) {
			fprintf(stderr,"could not find (sym)compartment '%s'\n",argv[2]);
			return(NULL);
		}
		path = path->next;
	} else {
		path = root;
	}

	for (;;) {
		for (elm=path;elm;elm=elm->next) {
			if ((strcmp(elm->object->name,"compartment") == 0) ||
				(strcmp(elm->object->name,"symcompartment") == 0)) {
				if (urandom() < prob) {
					sprintf (name,"%s[%d]",elm->name,elm->index);
					return(name);
				}
			}
		}
		path = root;
	}
}
