static char rcsid[] = "$Id: plane.c,v 1.1 1992/12/11 19:06:04 dhb Exp $";

/*
** $Log: plane.c,v $
** Revision 1.1  1992/12/11  19:06:04  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#include "header.h"

#define PI 3.1415927
/* mds3 changes */
/*
** #define MAXLONG                2147483641L
** #ifdef i860
** #define frandom(l,h)    (((float)rand()/MAXLONG)*((h)-(l))+(l))
** #else
** #define frandom(l,h)    (((float)random()/MAXLONG)*((h)-(l))+(l))
** #endif
*/

float newpt();

do_plane(argc,argv)
	int	argc;
	char	**argv;
{
	FILE	*fp,*fopen();
	float	x,y,dx,dy;
	float	theta,phi;
	float	nx,ny,nz;
	float	temp;
	int		i = 0;
	int 	normal = 0;
	int 	ellipse = 0;
	int 	hex = 0;
	int		center = 0;
	float	cx = 0,cy = 0;
	int		jitter = 0;
	float	jx = 0,jy = 0;
	float	tx,ty,px,py;

	if (argc < 6) {
		fprintf(stderr,"This routine generates coords for a plane with specified dimensions x,y\n");
		fprintf(stderr,"dx,dy specify the spacing.\n");
		fprintf(stderr,"cx,cy specify the center of the plane : default is (0,0).\n");
		fprintf(stderr,"jx,jy specify the jitter as a fraction of the spacing.\n");
		fprintf(stderr,"the -n(ormal) option decides if a normal should also be calculated\n");	
		fprintf(stderr,"the -e(llipse) option puts the cells in an ellipse rather than a rectangle\n");	
		fprintf(stderr,"the -h(exagona) option puts the cells in a hex array\n");	
		fprintf(stderr,"usage : %s filename x y dx dy [-c cx cy] [-j jx jy] [-n(ormal)] [-e(llipse)]\n [-h(exagonal)]\n",argv[0]);
		return;
	}
	x = Atof(argv[2])/2.0;
	y = Atof(argv[3])/2.0;
	dx = Atof(argv[4]);
	dy = Atof(argv[5]);

	for (i = 6 ; i < argc ; i++) {
		if (strncmp(argv[i],"-n",2) == 0) {
			normal = 1;
		}
		if (strncmp(argv[i],"-e",2) == 0) {
			ellipse = 1;
		}
		if (strncmp(argv[i],"-h",2) == 0) {
			hex = 1;
			printf("Hexagonal mode not yet implemented\n");
		}
		if (strncmp(argv[i],"-c",2) == 0) {
			center = 1; i++;
			cx = Atof(argv[i]); i++;
			cy = Atof(argv[i]);
		}
		if (strncmp(argv[i],"-j",2) == 0) {
			jitter = 1; i++;
			jx = Atof(argv[i]); i++;
			jy = Atof(argv[i]);
		}
	}

	fp = fopen(argv[1],"w");

	i = 0;
	for (px = -x ; px < x ; px += dx) {
		for (py = -y; py < y; py += dy) {
			tx = px; ty = py;
			if (ellipse) {
				if ((tx*tx/(x*x) + ty*ty/(y*y)) > 1.0)
					continue;
			}
			i++;
			if (center) {
				tx += cx;
				ty += cy;
			}
			if (jitter) {
				tx += dx * jx * frandom(-1.0,1.0);
				ty += dy * jy * frandom(-1.0,1.0);
			}
			if (normal) {
				fprintf(fp,"%-10.6e	%-10.6e	%-10.6e	%-10.6e	%-10.6e	%-10.6e\n",tx,ty,0.0,0.0,0.0,1.0);
			} else {
				fprintf(fp,"%-20.6e	%-20.6e	%-20.6e\n",tx,ty,0.0);
			}
		}
	}
	fclose(fp);
	printf ("%d coordinates were found\n",i);
}
