static char rcsid[] = "$Id: expfit.c,v 1.1 1992/12/11 19:05:54 dhb Exp $";

/*
** $Log: expfit.c,v $
** Revision 1.1  1992/12/11  19:05:54  dhb
** Initial revision
**
*/

#include "copyright.h"
#include <stdio.h>
#include <math.h>
#include "header.h"

#define MAXFITPTS 5001
#define MAXNA 20
#define ENDT 1000.0

/* E. De Schutter October 1990
** This file has the sum of exp form for the nonlin curvefit routine
** mrqmin to use.
** Modified version, fits for real tau values
*/

void myfitsum(x,a,y,dyda,na)
	float	x,a[],*y,dyda[];
	int na;
{
	int i;
	float arg,fac,fex;

	*y = a[1];
	dyda[1] = 1.0;

	for(i=2;i<=na;i+=2) {
		arg = x / a[i+1];
		fex = exp(-arg);
		fac = a[i] * fex;
		*y += fac;
		dyda[i] = fex;
		dyda[i+1] = fac * arg / a[i+1];
	}
}

char *tauexpfit(argc,argv)
	int		argc;
	char	**argv;
{
	float	x[MAXFITPTS],y[MAXFITPTS],sig[MAXFITPTS];
	float	a[MAXNA];
	int		lista[MAXNA];
	int		na,mfit;
	float	**covar,**alpha;
	float	chisq;
	float	lastchisq;
	float	alamda;
	int		plotno = 0;
	float	startt = 0,endt = ENDT,dt = 0,t=0;
	int		niterations=0,nexpterms=2,linterm=0,defaults=0;
	float	asymptote = -0.070; /* Resting potl */
	int		asymptote_flag = 0;
	char	*outputfile,*filemode;
	char	*notes;
	int		npts;
	int		i,n;
	static char ret[200];
	float	**matrix();

	float	*allvars[50];
	char	*varnames[50];
	int		nvars;

	if (argc < 2) {
		printf("usage : %s filename [-plot plotno] [-start time] [-end time]\n",argv[0]);
		printf("[-iterations n] [-expterms n] [-defaults Va  tau0 ..  taun]");
		printf("[-file outputfile mode]\n [-notes notes]\n");
		printf("The command returns : Vm(asymptotic),Vm(tau0),tau0,Vm(tau1),tau1,chisq\n");
		printf("start and end specify the points in the plot that will be fitted\n");
		printf("'iterations n' specifies the number of iterations : min if +ve, max if -ve\n");
		printf("It forces the routine to print out chisq for each stage\n");
		printf("'expterms' sets the number of exponential terms that the routine must fit\n");
		printf("Valid filemodes : multifile onefile onefileappend\n");
		return(NULL);
	}
	notes=NULL;
	outputfile=NULL;
	filemode=NULL;
	for (i = 2 ; i < argc ; i++) {
		if (strcmp(argv[i],"-plot") == 0) {
			i++; plotno = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-start") == 0) {
			i++; startt = Atof(argv[i]);
		}
		if (strcmp(argv[i],"-end") == 0) {
			i++; endt = Atof(argv[i]);
		}
		if (strcmp(argv[i],"-iterations") == 0) {
			i++; niterations = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-expterms") == 0) {
			i++; nexpterms = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-defaults") == 0) {
			defaults = 1;
			i++; a[1] = Atof(argv[i]);
			for (n = 1; n <= nexpterms; n++) {
				i++; a[2*n+1] = Atof(argv[i]);
			}
		}
		if (strcmp(argv[i],"-linterm") == 0) {
			linterm = 1;
		}
		if (strcmp(argv[i],"-file") == 0) {
			if (argc < (i + 2)) {
				printf("syntax : -file outputfile mode\n");
				return(NULL);
			}
			i++; outputfile = argv[i];
			i++; filemode = argv[i];
		}
		if (strcmp(argv[i],"-notes") == 0) {
			i++; notes = argv[i];
		}
	}

	na = 1 + nexpterms * 2 + linterm;
	if (na >= MAXNA) {
		printf("Max no of nexpterms is %d. Abandoning.\n",MAXNA/2 - 2);
		return(NULL);
	}

	nvars = 0;
	allvars[nvars] = &(a[1]); varnames[nvars] = "asymVm"; nvars++;
	allvars[nvars] = &chisq; varnames[nvars] = "chisq"; nvars++;
	for (i = 1 ; i <= (nexpterms * 2) ; i++) {
		allvars[nvars] = &(a[i+1]);
		varnames[nvars] = (char *) malloc(8 * sizeof(char *));
		if (i%2)
			sprintf(varnames[nvars],"Vm%d",(i-1)/2);
		else
			sprintf(varnames[nvars],"tau%d",(i-1)/2);
		nvars++;
	}

	if (!read_plot2(argv[1],plotno,&dt,y,MAXFITPTS - 1,&npts,startt,endt)) {
		printf("Read plot failed\n");
		return(NULL);
	}
	printf("Plot has %d points\n",npts);
	for (i=0,t=startt;i<npts;i++,t+=dt)
		x[i]=t;
	endt = t-dt;


/* INITIALISING VARIABLES */

	alpha = (float **)malloc((na + 1) * sizeof(float *));
	for (i = 0 ; i <= na ; i++)
		alpha[i] = (float *)malloc((na+1) * sizeof(float));
	covar = (float **)malloc((na+1) * sizeof(float *));
	for (i = 0 ; i <= na ; i++)
		covar[i] = (float *)malloc((na+1) * sizeof(float));

	if (!defaults) 
		a[1] = asymptote;	/* Resting potential by default */

	for (i=2;i<=na;i++){
		if (!(i%2)) /* odds i.e taus */
			if (!defaults) {
				a[i]= 5 * i * i;
			}
		else	
/*			a[i]=(float)(0.04/((float)i));	*/
			a[i]=0.02;	
	}
	printf("Defaults are %f %f %f %f %f\n",a[1],a[2],a[3],a[4],a[5]);

	mfit = na;
	mfit = na;
	for (i=0;i<=na;i++)
		lista[i] = i;

	for (i = npts ; i > 0 ; i--) {
		x[i] = x[i - 1];
		y[i] = y[i - 1];
		sig[i] = fabs(0.0005 * y[i]); /* assume 0.05% error */
		/* moving the values up because of their stupid
		** convention of starting at 1 */
	}
	
/* INITIALISING THE FUNCTION */
	alamda = -1;
	emrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
		myfitsum,&alamda);
	lastchisq = chisq * 1.01 + 1;

/* LOOPING TILL CONVERGENCE */
	if (niterations < 0) {
		niterations = -niterations;
		for (i = 1; i <= niterations; i++) {
			lastchisq = chisq;
			emrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
				myfitsum,&alamda);
			printf("Iteration %d, chisq = %f, lamda = %f\n",
				i,chisq,alamda);
			printf("%g %g %g %g %g\n",a[1],a[2],a[3],a[4],a[na]);
		}
	} else {
		for (i=1;((lastchisq - chisq)/1000.0) > 0.001 ||
			lastchisq <=  chisq || i <= niterations; i++) {
			lastchisq = chisq;
			emrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
				myfitsum,&alamda);
			printf("Iteration %d, chisq = %f, lamda = %f\n",
				i,chisq,alamda);
			printf("%g %g %g %g %g\n",a[1],a[2],a[3],a[4],a[na]);
		}
	}

/* EXTRACTING THE VARIABLES */
	alamda = 0;
	emrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
		myfitsum,&alamda);
	
	sprintf(ret,"%g %g %g %g %g %g",a[1],a[2],a[3],a[4],a[na],chisq);

	
/* CLEANING UP */
	for (i = 0 ; i <= na ; i++)
		free(alpha[i]);
	free(alpha);
	for (i = 0 ; i <= na ; i++)
		free(covar[i]);
	free(covar);
	
/* DUMPING OUTPUT */
    if (notes)
        printf("\n%s\n",notes);
    for (i = 0 ; i < nvars ; i++) {
        printf("%s  %g  ",varnames[i],*(allvars[i]));
        if ((i%3) == 2)
            printf("\n");
    }
    printf("\n");

	if (outputfile && strlen(outputfile) > 0) {
		spikeparmoutput(allvars,NULL,varnames,nvars,outputfile,filemode,notes);
	}
	return(ret);
}

#undef MAXFITPTS
