static char rcsid[] = "$Id: conn_3d.c,v 1.1.1.1 1993/07/08 20:41:27 dhb Exp $";

/*
** $Log: conn_3d.c,v $
 * Revision 1.1.1.1  1993/07/08  20:41:27  dhb
 * Fixed bug in gen_3d_msg(): changed type of slot_type to short!
 *
 * Revision 1.1  1992/10/29  19:21:45  dhb
 * Initial revision
 *
*/

/*******************************************************************
**                                                                **
**                          conn_3d.c                             **
**                Written by U.S.Bhalla.                          **
**  Permission to use and modify this software is freely granted, **
**    provided this message and acknowledgement remain intact.    **
**                                                                **
**	Parts of this code are derived from code written by           **
**                     Matt Wilson                                **
**                                                                **
**  I do not take any responsibility for the functionality and    **
**  use of this code, which is provided 'as is'.                  **
**                                                                **
*******************************************************************/

#include <stdio.h>
#include <math.h>

#include "sim_ext.h"

#ifndef EPSILON
#define EPSILON 1e-60
#endif

#define AXIAL 2
#define NSLOTS 20

struct vol_mask_type {
	short	type;
	short	box;
	float	cx,cy,cz;
	float	rx,ry,rz;
};

struct plane_mask_type {
	short	type;
	float	cx,cy,cz;
	float	nx,ny,nz;
	float	r,h;
};

static Element	*FindParentDend();
struct vol_mask_type *GetVolMaskFromArgv();

/*
** PerpDistBetweenLines returns the perpendicular distance between
** two lines in 3-d space. The returned value is negative if the
** perpendicular lies outside the line segments. The line segments
** are specified by the coords of elements and their parents.
**
** The algebra comes from considering a parametric rep of the two
** lines : R = R1 + n(R2-R2), P = P1 + m(P2-P1). Varying n and m
** we generate the lines. Solve for the condition that R - P is 
** normal to both the line segments. Check that n and m are between
** 0 and 1 to be sure that the perp is within the line segments.
*/

float PerpDistBetweenLines(parent1,elm1,parent2,elm2)
	Element	*parent1,*elm1,*parent2,*elm2;
{
	float r1x,r1y,r1z;
	float x2,y2,z2;
	float	PerpDist2();

	if (!elm1 || !parent1 || !elm2 || !parent2 ) {
		fprintf(stderr,"dd_3d_msg : Elements for vol messages do not exist\n");
		Error();
		return(-1.0);
	}

	r1x = parent2->x; r1y = parent2->y; r1z = parent2->z;
	x2 = elm2->x; y2 = elm2->y; z2 = elm2->z;
	return(PerpDist2(parent1,elm1,r1x,r1y,r1z,x2,y2,z2));
}

float PerpDist2(parent1,elm1,r1x,r1y,r1z,x2,y2,z2)
	Element	*parent1,*elm1;
	float r1x,r1y,r1z,x2,y2,z2;
{
	float p1x,p1y,p1z;
	float dpx,dpy,dpz;
	float dpsqr;
	float px,py,pz;

	float drx,dry,drz;
	float drsqr;
	float rx,ry,rz;

	float m,n;
	float t1,t2;
	float dist;

	p1x = parent1->x; p1y = parent1->y; p1z = parent1->z;
	dpx = elm1->x - p1x; dpy = elm1->y - p1y; dpz = elm1->z - p1z;
	dpsqr = dpx * dpx + dpy * dpy + dpz * dpz;

	drx = x2 - r1x; dry = y2 - r1y; drz = z2 - r1z;
	drsqr = drx * drx + dry * dry + drz * drz;

	t2 = t1 = (dpx * drx + dpy * dry + dpz * drz);
	t1 = t1 * t1 / drsqr - dpsqr;

	if (fabs(t1) < EPSILON) {
	/* The lines are parallel */
		m = 0.5;
	} else {
		t2 *= drx * (p1x - r1x) + dry * (p1y - r1y) + drz * (p1z - r1z);
		t2 /= drsqr;
		t2 = dpx * (p1x - r1x) + dpy * (p1y - r1y) + dpz * (p1z - r1z)
			- t2;
		m = t2 / t1;
	}

	n = drx * (p1x + m * dpx - r1x) + dry * (p1y + m * dpy - r1y) + 
		drz * (p1z + m * dpz - r1z);
	n /= drsqr;

	if (m < 0) {
		px = p1x; py = p1y ; pz = p1z;
	} else if (m > 1) {
		px = p1x + dpx ; py = p1y + dpy ; pz = p1z + dpz ;
	} else {
		px = p1x + m * dpx ; py = p1y + m * dpy ; pz = p1z + m * dpz ;
	}

	if (n < 0) {
		rx = r1x; ry = r1y ; rz = r1z;
	} else if (n > 1) {
		rx = r1x + drx ; ry = r1y + dry ; rz = r1z + drz ;
	} else {
		rx = r1x + n * drx ; ry = r1y + n * dry ; rz = r1z + n * drz ;
	}

	dist = (px - rx) * (px - rx) + (py - ry) * (py - ry) + 
		(pz - rz) * (pz - rz);
	dist = sqrt(dist);

	return(dist);
	/*
	if (n > 0.0 && n < 1.0 && m > 0.0 && m < 1.0) {
		the perp is within the two line segments
		return(dist);
	} else {
		return(-dist);
	}
	*/
}

/*
** This routine is largely based on Matt's do_add_msg routine
*/
void do_dd_3d_msg(argc,argv)
int 		argc;
char 		**argv;
{
char 		*ptr;
char 		*dst_path;
char 		*src_path;
char		*typename;
int		type;
ElementList	*src_list;
ElementList	*dst_list;
Element 	*src_element;
Element 	*dst_element;
short 		slot;
int		nxtarg;
Slot		sarray[NSLOTS];
struct mlist_type	*msgspec;
int		reqslots;
int		i,j,k;
double		number_value[100];
char		*str_value[100];
float		range;
MsgList	*GetMsgListByName();


    /*
    ** check the syntax
    */
    if(argc < 6) {
		TraceScript();
		printf("usage: %s sourcelist destlist range msgtype msg\n",
			argv[0]);
		return;
    }
    src_path = argv[1];
    dst_path = argv[2];
	range = Atof(argv[3]);
    typename = argv[4];
    src_list = WildcardGetElement(src_path,0);
    if(src_list->nelements == 0){
	InvalidPath(argv[0],src_path);
	FreeElementList(src_list);
	return;
    }
    dst_list = WildcardGetElement(dst_path,0);
    if(dst_list->nelements == 0){
	InvalidPath(argv[0],dst_path);
	FreeElementList(src_list);
	FreeElementList(dst_list);
	return;
    }

	dst_element = dst_list->element[0];
	/* 
	** get the msg type 
	*/
	if((msgspec = GetMsgListByName(dst_element->object,typename)) == NULL){
	    Error();
	    printf("%s is not a valid msg type for '%s'\n",
	    	typename, Pathname(dst_element));
	    return;
	}

	type = msgspec->type;
	reqslots = msgspec->slots;

	slot = 0;
	nxtarg = 4;
	/*
	** get the message specification information from the argument list
	*/
	while(++nxtarg < argc){
	    if(argv[nxtarg][0] == '*'){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    if(argv[nxtarg][0] == '\''){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    /*
		    ** find the trailing quote if any
		    */
		    if(strchr(argv[nxtarg]+1,'\'') != NULL){
			/*
			** and remove it
			*/
			*strchr(argv[nxtarg]+1,'\'') = '\0';
		    }
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    /* 
	    ** variable 
	    */
	    if(is_alpha(argv[nxtarg][0])){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    sarray[slot].name = CopyString(argv[nxtarg]);
		    slot++;
		}
	    } else
	    /* 
	    ** number 
	    */
	    if(is_num(argv[nxtarg][0]) ||
	    (argv[nxtarg][0] == '.' && is_num(argv[nxtarg][1]))){ 
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    number_value[slot] = Atof(argv[nxtarg]);
		    AssignSlotFunc(sarray+slot,DOUBLE);
		    sarray[slot].name = "_number";
		    slot++;
		}
	    } else {
		Error();
		return;
	    }
	}
	/*
	** check the number of slots filled against the number of
	** slots required
	*/
	if(slot != reqslots){
	    Error();
	    printf("msg type '%s' requires %d arguments.\n",
	    typename,reqslots);
	    return;
	}

	dd_sendmsg(src_list,dst_list,range,type,slot,sarray,reqslots,
		str_value,number_value);
    FreeElementList(src_list);
    FreeElementList(dst_list);
    OK();
}

/*
** dd_sendmsg  sends messges from one element list to another
** if the dends which are parents of the elements on the list 
** are within a given range of each other. 
*/
dd_sendmsg(source_chan,dest_chan,range,msgtype,slot,sarray,reqslots,str_value,number_value)
	ElementList	*source_chan;
	ElementList	*dest_chan;
	float	range;
	int		msgtype;
	short 		slot;
	Slot	*sarray;
	int		reqslots;
	double		*number_value;
	char		**str_value;
{
	int i,j,k;
	Element *sel, *del;
	float	dist;
	Element	*psel,*pdel;
	Element	*schan,*dchan;
	short slot_type;
	int sel_flag = 0,del_flag = 0;

	if (source_chan->nelements == 0 || dest_chan->nelements == 0)
		return;
	if (strcmp(source_chan->element[0]->object->name,"compartment")==0)
		sel_flag = 1;
	if (strcmp(dest_chan->element[0]->object->name,"compartment")==0)
		del_flag = 1;

	for (k = 0 ; k < source_chan->nelements ; k++) {
		schan = source_chan->element[k];
		if (sel_flag)
			sel = schan;
		else
			sel = schan->parent;
		psel = FindParentDend(sel);
		for (j = 0 ; j < dest_chan->nelements ; j++) {
			dchan = dest_chan->element[j];
			if (del_flag)
				del = dchan;
			else
				del = dchan->parent;
			pdel = FindParentDend(del);
			dist = PerpDistBetweenLines(psel,sel,pdel,del);
			if (dist >= 0 && dist < range) {
			    /*
			    ** assign the element specific info to the message
			    */
			    for(i=0;i<reqslots;i++){
					if (sarray[i].name && (strcmp(sarray[i].name,"_string")
						== 0)){
				    	sarray[i].data = CopyString(str_value[i]);
					} else if (sarray[i].name &&
						(strcmp(sarray[i].name,"_number") == 0)) {
				    	sarray[i].data = (char *)smalloc(sizeof(double));
				    	*((double *)(sarray[i].data)) = number_value[i];
					} else {
				    	if((sarray[i].data = 
				    		GetFieldAdr(schan,sarray[i].name,
							&slot_type)) == NULL){
							Error();
							printf("dd_sendmsg: could not find data field '%s' on '%s'\n",
							sarray[i].name, Pathname(schan));
							return;
				    	}
					AssignSlotFunc(sarray+i,slot_type);
					}
			    }
				AddMsg(schan,dchan,msgtype,slot,sarray);
			}
		}
	}
}

static Element	*FindParentDend(elm)
	Element	*elm;
{
	MsgIn	*msg;

	for (msg = elm->msg_in; msg ; msg = msg->next) {
		if (msg->type == AXIAL) {
			return(msg->src);
		}
	}
	return(NULL);
}

/*
** This routine is largely based on Matt's do_add_msg routine
*/
void do_gen_3d_msg(argc,argv)
int 		argc;
char 		**argv;
{
char 		*ptr;
char 		*dst_path;
char 		*src_path;
char		*typename;
int		type;
ElementList	*src_list;
ElementList	*dst_list;
Element 	*src_element;
Element 	*dst_element;
short 		slot;
int		nxtarg;
Slot		sarray[NSLOTS];
struct mlist_type	*msgspec;
int		reqslots;
int		i,j,k;
double		number_value[100];
char		*str_value[100];
float		range,prob;
MsgList	*GetMsgListByName();


    /*
    ** check the syntax
    */
    if(argc < 7) {
		TraceScript();
		printf("usage: %s sourcelist destlist range prob msgtype msg\n",
			argv[0]);
		return;
    }
    src_path = argv[1];
    dst_path = argv[2];
	range = Atof(argv[3]);
	prob = Atof(argv[4]);
    typename = argv[5];
    src_list = WildcardGetElement(src_path,0);
    if(src_list->nelements == 0){
	InvalidPath(argv[0],src_path);
	FreeElementList(src_list);
	return;
    }
    dst_list = WildcardGetElement(dst_path,0);
    if(dst_list->nelements == 0){
	InvalidPath(argv[0],dst_path);
	FreeElementList(src_list);
	FreeElementList(dst_list);
	return;
    }

	dst_element = dst_list->element[0];
	/* 
	** get the msg type 
	*/
	if((msgspec = GetMsgListByName(dst_element->object,typename)) == NULL){
	    Error();
	    printf("%s is not a valid msg type for '%s'\n",
	    	typename, Pathname(dst_element));
	    return;
	}

	type = msgspec->type;
	reqslots = msgspec->slots;

	slot = 0;
	nxtarg = 5;
	/*
	** get the message specification information from the argument list
	*/
	while(++nxtarg < argc){
	    if(argv[nxtarg][0] == '*'){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    if(argv[nxtarg][0] == '\''){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    /*
		    ** find the trailing quote if any
		    */
		    if(strchr(argv[nxtarg]+1,'\'') != NULL){
			/*
			** and remove it
			*/
			*strchr(argv[nxtarg]+1,'\'') = '\0';
		    }
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    /* 
	    ** variable 
	    */
	    if(is_alpha(argv[nxtarg][0])){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    sarray[slot].name = CopyString(argv[nxtarg]);
		    slot++;
		}
	    } else
	    /* 
	    ** number 
	    */
	    if(is_num(argv[nxtarg][0]) ||
	    (argv[nxtarg][0] == '.' && is_num(argv[nxtarg][1]))){ 
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    number_value[slot] = Atof(argv[nxtarg]);
		    AssignSlotFunc(sarray+slot,DOUBLE);
		    sarray[slot].name = "_number";
		    slot++;
		}
	    } else {
		Error();
		return;
	    }
	}
	/*
	** check the number of slots filled against the number of
	** slots required
	*/
	if(slot != reqslots){
	    Error();
	    printf("msg type '%s' requires %d arguments.\n",
	    typename,reqslots);
	    return;
	}

	vol_sendmsg(src_list,dst_list,range,prob,type,slot,sarray,reqslots,
		str_value,number_value);
    FreeElementList(src_list);
    FreeElementList(dst_list);
    OK();
}


/*
** vol_sendmsg  sends messages from one element list to another
** if the elements are within a given range of each other.
*/
vol_sendmsg(source_chan,dest_chan,range,prob,msgtype,slot,sarray,reqslots,str_value,number_value)
	ElementList	*source_chan;
	ElementList	*dest_chan;
	float	range;
	float	prob;
	int		msgtype;
	short 		slot;
	Slot	*sarray;
	int		reqslots;
	double		*number_value;
	char		**str_value;

{
	int i,j,k;
	float	dist;
	Element	*schan,*dchan;
	short	slot_type;

	for (k = 0 ; k < source_chan->nelements ; k++) {
		schan = source_chan->element[k];
		for (j = 0 ; j < dest_chan->nelements ; j++) {
			if (prob < 1.0 && urandom() > prob)
				continue;
			dchan = dest_chan->element[j];
			dist = (schan->x - dchan->x) * (schan->x - dchan->x) +
			(schan->y - dchan->y) * (schan->y - dchan->y) +
			(schan->z - dchan->z) * (schan->z - dchan->z) ;
			dist = sqrt(dist);
			if (dist < range) {
			    /*
			    ** assign the element specific info to the message
			    */
			    for(i=0;i<reqslots;i++){
					if (sarray[i].name && (strcmp(sarray[i].name,"_string")
						== 0)){
				    	sarray[i].data = CopyString(str_value[i]);
					} else if (sarray[i].name &&
						(strcmp(sarray[i].name,"_number") == 0)) {
				    	sarray[i].data = (char *)smalloc(sizeof(double));
				    	*((double *)(sarray[i].data)) = number_value[i];
					} else {
				    	if((sarray[i].data = 
				    		GetFieldAdr(schan,sarray[i].name,
							&slot_type)) == NULL){
							Error();
							printf("vol_sendmsg: could not find data field '%s' on '%s'\n",
							sarray[i].name, Pathname(schan));
							return;
				    	}
					AssignSlotFunc(sarray+i,slot_type);
					}
			    }
				AddMsg(schan,dchan,msgtype,slot,sarray);
			}
		}
	}
}





/*
** This routine derived from Matt Wilson's code, in particular,
** from the do_region_connect function.
**
** connects the elements of one tree to another
** using specified source projections and destination segments
** and the specified source and destination masks
** The destination mask is given relative to the source element location
*/
do_volume_connect(argc,argv)
int argc;
char **argv;
{
char                        *projection_name;
char                        *segment_name;
char                        *connection_object_name;
int                         src_count,dst_count;
struct vol_mask_type        *src_mask,*dst_mask;
int                         i;
int                         nxtarg;
float                       pconnect = 1;
int                         relative = 0;
char                        *type;
int							box;

    if(argc < 4){
        printf("usage: %s src_path [to] dst_path [[with] connection_object]\n",
        argv[0]);
        printf("       [-rel] [-box]\n");
        printf("       nsrc_masks type cx cy cz rx ry rz ...\n");
        printf("       ndst_masks type cx cy cz rx ry rz ...\n");
        printf("       [probability of connection]\n");
        printf("The default mode is to use an ellipse centered at cx,cy,cz\n");
        printf("and with axes rx,ry,rz\n");
        return;
    }
    /*
    ** PARSE THE COMMAND LINE
    */
    projection_name = argv[1];
    connection_object_name = NULL;
    nxtarg = 1;
    if(strcmp(argv[++nxtarg],"to") == 0){
        segment_name  = argv[++nxtarg];
    } else {
        segment_name  = argv[nxtarg];
    }
    if(strcmp(argv[++nxtarg],"with") == 0){
        connection_object_name  = argv[++nxtarg];
    } else {
        connection_object_name  = argv[nxtarg];
    }
    /*
    ** the remaining arguments give the mask specifications
    */
    nxtarg++;
    if(strcmp(argv[nxtarg],"-rel") == 0){
        relative = 1;
        nxtarg++;
    }
        if(strcmp(argv[nxtarg],"-box") == 0) {
                box = 1;        
                nxtarg++;
        }
    /*
    ** set up the src masks
    */
    src_mask = GetVolMaskFromArgv(&src_count,&nxtarg,argc,argv,box);
    /*
    ** set up the dst masks
    */
    dst_mask = GetVolMaskFromArgv(&dst_count,&nxtarg,argc,argv,box);
    /*
    ** if there is an argument left then use it as the probability
    ** of connection
    */
    if(argc > nxtarg){
        pconnect = Atof(argv[nxtarg]);
    }
    VolumeConnect(projection_name,src_mask,src_count, 
    segment_name,dst_mask,dst_count,
    connection_object_name,pconnect,relative);
    free(src_mask);
    free(dst_mask);
    OK();
}


struct vol_mask_type *GetVolMaskFromArgv(count,nxtarg,argc,argv,box)
int *count;
int *nxtarg;
int argc;
char **argv;
int	box;
{
int i;
struct vol_mask_type *mask;
int argcount;

    argcount = *nxtarg;
    *count = atoi(argv[argcount++]);
    if(argc < argcount + *count){
        Error();
        printf("bad region specification\n");
        printf("format: n +-1 cx1 cy1 cz1 rx1 ry1 rz1 ... +-1 cxn cyn czn rxn ryn rzn\n");
        return(NULL);
    }
    mask = (struct vol_mask_type *)
    malloc((*count) * sizeof(struct vol_mask_type));
    for(i=0;i<(*count);i++){
        mask[i].type = atoi(argv[argcount++]); 
        mask[i].box = box; 
        mask[i].cx = Atof(argv[argcount++]); 
        mask[i].cy = Atof(argv[argcount++]); 
        mask[i].cz = Atof(argv[argcount++]); 
        mask[i].rx = Atof(argv[argcount++]); 
        mask[i].ry = Atof(argv[argcount++]); 
        mask[i].rz = Atof(argv[argcount++]); 
    }
    *nxtarg = argcount;
    return(mask);
}


VolumeConnect(projection_path,src_region,src_nregions,
	    segment_path,dst_region,dst_nregions,
	    connection_object_name,
	    pconnect,
	    relative)
char 			*projection_path;
struct vol_mask_type 	*src_region;
int 			src_nregions;
char 			*segment_path;
struct vol_mask_type 	*dst_region;
int 			dst_nregions;
char			*connection_object_name;
float			pconnect;
int			relative;
{
Element 		*element;
Projection 		*projection;
Segment 		*segment;
Connection 		*connection;
ElementList		*slist,*plist;
float 			srcx,srcy,srcz;
GenesisObject			*connection_object;
int			i,j;
PFI			action_func;
float 			x,y;
register struct vol_mask_type *ptr;
int			val;

    connection_object = NULL;
    /*
    ** if the user specified a connection object then try to get it
    */
    if(connection_object_name){
	if((connection_object = GetObject(connection_object_name)) == NULL){
	    Error();
	    printf("could not find object '%s'\n",connection_object_name);
	    return;
	}
    }
    /*
    ** get the element list for the projections
    */
    plist = WildcardGetElement(projection_path,0);
    /*
    ** use a separate list for the segments
    */
    slist = WildcardGetElement(segment_path,0);
    /*
    ** go through all of the projections
    */
    for(i=0;i<plist->nelements;i++){
	projection = (Projection *)plist->element[i];
	/*
	** make sure its a projection
	*/
	if(!CheckClass(projection,PROJECTION_ELEMENT)){
	    continue;
	}
	/*
	** is it within the bounding regions
	*/
	if(!IsElementWithinVolume(projection,src_region,src_nregions)){
	    continue;
	};
	/*
	** assign and/or check the connection object of the projection
	*/
	if(!CheckConnectionObject(projection,connection_object)){
	    Error();
	    printf("must define a connection object\n");
	    return;
	}
	/*
	** get the CREATE action func for the connection
	*/
	action_func = GetActionFunc(connection_object,CREATE);
	/*
	** get the location of the projection
	*/
	srcx = projection->x;
	srcy = projection->y;
	srcz = projection->z;
	/*
	** go through all of the children of the dst_element
	** to get the destination segments
	*/
	for(j=0;j<slist->nelements;j++){
	    segment = (Segment *)slist->element[j];
	    /*
	    ** make sure it is a segment
	    */
	    if(!CheckClass(segment,SEGMENT_ELEMENT)){
		continue;
	    }
	    /*
	    ** is it within the bounding regions
	    */
	    if(relative){
			if(!IsElementWithinVolumeRel(segment,dst_region,
			dst_nregions,srcx,srcy,srcz)){
		    	continue;
			}
	    } else {
		if(!IsElementWithinVolume(segment,dst_region,dst_nregions)){
		    continue;
		}
	    }
	    /*
	    ** make the connection
	    */
	    if(pconnect >= 1 || urandom() <= pconnect){
		if((connection = AddConnection(projection,
		segment,connection_object,action_func)) == NULL){
		    printf("unable to make connection from '%s' to '%s'\n",
		    Pathname(projection),
		    Pathname(segment));
		} 
	    }
	}
	if (IsSilent() < 2) {
		printf(".");
		fflush(stdout);
	}
    }
    printf("\n");
    /*
    ** free up the element lists
    */
    FreeElementList(slist);
    FreeElementList(plist);
}


IsElementWithinVolume(element,mask,nmasks)
Element         *element;
struct vol_mask_type *mask;
int nmasks;
{
register float x,y,z;
float		rx,ry,rz;
register struct vol_mask_type *ptr;

    /*
    ** if no masks are specified then assume that is within the region
    */
    if(nmasks == 0) return(1);
    /*
    ** search the mask list from the bottom up
    ** if the element is bounded by a mask then
    ** it will possess that sign and no further search is 
    ** necessary
    */
    x = element->x;
    y = element->y;
    z = element->z;
    ptr = mask + nmasks-1;
    do{
		if (ptr->box) {
        	if ( 
        		x >= (ptr->cx - ptr->rx) && 
        		x <= (ptr->cx + ptr->rx) && 
        		y >= (ptr->cy - ptr->ry) &&
        		y <= (ptr->cy + ptr->ry) &&
        		z >= (ptr->cz - ptr->rz) &&
        		z <= (ptr->cz + ptr->rz)) {
            		return(ptr->type == 1);
        	}
		} else { /* Elliptical volume */
			if (ptr->rx < EPSILON ||
				ptr->ry < EPSILON ||
				ptr->rz < EPSILON) {
				return(0);
			}
			rx = (x - ptr->cx) / ptr->rx;
			ry = (y - ptr->cy) / ptr->ry;
			rz = (z - ptr->cz) / ptr->rz;
			if ((rx * rx + ry * ry + rz * rz) <= 1) {
            		return(ptr->type == 1);
			}
		}
    } while(ptr-- != mask);
    return(0);
}

IsElementWithinVolumeRel(element,mask,nmasks,relx,rely,relz)
Element                *element;
struct vol_mask_type *mask;
int nmasks;
float relx,rely,relz;
{
register float x,y,z;
float		rx,ry,rz;
register struct vol_mask_type *ptr;

    /*
    ** if no masks are specified then assume that is within the region
    */
    if(nmasks == 0) return(1);
    /*
    ** search the mask list from the bottom up
    ** if the element is bounded by a mask then
    ** it will possess that sign and no further search is 
    ** necessary
    */
    x = element->x - relx;
    y = element->y - rely;
    z = element->z - relz;
    ptr = mask + nmasks-1;
    do{
		if (ptr->box) {
        	if ( 
        		x >= (ptr->cx - ptr->rx) && 
        		x <= (ptr->cx + ptr->rx) && 
        		y >= (ptr->cy - ptr->ry) &&
        		y <= (ptr->cy + ptr->ry) &&
        		z >= (ptr->cz - ptr->rz) &&
        		z <= (ptr->cz + ptr->rz)) {
            		return(ptr->type == 1);
        	}
		} else { /* Elliptical volume */
			if (ptr->rx < EPSILON ||
				ptr->ry < EPSILON ||
				ptr->rz < EPSILON) {
				return(0);
			}
			rx = (x - ptr->cx) / ptr->rx;
			ry = (y - ptr->cy) / ptr->ry;
			rz = (z - ptr->cz) / ptr->rz;
			if ((rx * rx + ry * ry + rz * rz) <= 1) {
            		return(ptr->type == 1);
			}
		}
    } while(ptr-- != mask);
    return(0);
}

#ifdef NEW
do_planar_connect(argc,argv)
int argc;
char **argv;
{
char                        *projection_name;
char                        *segment_name;
char                        *connection_object_name;
int                         src_count,dst_count;
struct plane_mask_type      *src_mask,*dst_mask;
int                         i;
int                         nxtarg;
float                       pconnect = 1;
int                         relative = 0;
char                        *type;
int							box;

    if(argc < 4){
        printf("usage: %s src_path [to] dst_path [[with] connection_object]\n",
        argv[0]);
        printf("       [-rel] norm_path \n");
        printf("       nsrc_masks type cx cy cz r h ...\n");
        printf("       ndst_masks type cx cy cz r h ...\n");
        printf("       [probability of connection]\n");
        printf("The plane used for deciding where to connect to is\n");
        printf("specified by the coords of the source axon and the\n");
		printf("norm_path. The norm_path\n");
        printf("is the path of an element relative to the axon\n");
        printf("\n");
        return;
    }
}


IsElementWithin

do_conn_params
gaussian
linear 
inv-linear
random scatter
exp
tabulated.
non-radial : parallel fibre
			fraction of arc projection field
len offset
dependence on type/name/path of dest elements
#endif
