static char rcsid[] = "$Id: signal.c,v 1.1 1992/12/11 19:05:36 dhb Exp $";

/*
** $Log: signal.c,v $
** Revision 1.1  1992/12/11  19:05:36  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#include <signal.h>

/* mds3 changes */
/*
** Multiple casts to 'void*' made in calls to 'signal()'
*/

extern int harmless_sig();
extern int restore_context();
extern int sig_msg_restore_context();

SetSIGQUIT()
{

    signal(SIGQUIT,(void*)sig_msg_restore_context);
}

SetSignals()
{

    signal(SIGINT,(void*)restore_context);
    SetSIGQUIT();
    signal(SIGQUIT,SIG_IGN);
    signal(SIGSEGV,(void*)sig_msg_restore_context);
    signal(SIGILL,(void*)sig_msg_restore_context);
    /*
    signal(SIGFPE,sig_msg_restore_context);
    */
    signal(SIGBUS,(void*)sig_msg_restore_context);
    signal(SIGTRAP,(void*)sig_msg_restore_context);
}

ClearSignals()
{
    signal(SIGINT,SIG_DFL);
    signal(SIGQUIT,SIG_DFL);
    signal(SIGSEGV,SIG_DFL);
    signal(SIGILL,SIG_DFL);
    signal(SIGFPE,SIG_DFL);
    signal(SIGBUS,SIG_DFL);
}

harmless_sig(sig,code)
int sig,code;
{
	switch(sig){	
	case SIGSEGV :
		printf("segmentation violation\n");
		break;
	case SIGFPE :
		printf("floating point exception. code = %d\n",code);
		break;
	case SIGILL :
		printf("illegal instructio. code = %d\n",code);
		signal(SIGILL,(void*)harmless_sig);
		break;
	}
}

CoreRequest()
{
	printf("core dump (y/n) n? ");
	normal_tty();
	if(getchar() == 'y'){
	    signal(SIGQUIT,SIG_DFL);
	    kill(getpid(),SIGQUIT);
	}
	tset();
}

sig_msg(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
long clock;
char *name;

    switch(sig){	
    case SIGSEGV :
	    printf("segmentation violation\n");
	    CoreRequest();
	    break;
    case SIGILL :
	    printf("illegal instruction. code = %d\n",code);
	    signal(SIGILL,(void*)sig_msg_restore_context);
	    CoreRequest();
	    break;
    case SIGFPE :
	    printf("floating point exception. code = %d\n",code);
	    CoreRequest();
	    break;
    case SIGBUS :
	    printf("bus error\n");
	    CoreRequest();
	    break;
    case SIGTRAP :
	    printf("trace trap\n");
	    CoreRequest();
	    signal(SIGTRAP,(void*)sig_msg_restore_context);
	    break;
    default:
	    printf("Fatal error *** sig %d : code %d\n",sig,code);
	    CoreRequest();
	    break;
    }
    printf("exit program (y/n) n? ");
    normal_tty();
    if(getchar() == 'y'){
	exit(0);
    }
    tset();
}

