static char rcsid[] = "$Id: code_sym.c,v 1.1 1992/12/11 19:05:28 dhb Exp $";

/*
** $Log: code_sym.c,v $
** Revision 1.1  1992/12/11  19:05:28  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAX_DIMENSIONS 4

int no_include = 0;

is_space_char(c)
char	c;
{
	return(c== '\n' || c == ' ' || c=='\t' || c=='\0');
}

is_alpha(c)
char	c;
{
    return((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || (c=='_') ||
    (c >= '0' && c <= '9'));
}

#define Check(P)	if(*(P) == '\0') break;

NextField(ptr)
char **ptr;
{
    while(!is_space_char(**ptr) && **ptr != '\0') CInc(ptr);
    SkipWhiteSpace(ptr);
}

Inc(ptr)
char **ptr;
{
    if(**ptr != '\0') 
	(*ptr)++;
    else 
	return;
}

CInc(ptr)
char **ptr;
{
    if(**ptr != '\0') 
	(*ptr)++;
    else 
	return;
    SkipComments(ptr);
}

SkipComments(ptr)
char **ptr;
{
    if((**ptr == '/') && (*(*ptr +1) == '*')){
	while(**ptr != '\0' && strncmp(*ptr,"*/",2) != 0) (*ptr)++;
	if(**ptr != '\0') (*ptr) += 2;
    }
}
SkipWhiteSpace(ptr)
char **ptr;
{
    SkipComments(ptr);
    while(is_space_char(**ptr) && **ptr != '\0') CInc(ptr);
}

MakeStructCode(file,out,name,include)
char *file;
FILE *out;
char *name;
char *include;
{
FILE *fp;
char line[80];
char type[80];
char itemname[80];
char itemtype[80];
char tmp[80];
int indirection;
char *ptr;
char *tptr;
char *iptr;
short structure;
char *buf;
struct stat stbuf;
int fsize;
int count = 0;
int i;
char table[1000][80];
short dimensions;
int dimension_size[MAX_DIMENSIONS];

    /*
    ** open the function list file
    */
    if((fp = fopen(file,"r")) == NULL){
	fprintf(stderr,"unable to read function list file %s\n",file);
	return(0);
    }
    /*
    ** load the file into the buffer
    */
    stat(file,&stbuf);
    fsize = stbuf.st_size;
    buf = (char *)malloc(fsize+1);
    fread(buf,fsize,1,fp);
    buf[fsize] = '\0';
    fprintf(out,"%s\n",include);

    ptr = buf;
/* mds3 changes */
/* Only needed if compiling on a System V machine */
#ifdef SYSV
    fprintf(out,"#define __BZ memset(&info,0,sizeof(Info))\n");
#else
    fprintf(out,"#define __BZ bzero(&info,sizeof(Info))\n");
#endif
    fprintf(out,"#define __IFI(F) info.field_indirection = F\n");
    fprintf(out,"#define __IFT info.function_type = 1\n");
    fprintf(out,"#define __IND(N) info.dimensions = N\n");
    fprintf(out,"#define __IDS(S,N) info.dimension_size[S] = N\n");

    while(*ptr != '\0'){
	/*
	*** skip white space
	*/
	SkipWhiteSpace(&ptr);
	Check(ptr);
	/*
	** COMPILER DIRECTIVES
	*/
	if(*ptr == '#'){
	    /*
	    ** literal include
	    */
	    while(*ptr != '\n'){
		if(!no_include)
		    fprintf(out,"%c",*ptr);
		Inc(&ptr);
	    }
	    fprintf(out,"\n");
	    continue;
	}
	sscanf(ptr,"%s",type);
	/*
	** STRUCT
	*/
	if(strcmp(type,"struct") == 0){
	    /*
	    ** scan to the next field
	    */
	    NextField(&ptr);
	    sscanf(ptr,"%s",type);
	} else
	/*
	** TYPEDEFS
	*/
	if(strcmp(type,"typedef") == 0){
	    /*
	    ** skip it
	    */
	    while(*ptr != '{' && 
	    *ptr != ';' &&
	    *ptr != '\0') Inc(&ptr);
	    if(*ptr == '{'){
		/*
		** find the matching bracket
		*/
		while(*ptr != '}' && *ptr != '\0') Inc(&ptr);
		NextField(&ptr);
	    }
	    NextField(&ptr);
	    continue;
	} else {
	    /*
	    ** ignore it by skipping to the the end
	    */
	    while(*ptr != ';' && *ptr != '\0') Inc(&ptr);
	    Check(ptr);
	    Inc(&ptr);
	    continue;
	}
	/*
	** STRUCT SPECIFICATION
	**
	** find the left bracket
	*/
	while(*ptr != '{' && *ptr != '\0') Inc(&ptr);
	if(*ptr == '\0'){
	    fprintf(stderr,"missing matching bracket\n");
	    return(0);
	}
	strcpy(table[count++],type);
	fprintf(out,"INFO_%s(){\n",type);
	fprintf(out,"struct %s var;Info info;char fields[1000];fields[0]='\\0';info.name=\"%s\";info.type_size=sizeof(var);InfoHashPut(&info);\n",type,type);
	/*
	** FIELDS
	**
	** process the item fields
	*/
	while(*ptr != '\0'){
	    NextField(&ptr);
	    /*
	    ** END OF STRUCTURE SPEC
	    */
	    if(*ptr == '}') break;
	    Check(ptr);
	    /*
	    ** ITEMTYPE
	    ** get the item type by reading the type specification up
	    ** to either white space or an asterisk
	    */
	    tptr = ptr;
	    iptr = itemtype;
	    while(!is_space_char(*tptr) && *tptr != '*'){
		*iptr++ = *tptr++;
	    }
	    *iptr = '\0';
	    structure = 0;
	    /*
	    ** is it a structure?
	    */
	    if(strcmp(itemtype,"struct") == 0){
		/*
		** then use the structure name as the type
		** and flag it as a structure
		*/
		NextField(&ptr);
		Check(ptr);
		sscanf(ptr,"%s",itemtype);
		structure = 1;
	    } else 
	    if(strcmp(itemtype,"unsigned") == 0){
		/*
		** then use the structure name as the type
		** and flag it as a structure
		*/
		NextField(&ptr);
		Check(ptr);
		sscanf(ptr,"%s",tmp);
		sprintf(itemtype,"unsigned %s",tmp);
	    } 
	    NextField(&ptr);
	    Check(ptr);
	    dimensions = 0;
	    GetItemname(&ptr,itemname,&indirection,&dimensions,dimension_size);
	    PrintIt(out,type,itemname,itemtype,indirection,structure,
	    dimensions,dimension_size);
	    /*
	    ** check for a comma or a semicolon
	    */
	    while(*ptr != ';'){
		while(*ptr != ';' && *ptr != ',') Inc(&ptr);
		if(*ptr == ','){
		    Inc(&ptr);
		    GetItemname(&ptr,itemname,&indirection,&dimensions,dimension_size);
		    PrintIt(out,type,itemname,itemtype,indirection,structure,
		    dimensions,dimension_size);
		}
	    }
	}
	fprintf(out,"FieldHashPut(\"%s\",fields);\n}\n",type);
	Check(ptr);
	NextField(&ptr);
    }
    fprintf(out,"#undef __BZ\n");
    fprintf(out,"#undef __IFI\n");
    fprintf(out,"#undef __IFT\n");
    fprintf(out,"#undef __IND\n");
    fprintf(out,"#undef __IDS\n");
    /*
    ** make the calling function
    */
    fprintf(out,"DATA_%s(){\n",name);
    for(i=0;i<count;i++){
	fprintf(out,"INFO_%s();\n",table[i]);
    }
    fprintf(out,"}\n");
    free(buf);
}

GetItemname(ptr,itemname,indirection,dimensions,dimension_size)
char **ptr;
char *itemname;
int *indirection;
short *dimensions;
int dimension_size[MAX_DIMENSIONS];
{
char *tmp;
char *iptr;
char index[80];

    /*
    ** skip any white space
    */
    while(is_space_char(**ptr) && **ptr != '\0') Inc(ptr);
    /*
    ** skip any indirection
    */
    *indirection = 0;
    while(**ptr == '*') {
	Inc(ptr);
	(*indirection)++;
    }
    tmp = itemname;
    /*
    ** skip any white space
    */
    while(is_space_char(**ptr) && **ptr != '\0') Inc(ptr);
    /*
    ** get the itemname
    */
    while(is_alpha(**ptr)){
	*tmp = *(*ptr);
	tmp++;
	Inc(ptr);
    }
    /*
    ** get the array information
    */
    while(**ptr == '['){
	/*
	** get the index
	*/
	iptr = index;
	while(**ptr != ']'){
	    Inc(ptr);
	    *iptr++  = **ptr;
	}
	*iptr = '\0';
	Inc(ptr);
	dimension_size[(*dimensions)++] = atoi(index);
    }
    *tmp = '\0';
}

PrintIt(out,type,itemname,itemtype,indirection,structure,dimensions,dimension_size)
FILE *out;
char *type;
char *itemname;
char *itemtype;
short indirection;
short structure;
short dimensions;
int dimension_size[MAX_DIMENSIONS];
{
short i;
    fprintf(out,"__BZ;");
    if(dimensions == 0){
	fprintf(out,"info.name=\"%s.%s\";info.offset=(int)(&(var.%s))-(int)(&var);\t\t",type,itemname,itemname);
    } else {
	fprintf(out,"info.name=\"%s.%s\";info.offset=(int)((var.%s))-(int)(&var);\t\t",type,itemname,itemname);
    }
    fprintf(out,"info.type=\"%s\";",itemtype);
    if(structure){
	fprintf(out,"info.type_size=sizeof(struct %s);",itemtype);
    } else
	fprintf(out,"info.type_size=sizeof(%s);",itemtype);
    if(indirection > 0){
	fprintf(out,"__IFI(%d);",indirection);
    }
    if(dimensions > 0){
	fprintf(out,"__IND(%d);",dimensions);
	if(dimensions > MAX_DIMENSIONS){
	    fprintf(stderr,"too many array dimensions!!\n");
	}
	for(i=0;i<dimensions;i++){
	    fprintf(out,"__IDS(%d,%d);",i,dimension_size[i]);
	}
    }
    if(strncmp(itemtype,"PF",2) == 0){
	fprintf(out,"__IFT;");
    }
    fprintf(out,"InfoHashPut(&info);strcat(fields,\"%s\");strcat(fields,\"\\n\");\n",itemname);
}

main(argc,argv)
int argc;
char **argv;
{
int nxtarg;
char line[80];
char include[1000];
FILE *outfp;

    if(argc < 3) {
	printf("usage: %s file name [-o file][-I file -I ..]\n",argv[0]);
	exit(0);
    }
    nxtarg=2;
    include[0] = '\0';
    outfp = stdout;
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-I") == 0){
	    sprintf(line,"#include \"%s\"\n",argv[++nxtarg]);
	    strcat(include,line);
	} else
	if(strcmp(argv[nxtarg],"-NI") == 0){
	    no_include = 1;
	} else
	if(strcmp(argv[nxtarg],"-o") == 0){
	    /*
	    ** open the function list file
	    */
	    if((outfp = fopen(argv[++nxtarg],"w")) == NULL){
		fprintf(stderr,"unable to write function list file %s\n",
		argv[nxtarg]);
		return(0);
	    }
	}
    }
    MakeStructCode(argv[1],outfp,argv[2],include);
    exit(0);
}
