extern char *malloc(), *realloc();

# line 2 "script.y"
static char parsercsid[] = "$Id: script.y,v 1.1 1992/12/11 21:19:07 dhb Exp $";

/*
** $Log: script.y,v $
 * Revision 1.1  1992/12/11  21:19:07  dhb
 * Initial revision
 *
*/

#include <stdio.h>
#include <setjmp.h>
#include "parse.h"
#include "symtab.h"


/*
** Parser routines which return something other than int.
*/

extern ParseNode *vardef();
extern char *TokenStr();
extern char *MakeScriptInfo();	/* Actually a generic pointer */

/*
** Parser global variables
*/

extern jmp_buf	BreakBuf;	/* Used to break out of a loop */
extern jmp_buf	ReturnBuf;	/* Used to return out of a script */

static int	DefType;	/* Remembers type in a var decl */
static int	DefCast;	/* Remembers cast in a var decl */
static int	BreakAllowed = 0; /* In a loop control structure */
static int	ReturnIdents = 0; /* 1 ==> lexer doesn't classify IDENTs */
static int	Compiling = 0;	/* Make a statement list rather than execute */
static int	InFunctionDefinition = 0;
static int	NextLocal;	/* Next local symbol offset */
static int	ArgMatch;	/* Matches argument number to name in func */
Symtab		GlobalSymbols;	/* Symbols defined outside a function */
static Symtab	*LocalSymbols = NULL;	/* Symbols local to a function */
static ResultValue RV;			/* Dummy ReturnValue for PTNew */

# define LT 257
# define LE 258
# define GT 259
# define GE 260
# define EQ 261
# define NE 262
# define OR 263
# define AND 264
# define UMINUS 265
# define WHILE 266
# define IF 267
# define ELSE 268
# define FOR 269
# define FOREACH 270
# define END 271
# define INCLUDE 272
# define ENDSCRIPT 273
# define BREAK 274
# define INT 275
# define FLOAT 276
# define STR 277
# define RETURN 278
# define WHITESPACE 279
# define FUNCTION 280
# define INTCONST 281
# define DOLLARARG 282
# define FLOATCONST 283
# define STRCONST 284
# define LITERAL 285
# define IDENT 286
# define VARREF 287
# define FUNCREF 288
# define EXTERN 289
# define SL 290
# define COMMAND 291
# define ARGUMENT 292
# define ARGLIST 293
# define LOCREF 294
# define ICAST 295
# define FCAST 296
# define SCAST 297

# line 75 "script.y"
/*
** Start of lexical analyzer.  LEX source is in "script.l".
*/

extern YYSTYPE	yylval;

#include "lex.yy.c"
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1012 "script.y"


/*
** TokenStr
**
**	Return the token string for the given token.
*/

char *TokenStr(token)

int	token;

{	/* TokenStr --- Return token string for token */

	static char	buf[100];

	switch (token)
	  {

	  case LT: return("<");
	  case LE: return("<=");
	  case GT: return(">");
	  case GE: return(">=");
	  case EQ: return("==");
	  case NE: return("!=");

	  case OR: return("||");
	  case AND: return("&&");

#define	RET(tok)	case tok: return("tok")

	  RET(UMINUS);

	  RET(WHILE);
	  RET(IF);
	  RET(ELSE);
	  RET(FOR);
	  RET(FOREACH);
	  RET(END);
	  RET(INCLUDE);
	  RET(BREAK);
	  RET(INT);
	  RET(FLOAT);
	  RET(STR);
	  RET(RETURN);
	  RET(WHITESPACE);
	  RET(FUNCTION);
	  RET(INTCONST);
	  RET(DOLLARARG);
	  RET(FLOATCONST);
	  RET(STRCONST);
	  RET(LITERAL);
	  RET(IDENT);
	  RET(VARREF);
	  RET(FUNCREF);
	  RET(SL);
	  RET(COMMAND);
	  RET(ARGUMENT);
	  RET(ARGLIST);
	  RET(LOCREF);
	  RET(ICAST);
	  RET(FCAST);
	  RET(SCAST);

	  }

	if (token < 128)
	    if (token < ' ')
		sprintf(buf, "^%c", token+'@');
	    else
		sprintf(buf, "%c", token);
	else
	    sprintf(buf, "%d", token);

	return(buf);

}	/* TokenStr */



#ifdef COMMENT
Result *vardef(ident, type)

char	*ident;
int	type;

{	/* vardef --- Define a variable */

	Result	*rp, r;
	Symtab	*symtab;

	if (InFunctionDefinition && LocalSymbols != NULL)
	  {
	    rp = SymtabNew(LocalSymbols, ident);
	    if (rp->r_type == 0)
	      {
	        rp->r_type = LOCREF;
		rp->r.r_loc.l_type = type;
		rp->r.r_loc.l_offs = NextLocal++;
	      }
	  }
	else
	  {
	    rp = SymtabNew(&GlobalSymbols, ident);
	    switch(type)
	      {

	      case INT:
	        if (rp->r_type == 0)
	            rp->r.r_int = 0;
	        else
		    CastToInt(rp);
	        break;

	      case FLOAT:
	        if (rp->r_type == 0)
	            rp->r.r_float = 0.0;
	        else
		    CastToFloat(rp);
	        break;

	      case STR:
	        if (rp->r_type == 0)
	            rp->r.r_str = strsave("");
	        else
		    CastToStr(rp);
	        break;

	      }

	    rp->r_type = type;
	  }

	return(rp);

}	/* vardef */
#endif



ParseNode *vardef(ident, type, castop, init)

char		*ident;
int		type;
int		castop;
ParseNode	*init;

{	/* vardef --- Define a variable */

	ParseNode	*pn;
	Result		*rp, r;
	ResultValue	v, slv;

	if (InFunctionDefinition && LocalSymbols != NULL)
	  {
	    rp = SymtabNew(LocalSymbols, ident);
	    if (rp->r_type == 0)
	      {
	        rp->r_type = LOCREF;
		rp->r.r_loc.l_type = type;
		rp->r.r_loc.l_offs = NextLocal++;
	      }

	    v.r_str = (char *) rp;
	    pn = PTNew(castop, v, NULL, NULL);
	    if (init)
	      {
		slv.r_str = (char *) MakeScriptInfo();
		pn = PTNew(SL, slv, pn, PTNew('=', v, init, NULL));
	      }
	  }
	else
	  {
	    rp = SymtabNew(&GlobalSymbols, ident);
	    switch(type)
	      {

	      case INT:
	        if (rp->r_type == 0)
	            rp->r.r_int = 0;
	        else
		    CastToInt(rp);
	        break;

	      case FLOAT:
	        if (rp->r_type == 0)
	            rp->r.r_float = 0.0;
	        else
		    CastToFloat(rp);
	        break;

	      case STR:
	        if (rp->r_type == 0)
	            rp->r.r_str = (char *) strsave("");
	        else
		    CastToStr(rp);
	        break;

	      }

	    rp->r_type = type;
	    v.r_str = (char *) rp;
	    if (init)
	        pn = PTNew('=', v, init, NULL);
	    else
	        pn = NULL;
	  }

	return(pn);

}	/* vardef */


ParseInit()

{    /* ParseInit --- Initialize parser variables */

        InFunctionDefinition = 0;
	Compiling = 0;
	BreakAllowed = 0;
	LocalSymbols = NULL;
	nextchar(1);	/* Flush lexer input */
	PTInit();	/* Reinit parse tree evaluation */

}    /* ParseInit */


int NestedLevel()

{    /* NestedLevel --- Return TRUE if in func_def or control structure */

        return(InFunctionDefinition || Compiling);

}    /* NestedLevel */
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 3,
-1, 134,
	10, 61,
	59, 61,
	41, 61,
	-2, 56,
-1, 156,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 109,
-1, 157,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 110,
-1, 158,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 111,
-1, 159,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 112,
-1, 160,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 113,
-1, 161,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 114,
-1, 187,
	271, 32,
	-2, 3,
-1, 209,
	271, 33,
	-2, 3,
	};
# define YYNPROD 130
# define YYLAST 471
int yyact[]={

    20,    23,   131,    21,    22,    24,    34,    26,    32,    38,
    39,    40,    33,    75,    37,    76,    55,    63,    56,   131,
    35,    24,    36,    30,    72,    46,   194,    59,   142,    62,
   120,    49,   101,    95,    87,   134,   118,    99,    97,   137,
    98,    82,   100,   221,   220,   208,   197,   193,   201,   127,
   135,   125,    85,    86,   185,   101,    95,    58,     2,   165,
    99,    97,   210,    98,   145,   100,   101,    95,    48,    42,
   122,    99,    97,    84,    98,   101,   100,   191,   101,    95,
    99,    92,   124,    99,    97,   100,    98,   217,   100,    96,
   101,    95,   216,   215,   121,    99,    97,    83,    98,     9,
   100,   206,   114,   101,    95,    88,   213,    71,    99,    97,
    61,    98,    96,   100,   113,    91,   101,    95,    43,    94,
    79,    99,    97,    96,    98,   192,   100,    89,   191,   190,
   178,    52,   191,   179,    51,    96,    47,    45,   133,   138,
    44,   163,    94,   133,   212,    78,   162,    96,    93,   136,
   143,    31,   140,    94,   164,    54,   202,   173,   137,    53,
    96,   130,    50,   129,   128,    94,    74,    73,   169,   207,
   123,   117,   214,    96,   166,    41,   172,    94,   130,   171,
   129,   128,   132,     3,   119,    25,   172,   139,   175,    27,
    94,   176,    28,    15,    11,    57,    17,    13,    10,   177,
    29,   180,   141,    94,    90,    19,    18,   144,    16,    14,
    12,   200,     8,     7,     6,   182,   183,     5,     4,     1,
   186,   168,     0,   170,   172,   184,     0,     0,   187,     0,
     0,     0,   126,   195,   196,     0,     0,     0,   172,     0,
   171,     0,     0,     0,   203,     0,     0,     0,   204,   205,
     0,     0,   104,   105,   106,   107,   108,   109,   102,   103,
   209,   172,     0,     0,     0,    68,    70,    67,    69,     0,
    64,    66,    65,   218,   219,   104,   105,   106,   107,   108,
   109,   102,   103,   174,   199,   198,   104,   105,   106,   107,
   108,   109,   102,   103,     0,     0,    60,     0,   104,   105,
   106,   107,   108,   109,   102,   103,     0,     0,     0,     0,
   104,   105,   106,   107,   108,   109,   102,   103,   126,     0,
     0,   188,     0,   104,   105,   106,   107,   108,   109,   102,
   103,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    77,   102,   103,    80,    81,     0,     0,     0,     0,
     0,     0,     0,   211,     0,     0,   101,    95,   110,   111,
   112,    99,    97,     0,    98,     0,   100,     0,   115,   116,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   146,   147,   148,   149,   150,   151,   152,   153,   154,
   155,   156,   157,   158,   159,   160,   161,     0,     0,     0,
     0,     0,     0,    96,     0,     0,     0,     0,     0,   167,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   181,    94,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   189 };
int yypact[]={

 -1000, -1000, -1000,  -266,    59, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
   100,    97,  -262,    96,     7,  -254, -1000,    94,    91, -1000,
  -270,  -259, -1000,   -16, -1000, -1000, -1000,  -273, -1000, -1000,
 -1000, -1000, -1000, -1000,   -16,  -282,    80,   -16,   -16,  -238,
 -1000,  -245,  -245, -1000,    75, -1000, -1000,    37, -1000, -1000,
    66,   -16,   -16,   -16,    74,    62, -1000, -1000, -1000, -1000,
 -1000,   -16,   -16,  -243,  -255, -1000, -1000,    53,    11, -1000,
    41,    66,  -104, -1000,  -244,  -104,  -240, -1000,  -104,  -244,
 -1000,  -258, -1000,     3,   -16,   -16,   -16,   -16,   -16,   -16,
   -16,   -16,   -16,   -16,   -16,   -16,   -16,   -16,   -16,   -16,
 -1000, -1000,    79, -1000, -1000,    29,    18, -1000, -1000, -1000,
 -1000, -1000,   -16,  -243, -1000,  -244,  -104, -1000, -1000, -1000,
 -1000, -1000, -1000,  -121, -1000,  -245,  -104, -1000,  -245, -1000,
 -1000,    89, -1000,  -259, -1000,   -16,    38,    38,    38,    38,
    38, -1000, -1000, -1000,   319,   319,    79,    79,    79,    79,
    79,    79,  -245,  -245, -1000, -1000, -1000,    -5,  -104, -1000,
 -1000,  -121, -1000,   -16,  -104,    88,    84,  -224, -1000,  -260,
 -1000,    66,  -104,  -104,  -225,  -282,  -244,  -220,  -104,    66,
 -1000,  -245, -1000, -1000, -1000,  -245,  -245, -1000,    60, -1000,
  -226, -1000,   -63,  -104,    33,    33, -1000,    52, -1000, -1000,
 -1000,  -104,    51,    46, -1000, -1000, -1000, -1000,  -227,  -228,
 -1000, -1000 };
int yypgo[]={

     0,   219,   218,    58,   217,   214,   213,   212,   211,    99,
   210,    51,    50,   149,    49,   209,   208,   207,   206,   205,
   296,   204,   202,   200,   198,   197,   196,    57,   195,    73,
   194,   193,   192,   189,   185,   184,   183,   175,   174,   172,
   170,    97,   169,   168,   167,   166,   162,    52,   159,    53,
   157,   156,   155,   152,   151,   150,   148,   146,   144,   141,
   106 };
int yyr1[]={

     0,     1,     3,    36,     3,    37,    37,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    30,    38,     4,    39,     5,    40,    42,     6,
    43,     7,     8,     8,     9,    44,    34,    24,    24,    35,
    35,    45,    33,    46,    10,    10,    32,    25,    48,    25,
    29,    29,    11,    11,    47,    47,    49,    49,    12,    12,
    41,    41,    13,    13,    14,    14,    14,    50,    51,    14,
    31,    31,    23,    23,    52,    53,    15,    21,    21,    22,
    22,    54,    54,    54,    16,    28,    55,    28,    56,    27,
    17,    17,    26,    18,    18,    19,    20,    20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    20,    20,    20,    20,    57,    58,    20,    59,    60,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20 };
int yyr2[]={

     0,     2,     1,     1,     9,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     3,     1,    15,     1,    23,     1,     1,    23,
     1,    17,     1,     5,     7,     1,     7,    11,     7,     1,
     3,     1,     7,     1,     9,    13,     3,    13,     1,     9,
     1,     7,     3,     7,     0,     2,     2,     4,     3,    11,
     0,     2,     3,     5,     3,     3,     3,     1,     1,    11,
     5,     5,     5,     5,     1,     1,    13,     1,     7,     3,
     7,     3,     3,     3,     5,     2,     1,     9,     1,     7,
     1,     5,     3,     5,     3,     1,     7,     7,     7,     5,
     7,     7,     7,     7,     7,     5,     7,     7,     5,     7,
     7,     7,     7,     7,     7,     1,     1,    17,     1,     1,
    17,     3,     3,     3,     3,     3,     3,     3,     7,     7 };
int yychk[]={

 -1000,    -1,    -3,   -36,    -2,    -4,    -5,    -6,    -7,    -9,
   -24,   -30,   -10,   -25,   -15,   -31,   -16,   -26,   -18,   -19,
   266,   269,   270,   267,   287,   -34,   273,   -33,   -32,   -23,
   289,   -54,   274,   278,   272,   286,   288,   280,   275,   276,
   277,   -37,    10,    59,    40,    40,   287,    40,    61,   285,
   -46,    40,    40,   -48,   -52,   286,   288,   -28,   -27,   286,
   -20,   126,    45,    33,   286,   288,   287,   283,   281,   284,
   282,   123,    40,   -44,   -45,   286,   288,   -20,    -9,    40,
   -20,   -20,   279,   -41,   -29,   -47,   -49,   279,   -47,   -29,
   -21,    40,    44,   -56,   124,    38,    94,    43,    45,    42,
    47,    37,   263,   264,   257,   258,   259,   260,   261,   262,
   -20,   -20,   -20,    40,    40,   -20,   -20,   -41,   279,   -35,
   285,    41,    59,   -40,    41,   -11,   -13,   -14,   285,   284,
   282,   123,   -41,   -49,   279,   -12,   -13,   279,   -12,   -41,
   -53,   -22,   286,   -55,   -17,    61,   -20,   -20,   -20,   -20,
   -20,   -20,   -20,   -20,   -20,   -20,   -20,   -20,   -20,   -20,
   -20,   -20,   -57,   -59,   125,    41,   -38,   -20,   -41,   -43,
   -41,   -49,   -14,   -50,   -13,   -47,   -47,    -3,    41,    44,
   -27,   -20,   -47,   -47,    -3,    59,   -11,    -3,   -13,   -20,
    41,    44,    41,   271,   286,   -12,   -12,   271,    -9,   -41,
    -8,   268,   -51,   -47,   -47,   -47,    41,   -42,   271,    -3,
   125,   -13,   -58,   -60,   -39,    41,    41,    41,    -3,    -3,
   271,   271 };
int yydef[]={

     2,    -2,    -2,    95,     0,     7,     8,     9,    10,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
     0,     0,     0,     0,     0,     0,    22,    43,    48,    74,
     0,     0,    92,    94,    35,    41,    46,     0,    81,    82,
    83,     4,     5,     6,     0,     0,     0,     0,     0,    60,
    50,    54,    54,    50,    77,    70,    71,    84,    85,    88,
    93,     0,     0,     0,   123,   122,   121,   124,   125,   126,
   127,     0,     0,    60,    39,    72,    73,     0,     0,    27,
     0,    34,    61,    38,    60,     0,    55,    56,     0,    60,
    75,     0,    86,    90,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    99,   105,   108,   115,   118,     0,     0,    36,    61,    42,
    40,    23,     0,    60,    30,    60,    52,    62,    64,    65,
    66,    67,    44,     0,    -2,    54,    58,    57,    54,    49,
     2,     0,    79,     0,    89,     0,    96,    97,    98,   100,
   101,   102,   103,   104,   106,   107,    -2,    -2,    -2,    -2,
    -2,    -2,    54,    54,   128,   129,     2,     0,     0,     2,
    37,     0,    63,     0,    51,     0,     0,     3,    78,     0,
    87,    91,     0,     0,     3,     0,    60,    -2,    53,    68,
    45,    54,    47,    76,    80,    54,    54,    24,     0,    28,
     0,     2,     0,     0,   116,   119,    25,     0,    31,    -2,
    69,    59,     0,     0,     2,     2,   117,   120,     3,     3,
    26,    29 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"LT",	257,
	"LE",	258,
	"GT",	259,
	"GE",	260,
	"EQ",	261,
	"NE",	262,
	"!",	33,
	"OR",	263,
	"AND",	264,
	"+",	43,
	"-",	45,
	"&",	38,
	"|",	124,
	"^",	94,
	"*",	42,
	"/",	47,
	"%",	37,
	"~",	126,
	"UMINUS",	265,
	"WHILE",	266,
	"IF",	267,
	"ELSE",	268,
	"FOR",	269,
	"FOREACH",	270,
	"END",	271,
	"INCLUDE",	272,
	"ENDSCRIPT",	273,
	"BREAK",	274,
	"INT",	275,
	"FLOAT",	276,
	"STR",	277,
	"RETURN",	278,
	"WHITESPACE",	279,
	"FUNCTION",	280,
	"INTCONST",	281,
	"DOLLARARG",	282,
	"FLOATCONST",	283,
	"STRCONST",	284,
	"LITERAL",	285,
	"IDENT",	286,
	"VARREF",	287,
	"FUNCREF",	288,
	"EXTERN",	289,
	"SL",	290,
	"COMMAND",	291,
	"ARGUMENT",	292,
	"ARGLIST",	293,
	"LOCREF",	294,
	"ICAST",	295,
	"FCAST",	296,
	"SCAST",	297,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"script : statement_list",
	"statement_list : /* empty */",
	"statement_list : statement_list",
	"statement_list : statement_list statement stmnt_terminator",
	"stmnt_terminator : '\n'",
	"stmnt_terminator : ';'",
	"statement : while_stmnt",
	"statement : for_stmnt",
	"statement : foreach_stmnt",
	"statement : if_stmnt",
	"statement : assign_stmnt",
	"statement : include_stmnt",
	"statement : endscript_marker",
	"statement : cmd_stmnt",
	"statement : func_call",
	"statement : func_def",
	"statement : ext_func",
	"statement : decl_stmnt",
	"statement : break_stmnt",
	"statement : return_stmnt",
	"statement : null_stmnt",
	"endscript_marker : ENDSCRIPT",
	"while_stmnt : WHILE '(' expr ')'",
	"while_stmnt : WHILE '(' expr ')' statement_list END",
	"for_stmnt : FOR '(' assign_stmnt ';' expr ';' assign_stmnt ')'",
	"for_stmnt : FOR '(' assign_stmnt ';' expr ';' assign_stmnt ')' statement_list END",
	"foreach_stmnt : FOREACH VARREF '('",
	"foreach_stmnt : FOREACH VARREF '(' ws arg_list ws",
	"foreach_stmnt : FOREACH VARREF '(' ws arg_list ws ')' statement_list END",
	"if_stmnt : IF '(' expr ')'",
	"if_stmnt : IF '(' expr ')' statement_list else_clause END",
	"else_clause : /* empty */",
	"else_clause : ELSE statement_list",
	"assign_stmnt : VARREF '=' expr",
	"include_hdr : INCLUDE",
	"include_hdr : INCLUDE ws",
	"include_stmnt : include_hdr LITERAL WHITESPACE arg_list ws",
	"include_stmnt : include_hdr LITERAL ws",
	"opt_node : /* empty */",
	"opt_node : LITERAL",
	"cmd_name : IDENT",
	"cmd_name : IDENT opt_node",
	"cmd_stmnt : cmd_name",
	"cmd_stmnt : cmd_name opt_arg_list ws",
	"cmd_stmnt : cmd_name '(' optwslist func_call_list optwslist ')'",
	"funcref : FUNCREF",
	"func_call : funcref '(' optwslist func_call_list optwslist ')'",
	"func_call : funcref",
	"func_call : funcref opt_arg_list ws",
	"opt_arg_list : /* empty */",
	"opt_arg_list : opt_arg_list wslist arg_component_list",
	"arg_list : arg_component_list",
	"arg_list : arg_list wslist arg_component_list",
	"optwslist : /* empty */",
	"optwslist : wslist",
	"wslist : WHITESPACE",
	"wslist : wslist WHITESPACE",
	"func_call_list : arg_component_list",
	"func_call_list : func_call_list optwslist ',' optwslist arg_component_list",
	"ws : /* empty */",
	"ws : WHITESPACE",
	"arg_component_list : arg_component",
	"arg_component_list : arg_component_list arg_component",
	"arg_component : LITERAL",
	"arg_component : STRCONST",
	"arg_component : DOLLARARG",
	"arg_component : '{'",
	"arg_component : '{' expr",
	"arg_component : '{' expr '}'",
	"ext_func : EXTERN IDENT",
	"ext_func : EXTERN FUNCREF",
	"func_hdr : FUNCTION IDENT",
	"func_hdr : FUNCTION FUNCREF",
	"func_def : func_hdr",
	"func_def : func_hdr func_args",
	"func_def : func_hdr func_args statement_list END",
	"func_args : /* empty */",
	"func_args : '(' func_arg_list ')'",
	"func_arg_list : IDENT",
	"func_arg_list : func_arg_list ',' IDENT",
	"decl_type : INT",
	"decl_type : FLOAT",
	"decl_type : STR",
	"decl_stmnt : decl_type decl_list",
	"decl_list : decl_ident",
	"decl_list : decl_list ','",
	"decl_list : decl_list ',' decl_ident",
	"decl_ident : IDENT",
	"decl_ident : IDENT init",
	"init : /* empty */",
	"init : '=' expr",
	"break_stmnt : BREAK",
	"return_stmnt : RETURN expr",
	"return_stmnt : RETURN",
	"null_stmnt : /* empty */",
	"expr : expr '|' expr",
	"expr : expr '&' expr",
	"expr : expr '^' expr",
	"expr : '~' expr",
	"expr : expr '+' expr",
	"expr : expr '-' expr",
	"expr : expr '*' expr",
	"expr : expr '/' expr",
	"expr : expr '%' expr",
	"expr : '-' expr",
	"expr : expr OR expr",
	"expr : expr AND expr",
	"expr : '!' expr",
	"expr : expr LT expr",
	"expr : expr LE expr",
	"expr : expr GT expr",
	"expr : expr GE expr",
	"expr : expr EQ expr",
	"expr : expr NE expr",
	"expr : IDENT '('",
	"expr : IDENT '(' optwslist func_call_list optwslist",
	"expr : IDENT '(' optwslist func_call_list optwslist ')'",
	"expr : FUNCREF '('",
	"expr : FUNCREF '(' optwslist func_call_list optwslist",
	"expr : FUNCREF '(' optwslist func_call_list optwslist ')'",
	"expr : VARREF",
	"expr : FUNCREF",
	"expr : IDENT",
	"expr : FLOATCONST",
	"expr : INTCONST",
	"expr : STRCONST",
	"expr : DOLLARARG",
	"expr : '{' expr '}'",
	"expr : '(' expr ')'",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 2:
# line 90 "script.y"
{ 
		    yyval.pn = NULL;
 		  } break;
case 3:
# line 94 "script.y"
{
		    yyval.str = (char *) MakeScriptInfo();
		    SetLine(yyval.str);
		  } break;
case 4:
# line 99 "script.y"
{
		    ResultValue	v;

		    if (InFunctionDefinition || Compiling)
			if (yypvt[-1].pn != NULL)
			  {
			    v.r_str = yypvt[-2].str;
			    yyval.pn = PTNew(SL, v, yypvt[-3].pn, yypvt[-1].pn);
			  }
			else
			    yyval.pn = yypvt[-3].pn;
		    else
		      {
		        /* execute statement */
			if (setjmp(BreakBuf) == 0)
			    if (setjmp(ReturnBuf) == 0)
				PTEval(yypvt[-1].pn);
			    else
				EndScript();
			PTFree(yypvt[-1].pn);
		      }
		  } break;
case 22:
# line 145 "script.y"
{
		    /*
		    ** When the end of a script is encountered, the simulator
		    ** sgets routine returns NULL.  The nextchar routine in the
		    ** lexer returns a special character '\200' which is lexed
		    ** as ENDSCRIPT.  We need this when we include a script
		    ** in a function or control structure so that the script
		    ** local variable storage is allocated and deallocated.
		    */

		    if (Compiling || InFunctionDefinition)
		      {
			yyval.pn = PTNew(ENDSCRIPT, RV, NULL, NULL);
		      }
		    else
			yyval.pn = NULL;
		  } break;
case 23:
# line 165 "script.y"
{
		    Compiling++;
		    BreakAllowed++;
		    yyval.str = (char *) MakeScriptInfo();
		  } break;
case 24:
# line 171 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-2].str;
		    yyval.pn = PTNew(WHILE, v, yypvt[-4].pn, yypvt[-1].pn);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 25:
# line 182 "script.y"
{
		      Compiling++;
		      BreakAllowed++;
		      yyval.str = (char *) MakeScriptInfo();
		    } break;
case 26:
# line 189 "script.y"
{
		    ResultValue	v;
		    ParseNode	*forbody, *whilepart;

		    v.r_str = (char *) MakeScriptInfo();
		    forbody = PTNew(SL, v, yypvt[-1].pn, yypvt[-4].pn);
		    v.r_str = yypvt[-2].str;
		    whilepart = PTNew(WHILE, v, yypvt[-6].pn, forbody);
		    yyval.pn = PTNew(SL, v, yypvt[-8].pn, whilepart);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 27:
# line 204 "script.y"
{
			BEGIN FUNCLIT;
			Compiling++;
			BreakAllowed++;
		    } break;
case 28:
# line 210 "script.y"
{
			BEGIN 0;
		    } break;
case 29:
# line 214 "script.y"
{
		    Result	*rp;
		    ResultValue	v;
		    char        buf[100];

		    rp = (Result *) yypvt[-9].str;
		      {
			if ((rp->r_type != STR && rp->r_type != LOCREF) ||
			    (rp->r_type == LOCREF && rp->r.r_loc.l_type != STR))
			  {
			   yyerror("Variable in FOREACH not a string variable");
			    /* No Return */
			  }
		      }

		    v.r_str = (char *) rp;
		    yyval.pn = PTNew(FOREACH, v, yypvt[-5].pn, yypvt[-1].pn);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 30:
# line 237 "script.y"
{
		    Compiling++;
		    yyval.str = (char *) MakeScriptInfo();
		  } break;
case 31:
# line 242 "script.y"
{
		    ResultValue	v;
		    ParseNode	*stmntlists;

		    stmntlists = PTNew(0, v, yypvt[-2].pn, yypvt[-1].pn);
		    v.r_str = yypvt[-3].str;
		    yyval.pn = PTNew(IF, v, yypvt[-5].pn, stmntlists);
		    Compiling--;
		  } break;
case 32:
# line 254 "script.y"
{
 		    yyval.pn = NULL;
 		  } break;
case 33:
# line 258 "script.y"
{ yyval.pn = yypvt[-0].pn; } break;
case 34:
# line 262 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    char        buf[100];

		    yyval.pn = NULL;
		    rp = (Result *) yypvt[-2].str;
			  {
			    v.r_str = (char *) rp;
		            yyval.pn = PTNew('=', v, yypvt[-0].pn, NULL);
			  }
		  } break;
case 35:
# line 277 "script.y"
{
		    Pushyybgin(LIT);
		  } break;
case 36:
# line 281 "script.y"
{
		    yyval.str = NULL;
		  } break;
case 37:
# line 287 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    sprintf(argbuf, "%s", yypvt[-3].str);
		    argc = 1;
		    argv[0] = argbuf;
		    do_cmd_args(yypvt[-1].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
		    argv[argc] = NULL;

		    if (!IncludeScript(argc, argv))
		      {
			sprintf(argbuf, "Script '%s' not found", yypvt[-3].str);
			PTFree(yypvt[-1].pn);
			free(yypvt[-3].str);
			yyerror(argbuf);
		      }

		    if (Compiling || InFunctionDefinition)
		      {
			v.r_str = yypvt[-3].str;
			yyval.pn = PTNew(INCLUDE, v, yypvt[-1].pn, NULL);
		      }
		    else
		      {
			PTFree(yypvt[-1].pn);
			free(yypvt[-3].str);
			yyval.pn = NULL;
		      }
		  } break;
case 38:
# line 324 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    sprintf(argbuf, "%s", yypvt[-1].str);
		    argc = 1;
		    argv[0] = argbuf;
		    argv[argc] = NULL;

		    if (!IncludeScript(argc, argv))
		      {
			sprintf(argbuf, "Script '%s' not found", yypvt[-1].str);
			free(yypvt[-1].str);
			yyerror(argbuf);
		      }

		    if (Compiling || InFunctionDefinition)
		      {
			v.r_str = yypvt[-1].str;
			yyval.pn = PTNew(INCLUDE, v, NULL, NULL);
		      }
		    else
		      {
			free(yypvt[-1].str);
			yyval.pn = NULL;
		      }
		  } break;
case 39:
# line 360 "script.y"
{
		    yyval.str = (char*) strsave("");
		  } break;
case 40:
# line 364 "script.y"
{
		    yyval.str = yypvt[-0].str;
		  } break;
case 41:
# line 370 "script.y"
{
		    Pushyybgin(FUNCLIT);
		  } break;
case 42:
# line 374 "script.y"
{
		    char	cmd[200];

		    sprintf(cmd, "%s%s", yypvt[-2].str, yypvt[-0].str);
		    free(yypvt[-2].str);
		    free(yypvt[-0].str);
		    yyval.str = (char*) strsave(cmd);
		  } break;
case 43:
# line 385 "script.y"
{
		    BEGIN LIT;
		  } break;
case 44:
# line 389 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    if (!IsCommand(yypvt[-3].str))
		      {
			if (!IsInclude(yypvt[-3].str))
			  {
			    v.r_str = yypvt[-3].str;
			    yyval.pn = PTNew(COMMAND, v, yypvt[-1].pn, NULL);
			  }
			else
			  {
			    sprintf(argbuf, "%s", yypvt[-3].str);
			    argc = 1;
			    argv[0] = argbuf;
			    do_cmd_args(yypvt[-1].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
			    argv[argc] = NULL;
			    IncludeScript(argc, argv);

			    if (Compiling || InFunctionDefinition)
			      {
				v.r_str = yypvt[-3].str;
				yyval.pn = PTNew(INCLUDE, v, yypvt[-1].pn, NULL);
			      }
			    else
			      {
				PTFree(yypvt[-1].pn);
				free(yypvt[-3].str);
				yyval.pn = NULL;
			      }
			  }
		      }
		    else
		      {
			v.r_str = yypvt[-3].str;
			yyval.pn = PTNew(COMMAND, v, yypvt[-1].pn, NULL);
		      }
		  } break;
case 45:
# line 435 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    if (!IsCommand(yypvt[-5].str))
		      {
			if (!IsInclude(yypvt[-5].str))
			  {
			    v.r_str = yypvt[-5].str;
			    yyval.pn = PTNew(COMMAND, v, yypvt[-2].pn, NULL);
			  }
			else
			  {
			    sprintf(argbuf, "%s", yypvt[-5].str);
			    argc = 1;
			    argv[0] = argbuf;
			    do_cmd_args(yypvt[-2].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
			    argv[argc] = NULL;
			    IncludeScript(argc, argv);

			    if (Compiling || InFunctionDefinition)
			      {
				v.r_str = yypvt[-5].str;
				yyval.pn = PTNew(INCLUDE, v, yypvt[-2].pn, NULL);
			      }
			    else
			      {
				PTFree(yypvt[-2].pn);
				free(yypvt[-5].str);
				yyval.pn = NULL;
			      }
			  }
		      }
		    else
		      {
			v.r_str = yypvt[-5].str;
			yyval.pn = PTNew(COMMAND, v, yypvt[-2].pn, NULL);
		      }
		  } break;
case 46:
# line 483 "script.y"
{
		    Pushyybgin(FUNCLIT);
		    yyval.str = yypvt[-0].str;
		  } break;
case 47:
# line 490 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    Popyybgin();
		    rp = (Result *) yypvt[-5].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-2].pn, NULL);
		  } break;
case 48:
# line 499 "script.y"
{
		    BEGIN LIT;
		  } break;
case 49:
# line 503 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    Popyybgin();
		    rp = (Result *) yypvt[-3].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-1].pn, NULL);
		  } break;
case 50:
# line 514 "script.y"
{
		    yyval.pn = NULL;
		  } break;
case 51:
# line 518 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-2].pn, yypvt[-0].pn);
		  } break;
case 52:
# line 524 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, NULL, yypvt[-0].pn);
		  } break;
case 53:
# line 528 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-2].pn, yypvt[-0].pn);
		  } break;
case 58:
# line 542 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, NULL, yypvt[-0].pn);
		  } break;
case 59:
# line 546 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-4].pn, yypvt[-0].pn);
		  } break;
case 62:
# line 556 "script.y"
{
			    ResultValue	v;

			    yyval.pn = PTNew(ARGUMENT, v, NULL, yypvt[-0].pn);
			  } break;
case 63:
# line 562 "script.y"
{
			    ResultValue	v;

			    yyval.pn = PTNew(ARGUMENT, v, yypvt[-1].pn, yypvt[-0].pn);
			  } break;
case 64:
# line 570 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(LITERAL, v, NULL, NULL);
		  } break;
case 65:
# line 577 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(LITERAL, v, NULL, NULL);
		  } break;
case 66:
# line 584 "script.y"
{
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(DOLLARARG, v, NULL, NULL);
		  } break;
case 67:
# line 591 "script.y"
{
		    Pushyybgin(0);
		  } break;
case 68:
# line 595 "script.y"
{
		    Popyybgin();
		  } break;
case 69:
# line 599 "script.y"
{
		    if (yypvt[-2].pn->pn_val.r_type == STRCONST)
			yypvt[-2].pn->pn_val.r_type = LITERAL;

		    yyval.pn = yypvt[-2].pn;
		  } break;
case 70:
# line 608 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;

		    rp = SymtabNew(&GlobalSymbols, yypvt[-0].str);
		    if (rp->r_type != 0 && rp->r_type != FUNCTION)
			fprintf(stderr, "WARNING: function name '%s' is redefining a variable!\n", yypvt[-0].str);

		    rp->r_type = FUNCTION;

		    v.r_str = (char *) NULL;
		    funcpn = PTNew(SL, v, NULL, NULL);
		    rp->r.r_str = (char *) funcpn;

		    yyval.pn = NULL;
		  } break;
case 71:
# line 626 "script.y"
{
		    yyval.pn = NULL;
		  } break;
case 72:
# line 632 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;
		    char	*script;

		    if (InFunctionDefinition)
		      {
			fprintf(stderr, "Function definition within another function or\n");
			fprintf(stderr, "within a control structure (FUNCTION %s).\n", yypvt[-0].str);
			yyerror("");
			/* No Return */
		      }

		    InFunctionDefinition++;
		    NextLocal = 0;
		    rp = SymtabNew(&GlobalSymbols, yypvt[-0].str);
		    if (rp->r_type != 0 && rp->r_type != FUNCTION)
			fprintf(stderr, "WARNING: function name '%s' is redefining a variable!\n", yypvt[-0].str);

		    rp->r_type = FUNCTION;

		    LocalSymbols = SymtabCreate();
		    v.r_str = (char *) LocalSymbols;
		    funcpn = PTNew(SL, v, NULL, NULL);
		    rp->r.r_str = (char *) funcpn;

#ifdef COMMENT
		    rp = SymtabNew(LocalSymbols, "*SCRIPT*");
		    script = (char *) CurrentScriptName();
		    if (script == NULL)
			rp->r.r_str = (char *) strsave("<stdin>");
		    else
			rp->r.r_str = (char *) strsave(script);
		    rp = SymtabNew(LocalSymbols, "*FUNCTION*");
		    rp->r.r_str = (char *) strsave(yypvt[-0].str);
#endif
		    yyval.pn = funcpn;
		  } break;
case 73:
# line 672 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;
		    char	*script;

		    rp = (Result *) yypvt[-0].str;
		    if (InFunctionDefinition)
		      {
			fprintf(stderr, "Function definition within another function or\n");
			fprintf(stderr, "within a control structure (FUNCTION %s).\n", yypvt[-0].str);
			yyerror("");
			/* No Return */
		      }

		    /*
		    ** Free old function parse tree and symtab
		    */

		    funcpn = (ParseNode *) rp->r.r_str;
		    if (funcpn->pn_val.r.r_str != NULL)
			SymtabDestroy(funcpn->pn_val.r.r_str);
		    PTFree(funcpn->pn_left);
		    PTFree(funcpn->pn_right);

		    InFunctionDefinition++;
		    NextLocal = 0;
		    LocalSymbols = SymtabCreate();
		    funcpn->pn_val.r.r_str = (char *) LocalSymbols;

#ifdef COMMENT
		    rp = SymtabNew(LocalSymbols, "*SCRIPT*");
		    script = (char *) CurrentScriptName();
		    if (script == NULL)
			rp->r.r_str = (char *) strsave("<stdin>");
		    else
			rp->r.r_str = (char *) strsave(script);
		    rp = SymtabNew(LocalSymbols, "*FUNCTION*");
		    rp->r.r_str =(char *)strsave(SymtabKey(&GlobalSymbols, yypvt[-0].str));
#endif

		    yyval.pn = funcpn;
		  } break;
case 74:
# line 718 "script.y"
{
		    ReturnIdents = 1;
		  } break;
case 75:
# line 722 "script.y"
{
		    ReturnIdents = 0;
		  } break;
case 76:
# line 726 "script.y"
{
		    InFunctionDefinition--;

		    yypvt[-5].pn->pn_left = yypvt[-3].pn;
		    yypvt[-5].pn->pn_right = yypvt[-1].pn;

		    LocalSymbols = NULL;
		    yyval.pn = NULL;
		  } break;
case 77:
# line 738 "script.y"
{ yyval.pn = NULL; } break;
case 78:
# line 740 "script.y"
{ yyval.pn = yypvt[-1].pn; } break;
case 79:
# line 744 "script.y"
{
		    ResultValue	v;
		    ParseNode	*init;

		    ArgMatch = 1;
		    v.r_int = ArgMatch++;
		    init = PTNew(DOLLARARG, v, NULL, NULL);
		    yyval.pn = vardef(yypvt[-0].str, STR, SCAST, init);
		  } break;
case 80:
# line 754 "script.y"
{
		    ResultValue	v;
		    ParseNode	*init;

		    v.r_int = ArgMatch++;
		    init = PTNew(DOLLARARG, v, NULL, NULL);
		    v.r_str = (char *) MakeScriptInfo();
		    yyval.pn = PTNew(SL, v, yypvt[-2].pn, vardef(yypvt[-0].str, STR, SCAST, init));
		  } break;
case 81:
# line 766 "script.y"
{
		    ReturnIdents = 1;
		    DefType = INT;
		    DefCast = ICAST;
		  } break;
case 82:
# line 772 "script.y"
{
		    ReturnIdents = 1;
		    DefType = FLOAT;
		    DefCast = FCAST;
		  } break;
case 83:
# line 778 "script.y"
{
		    ReturnIdents = 1;
		    DefType = STR;
		    DefCast = SCAST;
		  } break;
case 84:
# line 786 "script.y"
{
		    yyval.pn = yypvt[-0].pn;
		  } break;
case 86:
# line 793 "script.y"
{
		    ReturnIdents = 1;
		  } break;
case 87:
# line 797 "script.y"
{
		    ResultValue	v;

		    v.r_str = (char *) MakeScriptInfo();
		    yyval.pn = PTNew(SL, v, yypvt[-3].pn, yypvt[-0].pn);
		  } break;
case 88:
# line 806 "script.y"
{
		    ReturnIdents = 0;
		  } break;
case 89:
# line 810 "script.y"
{
		    yyval.pn = vardef(yypvt[-2].str, DefType, DefCast, yypvt[-0].pn);
		  } break;
case 90:
# line 816 "script.y"
{ yyval.pn = NULL; } break;
case 91:
# line 818 "script.y"
{ yyval.pn = yypvt[-0].pn; } break;
case 92:
# line 822 "script.y"
{
		    ResultValue	v;

		    if (BreakAllowed)
			yyval.pn = PTNew(BREAK, v, NULL, NULL);
		    else
			yyerror("BREAK found outside of a loop");
			/* No Return */
		  } break;
case 93:
# line 834 "script.y"
{
		    ResultValue	v;

		    yyval.pn = PTNew(RETURN, v, yypvt[-0].pn, NULL);
		  } break;
case 94:
# line 840 "script.y"
{
		    ResultValue	v;

		    yyval.pn = PTNew(RETURN, v, NULL, NULL);
		  } break;
case 95:
# line 848 "script.y"
{ yyval.pn = NULL; } break;
case 96:
# line 852 "script.y"
{ yyval.pn = PTNew('|', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 97:
# line 854 "script.y"
{ yyval.pn = PTNew('&', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 98:
# line 856 "script.y"
{ yyval.pn = PTNew('^', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 99:
# line 858 "script.y"
{ yyval.pn = PTNew('~', RV, yypvt[-0].pn, NULL); } break;
case 100:
# line 861 "script.y"
{ yyval.pn = PTNew('+', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 101:
# line 863 "script.y"
{ yyval.pn = PTNew('-', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 102:
# line 865 "script.y"
{ yyval.pn = PTNew('*', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 103:
# line 867 "script.y"
{ yyval.pn = PTNew('/', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 104:
# line 869 "script.y"
{ yyval.pn = PTNew('%', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 105:
# line 871 "script.y"
{ yyval.pn = PTNew(UMINUS, RV, yypvt[-0].pn, NULL); } break;
case 106:
# line 874 "script.y"
{ yyval.pn = PTNew(OR, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 107:
# line 876 "script.y"
{ yyval.pn = PTNew(AND, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 108:
# line 878 "script.y"
{ yyval.pn = PTNew('!', RV, yypvt[-0].pn, NULL); } break;
case 109:
# line 881 "script.y"
{ yyval.pn = PTNew(LT, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 110:
# line 883 "script.y"
{ yyval.pn = PTNew(LE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 111:
# line 885 "script.y"
{ yyval.pn = PTNew(GT, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 112:
# line 887 "script.y"
{ yyval.pn = PTNew(GE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 113:
# line 889 "script.y"
{ yyval.pn = PTNew(EQ, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 114:
# line 891 "script.y"
{ yyval.pn = PTNew(NE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 115:
# line 894 "script.y"
{
			BEGIN FUNCLIT;
		    } break;
case 116:
# line 898 "script.y"
{
			BEGIN 0;
		    } break;
case 117:
# line 902 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    v.r_str = yypvt[-7].str;
		    yyval.pn = PTNew(COMMAND, v, yypvt[-3].pn, NULL);
		  } break;
case 118:
# line 911 "script.y"
{
			BEGIN FUNCLIT;
		    } break;
case 119:
# line 915 "script.y"
{
			BEGIN 0;
		    } break;
case 120:
# line 919 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    rp = (Result *) yypvt[-7].str;
		    if (rp != NULL && rp->r_type == FUNCTION)
		        yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-3].pn, NULL);
		  } break;
case 121:
# line 929 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Variable reference
		    */

		    rp = (Result *) yypvt[-0].str;
		      {
			if (rp->r_type == FUNCTION || rp->r_type == LOCREF)
			    v = rp->r;
			else /* Global Variable */
			    v.r_str = (char *) rp;

		        yyval.pn = PTNew(rp->r_type, v, NULL, NULL);
		      }
 		  } break;
case 122:
# line 949 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Function call
		    */

		    rp = (Result *) yypvt[-0].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, NULL, NULL);
 		  } break;
case 123:
# line 962 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Command
		    */

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(COMMAND, v, NULL, NULL);
 		  } break;
case 124:
# line 975 "script.y"
{ 
		    ResultValue	v;

		    v.r_float = yypvt[-0].fconst;
		    yyval.pn = PTNew(FLOATCONST, v, NULL, NULL);
 		  } break;
case 125:
# line 982 "script.y"
{ 
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(INTCONST, v, NULL, NULL);
 		  } break;
case 126:
# line 989 "script.y"
{ 
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(STRCONST, v, NULL, NULL);
 		  } break;
case 127:
# line 997 "script.y"
{
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(DOLLARARG, v, NULL, NULL);
		  } break;
case 128:
# line 1005 "script.y"
{ yyval.pn = yypvt[-1].pn; } break;
case 129:
# line 1009 "script.y"
{ yyval.pn = yypvt[-1].pn; } break;
	}
	goto yystack;		/* reset registers in driver code */
}
