/*
** $Id: symtab.h,v 1.1 1992/12/11 19:05:11 dhb Exp $
** $Log: symtab.h,v $
** Revision 1.1  1992/12/11  19:05:11  dhb
** Initial revision
**
*/

typedef struct _symtabent
  {
    char		*sym_ident;
    Result		sym_val;
    struct _symtabent	*sym_next;
  } SymtabEnt;

/*
** Eventually Symtab will have more fields
*/

typedef struct _symtab
  {
    SymtabEnt	*sym_entlist;
  } Symtab;

extern Symtab *SymtabCreate();
extern Result *SymtabLook();
extern Result *SymtabNew();
extern char   *SymtabKey();

#ifdef COMMENT

typedef enum _symtabscope
  {
    SymAnyScope,	/* Used to look in current scope then next global */
    SymLocScope,	/* Used to define local or look in current scope */
    SymGlobalScope	/* Used to define global scope */
  } SymtabScope;

typedef struct _symtabent
  {
    char		*sym_ident;
    Result		sym_val;
    struct _symtabent	*sym_next;
  } SymtabEnt;

typedef struct _symtabstack
  {
    SymtabScope		sym_scope;
    SymtabEnt		*sym_tab;
    struct _symtabstack	*sym_prev;
  } SymtabStack;
#endif
