%p 5000
%a 5000
%o 7500

%{
static char lexrcsid[] = "$Id: script.l,v 1.1 1992/12/11 21:18:51 dhb Exp $";

/*
** $Log: script.l,v $
 * Revision 1.1  1992/12/11  21:18:51  dhb
 * Initial revision
 *
*/

#undef input
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):nextchar(0))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)

#ifdef LEXTEST
#    define	lextoken(tok)	printf("%s ==> %s\n", yytext, "tok")
#    define	lexchar(ch)	printf("'%c'\n", ch)
#else
#  ifdef YACCTEST
#    define	lextoken(tok)	{ printf("%s ==> %s\n", yytext, "tok"); return(tok); }
#    define	lexchar(ch)	{ printf("'%c'\n", ch); return(ch); }
#  else
#    define	lextoken(tok)	return(tok)
#    define	lexchar(ch)	return(ch)
#  endif
#endif

#define	BGINSTKSIZE	100

static struct yysvf	*yybginstk[BGINSTKSIZE];
static int		yybginidx = 0;
static int		continuation = 0;
%}

S	("+"|"-")?
E	((e|E){S}[0-9]+)

%Start	LIT FUNCLIT CCOMMENT CPPCOMMENT

%{
/* I use this area to hold things that I might want back */

#ifdef COMMENT
<CPPCOMMENT>[^\n]*	Popyybgin();
"//"			Pushyybgin(CPPCOMMENT);

\\\n			continuation = 0;
#endif
%}

%%

<CCOMMENT>[^*\n]*	;
<CCOMMENT>"*"		;
<CCOMMENT>"\n"		;
<CCOMMENT>"*/"		Popyybgin();
"/*"			Pushyybgin(CCOMMENT);

"//".*			;

<LIT,FUNCLIT>\n		|
<LIT,FUNCLIT>"//"\n	{
			  if (!continuation)
			      lexchar('\n');
			  else
			    {
			      continuation = 0;
			      lexchar(WHITESPACE);
			    }
			}

\n			|
"//"\n			{
			  if (!continuation)
			      lexchar('\n');

			  continuation = 0;
			}

\\.*			continuation = 1;

\"[^\n"]*		{
			  char	ch;

			  ch = input();
			  if (ch == '\n')
			    {
			      yyerror
			      ("Missing closing quote in string constant");
			      /* No Return */
			    }

			  if (yytext[yyleng-1] == '\\')
			    {
			      yytext[yyleng-1] = '"';
			      yyless(yyleng-1);
			      yymore();
			    }
			  else
			    {
			      yylval.str = (char *) strsave(yytext+1);
			      lextoken(STRCONST);
			    }
			};

"$"[0-9]+		{
			  sscanf(yytext+1, " %d ", &yylval.iconst);
			  lextoken(DOLLARARG);
			}

<FUNCLIT>[^ \t\n{}(),"$\\]+ { 
			  yylval.str = (char *) strsave(yytext);
			  lextoken(LITERAL);
			};

<LIT>[^ \t\n{}"$;\\]+      { 
			  yylval.str = (char *) strsave(yytext);
			  lextoken(LITERAL);
			};

<FUNCLIT,LIT>[ \t]+	lextoken(WHITESPACE);
[ \t]+			;

include		lextoken(INCLUDE);

"*ENDSCRIPT*"	lextoken(ENDSCRIPT);

break		lextoken(BREAK);

return		lextoken(RETURN);

while		lextoken(WHILE);

if		lextoken(IF);

else		lextoken(ELSE);

for		lextoken(FOR);

foreach		lextoken(FOREACH);

end		lextoken(END);

function	lextoken(FUNCTION);

extern		lextoken(EXTERN);

int		lextoken(INT);

float		lextoken(FLOAT);

str		lextoken(STR);

"<"		lextoken(LT);
"<="		lextoken(LE);
">"		lextoken(GT);
">="		lextoken(GE);
"=="		lextoken(EQ);
"!="		lextoken(NE);

"||"		lextoken(OR);
"&&"		lextoken(AND);

[_A-Za-z][_A-Za-z0-9]*	{
			  Result	*rp;

			  if (!ReturnIdents &&
			      ((rp=SymtabLook(LocalSymbols, yytext)) != NULL ||
			       (rp=SymtabLook(&GlobalSymbols, yytext)) != NULL))
			    {
			      yylval.str = (char *) rp;
			      if (rp->r_type == FUNCTION)
				  { lextoken(FUNCREF); }
			      else
				  lextoken(VARREF);
			    }
			  else
			    {
			      yylval.str = (char *) strsave(yytext);
			      lextoken(IDENT);
			    }
			};

[0-9]+			{
			  sscanf(yytext, " %d ", &yylval.iconst);
			  lextoken(INTCONST);
			}

[0-9]+{E}		|
[0-9]+\.[0-9]*{E}?	|
[0-9]*\.[0-9]+{E}?	{
			  sscanf(yytext, " %lf ", &yylval.fconst);
			  lextoken(FLOATCONST);
			}

"{"			{ Pushyybgin(0); lexchar('{'); };
"}"			{ Popyybgin(); lexchar('}'); };

.			lexchar(yytext[0]);
%%

/*
** Lexer routines to push and pop the lexer begin state
*/

static Pushyybgin(start)

int	start;

{	/* Pushyybgin --- Push to another lexer begin state */

	if (yybginidx == BGINSTKSIZE)
	    yyerror("Pushyybgin: lexer begin state stack overflow");
	    /* No Return */

	yybginstk[yybginidx++] = yybgin;
	BEGIN start;

}	/* Pushyybgin */



static Popyybgin()

{	/* Popyybgin --- Pop to previous lexer begin state */

	if (yybginidx == 0)
	    yyerror("Popyybgin: lexer begin state stack underflow");
	    /* No Return */

	yybgin = yybginstk[--yybginidx];

}	/* Popyybgin */



/*
** Local routine to get input characters
*/

int nextchar(flush)

{	/* nextchar --- Return next char to lexer */

	static char	buf[100] = "";
	static char	*cp = buf;

	if (flush)
	  {
	    yybginidx = 0;
	    BEGIN 0;
	    yysptr = yysbuf;
	    *cp = '\0';
	    return;
	  }

	while (cp != NULL && *cp == '\0')
	    cp = (char *) sgets(buf, sizeof(buf), stdin);

	if (cp == NULL)
	  {
	    sprintf(buf, "*ENDSCRIPT*\n");
	    cp = buf;
	  }

	return(*cp++);

}	/* nextchar */

/*
** For systems that don't have a lex library, we define some of the support
** routines.
*/

/* mds3 changes */
#ifdef i860
yyless(x)
{
extern char yytext[];
register char *lastch, *ptr;
extern int yyleng;
extern int yyprevious;
lastch = yytext+yyleng;
if (x>=0 && x <= yyleng)
        ptr = x + yytext;
else
        ptr = x;
while (lastch > ptr)
        yyunput(*--lastch);
*lastch = 0;
if (ptr >yytext)
        yyprevious = *--lastch;
yyleng = ptr-yytext;
}

yywrap()
{
return 1;
}
#endif
/* end of mds3 changes */
