/*
** $Id: struct_defs.h,v 1.1 1992/10/27 21:19:36 dhb Exp $
** $Log: struct_defs.h,v $
 * Revision 1.1  1992/10/27  21:19:36  dhb
 * Initial revision
 *
*/


#define		ELEMENT_TYPE \
    char					*name;\
    int						index;\
    struct object_type				*object;\
    short					flags;\
    float					x;\
    float					y;\
    float					z;\
    MsgIn					*msg_in;\
    MsgOut					*msg_out;\
    Element 					*parent;\
    Element					*child;\
    Element					*next;

#define SEGMENT_TYPE \
    ELEMENT_TYPE  \
    float					activation;

#define CHAN_TYPE \
	SEGMENT_TYPE \
	double	Ik;\
	double	Gk;\
	float	Ek;

/*
** BUFFER
**
** tmin 	: the minimum time interval which must be held by the buffer
** size 	: buffer size in number of events
** current 	: current buffer location
** start 	: starting buffer location - 1
** end 		: last occupied buffer location
** event_size	: size of each event data structure
** event 	: circular event buffer
*/
#define BUFFER_TYPE \
    ELEMENT_TYPE  \
    float					tmin; \
    int						size; \
    int						current; \
    int						start; \
    int						end; \
    int						event_size; \
    struct event_type				*event; 

#define PROJECTION_TYPE \
    ELEMENT_TYPE  \
    GenesisObject				*connection_object; \
    Connection 					*connection; 

#define LINK_TYPE \
    Segment					*target;\
    Connection 					*next; \
    float					weight; 

/*
** CONNECTION
**
** dst_segment : pointer to the destination segment
** delay : time delay between src and dst cell
** this delay does not include the fixed latency
** of individual projections
** weight : synaptic weight used by many synaptic functions
*/
#define CONNECTION_TYPE \
    Segment					*target;\
    Connection 					*next; \
    float					weight; \
    float					delay; 

#define OUTPUT_TYPE \
    ELEMENT_TYPE \
    short					datatype; \
    short					datasize; \
    short					mixed_data; \
    struct output_data_type 			*data;


