//genesis

/*
** $Id: simlib.g,v 1.1 1992/10/27 20:39:07 dhb Exp $
**
** $Log: simlib.g,v $
** Revision 1.1  1992/10/27  20:39:07  dhb
** Initial revision
**
*/

/*
************************************************************************
**                       SIMULATOR SHELL COMMANDS                     **
************************************************************************
*/
addfunc		step			do_simulate
addfunc		bgstep			do_bgsimulate
addfunc		cpu			do_ps
addfunc		date			do_date			char*
addfunc		reset			do_reset
addfunc		sh			do_shell
addfunc		status			do_status		char*
addfunc		debug			do_debug		int
addfunc		randomseed		do_srandom		int
addfunc		silent			do_silent		int
addfunc		notes			do_notes
addfunc		clocks			ShowClocks
addfunc		setclock		do_set_clock

/*
** commands for moving around in the element tree structure
*/
addfunc		ce			do_change_element
addfunc		pwe			do_pwe
addfunc		le			do_list_elements
addfunc		push			do_pushe
addfunc		pop			do_pope
addfunc		stack			do_show_estack

/*
** commands for creating and manipulating elements and their structures
*/
addfunc		set			do_set
addfunc		show			do_show
addfunc		create			do_create
addfunc		copy			do_copy
addfunc		move			do_move
addfunc		createmap		do_create_map
addfunc		position		do_position
addfunc		connect			do_add_connection
addfunc		delete			do_delete_element
addfunc		delete_connection	do_delete_connection
addfunc		enable			do_enable
addfunc		disable			do_disable
	
/*
** simulator utilities
*/
addfunc		getinfo			do_getinfo
addfunc		check			CheckSimulation
addfunc		region_connect		do_region_connect
addfunc		cstat			do_connection_status	int
addfunc		help			do_help
addfunc		showbinding		do_show_binding
addfunc		clean			do_clean
addfunc		VERSION			do_version	float

addfunc		sendmsg			do_add_msg
addfunc		showmsg			do_show_msg
addfunc		stop			SetBreakFlag

addfunc		object			do_add_object
addfunc		listobjects		do_list_objects
addfunc		showobject		do_show_object

addfunc		listclasses		do_list_classes
addfunc		newclass		do_add_class

addfunc		clearschedule		do_clear_schedule
addfunc		addschedule		do_add_schedule
addfunc		reschedule		Reschedule
addfunc		jobs			do_list_jobs
addfunc		sched			do_list_tasks

addfunc		addaction		do_add_action
addfunc		call			do_call_element		char*
addfunc		clearerrors		ResetErrors
addfunc		logfile			do_logon
addfunc		saveimage		do_save
addfunc		restoreimage		do_restore
addfunc		addjob			do_add_job
addfunc		killjob			do_remove_job
addfunc		priority		do_change_priority
addfunc		alias			do_alias
addfunc		useclock		do_element_clock
addfunc		deletemsg		do_delete_msg
addfunc		openfile		do_openfile
addfunc		closefile		do_closefile
addfunc		writefile		do_writefile
addfunc		flushfile		do_flushfile
addfunc		listfiles		do_showfiles
addfunc		addescape		do_escape_seq
addfunc		listescape		do_list_esc
addfunc		abort			restore_context
addfunc		putevent		do_insert_event		int
addfunc		Error			Error
addfunc		setobjenv		do_setobjenv		int
addfunc		setmethod		do_set_method

/*
** functions not intended for the command line
*/
addfunc		getclock		do_getclock		float
addfunc		get			do_getfield		char*
addfunc		element_list		do_construct_list 	char**
addfunc		EL			do_construct_list 	char**
addfunc		readfile		do_readfile		char**
addfunc		eof			do_checkeof		int
addfunc		exists			do_exists		int
addfunc		getobjenv		do_getobjenv		char*
addfunc		getmsg			do_getmsg		char*
addfunc		getfields		do_getfields		char**
addfunc		pathname		do_pathname		char*
addfunc		save			do_saveparms		int
addfunc		restore			do_restoreparms		int
