static char rcsid[] = "$Id: sim_tree.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_tree.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:35:57  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

GetTreeCount(pathname)
char *pathname;
{
int count;

    /*
    ** search for the index delimiter or the end of the pathname
    */
    while(*pathname != '[' && *pathname != '/' && 
    *pathname != '\0'){
	pathname++;
    }
    /*
    ** if the delimiter is found then get the count
    */
    if(*pathname == '['){
	sscanf(pathname+1,"%d",&count);
	return(count);
    } else {
    /*
    ** if no count is found then return 0
    */
	return(0);
    }
}


char *GetTreeName(pathname)
char *pathname;
{
static char name[80];
char *name_ptr;

    name_ptr = name;
    while(*pathname != '[' && *pathname != '/' && *pathname != '\0'){
	*name_ptr++ = *pathname++;
    }
    *name_ptr = '\0';
    return(name);
}

char *AdvancePathname(pathname)
char *pathname;
{
    while(*pathname != '/' && *pathname != '\0'){
	pathname++;
    }
    if(*pathname == '/') pathname++;
	return(pathname);
}

ChangeWorkingElement(pathname)
char *pathname;
{
Element *element;

    if((element = GetElement(pathname)) != NULL){
	SetWorkingElement(element);
    } else {
	Error();
	printf("cannot change to '%s' from '%s'\n",
	pathname,
	Pathname(WorkingElement()));
    }
}

ListElements(element,recursive,showtype)
struct element_type *element;
short recursive;
short showtype;
{
struct element_type *child;
char name[100];
struct childlist_type {
    char name[80];
    int start;
    int end;
    int flags;
    short children;
    Element	*element;
    struct childlist_type *next;
} *childlist,*ptr,*newptr,*prev;
char string[80];
int col;

    /*
    ** we have to do this list thing to establish groupings in
    ** the elements so we dont have to list every single one
    */
    childlist = NULL;
    col = 0;
    for(child=element->child;child;child=child->next){
	/*
	** search the child list for the name
	*/
	prev = childlist;
	for(ptr=childlist;ptr;ptr=ptr->next){
	    prev = ptr;
	    /*
	    ** if found then increment the count
	    */
	    if(strcmp(child->name,ptr->name) == 0){
		/*
		** check the secondary indicators like
		** enabled mode and children
		*/
		if(ptr->flags != child->flags || 
		ptr->element->object != child->object ||
		ptr->end+1 != child->index ||
		((child->child != NULL) != ptr->children)){
		    /*
		    ** if found then print out the current
		    ** entry 
		    */
		    if(!IsEnabled(ptr->element))
			strcpy(name,"*");
		    else
			name[0] = '\0';
		    strcat(name,ptr->name);

		    if(ptr->start != ptr->end){
			sprintf(string,"[%d-%d]",ptr->start,ptr->end);
			strcat(name,string);
		    } else {
			if(ptr->start != 0){
			    sprintf(string,"[%d]",ptr->start);
			    strcat(name,string);
			}
		    }
		    if(ptr->children)
			strcat(name,"/");
		    if(showtype){
			strcat(name," {");
			strcat(name,ptr->element->object->name);
			strcat(name,"}");
		    }
		    printf("%-40s",name);
		    if((col+1)%2 == 0) printf("\n");
		    col++;
		    /*
		    ** and set up the new one in its place
		    */
#ifdef OLD
		    ptr->end++;
#else
		    ptr->end = child->index;
#endif
		    ptr->start = ptr->end;
		    ptr->children = (child->child != NULL);
		    ptr->flags = child->flags;
		    ptr->element = child;
		} else {
#ifdef OLD
		    ptr->end++;
#else
		    ptr->end = child->index;
#endif
		}
		break;
	    }
	}
	/*
	** if not there then add to the list
	*/
	if(ptr == NULL){
	    newptr = (struct childlist_type *)
	    calloc(1,sizeof(struct childlist_type));
	    strcpy(newptr->name,child->name);
	    newptr->start = newptr->end = child->index;
	    newptr->children = (child->child != NULL);
	    newptr->flags = child->flags;
	    newptr->element = child;
	    if(childlist == NULL){
		childlist = newptr;
	    } else
	    prev->next = newptr;
	}
    }
    /*
    ** print out the remainder
    */
    for(ptr=childlist;ptr;ptr=ptr->next){
	
	if(!IsEnabled(ptr->element)){
	    strcpy(name,"*");
	} else {
	    name[0] = '\0';
	}
	strcat(name,ptr->name);
	if(ptr->start != ptr->end){
	    sprintf(string,"[%d-%d]",ptr->start,ptr->end);
	    strcat(name,string);
	} else {
	    if(ptr->start != 0){
		sprintf(string,"[%d]",ptr->start);
		strcat(name,string);
	    }
	}
	if(ptr->children)
	    strcat(name,"/");
	if(showtype){
	    strcat(name," {");
	    strcat(name,ptr->element->object->name);
	    strcat(name,"}");
	}
	printf("%-40s",name);

	if((col+1)%2 == 0) printf("\n");
	col++;
	free(ptr);
    }
    if(col%2 != 0) printf("\n");
    /*
    ** if this is recursive then list the children of the children
    */
    if(recursive)
    for(child=element->child;child;child=child->next){
	if(child->child){
	    printf("\n%s:\n",Pathname(child));
	}
	ListElements(child,recursive,showtype);
    }
}

int CountChildren(tree,class)
Element 	*tree;
int		class;
{
int 		count = 0;
short 		stk;

    if(tree == NULL) {
	return(0);
    }
    stk = PutElementStack(tree);
    while(NextElement(0,class,stk)) count++;
    FreeElementStack(stk);
    return(count);
}

/*
** interpreter functions
*/
do_change_element(argc,argv)
int argc;
char **argv;
{
    if(argc > 1){
	ChangeWorkingElement(argv[1]);
    } else {
	printf("usage: %s pathname\n",argv[0]);
    }
}

do_pwe(argc,argv)
int argc;
char **argv;
{
    printf("%s\n", Pathname(WorkingElement()));
}

do_list_elements(argc,argv)
int argc;
char **argv;
{
Element 	*element;
int 		nxtarg;
short 		recursive = 0;
short 		showtype = 0;

    element = WorkingElement();
    nxtarg = 0;
    while(++nxtarg < argc){
	/*
	** check for a recursive listing
	*/
	if(arg_is("-R")){
	    recursive = 1;
	} else 
	if(arg_is("-t")){
	    showtype = 1;
	} else 
	if(argv[nxtarg][0] != '-') {
	    /*
	    ** check for a valid element
	    */
	    if((element = GetElement(argv[nxtarg])) == NULL){
		printf("cant find element '%s'\n",argv[nxtarg]);
		return;
	    }
	} else {
	    printf("usage: %s [pathname][-R][-t]\n",argv[0]);
	    return;
	}
    }
    ListElements(element,recursive,showtype);
}

#ifdef LATER
do_shift_element(argc,argv)
int argc;
char **argv;
{
Element 	*parent;
Element 	*element;
int shift;
int count;
char *path;
char *name;

    if(argc < 2){
	printf("usage: %s [-]count\n",argv[0]);
	return;
    }
    shift = atoi(argv[1]);
    parent = WorkingElement()->parent;
    path = Pathname(WorkingElement());
    /*
    ** get the current index and add the shift to it
    */
    count  = GetTreeCount(path) + shift;
    name = GetTreeName(path);
    /*
    ** get the element with the new index
    */
    if((element = GetChildElement(parent,name,count)) != NULL){
	SetWorkingElement(element);
    } else {
	Error();
	printf("could not find element '%s[%d]' \n",
	name,count);
    }
}
#endif
