/*
** $Id: sim_struct.h,v 1.1 1992/10/27 21:19:36 dhb Exp $
** $Log: sim_struct.h,v $
 * Revision 1.1  1992/10/27  21:19:36  dhb
 * Initial revision
 *
*/

#include "struct_defs.h"

typedef struct projection_type			Projection;
typedef struct projection_parm_type		Parm;
typedef struct element_type			Element;
typedef struct segment_type			Segment;
typedef struct event_type			Event;
typedef struct buffer_type			Buffer;
typedef struct connection_type			Connection;
typedef struct object_type			GenesisObject;
#include "shell_struct.h"

/*
** integer time fields include
** projection->tmax
** buffer->tmin
** event->time
** connection->delay
**
** these have been changed to float and the code should be compiled 
** with FLOATTIME defined
*/

typedef struct {
    char		*name;		/* action name */
    int			type;		/* action type */
    char		*data;		/* action data structure */
    int			argc;		/* optional action arg list */
    char		**argv;	
    char		*passback;	/* return data */
} Action;

typedef struct alist_type {
    char		*name;		/* action name */
    int			type;		/* action type */
    PFI			function;	/* function to call with this action */
    struct alist_type	*next;
} ActionList;

typedef struct mlist_type {
    char		*name;		/* msg name */
    int			type;		/* msg type */
    int			slots;		/* number of msg slots */
    char		**slotname;	/* names for the slots */
    struct mlist_type	*next;
} MsgList;

typedef struct flist_type {
    char		*name;		/* field name */
    struct flist_type	*next;
} FieldList;

typedef struct clist_type {
    int			id;
    struct clist_type 	*next;
} ClassList;

struct object_type {
    char		*name;		/* object name */
    char		*type;		/* name of the object data structure */
    int			size;		/* size of the data structure */
    PFI			function;	/* object function */
    int			flags;
    int			envc;		/* number of environment strings */
    char		**env;		/* environment string list */
    ClassList		*class;		/* object class list */
    ActionList		*valid_actions;
    MsgList		*valid_msgs;
    FieldList		*public_fields;	/* list of user-settable fields */
    char		*description;	/* object description */
    char		*author;	/* object author */
	short		method;		/* integration method */
};

typedef struct {
    PFI			function;
    int			argc;
    char		**argv;
    int			spec_argc;
    char		**spec_argv;
} Schedule;

typedef struct	{
    int			argc;
    char		**argv;
} Arglist;

typedef struct {
    char 		*name;
    char		*adr;
} VarList;

typedef char *InternalMsg;

typedef struct {
    char		*name;
    char		*data;
    PFD			func;
} Slot;

typedef struct msgout_type {
    Element		*dst;
    struct msgin_type	*msg_in;
    struct msgout_type 	*next;
} MsgOut;

typedef struct msgin_type {
    short		type;
    Element		*src;
    short		nslots;
    Slot		*slot;
    struct msgin_type  	*next;
} MsgIn;

typedef struct {
    Element	**element;
    Element	**sp;
    short	sp_used;
} ElementStack;

struct mask_type { 
    short		type;
    float 		xl,yl,xh,yh; 
}; 

struct region_type { 
    short		type;
    int 		xl,yl,xh,yh; 
}; 

struct region_mask_type {
    int			xmin,xmax,ymin,ymax;
    char		**map;
};

struct delay_table_type {
    int			xmin,xmax,ymin,ymax;
    float		**table;
};

/*
** the grid structure provides a means of accessing elements
** according to their xy coordinates
*/
struct map_type {
    float		wxmin;
    float		wymin;		/* max world coordinates for the grid */
    float		dx; 		/* the spacing between grid points in */
    float		dy; 		/* world coordinates */
    int			xmax,ymax; 	/* max grid indices */
    Element		***grid; 	/* a 2D array of pointers to elements */
};

struct segment_map_type {
    /*
    ** two-dimensional map of destination segments
    */
    float					wxmin,wymin;
    float					dx,dy;
    int						xmax,ymax;
    /*
    ** a 2D array of pointers to destination segment structures
    */
    Segment					***grid;
};

struct rel_connection_type {
    /*
    ** relative coordinates of the dst cell
    */
    short 					x;
    short					y;
    short					weight;
    char 					*specific;
};

struct converging_connection_type {
    ELEMENT_TYPE
    /*
    ** linked list containing pointers to connections 
    */
    Connection			 		*connection;
    Projection					*src_projection;
};

struct from_element_type {
    Element					*element;
    struct from_element_type			*next;
};

struct projection_parm_type {
    char					*name;
    char					*type;

    struct segment_map_type			*dst_map;
    struct region_mask_type			*src_region_mask;
    struct region_mask_type			*dst_region_mask;
    struct delay_table_type			*delay_table;


    /*
    ** dst segment used in relative connections 
    */
    int						target;
    int						rel_connection_tmax;
    float					time_resolution;
    /*
    ** interval between event propagations along the projection
    ** this should be consistent with the interval for 
    ** all destination segments the event buffer to
    ** which it is attached
    */
    short					transform;
    float					matrix[3][3];
    float					translate[3];

    /*
    ** relative connection information
    */
    int						*rel_connection_nentries;
    struct rel_connection_type			**rel_connection;
    PFI						rel_connection_func;
    PFI						fill_rel_connection_func;
};

/*
** the element list is a means of grouping elements together
*/
typedef struct element_list_type {
    int 					size;
    int 					nelements;
    Element		 			**element;
    PFI		 				*function;
} ElementList;

struct info_type {
    char 		*name;
    char 		*type;
    int	 		address;
    short 		indirection;
    int 		type_size;
    int 		offset;
    short 		field_indirection;
    int 		field_size;
    short 		dimensions;
    int 		dimension_size[4];
    short 		function;
    short 		function_type;
    short 		struct_type;
};

typedef struct {
    char		*name;
    int			size;
    char		*data;
} SaveStruct;

/*
** ELEMENT STRUCTURES
*/

struct element_type {
    ELEMENT_TYPE
};


struct projection_type {
    PROJECTION_TYPE
};

struct event_type {
    float					time;
    double					magnitude;
};

struct buffer_type {
    BUFFER_TYPE
};

struct segment_type {
    SEGMENT_TYPE
};

struct basic_element_type {
    ELEMENT_TYPE
    /*
    ** a pointer to a two-dimensional map of elements in the group
    */
    struct map_type				*map;
};

struct connection_type {
    CONNECTION_TYPE
};
