static char rcsid[] = "$Id: sim_status.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_status.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:32:10  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

#define NCLASSES	100
static int classcount;

typedef struct status_type {
    char	*name;
    int		count;
    int		size;
} Status;

Status class_status[NCLASSES];
Status object_status[NCLASSES];

Status *AddObjectStatus(name)
char	*name;
{
Status *status;

    if(classcount < NCLASSES){
	status = object_status+classcount;
	status->name = name;
	status->size = 0;
	status->count = 0;
	classcount++;
	return(status);
    } else {
	return(NULL);
    }
}

Status *GetObjectStatus(name)
char *name;
{
int i;

    for(i=0;i<classcount;i++){
	if(object_status[i].name && (strcmp(object_status[i].name,name) == 0)){
	    return(object_status + i);
	}
    }
    return(NULL);
}

PrintStatus(name,count,size)
char *name;
int count;
int size;
{
	printf("%10d %-15s %10d bytes (%6.2f Mbytes)\n",
	count,name,size,size/1.0e6);
}

element_count(root)
Element	*root;
{
char 		*class;
Element 	*element;
Buffer		*buffer;
Segment 	*segment;
Event 		*event;
Projection 	*projection;
Connection 	*connection;
int 		csize;
short 		stk;
Status		*status;
int		total_size;
int		total_count;
int		i;
MsgIn		*msgin;
MsgOut		*msgout;

    if(root == NULL) return;
    stk = PutElementStack(root);
    /*
    ** clean out all of the status values
    */
    classcount = 0;
    while((element = NextElement(0,0,stk)) != NULL){
	if(element->object == NULL) continue;
	class = element->object->name;
	/*
	** look for the status structure of the element class
	*/
	if((status = GetObjectStatus(class)) == NULL){
	    /*
	    ** if not found then make one
	    */
	    if((status = AddObjectStatus(class)) == NULL){
		printf("status table full\n");
		continue;
	    }
	}
	/*
	** update the statistics of the class
	*/
	(status->count)++;
	status->size += Size(element);
	/*
	** handle the messages
	*/
	if((status = GetObjectStatus("messages")) == NULL){
	    /*
	    ** if not found then make one
	    */
	    if((status = AddObjectStatus("messages")) == NULL){
		printf("status table full\n");
		continue;
	    }
	}
	/*
	** go through the msg out list
	*/
	for(msgout=element->msg_out;msgout;msgout=msgout->next){
	    (status->count)++;
	    status->size += sizeof(MsgOut);
	}
	/*
	** go through the msg in list
	*/
	for(msgin=element->msg_in;msgin;msgin=msgin->next){
	    status->size += (sizeof(MsgIn) + msgin->nslots*sizeof(Slot));
	}
	/*
	** deal with the special cases
	*/
	if(CheckClass(element,PROJECTION_ELEMENT)){
	    projection = (Projection *)element;
	    if(projection->connection_object){
		if((status=
		GetObjectStatus(projection->connection_object->name))==NULL){
		    if((status=
		    AddObjectStatus(projection->connection_object->name))==NULL){
			printf("status table full\n");
			continue;
		    }
		}
		csize = projection->connection_object->size;
	    } else {
		csize = 0;
	    }
	    for(connection=projection->connection;connection;
	    connection=connection->next){
		(status->count)++;
		status->size += csize;
	    }
	} else
	if(CheckClass(element,BUFFER_ELEMENT)){
	    buffer = (Buffer *)element;
	    if((status=GetObjectStatus("events"))==NULL){
		if((status = AddObjectStatus("events")) == NULL){
		    printf("status table full\n");
		    continue;
		}
	    }
	    status->count += buffer->size;
	    status->size += buffer->size*buffer->event_size;
	}
    }
    FreeElementStack(stk);
    /*
    ** go through all of the classes and print the results
    */
    printf("'%s' element count:\n",Pathname(root));
    total_size = 0;
    total_count = 0;
    for(i=0;i<classcount;i++){
	status = object_status+i;
	PrintStatus(status->name,status->count,status->size);
	total_size += status->size;
	total_count += status->count;
    }
    printf("----------------------------------------------------------\n");
    PrintStatus("",total_count,total_size);
    printf("\n");
    printf("total memory usage : %d bytes   ( %6.2f Mbytes )\n",
    memusage(),
    memusage()/1.0e6);
}

char *do_status(argc,argv)
int argc;
char **argv;
{
Element *element;

    if(argc > 1){
	if(strcmp(argv[1],"-time") == 0){
	    return(ftoa(SimulationTime()));
	}
	if(strcmp(argv[1],"-step") == 0){
	    return(itoa(GetCurrentStep()));
	}
	if(strcmp(argv[1],"-memory") == 0){
	    return(itoa(memusage()));
	}
	if(strcmp(argv[1],"-process") == 0){
	    ProcessStatus();
	    return(NULL);
	}
	if(strcmp(argv[1],"-element") == 0){
	    if(argc > 2){
		element = GetElement(argv[2]);
	    } else {
		element = RootElement();
	    }
	    element_count(element);
	    return(NULL);
	}
	printf("usage: %s [-time][-step][-memory][-process][-element [element]]\n",
	argv[0]);
	return(NULL);
    }
    SimStatus();
    return(NULL);
}

SimStatus()
{
char string[100];

    sprintf(string,"current simulation time = %f ; step = %d; dt = %e         ",
    SimulationTime(),
    GetCurrentStep(),
    ClockValue(0));
    if(!StatusMessage(string,0,1)){
	printf("%s\n",string);
    }
}
