static char rcsid[] = "$Id: sim_show.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_show.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:27:55  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

#define field_is(S) (all || strcmp(field,"S") == 0 )

ShowObject(object)
GenesisObject	*object;
{
int	i;
ActionList	*alist;
MsgList		*mlist;
FieldList	*plist;
ClassList	*clist;
char		*func_name;
int		special;

    if(object == NULL) return;
    func_name = GetFuncName(object->function);
    printf("\n");
    printf("%-20s = %s\n","object",object->name);
    printf("%-20s = %s\n","datatype",object->type);
    printf("%-20s = %s()\n","function",func_name);
    printf("%-20s = ","class");
    for(clist=object->class;clist;clist=clist->next){
	printf("[ %s ] ", GetClassName(clist->id));
    }
    printf("\n");
    printf("%-20s = %d bytes\n","size",object->size);
    printf("%-20s = %s\n","author",object->author);
    special = 0;
    if(object->valid_actions){
	printf("\nVALID ACTIONS\n\t");
	for(alist=object->valid_actions;alist;alist=alist->next){
	    if(alist->function != object->function) special = 1;
	    printf("%s  ",alist->name);
	}
	printf("\n");
    }
    if(special){
	printf("\nSPECIAL FUNCTIONS\n");
	for(alist=object->valid_actions;alist;alist=alist->next){
	    if(alist->function != object->function){
		printf("\t%-20s %s()\n",
		alist->name, GetFuncName(alist->function));
	    } 
	}
    }
    if(object->valid_msgs){
	printf("\nVALID MESSAGES\n");
	for(mlist=object->valid_msgs;mlist;mlist=mlist->next){
	    printf("\t[%d] %-20s : ",mlist->type,mlist->name);
	    for(i=0;i<mlist->slots;i++){
		printf("%s ",mlist->slotname[i]);
	    }
	    printf("\n");
	}
    }
    if(object->public_fields){
	printf("\nFIELDS\n");
	for(plist=object->public_fields;plist;plist=plist->next){
	    printf("\t%s\n",plist->name);
	}
    }
    if(object->envc > 0){
	printf("\nENVIRONMENT\n");
	for(i=0;i<object->envc-1;i += 2){
	    printf("\t%-20s = %20s\n",object->env[i],object->env[i+1]);
	}
    }
    if(object->description > 0){
	printf("\nDESCRIPTION\n");
	printf("\t%s",object->description);
    }
    printf("\n");
}

ShowSpecific(element)
Element		*element;
{
    if(element == NULL) return;
/*
    printf("\n[ %s ]\n",Pathname(element));
*/
    /*
    ** display all of the fields after the last field of the basic
    ** element
    */
    if(element->object){
	DisplayFields(element,element->object,
	element,element->object->type,"next",1);
    }
}

ShowBasic(element)
Element 	*element;
{
    if(element == NULL) return;
/*
    printf("\n[ %s ]\n",Pathname(element));
*/
    if(element->object){
	ShowObject(element->object);
    } else {
	printf("NO OBJECT DEFINITION\n"); 
    }
    printf("%-10s = ( %e , %e , %e )\n",
    "xyz", element->x, element->y, element->z);
    printf("%-10s = %x\n","flags",element->flags);
    if(IsEnabled(element)){
	if(IsActive(element)){
	    printf("FUNCTIONAL\n");
	} else {
	    printf("NOT FUNCTIONAL\n");
	}
    } else {
	printf("BLOCKED\n");
    }
    printf("Clock [ %d ] = %e\n",Clock(element),Clockrate(element));

    printf("%d incoming messages\n",CountMsgIn(element->msg_in));
    printf("%d outgoing messages\n",CountMsgOut(element->msg_out));
    printf("-----------------------------------------------------\n");

}

ShowAll(element)
Element 	*element;
{
char	*showname;
PFI	showfunc;

    if(element == NULL) return;
    ShowBasic(element);
    /*
    ** display all of the fields after the last field of the basic
    ** element
    */
    if(element->object){
	DisplayFields(element,element->object,
	element,element->object->type,"next",1);
    }
}

do_show(argc,argv)
int	argc;
char	**argv;
{
char 		*elementname;
Element 	*element;
int 		nxtarg;
char 		*field;
int		startarg;
ElementList	*list;
ElementList	*targetlist;
int		multiple;
int		j;
int		ecount;
int		start_connection;
int		end_connection;
Projection	*projection;
Connection 	*connection;
int		show_connections = 0;
char		*pathname;
int		count;
GenesisObject		*object;
PFI		func;

    if(argc < 2){
	printf("usage: %s [pathname[:connections]] *, *a, *b, field ...\n",
	argv[0]);
	return;
    } 
    pathname = argv[1];
    /*
    ** check for a connection
    */
    targetlist = NULL;
    show_connections = 
    ParseConnection(pathname,&start_connection,&end_connection,&targetlist);
    if(targetlist && targetlist->nelements < 1){
	printf("empty connection target path specification\n");
	return;
    }

    nxtarg = 1;
    list = WildcardGetElement(pathname,0);

    /*
    ** if there are more than 2 arguments then assume that there is
    ** a path specification. Try opening it as an element.
    */
    if((ecount = list->nelements) > 0){
	multiple = 1;
	nxtarg++;
    } else {
	element = WorkingElement();
	if (strcmp(argv[nxtarg], "*") != 0 &&
		strcmp(argv[nxtarg], "**") != 0 &&
		strcmp(argv[nxtarg], "***") != 0 &&
		FieldValue(element, element->object, argv[nxtarg]) == NULL) {
	    printf("'%s' is not an element or the field of the working element\n", argv[nxtarg]);
	    return;
	}

	ecount = 1;
	multiple = 0;
    }
    startarg = nxtarg;

    while(ecount>0){
	if(multiple){
	    element = list->element[list->nelements - ecount];
	}
	ecount--;
	nxtarg = startarg;
	if(show_connections != 4){
	    printf("\n[ %s ]\n",Pathname(element));
	}
	while(nxtarg < argc){
	    field = argv[nxtarg++];
	    if(!show_connections){
		ShowField(element,field);
	    } else {
		/*
		** connection
		*/
		if(!CheckClass(element,PROJECTION_ELEMENT)){
		    Error();
		    printf("'%s' is not a projection.\n",Pathname(element)); 
		    printf("Must specify a projection to show connections\n");
		    break;
		}
		projection = (Projection *)element;
		if(projection->connection_object == NULL){
		    Error();
		    printf("invalid connection\n");
		    break;
		}
		/*
		** show all connections for all projections in the tree
		*/
		if(show_connections == 1){
		    if((connection = 
		    GetConnection(projection,start_connection)) == NULL){
			Error();
			printf("unable to find connection %d on '%s'\n",
			start_connection,
			Pathname(projection));
			break;
		    }
		    ShowConnectionField(projection,connection,field);
		} else 
		if(show_connections == 2){
		    count = 0;
		    for(connection=projection->connection;connection;
		    connection=connection->next){
			if(count >= start_connection &&
			count <= end_connection){
			    ShowConnectionField(projection,connection,field);
			}
			count++;
		    }
		} else
		if(show_connections == 3){
		    for(connection=projection->connection;connection;
		    connection=connection->next){
			ShowConnectionField(projection,connection,field);
		    }
		} else
		if(show_connections == 4){
		    for(connection=projection->connection;connection;
		    connection=connection->next){
			for(j=0;j<targetlist->nelements;j++){
			    /*
			    ** if the connection is onto an element in
			    ** the target list then show it
			    */
			    if(connection->target ==
			    (Segment *)(targetlist->element[j])){
				printf("\nfrom [ %s ]\n",Pathname(element));
				ShowConnectionField(projection,
				connection,field);
				break;
			    }
			}
		    }
		}
	    }
	}
    }
    if(targetlist){
	FreeElementList(targetlist);
    }
    FreeElementList(list);
}

ShowField(element,field)
Element	*element;
char	*field;
{
    if(strcmp(field,"**") == 0){
	ShowAll(element);
    } else
    if(strcmp(field,"***") == 0){
	ShowBasic(element);
    } else 
    if(strcmp(field,"*") == 0){
	ShowSpecific(element);
    } else {
	DisplayField(element,element->object,field);
    }
}

ShowConnectionField(projection,connection,field)
Projection *projection;
Connection *connection;
char	*field;
{
char *str;

    if(!projection->connection_object) return;
    if(strcmp(field,"***") == 0){
	printf("connection to '%s'\n",Pathname(connection->target));
	ShowObject(projection->connection_object);
    } else
    if(strcmp(field,"**") == 0){
	ShowObject(projection->connection_object);
	printf("-----------------------------------------------------\n");
	DisplayFields(connection,projection->connection_object,
	connection,projection->connection_object->type,NULL,0);
    } else 
    if(strcmp(field,"*") == 0){
	DisplayFields(connection,projection->connection_object,
	connection,projection->connection_object->type,NULL,0);
    } else {
	if(projection->connection_object){
	    DisplayField(connection,projection->connection_object,field);
	} else {
	    FieldFormat(field,"???");
	}
    }
}

