static char rcsid[] = "$Id: sim_set.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_set.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:27:28  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

int do_set(argc,argv)
int 	argc;
char 	**argv;
{
Element	*element;
Projection	*projection;
Connection	*connection;
char 		*pathname;
short 		tree;
int 		nxtarg;
short 		stk;
int 		field_offset;
Info 		info;
char		*delimiter;
char 		*field;
char 		*value;
char		*tmp;
int		set_connections;
int		start_connection;
int		end_connection;
ElementList	*list;
ElementList	*targetlist;
int		type = 0;
GenesisObject		*previous_object;
int		i;
int		j;
Action		action;
GenesisObject		*object;
PFI		func;
int		count;
int		already_set;
char 		*adr;
/* Dale Fay's Additions */
char *char_ptr;
int return_int;

    if(argc < 3){
	TraceScript();
	printf("usage: %s [-env][pathname[:connection]] field value ...\n",
	argv[0]);
	return(0);
    }
/* Dale Fay's Bug Fixes */
/* To prevent the pointer at argv[0] from being freed twice */
   if(strcmp(argv[1],"-env") == 0){
       char_ptr = argv[1];
       argv[1] = argv[0];
       argc--;
       return_int = do_setelementenv(argc,argv+1);
       argv[1] = char_ptr;
       return(return_int);
   }

/*
    if(strcmp(argv[1],"-env") == 0){
	argv[1] = argv[0];
	argc--;
	return(do_setelementenv(argc,argv+1));
    }
*/
    nxtarg = 1;
    set_connections = 0;
    action.argv = (char **)malloc(argc*sizeof(char *));
    action.type = SET;
    action.name = "SET";
    action.argc = 2;
    /*
    ** check for a pathname
    */
    if(((argc - nxtarg)%2) != 0){
	pathname = argv[nxtarg];
	nxtarg++;
    } else {
	pathname = ".";
    }
    /*
    ** check for a connection
    */
    targetlist = NULL;
    set_connections =
    ParseConnection(pathname,&start_connection,&end_connection,&targetlist);
    if(targetlist && targetlist->nelements < 1){
	InvalidPath(argv[0],pathname);
	printf("empty connection target path specification\n");
	return(0);
    }

    if((list = WildcardGetElement(pathname,0)) == NULL){
	InvalidPath(argv[0],pathname);
	return(0);
    }
    if(list->nelements < 1){
	InvalidPath(argv[0],pathname);
	return(0);
    }
    /*
    ** loop over all the fields to be set
    */
    while(nxtarg < argc){
	/*
	** get the field to be set
	*/
	field = argv[nxtarg++];
	if(nxtarg == argc){
	    TraceScript();
	    printf("missing a value for field '%s'\n",field);
	    return(0);
	}
	/*
	** and its value
	*/
	value = argv[nxtarg++];
	previous_object = NULL;
	/*
	** loop over all the elements in the list
	*/
	for(i=0;i<list->nelements;i++){
	    /*
	    ** get the element
	    */
	    if((element = list->element[i]) == NULL) continue;
	    if(!set_connections){
		/*
		** check to see if the  object has a SET action
		*/
		object = element->object;
		already_set = 0;
		if(func = GetActionFunc(object,SET)){
		    /*
		    ** does this object want all of the arguments
		    ** at once
		    */
		    if(getobjenv(object,"SPECIAL_SET")){
			/*
			** call the element with the rest of the argument
			** line. Then null the list element so that it is not
			** called again for subsequent arguments in the 
			** arglist
			*/
			action.argc = argc - nxtarg + 2;
			for(j=0;j<action.argc;j++){
			    action.argv[j] = argv[j+nxtarg-2];
			}
			list->element[i] = NULL;
			already_set = 1;
			/*
			** call the function with the SET action
			*/
		        func(element,&action);
		    } else {
			action.argv[0] = field;
			action.argv[1] = value;
			/*
			** call the function with the SET action
			** and check its return status to determine
			** whether it actually set anything or not
			*/
			already_set = func(element,&action);
		    }
		} 
		/*
		** do the default set
		*/
		if(!already_set){
		    /*
		    ** calculate the field offset if new object
		    ** is being used
		    */
		    if(element->object != previous_object){
			if((field_offset = 
			CalculateOffset(Type(element),field,&info)) == -1){
			    InvalidField(argv[0],element,field);
			    continue;
			}
			previous_object = element->object;
		    }
		    if(field_offset == -2){ 
			/* 
			** have to compute the address
			** from scratch
			*/
			if((adr=
			CalculateAddress(element,Type(element),field,&info)) ==
			NULL){
			    InvalidField(argv[0],element,field);
			    continue;
			}
		    } else {
			adr = (char *)((char *)(element)+field_offset);
		    }
		    /*
		    ** set the field value
		    */
		    PutValue(adr,&info,value);
		}
	    } else {
		/*
		** connection
		*/
		if(!CheckClass(element,PROJECTION_ELEMENT)){
		    Error();
		    printf("'%s' is not a projection.\n",Pathname(element)); 
		    printf("Must specify a projection to set connections\n");
		    return(0);
		}
		projection = (Projection *)element;
		if(projection->connection_object == NULL){
		    Error();
		    printf("invalid connection\n");
		    return(0);
		}
		/*
		** if there is a SET action then use it
		*/
		already_set = 0;
		if(func = GetActionFunc(projection->object,SET)){
		    action.argv[0] = field;
		    action.argv[1] = value;
		    /*
		    ** set all connections for all projections in the tree
		    */
		    if(set_connections == 1){
			if((connection = GetConnection(element,start_connection)) ==
			NULL){
			    Error();
			    printf("could not find connection %d on '%s'\n",
			    start_connection,
			    Pathname(element));
			    return(0);
			}
		        already_set = func(connection,&action);
		    } else 
		    if(set_connections == 2){
			count = 0;
			for(connection=projection->connection;connection;
			connection=connection->next){
			    if(count >= start_connection &&
			    count <= end_connection){
				if(!(already_set = func(connection,&action))){
				    break;
				}
			    }
			    count++;
			}
		    } else
		    if(set_connections == 3){
			/*
			** all connections
			*/
			for(connection=projection->connection;connection;
			connection=connection->next){
			    if(!(already_set = func(connection,&action))){
				break;
			    }
			}
		    } else
		    if(set_connections == 4){
			/*
			** target list specification
			*/
			for(connection=projection->connection;connection;
			connection=connection->next){
			    for(j=0;j<targetlist->nelements;j++){
				/*
				** if the connection is onto an element in
				** the target list then show it
				*/
				if(connection->target ==
				(Segment *)(targetlist->element[j])){
				    already_set = func(connection,&action);
				    break;
				}
			    }
			}
		    } 
		}
		/*
		** do the default set
		*/
		if(!already_set){
		    if((field_offset = CalculateOffset(
		    projection->connection_object->type,field,&info)) == -1){
			Error();
			printf("%s: could find field '%s'\n",argv[0],field);
			return(0);
		    }
		    /*
		    ** set all connections for all projections in the tree
		    */
		    if(set_connections == 1){
			if((connection = GetConnection(element,start_connection)) ==
			NULL){
			    Error();
			    printf("could not find connection %d on '%s'\n",
			    start_connection,
			    Pathname(element));
			    return(0);
			}
			PutValue((char *)connection + field_offset, &info,value);
		    } else 
		    if(set_connections == 2){
			count = 0;
			for(connection=projection->connection;connection;
			connection=connection->next){
			    if(count >= start_connection &&
			    count <= end_connection){
				PutValue((char *)connection
				+field_offset, &info,value);
			    }
			    count++;
			}
		    } else
		    if(set_connections == 3){
			/*
			** all connections
			*/
			for(connection=projection->connection;connection;
			connection=connection->next){
			    PutValue((char *)connection +field_offset, &info,value);
			}
		    } else
		    if(set_connections == 4){
			/*
			** target list specification
			*/
			for(connection=projection->connection;connection;
			connection=connection->next){
			    for(j=0;j<targetlist->nelements;j++){
				/*
				** if the connection is onto an element in
				** the target list then show it
				*/
				if(connection->target ==
				(Segment *)(targetlist->element[j])){
				    PutValue((char *)connection 
				    +field_offset, &info,value);
				    break;
				}
			    }
			}
		    }
		}
	    }
	}
    }
    /*
    ** done with the list
    */
    if(targetlist){
	FreeElementList(targetlist);
    }
    FreeElementList(list);
    free(action.argv);
    OK();
    return(1);
}

int SetElement(element,field,value)
Element		*element;
char		*field;
char		*value;
{
GenesisObject		*object;
Action		action;
int 		field_offset;
Info 		info;
PFI		func;

    if(element == NULL || field == NULL || value == NULL){
	return(0);
    } 
    /*
    ** check to see if the  object has a create action
    */
    object = element->object;
    if(func = GetActionFunc(object,SET)){
	/*
	** if it does then call the function with the action
	*/
	action.name = "SET";
	action.type = SET;
	action.argc = 2;
	action.argv = (char **)malloc(2*sizeof(char *));
	action.argv[0] = field;
	action.argv[1] = value;
	func(element,&action);
	free(action.argv);
    } else {
	/*
	** calculate the field offset 
	*/
	if((field_offset = CalculateOffset(Type(element),field,&info)) == -1){
	    InvalidField("SetElement",element,field);
	    return(0);
	}
	/*
	** set the field value
	*/
	PutValue((char *)element + field_offset,&info,value);
    }
    return(1);
}


SetField(address,type,field,value)
char *address;
char *type;
char *field;
char *value;
{
Info info;
int offset;

    /*
    ** is the address valid?
    */
    if(address == NULL){
	Error();
	printf("SetField : NULL address for field '%s'. Unable to set\n",
	field);
	return(0);
    }
    /*
    ** is the field valid ?
    */
    if(field){
	/*
	** get the offset of the field from the beginning of the structure
	** type
	*/
	offset = CalculateOffset(type,field,&info);
    } else {
	Error();
	printf("SetField : must give a field to set\n");
	return(0);
    }
    /*
    ** did the offset calculation succeed?
    */
    if(offset != -1){
	/*
	** if it did then set the value and return the status
	** of the assignment operation
	*/
	return(PutValue(address+offset, &info,value));
    } else {
	Error();
	printf("SetField : could not make assignment to '%s'\n",field);
	return(0);
    }
}

/* LATER get the event setting function right */
do_set_event(argc,argv)
int argc;
char **argv;
{
Element 	*element;
char 		*pathname;
char 		*type;
int		size = 0;

    if(argc < 3){
	printf("usage: %s buffer_name event_object [-size #]\n",argv[0]);
	return;
    }
    /*
    ** get arguments
    */
    pathname = argv[1];
    size = atoi(argv[2]);
    type = argv[3];

    element = GetElement(pathname);

    /*
    ** check arguments
    */
    if(element == NULL){
	TraceScript();
	printf("%s: buffer is undefined\n",argv[0]);
	return(0);
    }
    if(!CheckClass(element,BUFFER_ELEMENT)){
	TraceScript();
	printf("%s: '%s' is not a buffer element\n",argv[0],pathname);
	return(0);
    }
    if(size <= 0){
	TraceScript();
	printf("%s: invalid buffer size\n",argv[0]);
	return(0);
    }
    /*
    ** add the event buffer
    */
    AddEventBuffer(element,size,type);
}


SetConnection(projection,connection,field,value)
Projection 	*projection;
Connection 	*connection;
char 		*field;
char 		*value;
{
    if(connection != NULL){
	if(field[0] == '.') field++;
	SetField(connection,"connection_type",field,value);
    } else {
	TraceScript();
	printf("connection is undefined\n");
	return(0);
    }
    return(1);
}

