static char rcsid[] = "$Id: sim_reset.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_reset.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:25:39  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

SimReset()
{
PFI			func;
Projection		*projection;
Connection		*connection;
Element			*element;
ElementStack		*stk;
Action			*action;
int			i;

    SetCurrentStep(0);
    simulation_time = 0;
    StepStatus();
    SetBreakFlag();
    ResetErrors();
    Reschedule();
/*
    CheckSimulation();
*/
    ResetTmin();

    action = GetAction("RESET");

    /*
    ** reset each element
    */
    stk = NewPutElementStack(RootElement());
    while((element=NewFastNextElement(1,stk)) != NULL){
	/*
	** get the element reset function
	*/
	if((func = GetActionFunc(element->object,RESET)) != NULL){
	    if (!IsHsolved(element)) {
			func(element,action);
		}
	}
	/*
	** reset the connections
	*/
	if(CheckClass(element,PROJECTION_ELEMENT)){
	    projection = (Projection *)element;
	    /*
	    ** do the connections have a reset action?
	    */
	    if(projection->connection_object){
		func = GetActionFunc(projection->connection_object,RESET);
	    } else {
		func = NULL;
	    }
	    if(func){
		/*
		** do each connection
		*/
		for(connection=projection->connection;
		connection;connection = connection->next){
		    func(connection,action,projection);
		}
	    }
	}
    }
    NewFreeElementStack(stk);
}

ResetTmin()
{
ElementStack	*stk;
Element	*element;

    stk = NewPutElementStack(RootElement());
    /*
    ** go through all elements 
	**
	** Bugfix by Upi Bhalla 16 Jul 1991 :
	** flag here is set to 0 to cause proper
	** reset for passive buffers involved in higher order integ methods
    */
    while(element = NewNextElement(0,BUFFER_ELEMENT,stk)){
	/*
	** clear the tmin of the buffers on this element
	*/
	((Buffer *)element)->tmin = 0;
	/*
	** Upi Bhalla 18 Jul 1991
	** Another bugfix : completely reset the passive buffers.
	*/
	if (strcmp(element->object->name,"passive_buffer") == 0)
		ClearBuffer(element);
    }
    NewFreeElementStack(stk);
}

ResetSimState()
{
    SetCurrentStep(0);
    simulation_time = 0;
    StepStatus();
    SetBreakFlag();
    ResetErrors();
    Reschedule();
    ResetTmin();

}

ResetElements(list)
ElementList *list;
{
PFI			func;
Projection		*projection;
Connection		*connection;
Element			*element;
Action			*action;
int			i;

    action = GetAction("RESET");

    /*
    ** reset each element
    */
    for(i=0;i<list->nelements;i++){
	element = list->element[i];
	/*
	** get the element reset function
	*/
	if((func = GetActionFunc(element->object,RESET)) != NULL){
	    func(element,action);
	}
	/*
	** reset the connections
	*/
	if(CheckClass(element,PROJECTION_ELEMENT)){
	    projection = (Projection *)element;
	    /*
	    ** do the connections have a reset action?
	    */
	    if(projection->connection_object){
		func = GetActionFunc(projection->connection_object,CHECK);
	    } else {
		func = NULL;
	    }
	    if(func){
		/*
		** do each connection
		*/
		for(connection=projection->connection;
		connection;connection = connection->next){
		    func(connection,action,projection);
		}
	    }
	}
    }
}

do_reset()
{
    SimReset(); 
}

do_reset_simstate()
{ 
    ResetSimState(); 
}

do_reset_elements(argc,argv) 
int argc;
char **argv;
{ 
ElementList *list;

    if(argc < 2){
	printf("usage: %s path\n",argv[0]);
	return;
    }
    list = WildcardGetElement(argv[1],1);
    ResetElements(list);
    FreeElementList(list);
}
