static char rcsid[] = "$Id: sim_random.c,v 1.2 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_random.c,v $
 * Revision 1.2  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:24:43  dhb
 * Initial revision
 *
*/

/*
** Random number routines from "Numerical Recipes in C", Chapter 7
** Entered by Michael D. Speight, 10th September 1991
** All references to '*idum' changed to 'idum'
*/
#include <stdio.h>
#define M1 259200
#define IA1 7141
#define IC1 54773
#define RM1 (1.0)/M1
#define M2 134456
#define IA2 8121
#define IC2 28411
#define RM2 (1.0)/M2
#define M3 243000
#define IA3 4561
#define IC3 51349

float ran1(idum)
     int idum;
{
  static long ix1,ix2,ix3;
  static float r[98];
  float temp;
  static int iff=0;
  int j;
  if (idum < 0 || iff == 0) {
    iff=1;
    ix1=(IC1-(idum)) % M1;
    ix1=(IA1*ix1+IC1) % M1;
    ix2=ix1 % M2;
    ix1=(IA1*ix1+IC1) % M1;
    ix3=ix1 % M3;
    for (j=1;j<=97;j++) {
      ix1=(IA1*ix1+IC1) % M1;
      ix2=(IA2*ix2+IC2) % M2;
      r[j]=(ix1+ix2*RM2)*RM1;
    }
    idum=1;
  }
  ix1=(IA1*ix1+IC1) % M1;
  ix2=(IA2*ix2+IC2) % M2;
  ix3=(IA3*ix3+IC3) % M3;
  j=1 + ((97*ix3)/M3);
  if (j>97||j<1) printf("RAN1: This cannot happen.\n");
  temp=r[j];
  r[j]=(ix1+ix2*RM2)*RM1;
  return temp;
}

#define MBIG 1000000000
#define MSEED 161803398
#define MZ 0
#define FAC (1.0/MBIG)
float ran3(idum)
     int idum;
{
  static int inext,inextp;
  static long ma[56];
  static int iff=0;
  long mj,mk;
  int i,ii,k;
  int temp;
  if (idum < 0 || iff == 0) {
    iff=1;
    mj=MSEED-(idum < 0 ? -idum : idum);
    mj %= MBIG;
    ma[55]=mj;
    mk=1;
    for (i=1;i<=54;i++) {
      ii=(21*i) % 55;
      ma[ii]=mk;
      mk=mj-mk;
      if (mk < MZ) mk += MBIG;
      mj=ma[ii];
    }
    for (k=1;k<=4;k++)
      for (i=1;i<=55;i++) {
	/* The original program has the line 
	**	ma[i] -= ma[1+(i+30) % 55];
	** which causes the i860 compiler to croak.
	** Therefore, this work-around.
	** Upinder S. Bhalla, Caltech, 1992
	*/
		temp=(i+30) % 55;
		temp++;
		ma[i] -= ma[temp];
		if (ma[i] < MZ) ma[i] += MBIG;
      }
    inext=0;
    inextp=31;
    idum=1;
  }
  if (++inext == 56) inext=1;
  if (++inextp == 56) inextp=1;
  mj=ma[inext]-ma[inextp];
  if (mj < MZ) mj += MBIG;
  ma[inext]=mj;
  return mj*FAC;
}
