static char rcsid[] = "$Id: sim_msg.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_msg.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:19:31  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

#define NSLOTS		20

/*
** msgs must be evaluated for validity after changing the
** enabled status of structure containing out messages
*/

MsgList *GetMsgListByName(object,name)
GenesisObject	*object;
char	*name;
{
MsgList	*list;
    
    /*
    ** look up the name in the object msg list
    */
    for(list=object->valid_msgs;list;list=list->next){
	if(strcmp(list->name,name) == 0){
	    return(list);
	}
    }
    return(NULL);
}

double DoubleMessageData(slot)
Slot *slot;
{
	return(*((double *)(slot->data)));
}

double FloatMessageData(slot)
Slot *slot;
{
	return((double)(*((float *)(slot->data))));
}

double IntMessageData(slot)
Slot *slot;
{
	return((double)(*((int *)(slot->data))));
}

double ShortMessageData(slot)
Slot *slot;
{
	return((double)(*((short *)(slot->data))));
}

double StringMessageData(slot)
Slot *slot;
{
	return((double)(Atof(slot->data)));
}

double VoidMessageData(slot)
Slot *slot;
{
	return(0.0);
}

#ifdef OLDMESSAGE
double MessageData(slot)
Slot *slot;
{
    switch(slot->type){
    case DOUBLE:
	return((double)(*((double *)(slot->data))));
	break;
    case FLOAT:
	return((double)(*((float *)(slot->data))));
	break;
    case INT:
	return((double)(*((int *)(slot->data))));
	break;
    case SHORT:
	return((double)(*((short *)(slot->data))));
	break;
    default:
	Error();
	printf("unrecognized data type of message field '%s'\n",
	slot->name);
	printf("probably a message slot left unspecified.\n");
	return((double)0.0);
	break;
    }
}
#endif
/*
** add a message specification to the source
*/
add_msg_usage(s)
char *s;
{
    printf("usage: %s from to msgtype msg ..\n",
    s);
    printf("\tmsg has the form:\n");
    printf("\t[variable_name] or [number]\n");
}

#ifndef OLDMESSAGE
DisplayMsgIn(msg_in)
MsgIn *msg_in;
{
int i;
int val;

    for(i=0;i<msg_in->nslots;i++){
	if(msg_in && msg_in->slot[i].name){
	    printf("< %s = ",
	    msg_in->slot[i].name);
	    val = (int)msg_in->slot[i].func;
	    if(val == (int) DoubleMessageData){
		printf("%g",*((double *)(msg_in->slot[i].data)));
	    } else
	    if(val == (int)FloatMessageData){
		printf("%g",*((float *)(msg_in->slot[i].data)));
	    } else
	    if(val == (int)IntMessageData){
		printf("%d",*((int *)(msg_in->slot[i].data)));
	    } else
	    if(val == (int)ShortMessageData){
		printf("%d",*((short *)(msg_in->slot[i].data)));
	    } else 
	    if(val == (int)StringMessageData){
		printf("%s",msg_in->slot[i].data);
	    }
	    printf(" > ");
	} else 
	break;
    }
}
#else
DisplayMsgIn(msg_in)
MsgIn *msg_in;
{
int i;

    for(i=0;i<msg_in->nslots;i++){
	if(msg_in && msg_in->slot[i].name){
	    printf("< %s = ",
	    msg_in->slot[i].name);
	    switch(msg_in->slot[i].type){
	    case DOUBLE:
		printf("%g",*((double *)(msg_in->slot[i].data)));
		break;
	    case FLOAT:
		printf("%g",*((float *)(msg_in->slot[i].data)));
		break;
	    case INT:
		printf("%d",*((int *)(msg_in->slot[i].data)));
		break;
	    case SHORT:
		printf("%d",*((short *)(msg_in->slot[i].data)));
		break;
	    case STRING:
		printf("%s",msg_in->slot[i].data);
		break;
	    }
	    printf(" > ");
	} else 
	break;
    }
}
#endif

MsgList *GetMsgListByType(type,object)
int	type;
GenesisObject	*object;
{
MsgList	*list;
	
    for(list=object->valid_msgs;list;list=list->next){
	if(list->type == type){
	    return(list);
	}
    }
    return(NULL);
}

ShowMsgIn(msg,object)
MsgIn *msg;
GenesisObject	*object;
{
int count = 0;
MsgList	*ml;
    if(msg == NULL){
	return(0);
    }
    for(;msg;msg=msg->next){
	ml=GetMsgListByType(msg->type,object);
	if (ml)
		printf("MSG %d from '%s' type [%d] '%s' ", 
			count,Pathname(msg->src),msg->type, ml->name);
	else
		printf("MSG %d from '%s' type [%d] '%s' ", 
			count,Pathname(msg->src),msg->type, "nil");
	DisplayMsgIn(msg);
	printf("\n");
	count++;
    }
    printf("\n");
}

ShowMsgOut(msg_out)
MsgOut *msg_out;
{
int count = 0;
int i;
MsgList	*ml;

    if(msg_out == NULL){
	return(0);
    }
    for(;msg_out;msg_out=msg_out->next){
	ml=GetMsgListByType(msg_out->msg_in->type,msg_out->dst->object);
	if (ml)
		printf("MSG %d to '%s' type [%d] '%s' ", 
		count, Pathname(msg_out->dst),
		msg_out->msg_in->type,ml->name);
	else
		printf("MSG %d to '%s' type [%d] '%s' ", 
		count, Pathname(msg_out->dst),
		msg_out->msg_in->type,"nil");
	DisplayMsgIn(msg_out->msg_in);
	printf("\n");
	count++;
    }
    printf("\n");
}

DeleteMsgIn(element,msg)
Element	*element;
MsgIn	*msg;
{
MsgIn	*ptr;
MsgIn	*prev;

    if(element == NULL) return(0);
    prev = NULL;
    for(ptr=element->msg_in;ptr;ptr=ptr->next){
	if(ptr == msg) break;
	prev = ptr;
    }
    if(ptr){
	/*
	** take the msgin out of the linked list
	*/
	if(prev == NULL){
	    element->msg_in = ptr->next;
	} else {
	    prev->next = ptr->next;
	}
	/*
	** free the msg
	*/
	if(ptr->slot)
	    sfree(ptr->slot);
	sfree(ptr);
    }
    return(1);
}

DeleteMsgOut(element,msgout)
Element	*element;
MsgOut	*msgout;
{
MsgOut	*ptr;
MsgOut	*prev;

    if(element == NULL) return(0);
    /*
    ** find the msgout on the src that references it 
    */
    prev = NULL;
    for(ptr=element->msg_out;ptr;ptr=ptr->next){
	if(ptr == msgout) break;
	prev = ptr;
    }
    if(ptr){
	/*
	** take the msgout out of the linked list
	*/
	if(prev == NULL){
	    /*
	    ** first item in the list
	    */
	    element->msg_out = ptr->next;
	} else {
	    prev->next = ptr->next;
	}
	/*
	** free the msg
	*/
	sfree(ptr);
    }
    return(1);
}

MsgOut *GetMsgOutByNumber(element,msgnum)
Element	*element;
int msgnum;
{
MsgOut	*msgout;
int	count = 0;

    if(element == NULL) return(NULL);
    /*
    ** find the msgout on the src that references it 
    */
    for(msgout=element->msg_out;msgout;msgout=msgout->next){
	if(count++ == msgnum) break;
    }
    return(msgout);
}

MsgIn *GetMsgInByNumber(element,msgnum)
Element	*element;
int msgnum;
{
MsgIn	*msgin;
int	count = 0;

    if(element == NULL) return(NULL);
    /*
    ** find the msgout on the src that references it 
    */
    for(msgin=element->msg_in;msgin;msgin=msgin->next){
	if(count++ == msgnum) break;
    }
    return(msgin);
}

MsgOut *GetMsgOutByMsgIn(element,msgin)
Element	*element;
MsgIn *msgin;
{
MsgOut	*msgout;

    if(element == NULL) return(NULL);
    /*
    ** find the msgout on the src that references it 
    */
    for(msgout=element->msg_out;msgout;msgout=msgout->next){
	if(msgout->msg_in == msgin) break;
    }
    return(msgout);
}


/*
** add a message to the destination
*/
AddMsgIn(dst,msg)
MsgIn **dst;
MsgIn *msg;
{
MsgIn *end;

    if(dst == NULL || msg == NULL) return(0);
    /*
    ** find the end of the destination message list
    */
    for(end = *dst;end && end->next;end=end->next);
    /*
    ** is this the first message?
    */
    if(end == NULL){
	*dst = msg;
    } else {
	end->next = msg;
    }
    return(1);
}

AddMsgOut(src,msg)
MsgOut **src;
MsgOut *msg;
{
MsgOut *end;

    if(src == NULL) return(0);
    /*
    ** find the end of the source message list
    */
    for(end = *src;end && end->next;end=end->next);
    /*
    ** is this the first message?
    */
    if(end == NULL){
	*src = msg;
    } else {
	end->next = msg;
    }
    return(1);
}

int CountMsgIn(msg)
MsgIn *msg;
{
int count = 0;
    if(msg == NULL){
	return(0);
    }
    for(;msg;msg=msg->next){
	count++;
    }
    return(count);
}

int CountMsgOut(msg)
MsgOut *msg;
{
int count = 0;
    if(msg == NULL){
	return(0);
    }
    for(;msg;msg=msg->next){
	count++;
    }
    return(count);
}

do_show_msg(argc,argv)
int argc;
char **argv;
{
Element 	*bptr;
char 		*elementname;
char 		*ptr;

    if(argc < 2){
	TraceScript();
	printf("usage: %s elementname\n",argv[0]);
	return;
    }
    elementname = argv[1];

    if((bptr = GetElement(elementname)) == NULL){
	TraceScript();
	printf("%s:  cannot find element '%s'\n",
	argv[0],
	elementname);
	return;
    }

    printf("\nINCOMING MESSAGES\n");
    ShowMsgIn(bptr->msg_in,bptr->object);
    printf("\nOUTGOING MESSAGES\n");
    ShowMsgOut(bptr->msg_out);
}

do_delete_msg(argc,argv)
int argc;
char **argv;
{
Element 	*element;
char 		*elementname;
char 		*ptr;
MsgIn		*msgin;
MsgOut		*msgout;
int		msgnum;
char		*msgmode;

    if(argc < 4){
	TraceScript();
	printf("usage: %s element [IN/OUT] msg#\n",argv[0]);
	return(0);
    }
    elementname = argv[1];

    if((element = GetElement(elementname)) == NULL){
	Error();
	printf("%s:  cannot find element '%s'\n",
	argv[0],
	elementname);
	return(0);
    }
    msgmode = argv[2];
    msgnum = atoi(argv[3]);

    if(strcmp(msgmode,"IN") == 0){
	if((msgin = GetMsgInByNumber(element,msgnum)) == NULL){
	    Error();
	    printf("could not get IN msg #%d from '%s'\n",
	    msgnum,
	    Pathname(element));
	    return(0);
	}
	if((msgout = GetMsgOutByMsgIn(msgin->src,msgin))== NULL){
	    Error();
	    printf("could not get OUT msg from '%s'\n",
	    Pathname(msgin->src));
	    return(0);
	}
	if(!DeleteMsgOut(msgin->src,msgout)){
	    printf("unable to delete msgout\n");
	    return(0);
	}
	if(!DeleteMsgIn(element,msgin)){
	    printf("unable to delete msgin\n");
	    return(0);
	}
    } else
    if(strcmp(msgmode,"OUT") == 0){
	if((msgout = GetMsgOutByNumber(element,msgnum)) == NULL){
	    Error();
	    printf("could not get OUT msg #%d from '%s'\n",
	    msgnum,
	    Pathname(element));
	    return(0);
	}
	if(!DeleteMsgIn(msgout->dst,msgout->msg_in)){
	    printf("unable to delete msgin\n");
	    return(0);
	}
	if(!DeleteMsgOut(element,msgout)){
	    printf("unable to delete msgout\n");
	    return(0);
	}
    } else {
	TraceScript();
	printf("must specify IN or OUT\n",argv[0]);
	return(0);
    }
    OK();
    return(1);
}

AssignSlotFunc(slot,slot_type)
Slot	*slot;
int	slot_type;
{
		switch(slot_type){
		case DOUBLE:
			slot->func = DoubleMessageData;
		break;
		case FLOAT:
			slot->func = FloatMessageData;
		break;
		case INT:
			slot->func = IntMessageData;
		break;
		case SHORT:
			slot->func = ShortMessageData;
		break;
		case STRING:
			slot->func = StringMessageData;
		break;
		case CHAR:
			slot->func = VoidMessageData;
		break;
		default:
		    fprintf(stderr,
		    "Unknown data type %d in a message argument\n",slot_type);
		    slot->func = VoidMessageData;
		break;
		}
}

void do_add_msg(argc,argv)
int 		argc;
char 		**argv;
{
char 		*ptr;
char 		*dst_path;
char 		*src_path;
char		*typename;
int		type;
ElementList	*src_list;
ElementList	*dst_list;
Element 	*src_element;
Element 	*dst_element;
short 		slot;
int		nxtarg;
Slot		sarray[NSLOTS];
struct mlist_type	*msgspec;
int		reqslots;
int		i,j,k;
double		number_value[100];
char		*str_value[100];
short		slot_type;

    /*
    ** check the syntax
    */
    if(argc < 5){
	TraceScript();
	add_msg_usage(argv[0]);
	return;
    }
    src_path = argv[1];
    dst_path = argv[2];
    typename = argv[3];
    src_list = WildcardGetElement(src_path,0);
    if(src_list->nelements == 0){
	InvalidPath(argv[0],src_path);
	FreeElementList(src_list);
	return;
    }
    dst_list = WildcardGetElement(dst_path,0);
    if(dst_list->nelements == 0){
	InvalidPath(argv[0],dst_path);
	FreeElementList(src_list);
	FreeElementList(dst_list);
	return;
    }
    for(k=0;k<dst_list->nelements;k++){
	dst_element = dst_list->element[k];
	/* 
	** get the msg type 
	*/
	if((msgspec = GetMsgListByName(dst_element->object,typename)) == NULL){
	    Error();
	    printf("%s is not a valid msg type for '%s'\n",
	    typename,
	    Pathname(dst_element));
	    return;
	}

	type = msgspec->type;
	reqslots = msgspec->slots;

	slot = 0;
	nxtarg = 3;
	/*
	** get the message specification information from the argument list
	*/
	while(++nxtarg < argc){
	    if(argv[nxtarg][0] == '*'){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    if(argv[nxtarg][0] == '\''){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    /*
		    ** find the trailing quote if any
		    */
		    if(strchr(argv[nxtarg]+1,'\'') != NULL){
			/*
			** and remove it
			*/
			*strchr(argv[nxtarg]+1,'\'') = '\0';
		    }
		    str_value[slot] = CopyString(argv[nxtarg]+1);
		    AssignSlotFunc(sarray+slot,STRING);
		    sarray[slot].name = "_string";
		    slot++;
		}
	    } else 
	    /* 
	    ** variable 
	    */
	    if(is_alpha(argv[nxtarg][0])){
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    sarray[slot].name = CopyString(argv[nxtarg]);
		    slot++;
		}
	    } else
	    /* 
	    ** number 
	    */
	    if(is_num(argv[nxtarg][0]) ||
	    (argv[nxtarg][0] == '.' && is_num(argv[nxtarg][1]))){ 
		if(slot >= NSLOTS){
		    Error();
		    printf("exceeded the maximum number of data slots\n");
		} else { 
		    number_value[slot] = Atof(argv[nxtarg]);
		    AssignSlotFunc(sarray+slot,DOUBLE);
		    sarray[slot].name = "_number";
		    slot++;
		}
	    } else {
		Error();
		add_msg_usage(argv[0]);
		return;
	    }
	}
	/*
	** check the number of slots filled against the number of
	** slots required
	*/
	if(slot != reqslots){
	    Error();
	    printf("msg type '%s' requires %d arguments.\n",
	    typename,reqslots);
	    return;
	}
	for(j=0;j<src_list->nelements;j++){
	    src_element = src_list->element[j];
	    /*
	    ** assign the element specific information to the message
	    */
	    for(i=0;i<reqslots;i++){
		if(sarray[i].name && (strcmp(sarray[i].name,"_string") == 0)){
		    sarray[i].data = CopyString(str_value[i]);
		} else 
		if(sarray[i].name && (strcmp(sarray[i].name,"_number") == 0)){
		    sarray[i].data = (char *)malloc(sizeof(double));
		    *((double *)(sarray[i].data)) = number_value[i];
		} else {
		    if((
		    sarray[i].data = 
		    GetFieldAdr(src_element,sarray[i].name,&slot_type)
		    ) == NULL){
			Error();
			printf("%s: could not find data field '%s' on '%s'\n",
			argv[0],
			sarray[i].name,
			Pathname(src_element));
			return;
		    }
			AssignSlotFunc(sarray+i,slot_type);
		}
	    }
	    AddMsg(src_element,dst_element,type,slot,sarray);
	}
    }
    FreeElementList(src_list);
    FreeElementList(dst_list);
    OK();
}

AddMsg(src_element,dst_element,type,nslots,sarray)
Element		*src_element;
Element		*dst_element;
int		type;
int		nslots;
Slot		*sarray;
{
MsgOut	*msg_out;
MsgIn	*msg_in;

    msg_in =	 	(MsgIn *)scalloc(1,sizeof(MsgIn));
    msg_in->src = 	src_element;
    msg_in->type = 	type;
    msg_in->nslots = 	nslots;

    /*
    ** copy in the slots
    */
    if(nslots > 0){
	msg_in->slot = (Slot *)scalloc(nslots,sizeof(Slot));
	bcopy(sarray,msg_in->slot,nslots*sizeof(Slot));
    }
    msg_out = 		(MsgOut *)scalloc(1,sizeof(MsgOut));
    msg_out->msg_in = 	msg_in;
    msg_out->dst = 	dst_element;
    if(AddMsgOut(&(src_element->msg_out),msg_out) == 0){
	Error();
	printf("could not add message to '%s'\n",
	Pathname(src_element));
	return;
    } else
    if(AddMsgIn(&(dst_element->msg_in),msg_in) == 0){
	Error();
	printf("could not add message to '%s'\n",
	Pathname(dst_element));
	return;
    }
}

char *do_getmsg(argc,argv)
int argc;
char **argv;
{
Element *element;
Element *msgindst;
char *msgmode;
int msgnum;
char *field;
MsgIn	*msgin = NULL;
MsgOut	*msgout = NULL;

    if(argc < 4){
	printf("usage: %s element IN/OUT [-count][index [type dst src]]\n",argv[0]);
	return(NULL);
    }
    if((element = GetElement(argv[1])) == NULL){
	InvalidPath(argv[0],argv[1]);
	return(NULL);
    }
    msgmode = argv[2];
    if(strcmp(argv[3],"-count") == 0){
	if(strcmp(msgmode,"IN") == 0){
	    return(itoa(CountMsgIn(element->msg_in)));
	}
	if(strcmp(msgmode,"OUT") == 0){
	    return(itoa(CountMsgOut(element->msg_out)));
	}
    }
    if(argc < 5){
	printf("usage: %s element IN/OUT [-count][index [type dst src]]\n",argv[0]);
	return(NULL);
    }
    msgnum = atoi(argv[3]);
    field = argv[4];

    if(strcmp(msgmode,"IN") == 0){
	if((msgin = GetMsgInByNumber(element,msgnum)) == NULL){
	    Error();
	    printf("could not get IN msg #%d from '%s'\n",
	    msgnum,
	    Pathname(element));
	    return(NULL);
	}
	msgindst = element;
    } else
    if(strcmp(msgmode,"OUT") == 0){
	if((msgout = GetMsgOutByNumber(element,msgnum)) == NULL){
	    Error();
	    printf("could not get OUT msg #%d from '%s'\n",
	    msgnum,
	    Pathname(element));
	    return(NULL);
	}
	msgin = msgout->msg_in;
	msgindst = msgout->dst;
    }
    /*
    ** check the field to return
    */
    if(strcmp(field,"type") == 0){
	if(msgin && msgindst){
	    return(
	    CopyString(GetMsgListByType(msgin->type,msgindst->object)->name));
	}
    } 
    if(strcmp(field,"src") == 0){
	if(msgin){
	    return(CopyString(Pathname(msgin->src)));
	}
    }
    if(msgout && strcmp(field,"dst") == 0){
	return(CopyString(Pathname(msgout->dst)));
    }
    return(NULL);
}
