static char rcsid[] = "$Id: sim_move.c,v 1.1.1.1 1993/07/21 21:32:47 dhb Exp $";

/*
** $Log: sim_move.c,v $
 * Revision 1.1.1.1  1993/07/21  21:32:47  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:19:17  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

/*
** check to see whether dst is a child of src
*/
ValidHierarchy(src,dst)
Element	*src;
Element	*dst;
{
Element	*ptr;

    for(ptr=dst;ptr;ptr=ptr->parent){
	if(ptr == src){
	    return(0);
	}
    }
    return(1);
}

do_move(argc,argv)
int		argc;
char		**argv;
{
short 		nxtarg;
char 		*src;
char 		*dst;
Element		*src_element;
Element		*dst_element;
Element		*new_element;
int		srcfound;
int		dstfound;
char		*new_name;
char		*dst_path;
int		new_index;
char		*ptr;

    if(argc < 3){
	printf("usage: %s src_element [to] dst_element\n",
	argv[0]); 
	return;
    }
    nxtarg = 0;
    srcfound = 0;
    dstfound = 0;
    new_name = NULL;

    /*
    ** locate the src/dst and the multiplier
    */
    while(++nxtarg < argc){
	if(!srcfound){
	    srcfound = 1;
	    src = argv[nxtarg];
	    continue;
	} else
	if(!dstfound){
	    if(strcmp(argv[nxtarg],"to") == 0){
		continue;
	    }
	    dstfound = 1;
	    dst = argv[nxtarg];
	    continue;
	} 
    }
    if((src_element = GetElement(src)) == NULL){
	Error();
	printf("could not find src element '%s'\n",src);
	return;
    }
    if((dst_element = GetElement(dst)) == NULL){
	/*
	** try and find the parent and use the base as the
	** name of the copy
	*/
	if(strlen(dst_path = GetParentComponent(dst)) == 0){
	    dst_path = ".";
	}
	if((dst_element = GetElement(dst_path)) == NULL){
	    Error();
	    printf("invalid copy destination '%s'\n",dst);
	    return;
	}
	/*
	** if the parent was found then use the base as the
	** new name of the copy
	*/
	new_name = GetBaseComponent(dst);
	new_index = GetTreeCount(new_name);
	if(ptr = strchr(new_name,'[')){
	    *ptr = '\0';
	}
    }
    if(!ValidHierarchy(src_element,dst_element)){
	Error();
	printf("cant move an element into itself\n");
	return;
    }
    /*
    ** detach the element from its current parent
    */
    if((DetachElement(src_element)) == NULL){
	Error();
	printf("could not move %s to %s\n",src,dst);
	return;
    }
    /*
    ** assign the new name
    */
    if(new_name){
	Name(src_element,new_name);
	src_element->index = new_index;
    }
    /*
    ** attach the new element to the destination
    */
    Attach(dst_element,src_element);
    OK();
}
