static char rcsid[] = "$Id: sim_method.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_method.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:18:48  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

/*
** Setting integration methods. The method is stored in the method
** field of the object associated with each element. 
*/

do_set_method(argc,argv)
int	argc;
char	**argv;
{
ElementList	*list;
char		**arglist;
Element		**elms;
int		i,j;
short	method;
GenesisObject	*new_obj,*old_obj;

    if(argc < 2){
		printf("usage: %s [path] method\n",argv[0]);
		printf("If no path is specified then the method is globally changed\n");
		return;
    }
	if (argc == 2) { /* Global change of method */
		method = atoi(argv[1]);
		if (!check_method(method)) return;
		/*
		** Scan through all elements recursively to set their
		** object->method
		** fields. This will have to be changed for parallelising.
		*/
		SetIntMethods(RootElement(),method);
	} else { /* changing method on path */
		method = atoi(argv[2]);
		if (!check_method(method)) return;
		list = WildcardGetElement(argv[1],0);
		elms = list->element;
		/*
		** Algorithm : identify the object for each entry in the list
		** and duplicate it with the new method. Scan the remainder of
		** the list for identical objects and replace them with the
		** duplicate. Null out elements on the list which have had
		** their method changed in this way.
		** 
		** First, scan element list for non-null entries
		*/
		for(i=0;i<list->nelements;i++) {
			if (elms[i]) {
				old_obj=elms[i]->object;
				/* 
				** A little bit of space stinginess : don't bother
				** with altering the neutrals in the path
				*/
				if (strcmp(old_obj->name,"neutral")==0)
					continue;
				/*
				** A bit more stinginess : if the old method is the
				** same as the new one, dont bother
				*/
				if (old_obj->method == method)
					continue;

				/*
				** If the method is an implicit one, only apply it to
				** hsolve elements.
				*/
				if (method >= BEULER_INT) {
					if (strcmp(old_obj->name,"hsolve") != 0)
						continue;
				}
				/*
				** If the method must be changed, make a copy of the
				** object, with only the method altered.
				*/
				new_obj=(GenesisObject *)malloc(sizeof(GenesisObject));
				bcopy(old_obj,new_obj,sizeof(GenesisObject));
				new_obj->method = method;
				/*
				** Scan the rest of the list for identical old objects,
				** swapping for the new ones and nulling out the entries
				** on the elmlist.
				*/
				for(j=i;j<list->nelements;j++) {
					if (elms[j] && elms[j]->object == old_obj) {
						elms[j]->object = new_obj;
						elms[j] = NULL;
					}
				}
			}
		}
		FreeElementList(list);
	}
}

SetIntMethods(elm,method)
	Element	*elm;
	short	method;
{
	Element *child;

	if ((method != BEULER_INT && method != CRANK_INT) || strcmp(elm->object->name,"hsolve") == 0)
		elm->object->method = method;
	for(child=elm->child;child;child=child->next)
		SetIntMethods(child,method);
}

int check_method(method)
	short method;
{
	if (IsSilent() < 1) {
		switch(method) {
			case FEULER_INT : printf("Forward Euler\n");
				break;
			case EEULER_INT : printf("Exponential Euler\n");
				break;
			case GEAR_INT : printf("Gear\n");
				break;
			case AB2_INT : printf("Adams-Bashforth 2-step\n");
				break;
			case AB3_INT : printf("Adams-Bashforth 3-step\n");
				break;
			case TRAPEZOIDAL_INT : printf("Trapezoidal\n");
				break;
			case AB4_INT : printf("Adams-Bashforth 4-step\n");
				break;
			case AB5_INT : printf("Adams-Bashforth 5-step\n");
				break;
			case RK_INT : printf("Runge-Kutta\n");
				break;
			case BEULER_INT : printf("Backward Euler. Note : applies only to hsolve elements\n");
				break;
			case CRANK_INT : printf("Crank-Nicolson. Note : applies only to hsolve elements\n");
				break;
			case EPC_INT : printf("Euler predictor-corrector : not yet implemented\n");
			default : 
				printf("Valid methods :\n");
				printf("-1	: Forward Euler\n");
				printf("0	: Exponential Euler\n");
				printf("1	: Gear\n");
				printf("2	: Adams-Bashforth 2-step\n");
				printf("3	: Adams-Bashforth 3-step\n");
				printf("4	: Trapezoidal\n");
				printf("5	: Adams-Bashforth 4-step\n");
				printf("6	: Adams-Bashforth 5-step\n");
				printf("7	: Runge-Kutta\n");
				printf("10	: Backward Euler - only for hsolve elements\n");
				printf("11	: Crank-Nicolson - only for hsolve elements\n");
				return(0);
				break;
		}
	}
	return(1);
}
