static char rcsid[] = "$Id: sim_map.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_map.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:17:29  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

void do_create_map(argc,argv)
int 	argc;
char 	**argv;
{
Element 	*element;
Element 	*parent;
int 		nx,ny;
float 		wdx,wdy;
float 		wxmin,wymin;
Element 	*new_parent;
char 		name[100];
char		*elementname;
char		*parentname;
int		srcfound = 0;
int		dstfound = 0;
int		nxtarg;
int		index;
char		*ptr;

    if(argc < 5){
	printf("usage: %s [of] src [on] dst Nx Ny [wdx wdy][wxmin wymin]\n",
	argv[0]);
	return;
    }
    nxtarg = 0;
    while(++nxtarg < argc){
	if(!srcfound){
	    if(strcmp(argv[nxtarg],"of") == 0) continue;
	    elementname = argv[nxtarg];
	    srcfound = 1;
	    continue;
	} else
	if(!dstfound){
	    if(strcmp(argv[nxtarg],"on") == 0) continue;
	    parentname = argv[nxtarg];
	    dstfound = 1;
	    continue;
	} else
	break;
    }
    /*
    ** find the element used to fill the map
    */
    element = GetElement(elementname);
    /*
    ** find the parent element to attach the elements to
    */
    parent = GetElement(parentname);
    /*
    ** if no such parent exists
    */
    if(parent == NULL){
	/*
	** try to create it using the next level up on the tree as
	** the new parent for the parent
	*/
	strcpy(name,GetParentComponent(parentname));
	new_parent = GetElement(name);
	/*
	** if some place to attach the parent was found then go ahead
	** and create the parent
	*/
	if(new_parent != NULL){
	    strcpy(name,GetBaseComponent(parentname));
	    index = GetTreeCount(name);
	    if(ptr = strchr(name,'[')){
		*ptr = '\0';
	    }
	    parent = Create("neutral",name,new_parent,NULL,index);
	} else {
	    Error();
	    printf("could not create element %s\n",name);
	    return;
	}
    }
    /*
    ** set the map parameters
    */
    nx = atoi(argv[nxtarg++]);
    ny = atoi(argv[nxtarg++]);
    if(nxtarg < argc ){
	wdx = Atof(argv[nxtarg++]);
	wdy = Atof(argv[nxtarg++]);
    } else {
	wdx = 1.0;
	wdy = 1.0;
    }
    if(nxtarg < argc ){
	wxmin = Atof(argv[nxtarg++]);
	wymin = Atof(argv[nxtarg++]);
    } else {
	wxmin = 0.0;
	wymin = 0.0;
    }
    /*
    ** make the map
    */
    if(!CreateMap(parent,element,nx,ny,wdx,wdy,wxmin,wymin)){
	Error();
	printf("unable to create map\n");
	return;
    }
    OK();
}

/*
** allocate a 2 dimensional map grid
*/
Element ***CreateGrid(nx,ny)
int nx,ny;
{
Element ***grid;
int i;

	grid = (struct element_type ***)
	malloc(sizeof(struct element_type **)*ny);
	for(i=0;i<ny;i++){
		grid[i] = (struct element_type **)
		malloc(sizeof(struct element_type *)*nx);
	}
	return(grid);
}

/*
** create a 2 dimensional map of elements
*/
CreateMap(parent,element,nx,ny,dx,dy,wxmin,wymin)
Element *parent;
Element *element;
int nx,ny;
float dx,dy;
float wxmin,wymin;
{
Element *last_element;
Element *new_element;
struct map_type *map;
int i,j;

    /*
    ** check for valid parameters
    */
    if(element == NULL || parent == NULL || 
    nx < 1 || ny < 1 || dx < 0 || dy < 0){
	return(0);
    }
#ifdef LATER	/* add the map grid to the elements */
    /*
    ** create the map structure
    */
    map = (struct map_type *)malloc(sizeof(struct map_type));
    /*
    ** fill in the map parameters
    */
    map->xmax = nx-1;
    map->ymax = ny-1;
    map->dx = dx;
    map->dy = dy;
    map->wxmin = wxmin;
    map->wymin = wymin;
    /*
    ** allocate the grid
    */
    map->grid = CreateGrid(nx,ny);
#endif
    /*
    ** fill the grid
    */
    last_element = parent->child;
    for(i=0;i<ny;i++){
	for(j=0;j<nx;j++){
	    /*
	    ** make a copy of the element and all its sub elements
	    */
	    new_element = CopyElementTree(element);
	    /*
	    ** set the default positions to the grid coordinates
	    */
	    PositionElement(new_element, j*dx + wxmin, i*dy + wymin,element->z);
	    /*
	    ** attach the new element to the parent
	    ** this needs to be optimized
	    */
	    AttachToEnd(parent,last_element,new_element);
	    if(last_element == NULL){
		new_element->index = 0;
	    } else {
		new_element->index = last_element->index+1;
	    }
	    last_element = new_element;
	    CopyConnections(element,new_element);
	    /*
	    ** copy the msgs between elements
	    */
	    CopyMsgs(element,new_element);
#ifdef LATER	/* add the map grid to the elements */
	    /*
	    ** place the element into the grid
	    */
	    map->grid[i][j] = new_element;
	    /*
	    ** attach the map to the element
	    */
	    new_element->map = map;
#endif
	}
    }
    /*
    ** return 1 to indicate success
    */
    return(1);
}
