static char rcsid[] = "$Id: sim_malloc.c,v 1.2 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_malloc.c,v $
 * Revision 1.2  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:16:27  dhb
 * Initial revision
 *
*/

#include <stdio.h>
/* mds3 changes */
#include "system_deps.h"

/*
** this blocksize is important in that it avoids a nasty
** bug in the DEC malloc routine which wastes large amounts
** of memory when allocating blocks smaller than this
*/
#define BLOCKSIZE 256000
struct mem_chunk {
    char		*adr;
    struct mem_chunk	*next;
};

/*
** start_chunk 
**	points to the beginning of the memory allocation table
**	this table consists of a linked list of table entries. Each entry
**	points to a block of memory given by BLOCKSIZE
** current_chunk 
**	points to the beginning of the current allocation table entry.
** current_ptr 
**	points to the beginning of the current memory block being allocated.
** current_offset
**	gives the offset of the next allocatable memory location in the current 
**	memory block.
*/
static struct mem_chunk start_chunk = { NULL,NULL};
static struct mem_chunk *current_chunk = &start_chunk;
static char *current_ptr = NULL;
static int current_offset = 0;

/*
** return the amount of memory currently allocated by smalloc
*/
int smalloc_used()
{
struct mem_chunk *ptr;
int	size;

    /*
    ** count all the allocated blocks
    */
    for(ptr = &start_chunk;ptr;ptr=ptr->next){
	size += BLOCKSIZE;
    }
    size -= BLOCKSIZE + current_offset;
    return(size);
}

/*
** allocate a new memory allocation table
*/
void init_smalloc()
{
    current_chunk = &start_chunk;
    current_ptr = current_chunk->adr = (char *)malloc(BLOCKSIZE);
    current_chunk->next = NULL;
    current_offset = 0;
}

/*
** allocate a block of memory. This memory can only be freed
** using the sfree_all function which frees all blocks allocated
** using the smalloc function.
** This malloc has minimal housekeeping overhead and is therefore
** quite efficient when dealing with once-only allocations
** particularly of many small blocks
*/
char *smalloc(size)
int size;
{
char *ptr;

    if(current_offset + size >= BLOCKSIZE){
	/*
	** this chunk is full so allocate another
	*/
	current_chunk->next=(struct mem_chunk*)malloc(sizeof(struct mem_chunk));
	current_chunk = current_chunk->next;
	current_chunk->next = NULL;
	current_ptr = current_chunk->adr = (char *)malloc(BLOCKSIZE);
	current_offset = 0;
    }
    /*
    ** return the memory
    */
    ptr = current_ptr + current_offset;
    current_offset += size;
    return(ptr);
}

/*
** allocate and zero a block
*/
char *scalloc(n,size)
int n;
int size;
{
char *ptr;

    ptr = smalloc(n*size);
    bzero(ptr,n*size);
    return(ptr);
}

/*
** place holder function for 
** individual block freeing which does nothing
** since this would require additional housekeeping overhead
** which is best left to malloc
*/
int sfree(ptr)
char *ptr;
{
}

/*
** free all memory in the allocation table
*/
int sfreeall()
{
struct mem_chunk *ptr;

    /*
    ** free all the allocated blocks
    */
    for(ptr = &start_chunk;ptr;ptr=ptr->next){
	free(ptr->adr);
	free(ptr);
    }
    /*
    ** reinitialize the allocator
    */
    init_smalloc();
}

#undef BLOCKSIZE
