static char rcsid[] = "$Id: sim_main.c,v 1.3 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_main.c,v $
 * Revision 1.3  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.2  1993/07/16  23:43:16  dhb
 * Version change to 1.4.1
 *
 * Revision 1.1  1992/10/27  20:15:31  dhb
 * Initial revision
 *
*/

#include "sim.h"
#ifdef sgi
#include <malloc.h>
#endif
#include <setjmp.h>
/* Modified Feb 1992 by Upi Bhalla: added silent flag to command line */

char	**global_envp;
jmp_buf main_context;

DisplayHeader()
{
printf("   ==========================================================================\n");
printf("                                  G E N E S I S\n");
printf("                              Release Version: %s\n\n", VERSIONSTR);
printf("                    Copyright 1988, 1989, 1990, 1991, 1992, 1993\n");
printf("                      California Institute of Technology\n");
printf("   ==========================================================================\n\n");
}

usage(s)
char *s;
{
    printf("usage : %s [-usage][-nosimrc][-nosig][-load][-batch][-status][script arg1 ...]\n",s);
}

main (argc, argv,envp)
int     argc;
char   *argv[];
char	**envp;
{
short     i,nxtarg;
extern	int	SetBreakFlag();
FILE	*pfile;
char	*pname;
int	file_arg;
char simfile[100];
short catch = 1;
char *home;
char string[100];
char *getenv();
int status_line=0;
int use_simrc;
char simrc_name[100];

#ifdef sgi
    mallopt(M_KEEP, 1);
#endif

    nxtarg = 0;
    use_simrc = 1;
	strcpy(simrc_name,".simrc");
    global_envp = envp;
    pname = NULL;
    while(++nxtarg < argc){
	if(arg_is("-load")){
	    EnableDynamicLoad();
	} else 
	if(arg_is("-defout")){
	    freopen(argv[++nxtarg],"w",stdout);
	} else 
	if(arg_is("-nosig")){
	    catch = 0;
	} else 
	/* Upi Modification Feb 1992 
	** Level 0,1 : Same effects as before
	** Level 2   : Silences the startup stuff, on all nodes.
	** Level 3   : (for parallel machines) All but node 0 are silent
	*/
	if(arg_is("-silent")){
	    nxtarg++;
	    SetSilent(atoi(argv[nxtarg]));
	} else 
	if(arg_is("-batch")){
	    SetBatchMode(1);
	} else 
	if(arg_is("-status")){
	    status_line = 1;
	} else 
	if(arg_is("-nosimrc")){
	    use_simrc = 0;
	} else 
	if(arg_is("-altsimrc")){
		nxtarg++;
		strcpy(simrc_name,argv[nxtarg]);
	} else 
	if(arg_is("-usage")){
	    usage(argv[0]);
	    exit(0);
	} else {
	    pname = argv[nxtarg];			
	    file_arg = nxtarg;
	    break;
	}
    }
    /* Moved down - Upi Feb 92 */
    if (IsSilent()<1) {
    	printf("Starting Genesis\n");
    	fflush(stdout);
    }

    /*
    ** get input from stdin
    */
    if(!IsBatchMode()){
	SetScript(stdin,0,NULL,0);
	if (IsSilent() < 2)
	    DisplayHeader();
    }

    /*
    ** initialize the command interpreter
    */
    SetDefaultPrompt("genesis #!");
	set_float_format("%0.10g");
	sim_set_float_format("%0.10g");

    if(!SetupInterp(argv[0])){
    	if (IsSilent() < 2) {
	    printf("Unable to find the simulator. ");
	    printf("Check your PATH environment variable\n");
	}
	exit(0);
    };

    /*
    ** initialization for the base simulator
    */
    SimStartup();

    sleep(2);

    /*
    ** load the symbolic information for the rest of the libraries
    */
    LOAD_LIBRARIES();

    /*
    ** if a script has been specified on the command line
    ** then read it in
    ** using the remaining command line args as args to the file
    */
    if(pname != NULL) {
	if((pfile=SearchForScript(pname,"r")) == NULL){
	    Error();
    	    if (IsSilent() < 2) 
	   	 printf("can't open parameter file %s\n",pname);
	} else {
	    if(IsSilent()<1) printf("%-20s%s\n","Simulation Script:",pname);
	    /*
	    ** try reading from the parameter file
	    */
	    AddScript(pfile,argc - file_arg,argv + file_arg,0);
	    /*
	    SetScript(pfile,argc - file_arg,argv + file_arg,0);
	    Interpreter(-1);
	    */
	}
    }

    /*
    ** try reading from the startup file
    */
    if(use_simrc){
	/*
	** first try and find it locally
	*/
	strcpy(string,simrc_name);
	if((pfile=fopen(string,"r")) == NULL){
	    /*
	    ** else try and find it in the home directory
	    */
	    if(home = getenv("HOME")){
		sprintf(string,"%s/%s",home,simrc_name);
		pfile=fopen(string,"r");
	    }
	}
	if(pfile){
	    if(IsSilent()<1) printf("%-20s%s\n","Startup script:",string);
	    /*
	    * get input from .simrc
	    */
	    AddScript(pfile,0,NULL,0);
	}
    }
    /*
    ** if it is batch mode then dont bother going into
    ** interactive mode
    */
    if(!IsBatchMode()){
	if(status_line){
	    EnableStatusLine();
	}

	/*
	** put the terminal into non-blocking custom io mode
	*/
	terminal_setup();
	/*
	** set the return point for context jumps
	*/
	if(setjmp(main_context) != 0){
	    /*
	    ** coming back from a longjump
	    */
	    ClearScriptStack();
	    RemoveSimulationJob();
	    tset();
	}

	ParseInit();

	if(catch){
	    SetSignals();
	}
	/*
	** go to the interactive interpreter level
	*/
    }
    EnableHistory(1);
    AlternatePrompt(NULL);
    Interpreter(-1);
}

