static char rcsid[] = "$Id: sim_hash.c,v 1.2 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_hash.c,v $
 * Revision 1.2  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:08:06  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"
#include "hash.h"

HASH *object_hash_table;

/*
** Hash table utilities
*/
void ObjectHashInit()
{
HASH *hash_create();

	/*
	* create the table
	*/
	object_hash_table = hash_create(2000);
}

int ObjectHashPut(object)
GenesisObject *object;
{
ENTRY	item,*hash_enter();

    item.data = (char *)calloc(1,sizeof(GenesisObject));
    bcopy(object,item.data,sizeof(GenesisObject));
    item.key = (char *)(((GenesisObject *)(item.data))->name);
    /*
    ** put the object into the table
    */
    if(hash_enter(&item,object_hash_table) == NULL){
	Error();
	printf("hash table full\n");
	return(0);
    };
    return(1);
}

GenesisObject *ObjectHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

    /*
    ** get the object from the table
    */
    if((found_item = hash_find(key,object_hash_table)) != NULL){
	return((GenesisObject *)found_item->data);
    } else
	return(NULL);
}

