static char rcsid[] = "$Id: sim_get.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_get.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:06:52  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

Element *GetElement(pathname)
char *pathname;
{
Element 	*element;
char 		*tree_ptr;
char 		*name;
int		count;
char 		*GetTreeName();
char 		*AdvancePathname();

    /*
    ** start at the root?
    */
    if(pathname[0] == '/') {
	element = RootElement();
	tree_ptr = pathname+1;
    } else {
	element = WorkingElement();
	tree_ptr = pathname;
    }

    while(*tree_ptr != '\0' && element != NULL){
	name = GetTreeName(tree_ptr);
	count = GetTreeCount(tree_ptr);
	if(strcmp(name,"..") == 0){
	    /*
	    ** parent element
	    */
	    element = element->parent;
	} else 
	if(strcmp(name,".") == 0){
	    /*
	    ** current element
	    */
	    element = element;
	} else 
	if(strcmp(name,"^") == 0){
	    /*
	    ** current element
	    */
	    element = RecentElement();
	} else {
	    element = (Element *)GetChildElement(element,name,count);
	}
	tree_ptr = AdvancePathname(tree_ptr);
    }
    return(element);
}

char *GetConnectionField(projection,connection,field)
Projection *projection;
Connection *connection;
char	*field;
{
char *str;
int	status;

    if((str = FieldValue(connection,projection->connection_object,field)) == NULL){
	Error();
	printf("could not find field '%s'\n",field);
	str = "???";
    }
    return(CopyString(str));
}

char *do_getfield(argc,argv)
     int argc;
     char **argv;
{
  char 		*pathname;
  char 		*value;
  char 		*field;
  Element 	*element;
  int		get_connections = 0;
  ElementList	*targetlist;
  int		start_connection,end_connection;
  Projection	*projection;
  Connection	*connection;
  char		*do_getelementenv();
/* Dale Fay's additions */  
  char *char_ptr;
  char *return_char_ptr;
  if(argc < 2){
    printf("usage: %s [-env] pathname field\n", argv[0]);
    return(NULL);
  }
/* Dale Fay's bug fix */
/*To prevent the pointer at argv[0] from being freed twice */
  if(strcmp(argv[1],"-env") == 0){
    char_ptr = argv[1];
    argv[1] = argv[0];
    argc--;
    return_char_ptr = do_getelementenv(argc,argv+1);
    argv[1] = char_ptr;
    return(return_char_ptr);
  }
  
/*
**    if(strcmp(argv[1],"-env") == 0){
**	argv[1] = argv[0];
**	argc--;
**	return(do_getelementenv(argc,argv+1));
**    }
*/
    pathname = argv[1];
    field = argv[2];
    /*
    ** check for a connection
    */
    targetlist = NULL;
    get_connections = 
    ParseConnection(pathname,&start_connection,&end_connection,&targetlist);
    if(targetlist && targetlist->nelements < 1){
	Error();
	printf("empty connection target path specification\n");
	return(NULL);
    }
    if(targetlist && targetlist->nelements > 1){
	Error();
	printf("cannot get multiple fields\n");
	return(NULL);
    }
    if((element = GetElement(pathname)) ==NULL){
	Error();
	printf("could not find '%s'\n",pathname);
	return(NULL);
    }
    if(!get_connections){
	value = FieldValue(element,element->object,field);
	if(value == NULL) {
	    /*
	    ** if its not a regular field try the environment
	    */
	    if((value = do_getelementenv(argc,argv)) == NULL){
		Error();
		printf("could not get the value for '%s'\n",field);
		return(NULL);
	    }
	}
    } else {
	/*
	** connection
	*/
	if(!CheckClass(element,PROJECTION_ELEMENT)){
	    Error();
	    printf("'%s' is not a projection.\n",Pathname(element)); 
	    printf("Must specify a projection to set connections\n");
	    return(NULL);
	}
	projection = (Projection *)element;
	if(projection->connection_object == NULL){
	    Error();
	    printf("invalid connection from '%s'\n",Pathname(projection));
	    return(NULL);
	}
	if(get_connections == 1){
	    if((connection = 
	    GetConnection(projection,start_connection)) == NULL){
		Error();
		printf("unable to find connection %d on '%s'\n",
		start_connection,
		Pathname(projection));
		return(NULL);
	    }
	    value = GetConnectionField(projection,connection,field);
	} else 
	if(get_connections == 2){
	    Error();
	    printf("cannot get multiple fields\n");
	    return(NULL);
	} else
	if(get_connections == 3){
	    Error();
	    printf("cannot get multiple fields\n");
	    return(NULL);
	} else
	if(get_connections == 4){
	    for(connection=projection->connection;connection;
	    connection=connection->next){
		if(connection->target ==
		(Segment *)(targetlist->element[0])){
		    value = GetConnectionField(projection, connection,field);
		    break;
		}
	    }
	}
    }
    if(targetlist){
	FreeElementList(targetlist);
    }
    return(CopyString(value));
}
