static char rcsid[] = "$Id: sim_estack.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_estack.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:01:06  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

#define STK_SIZE	100

static Element	*element_stk[STK_SIZE];
static short	sp;


Element *pop_element()
{
    if(--sp >= 0){
	return(element_stk[sp]);
    } else 
    {
	Error();
	printf("empty element stack\n");
	sp = 0;
	return(NULL);
    }
}

int push_element(element)
Element	*element;
{
    if(element == NULL){
	return(0);
    }
    element_stk[sp] = element;
    if(++sp > STK_SIZE){
	Error();
	printf("element stack overflow '%s'\n",element->name);
	sp = STK_SIZE;
	return(0);
    }
    return(1);
}

void do_show_estack(argc,argv)
int argc;
char **argv;
{
int i;

    for(i=0;i<sp;i++){
	printf("%s\n",Pathname(element_stk[i]));
    }
}

void do_pushe(argc,argv)
int 	argc;
char 	**argv;
{
Element *element;

    if(argc > 1){
	element = GetElement(argv[1]);
	if(element == NULL){
	    printf("cant find element '%s'\n",argv[1]);
	    return;
	}
    } else {
	element = WorkingElement();
    }
    push_element(WorkingElement());
    SetWorkingElement(element);
    if(IsSilent()<1)
	printf("%s\n",Pathname(element));
}

void do_pope(argc,argv)
int 	argc;
char 	**argv;
{
Element *element;

    element = pop_element();
    if(element != NULL){
	SetWorkingElement(element);
	if(IsSilent()<1)
	    printf("%s\n",Pathname(element));
    }
}
