static char rcsid[] = "$Id: sim_elemlist.c,v 1.2 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_elemlist.c,v $
 * Revision 1.2  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:00:48  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

#define LIST_RESIZE	100

/*
** public functions are:
**
** 	CreateElementList(size)
** 	AddElementToList(element,list)
** 	FreeElementList(list)
*/

ElementList *CreateElementList(size)
int	size;
{
ElementList *list;

    list = (ElementList *) calloc(1,sizeof(ElementList));
    ExpandElementList(size,list);
    return(list);
}

AddElementToList(element,list)
Element 	*element;
ElementList 	*list;
{
    if(list != NULL){
	/*
	** advance the nelements count
	*/
	IncrementElementList(list);
	/*
	** attach the element
	*/
	list->element[list->nelements-1] = element;
    }
}

FreeElementList(list)
ElementList	*list;
{
    if(list){
	if(list->element){
	    free(list->element);
	}
	if(list->function){
	    free(list->function);
	}
	free(list);
    }
}

static IncrementElementList(list)
ElementList *list;
{
    if(list != NULL){
	if(list->nelements >= list->size){
	    ExpandElementList(LIST_RESIZE,list);
	}
	list->nelements++;
    }
}

static ExpandElementList(expansion_size,list)
ElementList 	*list;
int 		expansion_size;
{
Element 	**new_element;
int		i;

    if(list != NULL){
	/*
	** allocate the new element pointer array
	*/
	if(list->element){
	    list->element  = (Element **)
	    realloc(list->element,
	    sizeof(Element *)*(list->size += expansion_size));
	} else {
	    list->element  = (Element **)
	    calloc(1, sizeof(Element *)*(list->size += expansion_size));
	}
    }
}

