static char rcsid[] = "$Id: sim_element.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_element.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  20:00:15  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

Element *GetChildElement(element,name,count)
Element *element;
char	*name;
int	count;
{
Element *child;

    for(child=element->child;child;child=child->next){
	if(name == NULL || strcmp(child->name,name) ==0){ 
#ifdef OLD
	    if(--count < 0)
		return(child);
#else
	    if(child->index == count)
		return(child);
#endif
	}
    }
    return(NULL);
}

IsElementWithinRegion(element,mask,nmasks)
Element 	*element;
struct mask_type *mask;
int nmasks;
{
register float x,y;
register struct mask_type *ptr;

    /*
    ** if no masks are specified then assume that is within the region
    */
    if(nmasks == 0) return(1);
    /*
    ** search the mask list from the bottom up
    ** if the element is bounded by a mask then
    ** it will possess that sign and no further search is 
    ** necessary
    */
    x = element->x;
    y = element->y;
    ptr = mask + nmasks-1;
    do{
	if( 
	x >= ptr->xl && 
	x <= ptr->xh &&
	y >= ptr->yl && 
	y <= ptr->yh){
	    return(ptr->type == 1);
	}
    } while(ptr-- != mask);
    return(0);
}

IsElementWithinRegionRel(element,mask,nmasks,relx,rely)
Element		*element;
struct mask_type *mask;
int nmasks;
float relx,rely;
{
register float x,y;
register struct mask_type *ptr;

    /*
    ** if no masks are specified then assume that is within the region
    */
    if(nmasks == 0) return(1);
    /*
    ** search the mask list from the bottom up
    ** if the element is bounded by a mask then
    ** it will possess that sign and no further search is 
    ** necessary
    */
    x = element->x - relx;
    y = element->y - rely;
    ptr = mask + nmasks-1;
    do{
	if( 
	x >= ptr->xl && 
	x <= ptr->xh &&
	y >= ptr->yl && 
	y <= ptr->yh){
	    return(ptr->type == 1);
	}
    } while(ptr-- != mask);
    return(0);
}

int do_exists(argc,argv)
int	argc;
char **argv;
{
Element *element;
int	status;
char	*do_getelementenv();

    if(argc < 2){
	printf("usage: %s element [field]\n",argv[0]);
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	return(0);
    }
    if(argc > 2){
	GetFieldStr(element,Type(element),argv[2],&status);
	if(!status){
	    /*
	    ** check the environment variables
	    */
	    status = (do_getelementenv(argc,argv) != NULL);
	}
	return(status);
    }
    return(1);
}
