/*
** $Id: sim_defs.h,v 1.1 1992/10/27 21:19:36 dhb Exp $
** $Log: sim_defs.h,v $
 * Revision 1.1  1992/10/27  21:19:36  dhb
 * Initial revision
 *
*/

#define FLOATTIME
#define VERSION		1.41
#define	VERSIONSTR	"1.4.1"

/*
** bit usage of the element flag (16 bits)
** 0-4		5 bits		clock
** 5-6		2 bits 		enable
** 7		1 bit 		internal marker
** 8		1 bit		local disable for hsolve.
** 8-12		4 bits 		reserved for future expansion
** 12-15	4 bits 		user
*/
#define CLOCKMASK		0x1F
#define BLOCKMASK		0x20
#define VISIBILITYMASK		0x40
#define MARKERMASK		0x80
#define USERMASK		0xF0
#define USERBITSHIFT		12
#define HSOLVEMASK		0x0100

/*
** usable flags = 0-3
*/
#define SetElementFlag(E,N) (E)->flags |= (1<<(N + USERBITSHIFT))
#define ClearElementFlag(E,N) (E)->flags &= ~(1<<(N + USERBITSHIFT))
#define CheckElementFlag(E,N) (((E)->flags & (1<<(N + USERBITSHIFT))) != 0)

/*
** pre-defined classes
*/
#define	INVALID_CLASS		0
#define	ELEMENT_ELEMENT		1
#define	SEGMENT_ELEMENT		2
#define	BUFFER_ELEMENT		3
#define	PROJECTION_ELEMENT	4
#define	CONNECTION_ELEMENT	5

#define NCLOCKS 		100
#define SIM_CLOCK 		0

/*
** pre-defined action types
*/
#define PROCESS			0
#define INIT			1
#define RESET			2
#define CHECK			3
#define COPY			4
#define SET			5
#define CREATE			6
#define RECALC			7
#define SHOW			8
#define DELETE			9
#define SAVE			10
#define RESTORE			11
#define SAVE2			12
#define RESTORE2		13
#define SETUP			14
#define RESULTS			15

/*
** pre-defined integration methods
*/
#define EPC_INT			-2
#define FEULER_INT		-1
#define EEULER_INT		0
#define GEAR_INT		1
#define AB2_INT			2
#define AB3_INT			3
#define TRAPEZOIDAL_INT	4
#define AB4_INT			5
#define AB5_INT			6
#define RK_INT			7
#define BEULER_INT		10
#define CRANK_INT		11

#ifndef PI
#define	PI			3.1415926536
#endif

#ifndef TRUE
#define	TRUE			1
#define	FALSE			0
#endif

#define BUFFER_INCREASE_HINT	10
#define WRAP 			0
#define EXPAND 			1

#define CurrentEventTime(B) 	((B)->event[(B)->current].time)	
#define CurrentEvent(B)		((B)->event[(B)->current])	
#define ValidEvent(B)		((B)->start != (B)->current)
#define BufferFull(B) 		((((B)->end +1) % (B)->size) == (B)->start)

#define Euler(y,dy,dt) 		((y) + (dy)*(dt))
#define CheckInterval(T,DT)	(GetCurrentStep() % (int)(0.5 + (T)/(DT)) == 0)
#define MATCH(A,B) 		(strncmp(A,B,strlen(A)) == 0)

/*
** quick but dangerous
#define MsgValue(M,T,N) 	(*((T *)((M)->data[N])))
*/

/* slow but safe */
#ifdef OLDMESSAGE
#define MsgValue(M,T,N) 	(MessageData(M->slot + N))
#else
#define MsgValue(M,T,N) 	((*(M->slot[N].func))(M->slot + N))
#endif

#define ClockValue(C)		(clock_value[C])
/*
** get clock information from the element
*/
#define Clockrate(I)		(ClockValue(((I)->flags) & CLOCKMASK))
#define Clock(I)		(((I)->flags) & CLOCKMASK)

#define CORRECTION 		(ClockValue(0)/10.0)

#define SimulationTime()	simulation_time

#define Type(I) 		((I)->object->type)
#define Size(I) 		((I)->object->size)
#define Function(I) 		((I)->object->function)

#define MSGLOOP(C,M) 		for(M=(C)->msg_in;M;M=M->next) switch(M->type)
#define MSGOUTLOOP(C,M)      for(M=(C)->msg_out;M;M=M->next) switch(M->type)

#ifdef OLDMESSAGE
#define MSGVALUE(M,N) 		(MessageData(M->slot + N))
#else
#define MSGVALUE(M,N) 		((*(M->slot[N].func))(M->slot + N))
#endif
#define MSGPTR(M,N) 		(M->slot[N].data)

#define SELECT_ACTION(A)	switch((A)->type)

#define ENABLED(E)	(!((E)->flags & BLOCKMASK))
#define ACTIVE(E)	((E)->object->function)
