static char rcsid[] = "$Id: sim_create.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_create.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:47:38  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

Element *Create(object_name,name,parent,action,index)
char	*object_name;
char 	*name;
Element	*parent;
Action	*action;
int	index;
{
Element 	*element;
GenesisObject 		*object;
int		size;
Action		defaction;
PFI		action_func;
int		status;

    /*
    ** find the object type in the object table
    */
    if((object = GetObject(object_name)) != NULL){
	/*
	** create an element using the object information
	*/
	if((size = object->size) > 0){
	    element = (Element *)calloc(1,size);
	} else {
	    Error();
	    printf("zero sized object '%s'\n", object_name);
	    return(NULL);
	}
    } else {
	Error();
	printf("could not find object '%s'\n", object_name);
	return(NULL);
    }
    element->object  = object;
    /*
    ** name the element
    */
    if(!Name(element,name)){
	Error();
	printf("could not assign element name.\n");
	return(NULL);
    }
    element->index = index;
    /*
    ** and attach it to the parent
    */
    Attach(parent,element);
    /*
    ** check to see if the  object has a create action
    */
    if(action_func = GetActionFunc(object,CREATE)){
	/*
	** if it does then call the function with the action
	*/
	if(action){
	    status = action_func(element,action);
	} else {
	    defaction.type = CREATE;
	    defaction.name = "CREATE";
	    status = action_func(element,&defaction);
	}
	if(!status){
	    /* 
	    ** creation failed. Reject the element
	    */
	    DeleteElement(element);
	    return(NULL);
	}
    }
    return(element);
}

char *CreateObject(object,action)
GenesisObject 	*object;
Action	*action;
{
char 		*instance;
int		size;
Action		defaction;
PFI		function;

    if(object == NULL) return(NULL);
    /*
    ** create an element using the object information
    */
    if((size = object->size) > 0){
	instance = (char *)calloc(1,size);
    } else {
	Error();
	printf("zero sized object'%s'\n", object->name);
	return(NULL);
    }
    /*
    ** check to see if the  object has a create action
    */
    if(function = GetActionFunc(object,CREATE)){
	/*
	** if it does then call the function with the action
	*/
	if(action){
	    function(instance,action);
	} else {
	    defaction.type = CREATE;
	    defaction.name = "CREATE";
	    function(instance,&defaction);
	}
    }
    return(instance);
}

void do_create(argc,argv)
int	argc;
char	**argv;
{
int 		nxtarg;
char 		*name;
char 		*type;
char 		*parent_name;
char 		*target;
short 		typefound 	= 0;
short 		targetfound 	= 0;
Element		*new_element;
Element		*parent_element;
Action		action;
int		index;
char		*ptr;

    if(argc < 3){
	printf("usage: %s [a an] object [called] name\n",
	argv[0]);
	return;
    }
    /*
    ** parse the command line arguments
    */
    nxtarg = 0;
    while(++nxtarg<argc && (!typefound || !targetfound)){
	if(!typefound){
	    if(strcmp(argv[nxtarg],"a")==0 || strcmp(argv[nxtarg],"an")==0){
		continue;
	    }
	    type = argv[nxtarg];
	    typefound = 1;
	    continue;
	} else 
	if(!targetfound){
	    if(strcmp(argv[nxtarg],"called")==0){ 
		continue;
	    }
	    target = argv[nxtarg];
	    targetfound = 1;
	    continue;
	}
    }
    if(strlen(parent_name = GetParentComponent(target)) == 0){
	parent_name = ".";
	name = target;
    } else {
	name = GetBaseComponent(target);
    }
    index = GetTreeCount(name);
    if(ptr = strchr(name,'[')){
	*ptr = '\0';
    }
    if((parent_element = (Element *)GetElement(parent_name)) == NULL){
	Error();
	printf("cannot find '%s'\n",parent_name);
	printf("unable to create '%s'\n",name);
	return;
    }
    /*
    ** create the element
    */
    action.argc = argc - 1;
    action.argv = argv + 1;
    action.type = CREATE;
    action.name = "CREATE";
	action.data = (char *)parent_element;
    if(new_element = Create(type,name,parent_element,&action,index)){
	SetRecentElement(new_element);
    } else {
	printf("unable to create '%s'\n",name);
	return;
    }
    OK();
}

