static char rcsid[] = "$Id: sim_copy.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_copy.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:45:30  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

CopyMsgs(orig,copy)
Element		*orig;
Element		*copy;
{
struct equiv_type {
    Element	*orig;
    Element	*copy;
} *equiv_table;
int 		count=0;
int 		i,j;
int 		size;
ElementStack 		*stk0,*stk1;
Element 	*orig_ptr;
Element 	*copy_ptr;
MsgIn		*msg_in;
MsgIn		*copy_msg_in;
MsgOut		*msg_out;
MsgOut		*copy_msg_out;
Element		*orig_msg_dst;
Element		*copy_msg_dst;
int		offset;
int		objsize;

    size = CountChildren(orig,0) + 1;
    equiv_table = (struct equiv_type *)
    malloc(size * sizeof(struct equiv_type));

    /*
    ** the trees should be identical or strange things could happen
    */
    stk0 = NewPutElementStack(orig);
    stk1 = NewPutElementStack(copy);
    /*
    ** check the first element 
    */
    equiv_table[0].orig = orig;
    equiv_table[0].copy = copy;
    count = 1;
    /*
    ** construct the element equivalence table
    ** by adding all elements in the tree
    */
    while((orig_ptr = NewFastNextElement(0,stk0)) != NULL){
	copy_ptr = NewFastNextElement(0,stk1);
	equiv_table[count].orig = orig_ptr;
	equiv_table[count].copy = copy_ptr;
	count++;
    }
    NewFreeElementStack(stk0);
    NewFreeElementStack(stk1);
    /*
    ** go through all of the elements in the table and map the msgs
    */
    for(i=0;i<count;i++){
	/*
	** get the next original projection
	*/
	orig_ptr = equiv_table[i].orig;
	/*
	** start the copy without any connections 
	*/
	copy_ptr = equiv_table[i].copy;
	/*
	** and go through all of the original msgs
	*/
	objsize = Size(orig_ptr);
	for(msg_out=orig_ptr->msg_out;msg_out; msg_out=msg_out->next){
	    /*
	    ** get the destination element
	    */
	    orig_msg_dst = msg_out->dst;
	    msg_in = msg_out->msg_in;
	    /*
	    ** get the equivalent destination element from the copy
	    ** by searching the equivalence table
	    */
	    for(j=0;j<count;j++){
		if(equiv_table[j].orig == orig_msg_dst)
		    break;
	    }
	    if(j >= count){
		/*
		** could not find the destination element within the 
		** table indicating a non-local msg
		** so forget it
		*/
		continue;
	    }
	    /*
	    ** get the equivalent copy destination element  
	    */
	    copy_msg_dst = equiv_table[j].copy;
	    /*
	    ** allocate copy msgs
	    */
	    copy_msg_in = (MsgIn *)scalloc(1,sizeof(MsgIn));
	    copy_msg_out = (MsgOut *)scalloc(1,sizeof(MsgOut));
	    /*
	    ** set the msg fields
	    */
	    copy_msg_out->msg_in = copy_msg_in;
	    copy_msg_out->dst = copy_msg_dst;
	    copy_msg_in->src = copy_ptr;
	    copy_msg_in->type = msg_in->type;

	    /*
	    ** copy the slots from original to the copy
	    */
	    if(msg_in->nslots > 0){
		copy_msg_in->slot = (Slot *)scalloc(msg_in->nslots,sizeof(Slot));
		bcopy(msg_in->slot,copy_msg_in->slot,
		msg_in->nslots*sizeof(Slot));
		copy_msg_in->nslots = msg_in->nslots;
	    }
	    /*
	    ** go through each slot and convert the data addresses to the
	    ** copy
	    ** LATER check the msg copying to handle non-contiguous
	    ** addresses like dynamic arrays etc.
	    */
	    for(j=0;j<msg_in->nslots;j++){
                offset = (msg_in->slot[j].data - (char *)orig_ptr);
                if(offset < objsize && offset >= 0){
                    copy_msg_in->slot[j].data = (char *)copy_ptr + offset;
                } else {
                    copy_msg_in->slot[j].data = msg_in->slot[j].data;
                }
	    }
	    /*
	    ** add the msgs to the copy elements
	    */
	    if(AddMsgOut(&(copy_ptr->msg_out),copy_msg_out) == 0){
		Error();
		printf("could not add message to '%s'\n",
		Pathname(copy_ptr));
		free(equiv_table);
		return;
	    } 
	    if(AddMsgIn(&(copy_msg_dst->msg_in),copy_msg_in) == 0){
		Error();
		printf("could not add message to '%s'\n",
		Pathname(copy_msg_dst));
		free(equiv_table);
		return;
	    }
	}
    }
    free(equiv_table);
}

/*
** routines for copying individual components
*/
Event *CopyEvents(buffer)
Buffer *buffer;
{
Event *event;
Event *new_event;
int 	buffer_size;
int 	event_size;
int i;

    if(buffer == NULL) return(NULL);
    event = buffer->event;
    buffer_size = buffer->size;
    event_size = buffer->event_size;
    if(event == NULL) return(NULL);
    /*
    ** allocate the new event
    */
    new_event = (Event *) malloc(event_size*buffer_size);
    /*
    ** copy the contents of the old event into the new event
    */
    bcopy(event,new_event,event_size*buffer_size);
    return(new_event);
}

/*
** copy a single element
*/
Element *CopyElement(element)
Element	*element;
{
Element	*new_element;
char		*funcname;
int		size;

    if(element == NULL){
	return(NULL);
    }
    size = element->object->size;
    /*
    ** allocate the new element
    */
    if((new_element=(Element *)malloc(size)) == NULL){
	return(NULL);
    }
    /*
    ** copy the contents of the old element into the new element
    */
    bcopy(element,new_element,size);
    /*
    ** erase the message structures
    */
    new_element->msg_in = NULL;
    new_element->msg_out = NULL;
    /*
    ** null the pointers
    */
    new_element->next = NULL;
    new_element->child = NULL;
    new_element->parent = NULL;
    return(new_element);
}

/*
** copy an element and all its sub-elements
*/

Element *CopyElementTree(src_element)
Element	*src_element;
{
Element	*last_element;
Element	*new_element;
Element	*new_child;
Element	*child;

    new_element = CopyElement(src_element);
    if(new_element == NULL){
	return(NULL);
    }
    last_element = new_element->child;
    for(child=src_element->child;child;child=child->next){
	new_child = CopyElementTree(child);
	AttachToEnd(new_element,last_element,new_child);
	last_element = new_child;
    }
    return(new_element);
}

/*
** copy the connections within a tree
*/
CopyConnections(orig,copy)
Element 	*orig;
Element	*copy;
{
struct equiv_ptype {
	Projection	*orig;
	Projection	*copy;
} *equiv_ptable;
struct equiv_stype {
	Segment		*orig;
	Segment		*copy;
} *equiv_stable;
int 		pcount=0;
int 		scount=0;
int 		i,j;
int 		psize;
int 		ssize;
ElementStack 	*stk0,*stk1;
Element 	*orig_ptr;
Element 	*copy_ptr;
Connection 	*connection;
Connection 	*new_connection;
Segment 	*orig_segment;
Segment 	*orig_target;
Segment 	*copy_target;
Projection 	*orig_projection;
Projection 	*copy_projection;

    if((psize = CountChildren(orig,PROJECTION_ELEMENT) + 1) == 1) return;
    if((ssize = CountChildren(orig,SEGMENT_ELEMENT) + 1) == 1) return;

    equiv_ptable = (struct equiv_ptype *)
	malloc(psize * sizeof(struct equiv_ptype));
    equiv_stable = (struct equiv_stype *)
	malloc(ssize * sizeof(struct equiv_stype));
    /*
    ** the trees should be identical or strange things could happen
    */
    stk0 = NewPutElementStack(orig);
    stk1 = NewPutElementStack(copy);
    /*
    ** check the first element 
    */
    if(CheckClass(orig,SEGMENT_ELEMENT)){
	equiv_stable[0].orig = (Segment *)orig;
	equiv_stable[0].copy = (Segment *)copy;
	scount = 1;
    }
    if(CheckClass(orig,PROJECTION_ELEMENT)){
	equiv_ptable[0].orig = (Projection *)orig;
	equiv_ptable[0].copy = (Projection *)copy;
	pcount = 1;
    }
    /*
    ** construct the element equivalence table
    ** by adding all projections and segments in the tree
    */
    while((orig_ptr = NewFastNextElement(0,stk0)) != NULL){
	copy_ptr = NewFastNextElement(0,stk1);
	if(CheckClass(orig_ptr,SEGMENT_ELEMENT)){
	    equiv_stable[scount].orig = (Segment *)orig_ptr;
	    equiv_stable[scount].copy = (Segment *)copy_ptr;
	    scount++;
	} else
	if(CheckClass(orig_ptr,PROJECTION_ELEMENT)){
	    equiv_ptable[pcount].orig = (Projection *)orig_ptr;
	    equiv_ptable[pcount].copy = (Projection *)copy_ptr;
	    pcount++;
	} 
    }
    NewFreeElementStack(stk0);
    NewFreeElementStack(stk1);
    /*
    ** go through all of the projections in the table and map the connections
    */
    for(i=0;i<pcount;i++){
	/*
	** get the next original projection
	*/
	orig_projection = equiv_ptable[i].orig;
	/*
	** start the copy without any connections 
	*/
	copy_projection = equiv_ptable[i].copy;
	copy_projection->connection = NULL;
	/*
	** and go through all of the original connections
	*/
	for(connection=orig_projection->connection;connection;
	connection=connection->next){
	    /*
	    ** get the destination segment
	    */
	    orig_target = connection->target;
	    /*
	    ** get the equivalent destination segment from the copy
	    ** by searching the equivalence table
	    */
	    for(j=0;j<scount;j++){
		if(equiv_stable[j].orig == orig_target)
		    break;
	    }
	    if(j >= scount){
		/*
		** could not find the destination segment within the 
		** table indicating a non-local connection
		** so forget it
		*/
		break;
	    }
	    /*
	    ** get the equivalent copy destination element  
	    */
	    copy_target = equiv_stable[j].copy;
	    /*
	    ** add the connection
	    */
	    new_connection = 
	    (Connection *)CreateObject(orig_projection->connection_object);
	    /*
	    ** copy the connection information from the original
	    */
	    bcopy(connection,new_connection, 
	    orig_projection->connection_object->size);
	    /*
	    ** set the copy pointers
	    */
	    new_connection->target = copy_target;
	    new_connection->next = copy_projection->connection;
	    copy_projection->connection = new_connection;
	}
    }
    free(equiv_ptable);
    free(equiv_stable);
}

CopyAction(orig,copy)
Element	*orig;
Element	*copy;
{
PFI	func;
Action	action;
ElementStack	*stk0,*stk1;
Element	*orig_ptr,*copy_ptr;

    /*
    ** the trees should be identical or strange things could happen
    */
    stk0 = NewPutElementStack(orig);
    stk1 = NewPutElementStack(copy);
    /*
    ** check the first element 
    */
    if(func = GetActionFunc(orig->object,COPY)){
	action.name = "COPY";
	action.type = COPY;
	action.argc = 0;
	action.argv = NULL;
	action.data = (char *)copy;
	func(orig,&action);
    }
    /*
    ** construct the element equivalence table
    ** by adding all elements in the tree
    */
    while((orig_ptr = NewFastNextElement(0,stk0)) != NULL){
	copy_ptr = NewFastNextElement(0,stk1);
	/*
	** check to see if the object has a copy action
	*/
	if(func = GetActionFunc(orig_ptr->object,COPY)){
	    action.name = "COPY";
	    action.type = COPY;
	    action.argc = 0;
	    action.argv = NULL;
	    action.data = (char *)copy_ptr;
	    func(orig_ptr,&action);
	}
    }
    NewFreeElementStack(stk0);
    NewFreeElementStack(stk1);
}

do_copy(argc,argv)
int		argc;
char		**argv;
{
int 		nxtarg;
char 		*src;
char 		*dst;
int 		repeat;
Element	*src_element;
Element	*dst_element;
Element	*new_element;
PFI		func;
char		*funcname;
int		srcfound;
int		dstfound;
char		*new_name;
char		*dst_path;
char		*ptr;
int		new_index;
int		i;

    if(argc < 3){
	printf("usage: %s src_element [to] dst_element [-repeat #]\n",
	argv[0]); 
	return;
    }
    nxtarg = 0;
    repeat = 1;
    srcfound = 0;
    dstfound = 0;
    new_name = NULL;

    /*
    ** locate the src/dst and the multiplier
    */
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-repeat") == 0){
	    repeat = atoi(argv[++nxtarg]);
	    continue;
	} else
	if(!srcfound){
	    srcfound = 1;
	    src = argv[nxtarg];
	    continue;
	} else
	if(!dstfound){
	    if(strcmp(argv[nxtarg],"to") == 0){
		continue;
	    }
	    dstfound = 1;
	    dst = argv[nxtarg];
	    continue;
	} 
    }
    if((src_element = GetElement(src)) == NULL){
	Error();
	printf("could not find src element '%s'\n",src);
	return;
    }
    if((dst_element = GetElement(dst)) == NULL){
	/*
	** try and find the parent and use the base as the
	** name of the copy
	*/
	if(strlen(dst_path = GetParentComponent(dst)) == 0){
	    dst_path = ".";
	}
	if((dst_element = GetElement(dst_path)) == NULL){
	    Error();
	    printf("invalid copy destination '%s'\n",dst);
	    return;
	}
	/*
	** if the parent was found then use the base as the
	** new name of the copy
	*/
	new_name = GetBaseComponent(dst);
	new_index = GetTreeCount(new_name);
	if(ptr = strchr(new_name,'[')){
	    *ptr = '\0';
	}
    }
    if(!ValidHierarchy(src_element,dst_element)){
	Error();
	printf("cant copy an element into itself\n");
	return;
    }
    /*
    ** copy it
    */
    for(i=0;i<repeat;i++){
	if((new_element = CopyElementTree(src_element)) == NULL){
	    printf("could not copy %s to %s\n",src,dst);
	    break;
	}
	if(new_name){
	    Name(new_element,new_name);
	    new_element->index = new_index+i;
	}
	/*
	** attach the new element to the destination
	*/
	Attach(dst_element,new_element);
	/*
	** make connections between the elements
	*/
	CopyConnections(src_element,new_element);
	/*
	** copy the msgs between elements
	*/
	CopyMsgs(src_element,new_element);
	/*
	** call special copy routines if any
	*/
	CopyAction(src_element,new_element);
    }
    SetRecentElement(new_element);
}

