static char rcsid[] = "$Id: sim_clock.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_clock.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:42:50  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

short			nactive_clocks;
short			clock_set[NCLOCKS];
short			clock_active[NCLOCKS];

void CheckClocks()
{
int i;
double simulation_dt;

    simulation_dt = clock_value[0];
    bzero(clock_active,sizeof(short)*NCLOCKS);
    for(i=0;i<nactive_clocks;i++){
	/* Hack to bypass the divide-by-zero case which seems to be here */
	if ((1.99999999*clock_value[i]) > simulation_dt) {
	if(i == 0 || CheckInterval(clock_value[i],simulation_dt)){
	    clock_active[i] = 1;
	} else {
	    clock_active[i] = 0;
	}
	} else {
	    clock_active[i] = 1;
	}
    }
}

void CheckClocksSet()
{
int i;
double simulation_dt;

    bzero(clock_set,sizeof(short)*NCLOCKS);
    nactive_clocks = 0;
    for(i=0;i<NCLOCKS;i++){
	if(clock_value[i]>0){
	    clock_set[i] = i;
	    nactive_clocks++;
	}
    }
}

ShowClocks()
{
int i;
    /*
    ** print all non-zero clock values
    */
    printf("\nACTIVE CLOCKS\n");
    printf("-------------\n");
    for(i=0;i<NCLOCKS;i++){
	if(clock_value[i] != 0){
	    printf("[%d] : %g\n",
	    i,
	    clock_value[i]);
	}
    }
    printf("\n");
}

AssignElementClock(element,clock)
Element 	*element;
int		clock;
{
    /*
    ** clear the old clock value
    */
    element->flags = ((element->flags) & ~CLOCKMASK);
    /*
    ** and assign the new one
    */
    element->flags = ((element->flags) | (clock & CLOCKMASK));
}

SetClock(n,val)
int n;
float val;
{
    clock_value[n] = val;
    CheckClocksSet();
}

do_set_clock(argc,argv)
int argc;
char **argv;
{
int clock;
float value;

    if(argc < 3){
	printf("usage: %s clock value\n",argv[0]);
	return;
    }
    clock = atoi(argv[1]);
    value = Atof(argv[2]);
    if(IsSilent()<1 && clock_value[clock] != 0 &&
    clock_value[clock] != value){
	printf("changing clock [%d] from %g to %g\n",
	clock,
	clock_value[clock],
	value);
    }
    SetClock(clock,value);
}

do_element_clock(argc,argv)
int argc;
char **argv;
{
int clock;
char *path;
ElementList *list;
int	i;

    if(argc < 3){
	printf("usage: %s path clock\n",argv[0]);
	return;
    }
    path = argv[1];
    clock = atoi(argv[2]);
    list = WildcardGetElement(path,0);
    for(i=0;i<list->nelements;i++){
	AssignElementClock(list->element[i],clock);
    }
    FreeElementList(list);
}
