static char rcsid[] = "$Id: sim_attach.c,v 1.2 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_attach.c,v $
 * Revision 1.2  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:30:27  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

/*
** add the element pointer to the parents list of children
*/
int Attach(parent,child)
Element *parent;
Element *child;
{
Element *ptr;
Element *prev;
Element *current;
int status;
	

    if(parent == NULL || child == NULL) return(0);
    /*
    ** find the append/insert point in the child list
    */
    if(parent->child == NULL){
	/*
	** the child list is empty so just append to the head 
	*/
	parent->child =  child;
    } else{
	prev = NULL;
	for(ptr=parent->child;ptr;ptr=ptr->next){
	    current = ptr;
	    if(ptr->index == child->index &&
	    (strcmp(ptr->name,child->name) == 0)){
		/*
		** found an identical child so replace it
		*/
		break;
	    }
	    prev = ptr;
	}
	if(ptr == NULL){
	    /*
	    ** append the child to the parent list
	    */
	    prev->next = child;
	    status = 1;
	} else 
	if(prev == NULL){
	    /*
	    ** replace current with new
	    */
	    child->next = current->next;
	    parent->child = child;
	    status = 2;
	    Warning();
	    printf("overwriting an existing element '%s'\n",
	    Pathname(current));
	} else {
	    /*
	    ** replace current with new
	    */
	    child->next = current->next;
	    prev->next = child;
	    status = 2;
	    Warning();
	    printf("overwriting an existing element '%s'\n",
	    Pathname(current));
	}
    }
    /*
    ** inform the child about who just adopted it
    */
    child->parent = parent;
    return(status);
}

/*
** add the element pointer to the parents list of children
*/
int AttachToEnd(parent,last_child,child)
Element *parent;
Element *last_child;
Element *child;
{

    if(parent == NULL || child == NULL) return(0);
    /*
    ** insert the child at the end last_child list
    */
    if(last_child == NULL)
	parent->child = child;
    else
	last_child->next = child;
    /*
    ** inform the child about who just adopted it
    */
    child->parent = parent;
    return(1);
}
