static char rcsid[] = "$Id: sim_address.c,v 1.2 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_address.c,v $
 * Revision 1.2  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:28:53  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"
#define MAX_DIMENSIONS 4

/*
** calculates the linear offset of an array element from the 
** beginning of a multi-dimensional array
*/
int IndexOffset(i,index,dim,maxd)
int i;
int index;
int dim[MAX_DIMENSIONS];
int maxd;
{
int j;
int offset;

    offset = index;
    for(j=i+1;j<maxd;j++){
	offset *= dim[j];
    }
    return(offset);
}

/*
** calculate the offset of a field from the beginning of a structure
*/
int CalculateOffset(type,field,returninfo)
char *type;
char *field;
Info *returninfo;
{
char fullname[100];
Info info;
char *end;
char *iptr;
char tmp[100];
int offset;
int field_offset;
char *strchr();
int index[MAX_DIMENSIONS];
int dim;
int i;

    if(type == NULL || field == NULL){
	return(-1);
    }
    strcpy(fullname,type);
    strcat(fullname,".");
    /*
    ** check for any type of indirection in the field
    ** if so then an offset calculation cannot be made and the
    ** return value of -2 indicates that CalculateAddress should
    ** be used instead
    */
    if(strchr(field,'*') != NULL) return(-2);
    if(strchr(field,'-') != NULL) return(-2);
    /*
    ** any array indices?
    */
    dim  = 0;
    iptr = field;
    if(end =strchr(iptr,'[')){
	/*
	** get the name
	*/
	strncpy(tmp,field,(int)end-(int)field);
	tmp[end-field] = '\0';
	strcat(fullname,tmp);
	/*
	** extract the index components
	*/
	while(end =strchr(iptr,'[')){
	    sscanf(end+1,"%d",index+dim);
	    iptr = strchr(end,']');
	    dim++;
	}
    } else
    /*
    ** are there multiple fields
    */
    if(end =strchr(field,'.')){
	/*
	** if there are more  fields then just do the first
	*/
	strncpy(tmp,field,(int)end-(int)field);
	tmp[end-field] = '\0';
	strcat(fullname,tmp);
    } else {
	strcat(fullname,field);
    }
    /*
    ** get the info on the field
    */
    if(GetInfo(fullname,&info)){
	/*
	** get its offset
	*/
	/*
	** if there is array indexing then  calculate the array offset
	** as well
	*/
	if(dim != info.dimensions){
	    if(info.field_indirection != dim){
		return(-1);
	    } else {
		return(-2);
	    }
	}
	/*
	** this bit of code calculates the offset of an array indexing 
	** sequence given in index
	*/
	if(dim == 0){
	    field_offset = info.offset;
	} else{
	    field_offset = info.offset;
	    for(i=0;i<dim;i++){
		if(info.field_indirection == 0){
		    field_offset += 
		    IndexOffset(i,index[i],info.dimension_size,dim)*
		    info.type_size;
		} else {
		    field_offset += 
		    IndexOffset(i,index[i],info.dimension_size,dim)*
		    sizeof(char *);
		}
	    }
	}
	/*
	** check for more fields
	*/
	if(end = strchr(field,'.')){
	    /*
	    ** if there are more then calculate their offsets
	    ** using the newly aquired type info and the next field
	    */
	    if((offset = CalculateOffset(info.type,strchr(field,'.')+1,&info))
	    == -1) return(-1);
	    if(offset == -2) return(-2);
	} else {
	    offset = 0;
	}
	/*
	** return the offset info
	*/
	bcopy(&info,returninfo,sizeof(Info));
	return(offset + field_offset);
    } else {
	return(-1);
    }
}

/*
** return the size of a structure
*/
int StructSize(type)
char *type;
{
Info info;
static char *ptype = NULL;
static size;

    if(type == NULL){
	return(0);
    }
    if(type == ptype) return(size);
    if(GetInfo(type,&info)){
	size = info.type_size;		
	return(size);
    } else {
	return(0);
    }
}

int ComputeMode(field)
char *field;
{
char *iptr;
int mode;

    mode = 0;	/* no operator */
    for(iptr=field;iptr && *iptr!= '\0';iptr++){
	switch(*iptr){
	case '.': mode = 1; break;	/* structure */
	case '-': mode = 2; break;	/* structure indirection */
	case '[': mode = 3; break;	/* array */
	}
	/*
	** end the search after finding an operator
	*/
	if(mode > 0) break;
    }
    return(mode);
}

int ComputeIndirection(field)
char *field;
{
char *iptr;
int mode;
int	indirection=0;

    mode = 0;	/* no operator */
    for(iptr=field;iptr && *iptr!= '\0';iptr++){
	switch(*iptr){
	case '.': mode = 1; break;	/* structure */
	case '-': mode = 2; break;	/* structure indirection */
	case '[': mode = 3; break;	/* array */
	case '*': indirection++; break;	/* indirection */
	}
	/*
	** end the search after finding an operator
	*/
	if(mode > 0) break;
    }
    return(indirection);
}

/*
** calculate the address of a field 
*/
char *CalculateAddress(adr,type,field,returninfo)
char *adr;
char *type;
char *field;
Info *returninfo;
{
char fullname[100];
Info info;
char *end;
char *iptr;
char tmp[100];
int offset;
int field_offset;
char *strchr();
int index[MAX_DIMENSIONS];
int dim;
int i;
int indirection = 0;
int mode;

    if(adr == NULL || type == NULL || field == NULL){
	return(NULL);
    }
    strcpy(fullname,type);
    strcat(fullname,".");
    /*
    ** find out what type of operator (if any) exists for the
    ** first field
    */
    mode = ComputeMode(field);
    indirection = ComputeIndirection(field);

    /*
    ** build the full type.field name
    */
    dim  = 0;
    iptr = field;
    if(indirection > 0){
	i=0;
	while(i< indirection){
	    if(*field == '*') i++;
	    field++;
	}
    }
    switch(mode){
    case 0: 		/* plain field name */
	/*
	** append it to the full type string
	*/
	strcat(fullname,field);
	break;
    case 1:		/* structure reference */
        end =strchr(field,'.');
	/*
	** copy the first component (up to the .) into tmp
	*/
	strncpy(tmp,field,(int)end-(int)field);
	tmp[end-field] = '\0';
	/*
	** and append it to the full type string
	*/
	strcat(fullname,tmp);
	break;
    case 2:		/* structure indirection */
        end =strchr(field,'-');
	/*
	** copy the first component (up to the -) into tmp
	*/
	strncpy(tmp,field,(int)end-(int)field);
	tmp[end-field] = '\0';
	/*
	** and append it to the full type string
	*/
	strcat(fullname,tmp);
	break;
    case 3:		/* array reference */
        end =strchr(iptr,'[');
	/*
	** copy the field name (up to the [) into tmp
	*/
	strncpy(tmp,field,(int)end-(int)field);
	tmp[end-field] = '\0';
	/*
	** add the field name to the full type string
	*/
	strcat(fullname,tmp);
	/*
	** get the index values
	** this needs to be fixed (doesnt handle multiple array fields
	** correctly) b[x].c[y]
	*/
	while(end =strchr(iptr,'[')){
	    sscanf(end+1,"%d",index+dim);
	    iptr = strchr(end,']');
	    dim++;
	}
	break;
    }

    /*
    ** get the info on the type.field and compute its address
    */
    if(GetInfo(fullname,&info)){
	/*
	** if there is array indexing then  calculate the array offset
	** as well
	*/
	if(dim == info.dimensions){
	    /*
	    ** this bit of code calculates the offset of an array indexing 
	    ** sequence given in index
	    */
	    if(dim == 0){
		field_offset = info.offset;
	    } else{
		field_offset = info.offset;
		for(i=0;i<dim;i++){
		    if(info.field_indirection == 0){
			field_offset += 
			IndexOffset(i,index[i],info.dimension_size,dim)
			*info.type_size;
		    } else {
			field_offset += 
			IndexOffset(i,index[i],info.dimension_size,dim)
			*sizeof(char *);
		    }
		}
	    }
	    adr += field_offset;
	} else
	/*
	** is this a dynamically allocated array?
	*/
	if(info.field_indirection <= dim){
	    /*
	    ** this bit of code calculates the offset of an array indexing 
	    ** sequence 
	    */
	    if(dim == 0){
		adr += info.offset;
	    } else{
		field_offset = info.offset;
		for(i=0;i<dim;i++){
		    adr  = (char *)(*((char **)(adr + field_offset)));
		    if(--info.field_indirection > 0){
			field_offset = index[i] *sizeof(char *);
		    } else {
			field_offset = index[i] *info.type_size;
		    }
		}
		adr  += field_offset;
	    }
	} else {
	    Error();
	    printf("invalid array indexing\n");
	    return(NULL);
	}
	/*
	** if there are more fields then recursively calculate their 
	** addresses using the newly aquired type info and the next field
	*/
	if(mode == 3){
	    /*
	    ** get the index values
	    ** this needs to be fixed (doesnt handle multiple array fields
	    ** correctly) b[x].c[y]
	    */
	    while(end =strchr(field,']')){
		field = end+1;
	    }
	    mode = ComputeMode(field);
	}
	switch(mode){
	case 1:
	    end = strchr(field,'.');
	    /*
	    ** nested structure field
	    */
	    if((adr = 
	    CalculateAddress(adr,info.type,strchr(field,'.')+1,&info)) == NULL) 
	    return(NULL);
	    break;
	case 2:
	    end = strchr(field,'-');
	    /*
	    ** pointer indirection field
	    */
	    if((adr = 
	    CalculateAddress((char *)(*((char **)(adr))),
	    info.type,strchr(field,'>')+1,&info)) == NULL) 
	    return(NULL);
	    break;
	}
	/*
	** if there is indirection then determine if it is appropriate
	** and then apply it
	*/
	if(info.field_indirection >= indirection){
	    for(i=0;i<indirection;i++){
		info.field_indirection--;
		adr = (char *)(*((char **)adr));
	    }
	}
	/*
	** get the field info and return its address 
	*/
	bcopy(&info,returninfo,sizeof(Info));
	return(adr);
    } else {
	return(NULL);
    }
}
