static char rcsid[] = "$Id: sim_access.c,v 1.1.1.1 1993/07/21 21:31:57 dhb Exp $";

/*
** $Log: sim_access.c,v $
 * Revision 1.1.1.1  1993/07/21  21:31:57  dhb
 * fixed rcsid variable type
 *
 * Revision 1.1  1992/10/27  19:25:34  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"
/* Modified '91, by Upi Bhalla to put in Hsolve related funcs */


void Enable(element)
Element *element;
{
    if(element != NULL)
    element->flags &= ~BLOCKMASK;
}

void Block(element)
Element *element;
{
    if(element != NULL)
    element->flags |= BLOCKMASK;
}

int IsEnabled(element)
Element *element;
{
    if(element != NULL)
	return((element->flags & BLOCKMASK) == 0);
    else
    return(FALSE);
}

void HsolveEnable(element)
Element *element;
{
    if(element != NULL)
    element->flags &= ~HSOLVEMASK;
}

void HsolveBlock(element)
Element *element;
{
    if(element != NULL)
    element->flags |= HSOLVEMASK;
}

int IsHsolved(element)
Element *element;
{
    if(element != NULL)
	return((element->flags & HSOLVEMASK) != 0);
    else
    return(FALSE);
}

int IsActive(element)
Element *element;
{
    if(element != NULL & element->object != NULL){
	return(element->object->function != NULL);
    } else {
	return(0);
    }
}

int do_enable(argc,argv)
int	argc;
char	**argv;
{
Element		*element;

    if(argc < 2){
	printf("usage: %s element\n");
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	Error();
	printf("cannot find element '%s'\n",argv[1]);
	return(0);
    }
    Enable(element);
    OK();
    return(1);
}

int do_disable(argc,argv)
int	argc;
char	**argv;
{
Element		*element;

    if(argc < 2){
	printf("usage: %s element\n");
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	Error();
	printf("cannot find element '%s'\n",argv[1]);
	return(0);
    }
    Block(element);
    OK();
    return(1);
}
