static char rcsid[] = "$Id: shell_setup.c,v 1.1 1992/12/11 19:04:43 dhb Exp $";

/*
** $Log: shell_setup.c,v $
** Revision 1.1  1992/12/11  19:04:43  dhb
** Initial revision
**
*/

#include "shell.h"
#ifndef NEW
    ParseInit(){}
#endif

#ifdef NEW
SetUpFuncTable()
{
	AddFunc("addfunc",			do_add_func	,"void");
	AddFunc("execute",			do_execute	,"void");
	AddFunc("debug",			do_debug	,"void");
	AddFunc("debugfunc",			do_debug_func	,"void");
	AddFunc("h",				ShowHistory	,"void");
	AddFunc("cd",				do_cd		,"int");
	AddFunc("echo",				do_echo		,"void");
	AddFunc("prompt",			do_set_prompt	,"void");
	AddFunc("where",			do_where	,"void");
	AddFunc("exit",				do_exit		,"void");
	AddFunc("quit",				do_exit		,"void");
	AddFunc("tset",				tset		,"void");
	AddFunc("commands",			ShowFuncNames	,"void");
	AddFunc("source",			do_source	,"void");
	AddFunc("read",				do_source	,"void");
	AddFunc("endscript",			EndScript	,"void");
	AddFunc("printargs",			do_printargs	,"void");
	AddFunc("autoshell",			do_autoshell	,"void");
	AddFunc("silent",			do_silent	,"void");
	AddFunc("setenv",			do_setenv	,"void");
	AddFunc("getenv",			do_getenv	,"char*");
	AddFunc("printenv",			do_printenv	,"void");
	if(Dynamic()){
	    AddFunc("loadfunc",			do_load_func	,"void");
	}
#ifdef DEPENDENT
	AddFunc("print_global",			do_getdata	,"void");
	AddFunc("set_global",			do_putdata	,"void");
#endif
	AddFunc("getinfo",			do_getinfo	,"void");
	AddFunc("library",			do_load_lib	,"void");
}

char *StripCR(s)
char *s;
{
char *ptr;

    ptr = s;
    for(ptr=s;*ptr != '\0' && *ptr != '\n';ptr++)
	;
    *ptr = '\0';
    return(s);
}

SetupInterp(file)
char	*file;
{
FILE *fp;
char *wd;
char *getwd();
char tmp[300];
char tmpwd[300];

    /*
    ** check to see whether the executable can be opened
    */
    if((fp = SearchForExecutable(file,"r",&progname)) == NULL){
	return(0);
    }
    fclose(fp);
    /*
    ** construct the absolute pathname for the program if it has 
    ** has a relative specification
    */
    if(*progname  != '/'){
	/* getenv("PWD") */
/* mds3 changes */
#ifdef SYSV
      if((wd = (char *)getcwd(tmpwd, sizeof(tmpwd))) == NULL){
#else
      if((wd = getwd(tmpwd)) == NULL){
#endif
/* end of mds3 changes */
	    printf("unable to get the working directory\n");
	} else {
	    /* strcpy(tmpwd,wd); */
	    /*
	    ** get rid of CRs
	    */
	    wd = StripCR(tmpwd);
	    sprintf(tmp,"%s/%s",wd,progname);
	    progname = CopyString(tmp);
	}
    }
	if (IsSilent() < 2)
    	printf("%-20s%s\n","Executable:",progname);
    RecordStartTime();
    HashInit();
    if(Dynamic()){
	printf("initializing dynamic load module...\n");
	LoadFuncInit(file);
    }
    FUNC_shell();
    SetUpFuncTable();
    DefaultPrompt();
    return(1);
}

Interpreter()
{
    yyparse();
}
#endif
